/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer;

import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueColourFinder;
import jalview.renderer.ResidueShaderI;
import jalview.util.Comparison;
import java.awt.Color;

public class OverviewResColourFinder
extends ResidueColourFinder {
    final Color GAP_COLOUR;
    final Color RESIDUE_COLOUR;
    final Color HIDDEN_COLOUR;
    boolean useLegacy = false;
    public static final Color OVERVIEW_DEFAULT_GAP = Color.lightGray;
    public static final Color OVERVIEW_DEFAULT_LEGACY_GAP = Color.white;
    public static final Color OVERVIEW_DEFAULT_HIDDEN = Color.darkGray.darker();

    public OverviewResColourFinder() {
        this(false, OVERVIEW_DEFAULT_GAP, OVERVIEW_DEFAULT_HIDDEN);
    }

    public OverviewResColourFinder(boolean useLegacyColouring, Color gapCol, Color hiddenCol) {
        if (useLegacyColouring) {
            this.GAP_COLOUR = Color.white;
            this.RESIDUE_COLOUR = Color.lightGray;
            this.HIDDEN_COLOUR = hiddenCol;
        } else {
            this.GAP_COLOUR = gapCol;
            this.RESIDUE_COLOUR = Color.white;
            this.HIDDEN_COLOUR = hiddenCol;
        }
    }

    @Override
    public Color getBoxColour(ResidueShaderI shader, SequenceI seq, int i) {
        Color resBoxColour = this.RESIDUE_COLOUR;
        char currentChar = seq.getCharAt(i);
        if (shader.getColourScheme() != null) {
            resBoxColour = Comparison.isGap(currentChar) && !shader.getColourScheme().hasGapColour() ? this.GAP_COLOUR : shader.findColour(currentChar, i, seq);
        } else if (Comparison.isGap(currentChar)) {
            resBoxColour = this.GAP_COLOUR;
        }
        return resBoxColour;
    }

    @Override
    protected Color getResidueBoxColour(boolean showBoxes, ResidueShaderI shader, SequenceGroup[] allGroups, SequenceI seq, int i) {
        SequenceGroup currentSequenceGroup = this.getCurrentSequenceGroup(allGroups, i);
        ResidueShaderI currentShader = currentSequenceGroup != null ? currentSequenceGroup.getGroupColourScheme() : shader;
        return this.getBoxColour(currentShader, seq, i);
    }

    protected Color getHiddenColour() {
        return this.HIDDEN_COLOUR;
    }
}

