/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer;

import jalview.api.AlignmentColsCollectionI;
import jalview.api.AlignmentRowsCollectionI;
import jalview.api.RendererListenerI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.renderer.OverviewResColourFinder;
import jalview.renderer.ResidueShaderI;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.renderer.seqfeatures.FeatureRenderer;
import jalview.viewmodel.OverviewDimensions;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;

public class OverviewRenderer {
    private final float TRANSPARENCY = 0.5f;
    public static final String UPDATE = "OverviewUpdate";
    private static final int MAX_PROGRESS = 100;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private FeatureColourFinder finder;
    private BufferedImage miniMe;
    private float pixelsPerCol;
    private float pixelsPerSeq;
    private int graphHeight;
    private volatile boolean redraw = false;
    private AlignmentI al;
    private ResidueShaderI shader;
    private OverviewResColourFinder resColFinder;

    public OverviewRenderer(FeatureRenderer fr, OverviewDimensions od, AlignmentI alignment, ResidueShaderI resshader, OverviewResColourFinder colFinder) {
        this.finder = new FeatureColourFinder(fr);
        this.resColFinder = colFinder;
        this.al = alignment;
        this.shader = resshader;
        this.pixelsPerCol = od.getPixelsPerCol();
        this.pixelsPerSeq = od.getPixelsPerSeq();
        this.graphHeight = od.getGraphHeight();
        this.miniMe = new BufferedImage(od.getWidth(), od.getHeight(), 1);
    }

    public BufferedImage draw(AlignmentRowsCollectionI rows, AlignmentColsCollectionI cols) {
        int rgbcolor = Color.white.getRGB();
        int seqIndex = 0;
        int pixelRow = 0;
        int alignmentHeight = this.miniMe.getHeight() - this.graphHeight;
        int totalPixels = this.miniMe.getWidth() * alignmentHeight;
        int lastRowUpdate = 0;
        int lastUpdate = 0;
        this.changeSupport.firePropertyChange(UPDATE, -1, 0);
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            int alignmentRow = (Integer)iterator.next();
            if (this.redraw) break;
            SequenceI seq = rows.getSequence(alignmentRow);
            SequenceGroup[] allGroups = this.al.findAllGroups(seq);
            int endRow = Math.min(Math.round((float)(seqIndex + 1) * this.pixelsPerSeq) - 1, this.miniMe.getHeight() - 1);
            int colIndex = 0;
            int pixelCol = 0;
            Iterator iterator2 = cols.iterator();
            while (iterator2.hasNext()) {
                int alignmentCol = (Integer)iterator2.next();
                if (this.redraw) break;
                int endCol = Math.min(Math.round((float)(colIndex + 1) * this.pixelsPerCol) - 1, this.miniMe.getWidth() - 1);
                if (pixelCol <= endCol) {
                    rgbcolor = this.getColumnColourFromSequence(allGroups, seq, alignmentCol);
                    for (int row = pixelRow; row <= endRow; ++row) {
                        for (int col = pixelCol; col <= endCol; ++col) {
                            this.miniMe.setRGB(col, row, rgbcolor);
                        }
                    }
                    lastUpdate = this.sendProgressUpdate((pixelCol + 1) * (endRow - pixelRow), totalPixels, lastRowUpdate, lastUpdate);
                    pixelCol = endCol + 1;
                }
                ++colIndex;
            }
            if (pixelRow != endRow + 1) {
                lastUpdate = lastRowUpdate = this.sendProgressUpdate(endRow + 1, alignmentHeight, 0, lastUpdate);
                pixelRow = endRow + 1;
            }
            ++seqIndex;
        }
        this.overlayHiddenRegions(rows, cols);
        if (this.redraw) {
            this.sendProgressUpdate(pixelRow - 1, alignmentHeight, 0, 0);
        } else {
            this.sendProgressUpdate(alignmentHeight, this.miniMe.getHeight(), 0, 0);
        }
        return this.miniMe;
    }

    private int sendProgressUpdate(int position, int maximum, int rowOffset, int lastUpdate) {
        int newUpdate = rowOffset + Math.round(100.0f * ((float)position / (float)maximum));
        if (newUpdate > lastUpdate) {
            this.changeSupport.firePropertyChange(UPDATE, rowOffset, newUpdate);
            return newUpdate;
        }
        return newUpdate;
    }

    int getColumnColourFromSequence(SequenceGroup[] allGroups, SequenceI seq, int lastcol) {
        Color color = this.resColFinder.GAP_COLOUR;
        if (seq != null && seq.getLength() > lastcol) {
            color = this.resColFinder.getResidueColour(true, this.shader, allGroups, seq, lastcol, this.finder);
        }
        return color.getRGB();
    }

    private void overlayHiddenRegions(AlignmentRowsCollectionI rows, AlignmentColsCollectionI cols) {
        if (cols.hasHidden() || rows.hasHidden()) {
            BufferedImage mask = this.buildHiddenImage(rows, cols, this.miniMe.getWidth(), this.miniMe.getHeight());
            Graphics2D g = (Graphics2D)this.miniMe.getGraphics();
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g.drawImage(mask, 0, 0, this.miniMe.getWidth(), this.miniMe.getHeight(), null);
        }
    }

    private BufferedImage buildHiddenImage(AlignmentRowsCollectionI rows, AlignmentColsCollectionI cols, int width, int height) {
        BufferedImage hiddenImage = new BufferedImage(width, height, 2);
        int colIndex = 0;
        int pixelCol = 0;
        Color hidden = this.resColFinder.getHiddenColour();
        Graphics2D g2d = (Graphics2D)hiddenImage.getGraphics();
        g2d.setComposite(AlphaComposite.Src);
        Iterator iterator = cols.iterator();
        while (iterator.hasNext()) {
            int alignmentCol = (Integer)iterator.next();
            if (this.redraw) break;
            int endCol = Math.min(Math.round((float)(colIndex + 1) * this.pixelsPerCol) - 1, hiddenImage.getWidth() - 1);
            if (pixelCol <= endCol) {
                if (cols.isHidden(alignmentCol)) {
                    g2d.setColor(hidden);
                    g2d.fillRect(pixelCol, 0, endCol - pixelCol + 1, height);
                }
                pixelCol = endCol + 1;
            }
            ++colIndex;
        }
        int seqIndex = 0;
        int pixelRow = 0;
        Iterator iterator2 = rows.iterator();
        while (iterator2.hasNext()) {
            int alignmentRow = (Integer)iterator2.next();
            if (this.redraw) break;
            int endRow = Math.min(Math.round((float)(seqIndex + 1) * this.pixelsPerSeq) - 1, this.miniMe.getHeight() - 1);
            if (rows.isHidden(alignmentRow)) {
                g2d.setColor(hidden);
                g2d.fillRect(0, pixelRow, width, endRow - pixelRow + 1);
            }
            pixelRow = endRow + 1;
            ++seqIndex;
        }
        return hiddenImage;
    }

    public void drawGraph(Graphics g, AlignmentAnnotation anno, int y, AlignmentColsCollectionI cols) {
        Annotation[] annotations = anno.annotations;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.miniMe.getWidth(), y);
        int colIndex = 0;
        int pixelCol = 0;
        Iterator iterator = cols.iterator();
        while (iterator.hasNext()) {
            int alignmentCol = (Integer)iterator.next();
            if (this.redraw) {
                this.changeSupport.firePropertyChange(UPDATE, 99, 0);
                break;
            }
            if (alignmentCol >= annotations.length) break;
            int endCol = Math.min(Math.round((float)(colIndex + 1) * this.pixelsPerCol) - 1, this.miniMe.getWidth() - 1);
            if (annotations[alignmentCol] != null) {
                if (annotations[alignmentCol].colour == null) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(annotations[alignmentCol].colour);
                }
                int height = (int)(annotations[alignmentCol].value / anno.graphMax * (float)y);
                if (height > y) {
                    height = y;
                }
                g.fillRect(pixelCol, y - height, endCol - pixelCol + 1, height);
            }
            pixelCol = endCol + 1;
            ++colIndex;
        }
        this.changeSupport.firePropertyChange(UPDATE, 99, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRedraw(boolean b) {
        OverviewRenderer overviewRenderer = this;
        synchronized (overviewRenderer) {
            this.redraw = b;
        }
    }

    public void addPropertyChangeListener(RendererListenerI listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(RendererListenerI listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }
}

