/*
 * Decompiled with CFR 0.152.
 */
package jalview.json.binding.biojson.v1;

import com.github.reinert.jjschema.Attributes;

public class SequencePojo {
    @Attributes(required=true, minLength=3, maxLength=0x7FFFFFFFL, description="Sequence residue characters. An aligned sequence may contain <br>one of the following gap characters &#x201c;.&#x201d;, &#x201c;-&#x201d; or &#x201c;&nbsp;&#x201d;")
    private String seq;
    @Attributes(required=true, description="Sequence name")
    private String name;
    @Attributes(required=false, description="Sequence type", enums={"DNA", "RNA", "Protein"})
    private String type;
    @Attributes(required=true, description="Unique identifier for a given Sequence")
    private String id;
    @Attributes(required=false, description="The order/position of a sequence in the alignment space")
    private int order;
    @Attributes(required=true, description="The index of the sequence\u2019s first residue in its source database, <br>using a one-based numbering index system")
    private int start;
    @Attributes(required=true, description="The index of the sequence\u2019s last residue in its source database, <br>using a one-based numbering index system")
    private int end;

    public SequencePojo() {
    }

    public SequencePojo(int start, int end, String id, String name, String seq) {
        this.id = id;
        this.name = name;
        this.seq = seq;
    }

    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

