/*
 * Decompiled with CFR 0.152.
 */
package jalview.jbgui;

import jalview.jbgui.GAlignFrame;
import jalview.util.Platform;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JInternalFrame;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class GSplitFrame
extends JInternalFrame {
    protected static final int DIVIDER_SIZE = 5;
    private static final long serialVersionUID = 1L;
    private GAlignFrame topFrame;
    private GAlignFrame bottomFrame;
    private JSplitPane splitPane;
    private double dividerRatio;

    public GSplitFrame(GAlignFrame top, GAlignFrame bottom) {
        this.setName("jalview-splitframe");
        this.topFrame = top;
        this.bottomFrame = bottom;
        this.hideTitleBars();
        this.addSplitPane();
    }

    protected void addSplitPane() {
        this.splitPane = new JSplitPane(0, this.topFrame, this.bottomFrame);
        this.splitPane.setVisible(true);
        int topFrameHeight = this.topFrame.getHeight();
        this.splitPane.setDividerSize(5);
        if (topFrameHeight == 0) {
            this.setRelativeDividerLocation(0.5);
        } else {
            int dividerPosition = topFrameHeight + 2;
            this.splitPane.setDividerLocation(dividerPosition);
        }
        this.splitPane.setResizeWeight(0.5);
        this.add(this.splitPane);
    }

    protected void hideTitleBars() {
        if (Platform.isAMacAndNotJS()) {
            this.topFrame.putClientProperty("JInternalFrame.isPalette", true);
            this.bottomFrame.putClientProperty("JInternalFrame.isPalette", true);
        } else {
            ((BasicInternalFrameUI)this.topFrame.getUI()).setNorthPane(null);
            ((BasicInternalFrameUI)this.bottomFrame.getUI()).setNorthPane(null);
        }
    }

    public GAlignFrame getTopFrame() {
        return this.topFrame;
    }

    public GAlignFrame getBottomFrame() {
        return this.bottomFrame;
    }

    protected GAlignFrame getFrameAtMouse() {
        Point loc = MouseInfo.getPointerInfo().getLocation();
        if (this.isIn(loc, this.splitPane.getTopComponent())) {
            return this.getTopFrame();
        }
        if (this.isIn(loc, this.splitPane.getBottomComponent())) {
            return this.getBottomFrame();
        }
        return null;
    }

    private boolean isIn(Point loc, Component comp) {
        if (!comp.isVisible()) {
            return false;
        }
        Point p = comp.getLocationOnScreen();
        Rectangle r = new Rectangle(p.x, p.y, comp.getWidth(), comp.getHeight());
        return r.contains(loc);
    }

    public void setComplementVisible(Object alignFrame, boolean show) {
        if (show) {
            this.setRelativeDividerLocation(this.dividerRatio);
        } else {
            this.dividerRatio = (double)this.splitPane.getDividerLocation() / (double)(this.splitPane.getHeight() - this.splitPane.getDividerSize());
        }
        if (alignFrame == this.topFrame) {
            this.bottomFrame.setVisible(show);
        } else if (alignFrame == this.bottomFrame) {
            this.topFrame.setVisible(show);
        }
        this.validate();
    }

    public void setRelativeDividerLocation(double r) {
        this.dividerRatio = r;
        this.splitPane.setDividerLocation(r);
    }

    protected void setDividerLocation(int p) {
        this.splitPane.setDividerLocation(p);
    }

    protected int getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }
}

