/*
 * Decompiled with CFR 0.152.
 */
package jalview.jbgui;

import jalview.io.cache.JvCacheableInputBox;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class GFinder
extends JPanel {
    private static final Font VERDANA_12 = new Font("Verdana", 0, 12);
    private static final String FINDER_CACHE_KEY = "CACHE.FINDER";
    private static final int PANEL_ROWS = 4;
    protected JButton createFeatures;
    protected JvCacheableInputBox<String> searchBox;
    protected JCheckBox caseSensitive;
    protected JCheckBox searchDescription;
    protected JCheckBox ignoreHidden;

    public GFinder() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        JPanel eastPanel = new JPanel();
        eastPanel.setLayout(new GridLayout(4, 1));
        this.add((Component)eastPanel, "East");
        JPanel centrePanel = new JPanel();
        centrePanel.setLayout(new GridLayout(4, 1));
        this.add((Component)centrePanel, "Center");
        JPanel westPanel = new JPanel();
        westPanel.setLayout(new GridLayout(4, 1));
        this.add((Component)westPanel, "West");
        JLabel findLabel = new JLabel(" " + MessageManager.getString("label.find") + " ");
        findLabel.setFont(VERDANA_12);
        westPanel.add(findLabel);
        this.searchBox = new JvCacheableInputBox(FINDER_CACHE_KEY, 25);
        this.searchBox.getComponent().setFont(VERDANA_12);
        this.searchBox.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                GFinder.this.textfield_caretUpdate();
            }
        });
        this.searchBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                GFinder.this.textfield_keyPressed(e);
            }
        });
        centrePanel.add(this.searchBox.getComponent());
        this.caseSensitive = new JCheckBox();
        this.caseSensitive.setHorizontalAlignment(2);
        this.caseSensitive.setText(MessageManager.getString("label.match_case"));
        this.searchDescription = new JCheckBox();
        this.searchDescription.setText(MessageManager.getString("label.include_description"));
        this.ignoreHidden = new JCheckBox();
        this.ignoreHidden.setText(MessageManager.getString("label.ignore_hidden"));
        this.ignoreHidden.setToolTipText(MessageManager.getString("label.ignore_hidden_tooltip"));
        centrePanel.add(this.caseSensitive);
        centrePanel.add(this.searchDescription);
        centrePanel.add(this.ignoreHidden);
        JButton findAll = new JButton(MessageManager.getString("action.find_all"));
        findAll.setFont(VERDANA_12);
        findAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFinder.this.findAll_actionPerformed();
            }
        });
        JButton findNext = new JButton(MessageManager.getString("action.find_next"));
        findNext.setFont(VERDANA_12);
        findNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFinder.this.findNext_actionPerformed();
            }
        });
        this.createFeatures = new JButton();
        this.createFeatures.setEnabled(false);
        this.createFeatures.setFont(VERDANA_12);
        this.createFeatures.setText(MessageManager.getString("label.new_feature"));
        this.createFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GFinder.this.createFeatures_actionPerformed();
            }
        });
        eastPanel.add(findNext);
        eastPanel.add(findAll);
        eastPanel.add(this.createFeatures);
    }

    protected void textfield_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && !this.searchBox.isPopupVisible()) {
            e.consume();
            this.findNext_actionPerformed();
        }
    }

    protected void findNext_actionPerformed() {
    }

    protected void findAll_actionPerformed() {
    }

    public void createFeatures_actionPerformed() {
    }

    public void textfield_caretUpdate() {
    }
}

