/*
 * Decompiled with CFR 0.152.
 */
package jalview.javascript.log4j;

import jalview.javascript.log4j.Appender;
import jalview.javascript.log4j.Level;
import jalview.javascript.log4j.spi.LoggingEvent;
import java.util.Hashtable;
import java.util.Map;

public class Logger {
    private static Map<String, Logger> registry;
    private String name;
    private Level level;
    private boolean enabled = true;
    private boolean isEnabled;
    private Appender appender;

    private Logger(String name) {
        this.name = name;
    }

    public static Logger getLogger(String name) {
        Logger logger;
        if (registry == null) {
            registry = new Hashtable<String, Logger>();
            Logger.getLogger("root");
        }
        if ((logger = registry.get(name)) == null) {
            logger = new Logger(name);
            registry.put(name, logger);
            logger.setLevel(Level.INFO);
        }
        return logger;
    }

    public static Logger getRootLogger() {
        return Logger.getLogger("root");
    }

    public void setLevel(Level l) {
        this.level = l;
    }

    public void addAppender(Appender appender) {
        this.appender = appender;
    }

    public boolean isDebugEnabled() {
        return this.isEnabled;
    }

    public void debug(Object o) {
        this.debug(o, null);
    }

    public void debug(Object o, Throwable e) {
        switch (this.level.level) {
            case 10000: 
            case 20000: 
            case 30000: 
            case 40000: 
            case 50000: {
                this.log(o, e);
            }
        }
    }

    public void info(Object o) {
        this.info(o, null);
    }

    public void info(Object o, Throwable e) {
        switch (this.level.level) {
            case 20000: 
            case 30000: 
            case 40000: 
            case 50000: {
                this.log(o, e);
            }
        }
    }

    public void warn(Object o) {
        this.warn(o, null);
    }

    public void warn(Object o, Throwable e) {
        switch (this.level.level) {
            case 30000: 
            case 40000: 
            case 50000: {
                this.log(o, e);
            }
        }
    }

    public void error(Object o) {
        this.error(o, null);
    }

    public void error(Object o, Throwable e) {
        switch (this.level.level) {
            case 40000: 
            case 50000: {
                this.log(o, e);
            }
        }
    }

    private void log(Object s, Throwable e) {
        switch (this.level.level) {
            case 40000: {
                if (this.appender != null) break;
                System.err.println(s);
                return;
            }
            case 30000: {
                if (this.appender != null) break;
                System.err.println(s);
                return;
            }
            case 20000: {
                if (this.appender != null) break;
                System.out.println(s);
                return;
            }
            case 10000: {
                if (this.appender != null) break;
                System.out.println(s);
                return;
            }
        }
        e.printStackTrace();
        this.appender.append(new LoggingEvent(this, s.toString(), this.level));
    }
}

