/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.gff;

import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.MappingType;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.gff.GffHelperBase;
import jalview.io.gff.SequenceOntologyFactory;
import jalview.io.gff.SequenceOntologyI;
import jalview.util.MapList;
import jalview.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class Gff3Helper
extends GffHelperBase {
    public static final String ALLELES = "alleles";
    protected static final String TARGET = "Target";
    protected static final String ID = "ID";
    private static final String NAME = "Name";

    public static Map<String, List<String>> parseNameValuePairs(String text) {
        return Gff3Helper.parseNameValuePairs(text, ";", '=', ",");
    }

    @Override
    public SequenceFeature processGff(SequenceI seq, String[] gff, AlignmentI align, List<SequenceI> newseqs, boolean relaxedIdMatching) throws IOException {
        SequenceFeature sf = null;
        if (gff.length == 9) {
            String soTerm = gff[2];
            String atts = gff[8];
            Map<String, List<String>> attributes = Gff3Helper.parseNameValuePairs(atts);
            SequenceOntologyI so = SequenceOntologyFactory.getInstance();
            sf = so.isA(soTerm, "protein_match") ? this.processProteinMatch(attributes, seq, gff, align, newseqs, relaxedIdMatching) : (so.isA(soTerm, "nucleotide_match") ? this.processNucleotideMatch(attributes, seq, gff, align, newseqs, relaxedIdMatching) : this.buildSequenceFeature(gff, attributes));
        } else {
            sf = this.buildSequenceFeature(gff, null);
        }
        return sf;
    }

    protected SequenceFeature processNucleotideMatch(Map<String, List<String>> attributes, SequenceI seq, String[] gffColumns, AlignmentI align, List<SequenceI> newseqs, boolean relaxedIdMatching) throws IOException {
        String strand = gffColumns[6];
        if ("-".equals(strand)) {
            System.err.println("Skipping mapping from reverse complement as not yet supported");
            return null;
        }
        List<String> targets = attributes.get(TARGET);
        if (targets == null) {
            System.err.println("'Target' missing in GFF");
            return null;
        }
        for (String target : targets) {
            String[] tokens = target.split(" ");
            if (tokens.length < 3) {
                System.err.println("Incomplete Target: " + target);
                continue;
            }
            String targetId = this.findTargetId(tokens[0], attributes);
            SequenceI mappedSequence1 = this.findSequence(targetId, align, newseqs, relaxedIdMatching);
            SequenceI mappedSequence = mappedSequence1;
            if (mappedSequence == null) continue;
            AlignedCodonFrame acf = this.getMapping(align, seq, mappedSequence);
            try {
                int fromEnd;
                int fromStart;
                MapList mapping;
                int toStart = Integer.parseInt(tokens[1]);
                int toEnd = Integer.parseInt(tokens[2]);
                if (tokens.length > 3 && "-".equals(tokens[3])) {
                    int temp = toStart;
                    toStart = toEnd;
                    toEnd = temp;
                }
                if ((mapping = this.constructMappingFromAlign(fromStart = Integer.parseInt(gffColumns[3]), fromEnd = Integer.parseInt(gffColumns[4]), toStart, toEnd, MappingType.NucleotideToNucleotide)) == null) continue;
                acf.addMap(seq, mappedSequence, mapping);
                align.addCodonFrame(acf);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Invalid start or end in Target " + target);
            }
        }
        SequenceFeature sf = this.buildSequenceFeature(gffColumns, attributes);
        return sf;
    }

    protected String findTargetId(String target, Map<String, List<String>> set) {
        return target;
    }

    protected SequenceFeature processProteinMatch(Map<String, List<String>> set, SequenceI seq, String[] gffColumns, AlignmentI align, List<SequenceI> newseqs, boolean relaxedIdMatching) {
        SequenceFeature sf = this.buildSequenceFeature(gffColumns, set);
        List<String> targets = set.get(TARGET);
        if (targets != null) {
            for (String target : targets) {
                SequenceI mappedSequence1 = this.findSequence(this.findTargetId(target, set), align, newseqs, relaxedIdMatching);
                SequenceI mappedSequence = mappedSequence1;
                if (mappedSequence == null) continue;
                int sequenceFeatureLength = 1 + sf.getEnd() - sf.getBegin();
                SequenceFeature sf2 = new SequenceFeature(sf, 1, sequenceFeatureLength, sf.getFeatureGroup(), sf.getScore());
                mappedSequence.addSequenceFeature(sf2);
                String accessionId = StringUtils.listToDelimitedString(set.get(NAME), ",");
                if (accessionId.length() > 0) {
                    String database = sf.getType();
                    String qualifiedAccId = database + "|" + accessionId;
                    sf2.setValue("$RENAME_TO$", qualifiedAccId);
                }
                AlignedCodonFrame alco = this.getMapping(align, seq, mappedSequence);
                int[] from = new int[]{sf.getBegin(), sf.getEnd()};
                int[] to = new int[]{1, sequenceFeatureLength};
                MapList mapping = new MapList(from, to, 1, 1);
                alco.addMap(seq, mappedSequence, mapping);
                align.addCodonFrame(alco);
            }
        }
        return sf;
    }

    @Override
    protected SequenceFeature buildSequenceFeature(String[] gff, int typeColumn, String group, Map<String, List<String>> attributes) {
        SequenceFeature sf = super.buildSequenceFeature(gff, typeColumn, group, attributes);
        String desc = this.getDescription(sf, attributes);
        if (desc != null) {
            sf.setDescription(desc);
        }
        return sf;
    }

    protected String getDescription(SequenceFeature sf, Map<String, List<String>> attributes) {
        String type;
        SequenceOntologyI so;
        String desc = null;
        String target = (String)sf.getValue(TARGET);
        if (target != null) {
            desc = target.split(" ")[0];
        }
        if ((so = SequenceOntologyFactory.getInstance()).isA(type = sf.getType(), "sequence_variant")) {
            desc = StringUtils.listToDelimitedString(attributes.get(ALLELES), ",");
        }
        if ("NMD_transcript_variant".equals(type) || so.isA(type, "transcript") || so.isA(type, "exon")) {
            desc = StringUtils.listToDelimitedString(attributes.get(NAME), ",");
        }
        if (desc == null) {
            desc = (String)sf.getValue(ID);
        }
        desc = StringUtils.urlDecode(desc, ",=;\t%");
        return desc;
    }
}

