/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Cache;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.Desktop;
import jalview.gui.TreePanel;
import jalview.io.vamsas.Datasetsequence;
import jalview.io.vamsas.DatastoreRegistry;
import jalview.io.vamsas.Dbref;
import jalview.io.vamsas.Sequencefeature;
import jalview.io.vamsas.Sequencemapping;
import jalview.io.vamsas.Tree;
import jalview.project.Jalview2XML;
import jalview.util.MapList;
import jalview.util.MessageManager;
import jalview.util.jarInputStreamProvider;
import jalview.viewmodel.AlignmentViewport;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javax.swing.JInternalFrame;
import uk.ac.vamsas.client.IClientAppdata;
import uk.ac.vamsas.client.IClientDocument;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.objects.core.AlignmentSequence;
import uk.ac.vamsas.objects.core.AlignmentSequenceAnnotation;
import uk.ac.vamsas.objects.core.AnnotationElement;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.DataSetAnnotations;
import uk.ac.vamsas.objects.core.DbRef;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.Glyph;
import uk.ac.vamsas.objects.core.Local;
import uk.ac.vamsas.objects.core.MapType;
import uk.ac.vamsas.objects.core.Mapped;
import uk.ac.vamsas.objects.core.Property;
import uk.ac.vamsas.objects.core.Provenance;
import uk.ac.vamsas.objects.core.RangeAnnotation;
import uk.ac.vamsas.objects.core.RangeType;
import uk.ac.vamsas.objects.core.Seg;
import uk.ac.vamsas.objects.core.Sequence;
import uk.ac.vamsas.objects.core.SequenceType;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.utils.Properties;

public class VamsasAppDatastore {
    public static final String JALVIEW_ANNOTATION_ROW = "JalviewAnnotation";
    public static final String DISCRETE_ANNOTATION = "discrete";
    private static final String CONTINUOUS_ANNOTATION = "continuous";
    private static final String THRESHOLD = "threshold";
    Entry provEntry = null;
    IClientDocument cdoc;
    Hashtable vobj2jv;
    IdentityHashMap jv2vobj;
    Hashtable alignRDHash;
    Hashtable skipList;
    boolean dojvsync = true;
    private final Vector newAlignmentViews = new Vector();
    private static int HASSECSTR = 0;
    private static int HASVALS = 1;
    private static int HASHPHOB = 2;
    private static int HASDC = 3;
    private static int HASDESCSTR = 4;
    private static int HASTWOSTATE = 5;
    DatastoreRegistry dsReg = new DatastoreRegistry();

    public VamsasAppDatastore(IClientDocument cdoc, Hashtable vobj2jv, IdentityHashMap jv2vobj, Entry provEntry, Hashtable alignRDHash) {
        this.cdoc = cdoc;
        this.vobj2jv = vobj2jv;
        this.jv2vobj = jv2vobj;
        this.provEntry = provEntry;
        this.alignRDHash = alignRDHash;
        this.buildSkipList();
    }

    private void buildSkipList() {
        this.skipList = new Hashtable();
        AlignFrame[] al = Desktop.getAlignFrames();
        for (int f = 0; al != null && f < al.length; ++f) {
            this.skipList.put(al[f].getViewport().getSequenceSetId(), al[f]);
        }
    }

    protected Vobject getjv2vObj(Object jvobj) {
        if (this.jv2vobj.containsKey(jvobj)) {
            return this.cdoc.getObject((VorbaId)this.jv2vobj.get(jvobj));
        }
        if (jvobj instanceof String) {
            Object seqsetidobj = null;
            seqsetidobj = this.getVamsasObjectBinding().get(jvobj);
            if (seqsetidobj != null) {
                if (seqsetidobj instanceof String) {
                    Vobject obj = this.getjv2vObj(seqsetidobj);
                    if (obj != null && !(obj instanceof uk.ac.vamsas.objects.core.Alignment)) {
                        Cache.log.warn((Object)("IMPLEMENTATION ERROR?: Unexpected mapping for unmapped jalview string object content:" + seqsetidobj + " to object " + obj));
                    }
                    return obj;
                }
                Cache.log.warn((Object)("Unexpected mapping for Jalview String Object ID " + seqsetidobj + " to another jalview dataset object " + seqsetidobj));
            }
        }
        if (Cache.log.isDebugEnabled()) {
            Cache.log.debug((Object)("Returning null VorbaID binding for jalview object " + jvobj));
        }
        return null;
    }

    protected Object getvObj2jv(Vobject vobj) {
        VorbaId id = vobj.getVorbaId();
        if (id == null) {
            id = this.cdoc.registerObject(vobj);
            Cache.log.debug((Object)"Registering new object and returning null for getvObj2jv");
            return null;
        }
        if (this.vobj2jv.containsKey(vobj.getVorbaId())) {
            return this.vobj2jv.get(vobj.getVorbaId());
        }
        return null;
    }

    protected void bindjvvobj(Object jvobj, Vobject vobj) {
        VorbaId id = vobj.getVorbaId();
        if (id == null && ((id = this.cdoc.registerObject(vobj)) == null || vobj.getVorbaId() == null || this.cdoc.getObject(id) != vobj)) {
            Cache.log.error((Object)("Failed to get id for " + (vobj.isRegisterable() ? "registerable" : "unregisterable") + " object " + vobj));
        }
        if (this.vobj2jv.containsKey(vobj.getVorbaId()) && !((VorbaId)this.vobj2jv.get(vobj.getVorbaId())).equals(jvobj)) {
            Cache.log.debug((Object)("Warning? Overwriting existing vamsas id binding for " + vobj.getVorbaId()), (Throwable)new Exception(MessageManager.getString("exception.overwriting_vamsas_id_binding")));
        } else if (this.jv2vobj.containsKey(jvobj) && !((VorbaId)this.jv2vobj.get(jvobj)).equals((Object)vobj.getVorbaId())) {
            Cache.log.debug((Object)("Warning? Overwriting existing jalview object binding for " + jvobj), (Throwable)new Exception("Overwriting jalview object binding."));
        }
        Cache.log.debug((Object)("Binding " + vobj.getVorbaId() + " to " + jvobj));
        this.vobj2jv.put(vobj.getVorbaId(), jvobj);
        this.jv2vobj.put(jvobj, vobj.getVorbaId());
    }

    public boolean storeVAMSAS(AlignViewport av, String aFtitle) {
        try {
            int i;
            uk.ac.vamsas.objects.core.Alignment alignment;
            AlignmentI jal = av.getAlignment();
            AlignmentI jds = jal.getDataset();
            boolean nw = false;
            VAMSAS root = null;
            DataSet dataset = null;
            if (jds == null) {
                Cache.log.warn((Object)"Creating new dataset for an alignment.");
                jal.setDataset(null);
                jds = jal.getDataset();
            }
            if ((dataset = (alignment = (uk.ac.vamsas.objects.core.Alignment)this.getjv2vObj(av.getSequenceSetId())) != null ? (DataSet)alignment.getV_parent() : (DataSet)this.getjv2vObj(jds)) == null) {
                SequenceI[] jdatset = jds.getSequencesArray();
                for (int i2 = 0; i2 < jdatset.length; ++i2) {
                    Vobject vbound = this.getjv2vObj(jdatset[i2]);
                    if (vbound == null || !(vbound instanceof Sequence)) continue;
                    if (dataset == null) {
                        dataset = (DataSet)vbound.getV_parent();
                        continue;
                    }
                    if (vbound.getV_parent() == null || dataset == vbound.getV_parent()) continue;
                    throw new Error("IMPLEMENTATION ERROR: Cannot map an alignment of sequences from different datasets into a single alignment in the vamsas document.");
                }
            }
            if (dataset == null) {
                Cache.log.warn((Object)("Creating new vamsas dataset for alignment view " + av.getSequenceSetId()));
                root = this.cdoc.getVamsasRoots()[0];
                dataset = new DataSet();
                root.addDataSet(dataset);
                this.bindjvvobj(jds, (Vobject)dataset);
                dataset.setProvenance(this.dummyProvenance());
                nw = true;
            } else {
                root = (VAMSAS)dataset.getV_parent();
            }
            String dict = jal.isNucleotide() ? "info:iubmb.org/nucleosides" : "info:iubmb.org/aminoacids";
            Vector<Sequence> dssmods = new Vector<Sequence>();
            for (i = 0; i < jal.getHeight(); ++i) {
                SequenceI sq = jal.getSequenceAt(i).getDatasetSequence();
                Datasetsequence dssync = new Datasetsequence(this, sq, dict, dataset);
                Sequence sequence = (Sequence)dssync.getVobj();
                if (!dssync.getModified()) continue;
                dssmods.addElement(sequence);
            }
            if (dssmods.size() > 0 && !nw) {
                Entry pentry = this.addProvenance(dataset.getProvenance(), "updated sequences");
                dssmods.removeAllElements();
            }
            if (this.alignmentWillBeSkipped(av)) {
                this.addToSkipList(av);
                return false;
            }
            if (alignment == null) {
                alignment = new uk.ac.vamsas.objects.core.Alignment();
                this.bindjvvobj(av.getSequenceSetId(), (Vobject)alignment);
                if (alignment.getProvenance() == null) {
                    alignment.setProvenance(new Provenance());
                }
                this.addProvenance(alignment.getProvenance(), "added");
                dataset.addAlignment(alignment);
                Property title = new Property();
                title.setName("title");
                title.setType("string");
                title.setContent(aFtitle);
                alignment.addProperty(title);
                alignment.setGapChar(String.valueOf(av.getGapCharacter()));
                for (i = 0; i < jal.getHeight(); ++i) {
                    this.syncToAlignmentSequence(jal.getSequenceAt(i), alignment, null);
                }
                this.alignRDHash.put(av.getSequenceSetId(), av.getUndoRedoHash());
            } else {
                boolean alismod = av.isUndoRedoHashModified((long[])this.alignRDHash.get(av.getSequenceSetId()));
                if (alignment.getModifiable() == null || alignment.getModifiable().length() == 0) {
                    boolean modified = false;
                    Vector docseqs = new Vector(alignment.getAlignmentSequenceAsReference());
                    for (int i3 = 0; i3 < jal.getHeight(); ++i3) {
                        modified |= this.syncToAlignmentSequence(jal.getSequenceAt(i3), alignment, docseqs);
                    }
                    if (docseqs.size() > 0) {
                        docseqs.removeAllElements();
                        System.out.println("Sequence deletion from alignment is not implemented.");
                    }
                    if (modified) {
                        if (alismod) {
                            this.addProvenance(alignment.getProvenance(), "Edited");
                        } else {
                            this.addProvenance(alignment.getProvenance(), "Attributes Edited");
                        }
                    }
                    if (alismod) {
                        System.out.println("update alignment in document.");
                    } else {
                        System.out.println("alignment in document left unchanged.");
                    }
                } else {
                    System.out.println("update edited alignment to new alignment in document.");
                }
            }
            int iSize = alignment.getAlignmentSequenceCount();
            for (i = 0; i < iSize; ++i) {
                AlignmentSequence valseq = alignment.getAlignmentSequence(i);
                SequenceI alseq = (SequenceI)this.getvObj2jv((Vobject)valseq);
                if (alseq != null && alseq.getSequenceFeatures() == null) continue;
            }
            if (jal.getAlignmentAnnotation() != null) {
                AlignmentAnnotation[] aa = jal.getAlignmentAnnotation();
                HashMap AlSeqMaps = new HashMap();
                block7: for (int i4 = 0; i4 < aa.length; ++i4) {
                    if (aa[i4] == null || this.isJalviewOnly(aa[i4])) continue;
                    if (aa[i4].groupRef != null) {
                        Cache.log.warn((Object)"Group associated sequence annotation is not stored in VAMSAS document.");
                        continue;
                    }
                    if (aa[i4].sequenceRef != null) {
                        Vobject sref = this.getjv2vObj(aa[i4].sequenceRef);
                        if (sref instanceof AlignmentSequence) {
                            this.saveAlignmentSequenceAnnotation(AlSeqMaps, (AlignmentSequence)sref, aa[i4]);
                            continue;
                        }
                        for (SequenceI jvalsq : av.getAlignment().getSequences()) {
                            if (jvalsq.getDatasetSequence() != aa[i4].sequenceRef) continue;
                            Vobject alsref = this.getjv2vObj(jvalsq);
                            this.saveAlignmentSequenceAnnotation(AlSeqMaps, (AlignmentSequence)alsref, aa[i4]);
                            continue block7;
                        }
                        continue;
                    }
                    uk.ac.vamsas.objects.core.AlignmentAnnotation an = (uk.ac.vamsas.objects.core.AlignmentAnnotation)this.getjv2vObj(aa[i4]);
                    if (an == null) {
                        an = new uk.ac.vamsas.objects.core.AlignmentAnnotation();
                        an.setType(JALVIEW_ANNOTATION_ROW);
                        an.setDescription(aa[i4].description);
                        alignment.addAlignmentAnnotation(an);
                        Seg vSeg = new Seg();
                        vSeg.setStart(1);
                        vSeg.setInclusive(true);
                        vSeg.setEnd(jal.getWidth());
                        an.addSeg(vSeg);
                        if (aa[i4].graph > 0) {
                            an.setGraph(true);
                        }
                        an.setLabel(aa[i4].label);
                        an.setProvenance(this.dummyProvenance());
                        if (aa[i4].graph != 0) {
                            an.setGroup(Integer.toString(aa[i4].graphGroup));
                            an.setGraph(true);
                        } else {
                            an.setGraph(false);
                        }
                        for (int a = 0; a < aa[i4].annotations.length; ++a) {
                            if (aa[i4] == null || aa[i4].annotations[a] == null) continue;
                            AnnotationElement ae = new AnnotationElement();
                            ae.setDescription(aa[i4].annotations[a].description);
                            ae.addGlyph(new Glyph());
                            ae.getGlyph(0).setContent(aa[i4].annotations[a].displayCharacter);
                            if (an.isGraph()) {
                                ae.addValue(aa[i4].annotations[a].value);
                            }
                            ae.setPosition((long)(a + 1));
                            if (aa[i4].annotations[a].secondaryStructure != ' ') {
                                Glyph ss = new Glyph();
                                ss.setDict("aasecstr_3");
                                ss.setContent(String.valueOf(aa[i4].annotations[a].secondaryStructure));
                                ae.addGlyph(ss);
                            }
                            an.addAnnotationElement(ae);
                        }
                        if (aa[i4].editable) {
                            // empty if block
                        }
                        this.setAnnotationType((RangeAnnotation)an, aa[i4]);
                        if (aa[i4].graph == 0) continue;
                        an.setGraph(true);
                        an.setGroup(Integer.toString(aa[i4].graphGroup));
                        if (aa[i4].threshold == null || !aa[i4].threshold.displayed) continue;
                        an.addProperty(Properties.newProperty((String)THRESHOLD, (String)"float", (String)("" + aa[i4].threshold.value)));
                        if (aa[i4].threshold.label == null) continue;
                        an.addProperty(Properties.newProperty((String)"thresholdName", (String)"string", (String)("" + aa[i4].threshold.label)));
                        continue;
                    }
                    if (an.getModifiable() == null) {
                        Cache.log.info((Object)"update alignment sequence annotation. not yet implemented.");
                        continue;
                    }
                    Cache.log.info((Object)"updated alignment sequence annotation added.");
                }
            }
            if (Desktop.desktop != null) {
                JInternalFrame[] frames = Desktop.instance.getAllFrames();
                for (int t = 0; t < frames.length; ++t) {
                    TreePanel tp;
                    if (!(frames[t] instanceof TreePanel) || !(tp = (TreePanel)frames[t]).getViewPort().getSequenceSetId().equals(av.getSequenceSetId())) continue;
                    Tree tree = new Tree(this, tp, jal, alignment);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean alignmentWillBeSkipped(AlignmentViewport av) {
        return !av.getAlignment().isAligned();
    }

    private void addToSkipList(AlignmentViewport av) {
        if (this.skipList == null) {
            this.skipList = new Hashtable();
        }
        this.skipList.put(av.getSequenceSetId(), av);
    }

    private void removeValignmentSequences(uk.ac.vamsas.objects.core.Alignment alignment, Vector docseqs) {
        Enumeration en = docseqs.elements();
        while (en.hasMoreElements()) {
            alignment.removeAlignmentSequence((AlignmentSequence)en.nextElement());
        }
        Entry pe = this.addProvenance(alignment.getProvenance(), "Removed " + docseqs.size() + " sequences");
        en = alignment.enumerateAlignmentAnnotation();
        Vector<uk.ac.vamsas.objects.core.AlignmentAnnotation> toremove = new Vector<uk.ac.vamsas.objects.core.AlignmentAnnotation>();
        while (en.hasMoreElements()) {
            uk.ac.vamsas.objects.core.AlignmentAnnotation alan = (uk.ac.vamsas.objects.core.AlignmentAnnotation)en.nextElement();
            if (alan.getSeqrefsCount() <= 0) continue;
            boolean p = false;
            Vector storem = new Vector();
            Enumeration sr = alan.enumerateSeqrefs();
            while (sr.hasMoreElements()) {
                Object alsr = sr.nextElement();
                if (!docseqs.contains(alsr)) continue;
                storem.addElement(alsr);
            }
            sr = storem.elements();
            while (sr.hasMoreElements()) {
                alan.removeSeqrefs(sr.nextElement());
            }
            if (alan.getSeqrefsCount() != 0) continue;
            toremove.addElement(alan);
        }
        en = toremove.elements();
        while (en.hasMoreElements()) {
            alignment.removeAlignmentAnnotation((uk.ac.vamsas.objects.core.AlignmentAnnotation)en.nextElement());
        }
    }

    private boolean syncToAlignmentSequence(SequenceI jvalsq, uk.ac.vamsas.objects.core.Alignment alignment, Vector unbounddocseq) {
        boolean modal = false;
        boolean up2doc = false;
        AlignmentSequence alseq = (AlignmentSequence)this.getjv2vObj(jvalsq);
        if (alseq == null) {
            alseq = new AlignmentSequence();
            up2doc = true;
        } else if (unbounddocseq != null) {
            unbounddocseq.removeElement(alseq);
        }
        if (up2doc || !alseq.getSequence().equals(jvalsq.getSequenceAsString())) {
            alseq.setSequence(jvalsq.getSequenceAsString());
            alseq.setStart((long)jvalsq.getStart());
            alseq.setEnd((long)jvalsq.getEnd());
            modal = true;
        }
        if (up2doc || !alseq.getName().equals(jvalsq.getName())) {
            modal = true;
            alseq.setName(jvalsq.getName());
        }
        if (!(jvalsq.getDescription() == null || alseq.getDescription() != null && jvalsq.getDescription().equals(alseq.getDescription()))) {
            modal = true;
            alseq.setDescription(jvalsq.getDescription());
        }
        if (this.getjv2vObj(jvalsq.getDatasetSequence()) == null) {
            Cache.log.warn((Object)("Serious Implementation error - Unbound dataset sequence in alignment: " + jvalsq.getDatasetSequence()));
        }
        alseq.setRefid((Object)this.getjv2vObj(jvalsq.getDatasetSequence()));
        if (up2doc) {
            alignment.addAlignmentSequence(alseq);
            this.bindjvvobj(jvalsq, (Vobject)alseq);
        }
        return up2doc || modal;
    }

    private boolean syncFromAlignmentSequence(AlignmentSequence valseq, char valGapchar, char gapChar, List<SequenceI> dsseqs) {
        Vobject datsetseq;
        boolean modal = false;
        boolean upFromdoc = false;
        SequenceI alseq = (SequenceI)this.getvObj2jv((Vobject)valseq);
        if (alseq == null) {
            upFromdoc = true;
        }
        if (alseq != null) {
            if (upFromdoc || !valseq.getSequence().equals(alseq.getSequenceAsString())) {
                alseq.setSequence(new String(valseq.getSequence()).replace(valGapchar, gapChar));
                alseq.setStart((int)valseq.getStart());
                alseq.setEnd((int)valseq.getEnd());
                modal = true;
            }
            if (!valseq.getName().equals(alseq.getName())) {
                modal = true;
                alseq.setName(valseq.getName());
            }
            if (alseq.getDescription() == null || valseq.getDescription() != null && !alseq.getDescription().equals(valseq.getDescription())) {
                alseq.setDescription(valseq.getDescription());
                modal = true;
            }
            if (modal && Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Updating apparently edited sequence " + alseq.getName()));
            }
        } else {
            alseq = new jalview.datamodel.Sequence(valseq.getName(), valseq.getSequence().replace(valGapchar, gapChar), (int)valseq.getStart(), (int)valseq.getEnd());
            datsetseq = (Vobject)valseq.getRefid();
            if (datsetseq != null) {
                alseq.setDatasetSequence((SequenceI)this.getvObj2jv(datsetseq));
                if (valseq.getDescription() != null) {
                    alseq.setDescription(valseq.getDescription());
                } else if (alseq.getDatasetSequence().getDescription() != null) {
                    alseq.setDescription(alseq.getDatasetSequence().getDescription());
                }
            } else {
                Cache.log.error((Object)("Invalid dataset sequence id (null) for alignment sequence " + valseq.getVorbaId()));
            }
            this.bindjvvobj(alseq, (Vobject)valseq);
            alseq.setVamsasId(valseq.getVorbaId().getId());
            dsseqs.add(alseq);
        }
        if ((datsetseq = (Vobject)valseq.getRefid()) != null) {
            if (datsetseq != alseq.getDatasetSequence()) {
                modal = true;
            }
            alseq.setDatasetSequence((SequenceI)this.getvObj2jv(datsetseq));
        }
        return upFromdoc || modal;
    }

    private void initRangeAnnotationType(RangeAnnotation an, AlignmentAnnotation alan, int[] gapMap) {
        Seg vSeg = new Seg();
        vSeg.setStart(1);
        vSeg.setInclusive(true);
        vSeg.setEnd(gapMap.length);
        an.addSeg(vSeg);
        an.setDescription(alan.description);
        an.setLabel(alan.label);
        an.setGroup(Integer.toString(alan.graphGroup));
        for (int a = 0; a < alan.annotations.length; ++a) {
            if (alan.annotations[a] == null) continue;
            AnnotationElement ae = new AnnotationElement();
            ae.setDescription(alan.annotations[a].description);
            ae.addGlyph(new Glyph());
            ae.getGlyph(0).setContent(alan.annotations[a].displayCharacter);
            if (alan.graph != 0) {
                ae.addValue(alan.annotations[a].value);
            }
            ae.setPosition((long)(gapMap[a] + 1));
            if (alan.annotations[a].secondaryStructure != ' ') {
                Glyph ss = new Glyph();
                ss.setDict("aasecstr_3");
                ss.setContent(String.valueOf(alan.annotations[a].secondaryStructure));
                ae.addGlyph(ss);
            }
            an.addAnnotationElement(ae);
        }
    }

    private void saveDatasetSequenceAnnotation(HashMap AlSeqMaps, Sequence sref, AlignmentAnnotation alan) {
        DataSetAnnotations an = (DataSetAnnotations)this.getjv2vObj(alan);
        int[] gapMap = this.getGapMap(AlSeqMaps, alan);
        if (an == null) {
            an = new DataSetAnnotations();
            this.initRangeAnnotationType((RangeAnnotation)an, alan, gapMap);
            an.setProvenance(this.dummyProvenance());
            this.setAnnotationType((RangeAnnotation)an, alan);
            an.setGroup(Integer.toString(alan.graphGroup));
            if (alan.getThreshold() != null && alan.getThreshold().displayed) {
                an.addProperty(Properties.newProperty((String)THRESHOLD, (String)"float", (String)("" + alan.getThreshold().value)));
                if (alan.getThreshold().label != null) {
                    an.addProperty(Properties.newProperty((String)"thresholdName", (String)"string", (String)("" + alan.getThreshold().label)));
                }
            }
            ((DataSet)sref.getV_parent()).addDataSetAnnotations(an);
            this.bindjvvobj(alan, (Vobject)an);
        } else if (an.getModifiable() == null) {
            System.out.println("update dataset sequence annotation.");
        } else {
            System.out.println("make new alignment dataset sequence annotation if modification has happened.");
        }
    }

    private int[] getGapMap(HashMap AlSeqMaps, AlignmentAnnotation alan) {
        int[] gapMap;
        if (AlSeqMaps.containsKey(alan.sequenceRef)) {
            gapMap = (int[])AlSeqMaps.get(alan.sequenceRef);
        } else {
            gapMap = new int[alan.sequenceRef.getLength()];
            int[] sgapMap = alan.sequenceRef.gapMap();
            for (int a = 0; a < sgapMap.length; ++a) {
                gapMap[sgapMap[a]] = a;
            }
        }
        return gapMap;
    }

    private void saveAlignmentSequenceAnnotation(HashMap AlSeqMaps, AlignmentSequence alsref, AlignmentAnnotation alan) {
        AlignmentSequenceAnnotation an = (AlignmentSequenceAnnotation)this.getjv2vObj(alan);
        int[] gapMap = this.getGapMap(AlSeqMaps, alan);
        if (an == null) {
            an = new AlignmentSequenceAnnotation();
            this.initRangeAnnotationType((RangeAnnotation)an, alan, gapMap);
            an.setType(JALVIEW_ANNOTATION_ROW);
            alsref.addAlignmentSequenceAnnotation(an);
            this.bindjvvobj(alan, (Vobject)an);
            this.setAnnotationType((RangeAnnotation)an, alan);
            an.setProvenance(this.dummyProvenance());
        } else if (an.getModifiable() == null) {
            System.out.println("update alignment sequence annotation.");
        } else {
            System.out.println("make new alignment sequence annotation if modification has happened.");
        }
    }

    private void setAnnotationType(RangeAnnotation an, AlignmentAnnotation alan) {
        if (an instanceof AlignmentSequenceAnnotation) {
            if (alan.graph != 0) {
                ((AlignmentSequenceAnnotation)an).setGraph(true);
            } else {
                ((AlignmentSequenceAnnotation)an).setGraph(false);
            }
        }
        if (an instanceof uk.ac.vamsas.objects.core.AlignmentAnnotation) {
            if (alan.graph != 0) {
                ((uk.ac.vamsas.objects.core.AlignmentAnnotation)an).setGraph(true);
            } else {
                ((uk.ac.vamsas.objects.core.AlignmentAnnotation)an).setGraph(false);
            }
        }
        switch (alan.graph) {
            case 1: {
                an.addProperty(Properties.newProperty((String)DISCRETE_ANNOTATION, (String)"boolean", (String)"true"));
                break;
            }
            case 2: {
                an.addProperty(Properties.newProperty((String)CONTINUOUS_ANNOTATION, (String)"boolean", (String)"true"));
                break;
            }
        }
    }

    private int[] getSegRange(Seg visSeg, boolean ensureDirection) {
        boolean incl = visSeg.getInclusive();
        int pol = visSeg.getStart() <= visSeg.getEnd() ? 1 : -1;
        int start = visSeg.getStart() + (incl ? 0 : pol);
        int end = visSeg.getEnd() + (incl ? 0 : -pol);
        if (ensureDirection && pol == -1) {
            int t = end;
            end = start;
            start = t;
        }
        return new int[]{start, end, pol < 0 ? 1 : 0};
    }

    private boolean isJalviewOnly(AlignmentAnnotation annotation) {
        return annotation.autoCalculated || annotation.label.equals("Quality") || annotation.label.equals("Conservation") || annotation.label.equals("Consensus");
    }

    public void updateJalviewFromAppdata() {
        Jalview2XML fromxml2;
        final IClientAppdata cappdata = this.cdoc.getClientAppdata();
        if (cappdata != null && cappdata.hasClientAppdata()) {
            try {
                fromxml2 = new Jalview2XML();
                fromxml2.attemptversion1parse = false;
                fromxml2.setUniqueSetSuffix("");
                fromxml2.setObjectMappingTables(this.vobj2jv, this.jv2vobj);
                fromxml2.setSkipList(this.skipList);
                jarInputStreamProvider jprovider = new jarInputStreamProvider(){

                    @Override
                    public String getFilename() {
                        return "Jalview Vamsas Document Client Data";
                    }

                    @Override
                    public JarInputStream getJarInputStream() throws IOException {
                        Cache.log.debug((Object)"Returning client input stream for Jalview from Vamsas Document.");
                        return new JarInputStream((InputStream)cappdata.getClientInputStream());
                    }
                };
                if (this.dojvsync) {
                    fromxml2.loadJalviewAlign(jprovider);
                }
            }
            catch (Exception fromxml2) {
            }
            catch (OutOfMemoryError fromxml2) {
            }
            catch (Error fromxml2) {
                // empty catch block
            }
        }
        if (cappdata.hasUserAppdata()) {
            try {
                fromxml2 = new Jalview2XML();
                fromxml2.attemptversion1parse = false;
                fromxml2.setUniqueSetSuffix("");
                fromxml2.setSkipList(this.skipList);
                fromxml2.setObjectMappingTables(this.mapKeysToString(this.vobj2jv), this.mapValuesToString(this.jv2vobj));
                jarInputStreamProvider jarstream = new jarInputStreamProvider(){

                    @Override
                    public String getFilename() {
                        return "Jalview Vamsas Document User Data";
                    }

                    @Override
                    public JarInputStream getJarInputStream() throws IOException {
                        Cache.log.debug((Object)"Returning user input stream for Jalview from Vamsas Document.");
                        return new JarInputStream((InputStream)cappdata.getUserInputStream());
                    }
                };
                if (this.dojvsync) {
                    fromxml2.loadJalviewAlign(jarstream);
                }
            }
            catch (Exception exception) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        this.flushAlignViewports();
    }

    private void flushAlignViewports() {
        AlignmentViewport av2 = null;
        AlignFrame af = null;
        for (AlignmentViewport av2 : this.newAlignmentViews) {
            af = Desktop.getAlignFrameFor(av2);
            String seqsetidobj = av2.getSequenceSetId();
            AlignmentViewport[] views = Desktop.getViewports(seqsetidobj);
            Cache.log.debug((Object)("Found " + (views == null ? " no " : "" + views.length) + " views for '" + av2.getSequenceSetId() + "'"));
            if (views.length <= 1) continue;
            boolean gathered = false;
            String newviewid = null;
            List<AlignedCodonFrame> mappings = av2.getAlignment().getCodonFrames();
            for (int i = 0; i < views.length; ++i) {
                if (views[i] != av2) {
                    AlignFrame viewframe = Desktop.getAlignFrameFor(views[i]);
                    if (viewframe == af) {
                        gathered = true;
                    }
                    newviewid = views[i].getSequenceSetId();
                    continue;
                }
                views[i] = null;
            }
            if (gathered) {
                af.closeView(av2);
            } else {
                af.closeMenuItem_actionPerformed(false);
            }
            this.replaceJvObjMapping(seqsetidobj, newviewid);
            seqsetidobj = newviewid;
        }
        Iterator newviews = null;
        this.newAlignmentViews.clear();
    }

    private void replaceJvObjMapping(Object oldjvobject, Object newjvobject) {
        Object vobject = this.jv2vobj.remove(oldjvobject);
        if (vobject == null) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_old_jalview_object_not_bound", new String[]{oldjvobject.toString()}));
        }
        if (newjvobject != null) {
            this.jv2vobj.put(newjvobject, vobject);
            this.vobj2jv.put(vobject, newjvobject);
        }
    }

    public void updateJalviewClientAppdata() {
        IClientAppdata cappdata = this.cdoc.getClientAppdata();
        if (cappdata != null) {
            try {
                Jalview2XML jxml = new Jalview2XML();
                jxml.setObjectMappingTables(this.mapKeysToString(this.vobj2jv), this.mapValuesToString(this.jv2vobj));
                jxml.setSkipList(this.skipList);
                if (this.dojvsync) {
                    jxml.saveState(new JarOutputStream((OutputStream)cappdata.getClientOutputStream()));
                }
            }
            catch (Exception e) {
                Cache.log.error((Object)"Couldn't update jalview client application data. Giving up - local settings probably lost.", (Throwable)e);
            }
        } else {
            Cache.log.error((Object)"Couldn't access client application data for vamsas session. This is probably a vamsas client bug.");
        }
    }

    private IdentityHashMap mapValuesToString(IdentityHashMap jv2vobj2) {
        IdentityHashMap mapped = new IdentityHashMap();
        for (Object key : jv2vobj2.keySet()) {
            mapped.put(key, jv2vobj2.get(key).toString());
        }
        return mapped;
    }

    private Hashtable mapKeysToString(Hashtable vobj2jv2) {
        Hashtable mapped = new Hashtable();
        for (Object key : vobj2jv2.keySet()) {
            mapped.put(key.toString(), vobj2jv2.get(key));
        }
        return mapped;
    }

    public int updateToJalview() {
        VAMSAS[] _roots = this.cdoc.getVamsasRoots();
        for (int _root = 0; _root < _roots.length; ++_root) {
            DataSet dataset;
            int _ds;
            VAMSAS root = _roots[_root];
            boolean newds = false;
            int _nds = root.getDataSetCount();
            for (_ds = 0; _ds < _nds; ++_ds) {
                int i;
                List<Object> dsseqs;
                dataset = root.getDataSet(_ds);
                int iSize = dataset.getSequenceCount();
                Alignment jdataset = (Alignment)this.getvObj2jv((Vobject)dataset);
                int jremain = 0;
                if (jdataset == null) {
                    Cache.log.debug((Object)"Initialising new jalview dataset fields");
                    newds = true;
                    dsseqs = new Vector();
                } else {
                    Cache.log.debug((Object)"Update jalview dataset from vamsas.");
                    jremain = jdataset.getHeight();
                    dsseqs = jdataset.getSequences();
                }
                for (i = 0; i < iSize; ++i) {
                    Sequence vdseq = dataset.getSequence(i);
                    Datasetsequence dssync = new Datasetsequence(this, vdseq);
                    SequenceI dsseq = (SequenceI)dssync.getJvobj();
                    if (dssync.isAddfromdoc()) {
                        dsseqs.add(dsseq);
                    }
                    if (vdseq.getDbRefCount() <= 0) continue;
                    DbRef[] dbref = vdseq.getDbRef();
                    for (int db = 0; db < dbref.length; ++db) {
                        new Dbref(this, dbref[db], vdseq, dsseq);
                    }
                    dsseq.updatePDBIds();
                }
                if (newds) {
                    SequenceI[] seqs = new SequenceI[dsseqs.size()];
                    iSize = dsseqs.size();
                    for (i = 0; i < iSize; ++i) {
                        seqs[i] = (SequenceI)dsseqs.get(i);
                        dsseqs.set(i, null);
                    }
                    jdataset = new Alignment(seqs);
                    Cache.log.debug((Object)"New vamsas dataset imported into jalview.");
                    this.bindjvvobj(jdataset, (Vobject)dataset);
                }
                if (dataset.getDataSetAnnotations() != null) {
                    for (int dsa = 0; dsa < dataset.getDataSetAnnotationsCount(); ++dsa) {
                        DataSetAnnotations dseta = dataset.getDataSetAnnotations(dsa);
                        if (dseta.getSeqRefCount() == 1) {
                            SequenceI dsSeq = (SequenceI)this.getvObj2jv((Vobject)dseta.getSeqRef(0));
                            if (dsSeq == null) {
                                Cache.log.warn((Object)("Couldn't resolve jalview sequenceI for dataset object reference " + ((Vobject)dataset.getDataSetAnnotations(dsa).getSeqRef(0)).getVorbaId().getId()));
                                continue;
                            }
                            if (dseta.getAnnotationElementCount() == 0) {
                                new Sequencefeature(this, dseta, dsSeq);
                                continue;
                            }
                            Cache.log.warn((Object)"Ignoring dataset annotation with annotationElements. Not yet supported in jalview.");
                            continue;
                        }
                        Cache.log.warn((Object)"Ignoring multiply referenced dataset sequence annotation for binding to datsaet sequence features.");
                    }
                }
                if (dataset.getAlignmentCount() <= 0) continue;
                int nal = dataset.getAlignmentCount();
                for (int al = 0; al < nal; ++al) {
                    AlignFrame alignFrame;
                    uk.ac.vamsas.objects.core.Alignment alignment = dataset.getAlignment(al);
                    AlignmentViewport av = this.findViewport(alignment);
                    AlignmentI jal = null;
                    if (av != null) {
                        jal = av.hasHiddenRows() ? av.getAlignment().getHiddenSequences().getFullAlignment() : av.getAlignment();
                    }
                    iSize = alignment.getAlignmentSequenceCount();
                    boolean refreshal = false;
                    Vector<AlignmentAnnotation> newasAnnots = new Vector<AlignmentAnnotation>();
                    char gapChar = ' ';
                    if (jal != null) {
                        dsseqs = jal.getSequences();
                        gapChar = jal.getGapCharacter();
                    } else {
                        dsseqs = new Vector();
                    }
                    char valGapchar = alignment.getGapChar().charAt(0);
                    for (i = 0; i < iSize; ++i) {
                        AlignmentSequence valseq = alignment.getAlignmentSequence(i);
                        jalview.datamodel.Sequence alseq = (jalview.datamodel.Sequence)this.getvObj2jv((Vobject)valseq);
                        if (this.syncFromAlignmentSequence(valseq, valGapchar, gapChar, dsseqs) && alseq != null) {
                            --jremain;
                            refreshal = true;
                        }
                        if (valseq.getAlignmentSequenceAnnotationCount() <= 0) continue;
                        AlignmentSequenceAnnotation[] vasannot = valseq.getAlignmentSequenceAnnotation();
                        for (int a = 0; a < vasannot.length; ++a) {
                            AlignmentAnnotation asa = (AlignmentAnnotation)this.getvObj2jv((Vobject)vasannot[a]);
                            if (asa == null) {
                                int[] se = this.getBounds((RangeType)vasannot[a]);
                                asa = this.getjAlignmentAnnotation(jal, (RangeAnnotation)vasannot[a]);
                                asa.setSequenceRef(alseq);
                                asa.createSequenceMapping(alseq, se[0], false);
                                alseq.addAlignmentAnnotation(asa);
                                this.bindjvvobj(asa, (Vobject)vasannot[a]);
                                refreshal = true;
                                newasAnnots.add(asa);
                                continue;
                            }
                            if (vasannot[a].getModifiable() != null) continue;
                            Cache.log.info((Object)"UNIMPLEMENTED: not recovering user modifiable sequence alignment annotation");
                        }
                    }
                    if (jal == null) {
                        SequenceI[] seqs = new SequenceI[dsseqs.size()];
                        iSize = dsseqs.size();
                        for (i = 0; i < iSize; ++i) {
                            seqs[i] = (SequenceI)dsseqs.get(i);
                            dsseqs.set(i, null);
                        }
                        jal = new Alignment(seqs);
                        Cache.log.debug((Object)("New vamsas alignment imported into jalview " + alignment.getVorbaId().getId()));
                        jal.setDataset(jdataset);
                    }
                    if (newasAnnots != null && newasAnnots.size() > 0) {
                        int anSize = newasAnnots.size();
                        for (int an = 0; an < anSize; ++an) {
                            jal.addAnnotation((AlignmentAnnotation)newasAnnots.elementAt(an));
                            newasAnnots.setElementAt(null, an);
                        }
                        newasAnnots = null;
                    }
                    if (alignment.getAlignmentAnnotationCount() > 0) {
                        uk.ac.vamsas.objects.core.AlignmentAnnotation[] an = alignment.getAlignmentAnnotation();
                        for (int j = 0; j < an.length; ++j) {
                            AlignmentAnnotation jan = (AlignmentAnnotation)this.getvObj2jv((Vobject)an[j]);
                            if (jan != null) {
                                Cache.log.debug((Object)"update from vamsas alignment annotation to existing jalview alignment annotation.");
                                if (an[j].getModifiable() != null) continue;
                                Cache.log.info((Object)"NOT IMPLEMENTED - Recovering user-modifiable annotation - yet...");
                                continue;
                            }
                            jan = this.getjAlignmentAnnotation(jal, (RangeAnnotation)an[j]);
                            jal.addAnnotation(jan);
                            this.bindjvvobj(jan, (Vobject)an[j]);
                            refreshal = true;
                        }
                    }
                    if (av == null) {
                        Cache.log.debug((Object)("New alignframe for alignment " + alignment.getVorbaId()));
                        alignFrame = new AlignFrame(jal, 700, 500, alignment.getVorbaId().toString());
                        av = alignFrame.getViewport();
                        this.newAlignmentViews.addElement(av);
                        String title = alignment.getProvenance().getEntry(alignment.getProvenance().getEntryCount() - 1).getAction();
                        if (alignment.getPropertyCount() > 0) {
                            int pe = alignment.getPropertyCount();
                            for (int p = 0; p < pe; ++p) {
                                if (!alignment.getProperty(p).getName().equals("title")) continue;
                                title = alignment.getProperty(p).getContent();
                            }
                        }
                        if (Cache.log.isDebugEnabled()) {
                            title = title + "(" + alignment.getVorbaId() + ")";
                        }
                        Desktop.addInternalFrame(alignFrame, title, 700, 500);
                        this.bindjvvobj(av.getSequenceSetId(), (Vobject)alignment);
                    } else {
                        alignFrame = Desktop.getAlignFrameFor(av);
                        if (refreshal) {
                            av.alignmentChanged(alignFrame.alignPanel);
                            alignFrame.alignPanel.adjustAnnotationHeight();
                        }
                    }
                    if (alignment.getTreeCount() <= 0) continue;
                    for (int t = 0; t < alignment.getTreeCount(); ++t) {
                        Tree vstree = new Tree(this, alignFrame, alignment.getTree(t));
                        TreePanel tp = null;
                        if (vstree.isValidTree()) {
                            tp = alignFrame.showNewickTree(vstree.getNewickTree(), vstree.getTitle(), vstree.getInputData(), 600, 500, t * 20 + 50, t * 20 + 50);
                        }
                        if (tp != null) {
                            this.bindjvvobj(tp, (Vobject)alignment.getTree(t));
                            try {
                                vstree.UpdateSequenceTreeMap(tp);
                            }
                            catch (RuntimeException e) {
                                Cache.log.warn((Object)"update of labels failed.", (Throwable)e);
                            }
                            continue;
                        }
                        Cache.log.warn((Object)("Cannot create tree for tree " + t + " in document (" + alignment.getTree(t).getVorbaId()));
                    }
                }
            }
            _nds = root.getDataSetCount();
            for (_ds = 0; _ds < _nds; ++_ds) {
                dataset = root.getDataSet(_ds);
                if (dataset.getSequenceMappingCount() <= 0) continue;
                int smCount = dataset.getSequenceMappingCount();
                for (int sm = 0; sm < smCount; ++sm) {
                    Sequencemapping sequencemapping = new Sequencemapping(this, dataset.getSequenceMapping(sm));
                }
            }
        }
        return this.newAlignmentViews.size();
    }

    public AlignmentViewport findViewport(uk.ac.vamsas.objects.core.Alignment alignment) {
        AlignmentViewport av = null;
        AlignmentViewport[] avs = Desktop.getViewports((String)this.getvObj2jv((Vobject)alignment));
        if (avs != null) {
            av = avs[0];
        }
        return av;
    }

    private Object[] parseRangeAnnotation(RangeAnnotation annotation) {
        boolean[] AeContent = new boolean[]{false, false, false, false, false};
        int[] rangeMap = this.getMapping((RangeType)annotation);
        Annotation[][] anot = new Annotation[][]{new Annotation[rangeMap.length], new Annotation[rangeMap.length]};
        boolean mergeable = true;
        if (annotation.getAnnotationElementCount() > 0) {
            int i;
            AnnotationElement[] ae = annotation.getAnnotationElement();
            for (int aa = 0; aa < ae.length; ++aa) {
                int pos = (int)ae[aa].getPosition() - 1;
                if (pos >= 0 && pos < rangeMap.length) {
                    int row;
                    int n = row = ae[aa].getAfter() ? 1 : 0;
                    if (anot[row][pos] != null) {
                        Cache.log.debug((Object)("Ignoring duplicate annotation site at " + pos));
                        continue;
                    }
                    if (anot[1 - row][pos] != null) {
                        mergeable = false;
                    }
                    String desc = "";
                    if (ae[aa].getDescription() != null && (desc = ae[aa].getDescription()).length() > 0) {
                        AeContent[VamsasAppDatastore.HASDESCSTR] = true;
                    }
                    String dc = null;
                    String ss = null;
                    Color colour = null;
                    if (ae[aa].getGlyphCount() > 0) {
                        Glyph[] glyphs = ae[aa].getGlyph();
                        for (int g = 0; g < glyphs.length; ++g) {
                            if (glyphs[g].getDict().equals("aasecstr_3")) {
                                ss = glyphs[g].getContent();
                                AeContent[VamsasAppDatastore.HASSECSTR] = true;
                                continue;
                            }
                            if (glyphs[g].getDict().equals("kd_hydrophobicity")) {
                                Cache.log.debug((Object)"ignoring hydrophobicity glyph marker.");
                                AeContent[VamsasAppDatastore.HASHPHOB] = true;
                                dc = glyphs[g].getContent();
                                char c = dc.charAt(0);
                                colour = new Color(c == '+' ? 255 : 0, c == '.' ? 255 : 0, c == '-' ? 255 : 0);
                                continue;
                            }
                            if (glyphs[g].getDict().equals("utf8")) {
                                dc = glyphs[g].getContent();
                                AeContent[VamsasAppDatastore.HASDC] = true;
                                continue;
                            }
                            Cache.log.debug((Object)("IMPLEMENTATION TODO: Ignoring unknown glyph type " + glyphs[g].getDict()));
                        }
                    }
                    float val = 0.0f;
                    if (ae[aa].getValueCount() > 0) {
                        AeContent[VamsasAppDatastore.HASVALS] = true;
                        if (ae[aa].getValueCount() > 1) {
                            Cache.log.warn((Object)("ignoring additional " + (ae[aa].getValueCount() - 1) + " values in annotation element."));
                        }
                        val = ae[aa].getValue(0);
                    }
                    if (colour == null) {
                        anot[row][pos] = new Annotation(dc != null ? dc : "", desc, ss != null ? (char)ss.charAt(0) : (char)' ', val);
                        continue;
                    }
                    anot[row][pos] = new Annotation(dc != null ? dc : "", desc, ss != null ? (char)ss.charAt(0) : (char)' ', val, colour);
                    continue;
                }
                Cache.log.warn((Object)("Ignoring out of bound annotation element " + aa + " in " + annotation.getVorbaId().getId()));
            }
            if (mergeable) {
                for (i = 0; i < anot[0].length; ++i) {
                    if (anot[1][i] == null) continue;
                    anot[0][i] = anot[1][i];
                    anot[0][i].description = anot[0][i].description + " (after)";
                    AeContent[VamsasAppDatastore.HASDESCSTR] = true;
                    anot[1][i] = null;
                }
                anot[1] = null;
            } else {
                for (i = 0; i < anot[0].length; ++i) {
                    anot[1][i].description = anot[1][i].description + " (after)";
                }
            }
            return new Object[]{AeContent, rangeMap, anot[0], anot[1]};
        }
        return new Object[]{AeContent, rangeMap, anot[0], anot[1]};
    }

    private AlignmentAnnotation getjAlignmentAnnotation(AlignmentI jal, RangeAnnotation annotation) {
        if (annotation == null) {
            return null;
        }
        Object[] parsedRangeAnnotation = this.parseRangeAnnotation(annotation);
        String a_label = annotation.getLabel();
        String a_descr = annotation.getDescription();
        GraphLine gl = null;
        int type = 0;
        boolean interp = true;
        if (annotation.getPropertyCount() > 0) {
            Property[] props = annotation.getProperty();
            for (int p = 0; p < props.length; ++p) {
                if (props[p].getName().equalsIgnoreCase(DISCRETE_ANNOTATION)) {
                    type = 1;
                    interp = false;
                    continue;
                }
                if (props[p].getName().equalsIgnoreCase(CONTINUOUS_ANNOTATION)) {
                    type = 2;
                    continue;
                }
                if (props[p].getName().equalsIgnoreCase(THRESHOLD)) {
                    Float val = null;
                    try {
                        val = Float.valueOf(props[p].getContent());
                    }
                    catch (Exception e) {
                        Cache.log.warn((Object)"Failed to parse threshold property");
                    }
                    if (val == null) continue;
                    if (gl == null) {
                        gl = new GraphLine(val.floatValue(), "", Color.black);
                        continue;
                    }
                    gl.value = val.floatValue();
                    continue;
                }
                if (!props[p].getName().equalsIgnoreCase("thresholdName")) continue;
                if (gl == null) {
                    gl = new GraphLine(0.0f, "", Color.black);
                }
                gl.label = props[p].getContent();
            }
        }
        AlignmentAnnotation jan = null;
        if ((a_label == null || a_label.length() == 0) && (a_label = annotation.getType()).length() == 0) {
            a_label = "Unamed annotation";
        }
        if (a_descr == null || a_descr.length() == 0) {
            a_descr = "Annotation of type '" + annotation.getType() + "'";
        }
        if (parsedRangeAnnotation != null) {
            if (parsedRangeAnnotation[3] != null) {
                Cache.log.warn((Object)("Ignoring 'After' annotation row in " + annotation.getVorbaId()));
            }
            Annotation[] arow = (Annotation[])parsedRangeAnnotation[2];
            boolean[] has = (boolean[])parsedRangeAnnotation[0];
            if (has[HASVALS]) {
                if (type == 0) {
                    type = 1;
                    if (has[HASHPHOB]) {
                        type = 1;
                    }
                }
                boolean first = true;
                float min = 0.0f;
                float max = 1.0f;
                int lastval = 0;
                for (int i = 0; i < arow.length; ++i) {
                    if (arow[i] == null) continue;
                    if (i - lastval > 1 && interp && arow[lastval] != null) {
                        float interval = arow[i].value - arow[lastval].value;
                        interval /= (float)(i - lastval);
                        float base = arow[lastval].value;
                        int np = 0;
                        for (int ip = lastval + 1; ip < i; ++ip) {
                            arow[ip] = new Annotation("", "", ' ', interval * (float)np + base);
                            ++np;
                        }
                    }
                    lastval = i;
                    if (first) {
                        min = max = arow[i].value;
                        first = false;
                    } else if (arow[i].value < min) {
                        min = arow[i].value;
                    } else if (arow[i].value > max) {
                        max = arow[i].value;
                    }
                    if (!has[HASDESCSTR]) {
                        arow[i].description = arow[i].value + "";
                    }
                    if (has[HASDC]) continue;
                    if (!interp) {
                        if (arow[i].description == null || arow[i].description.length() >= 3) continue;
                        arow[i].displayCharacter = new String(arow[i].description);
                        continue;
                    }
                    arow[i].displayCharacter = arow[i].value + "";
                }
                jan = new AlignmentAnnotation(a_label, a_descr, arow, min, max, type);
            } else {
                if (annotation.getAnnotationElementCount() == 0) {
                    // empty if block
                }
                jan = new AlignmentAnnotation(a_label, a_descr, arow);
                jan.setThreshold(null);
                jan.annotationId = annotation.getVorbaId().toString();
            }
            if (annotation.getLinkCount() > 0) {
                Cache.log.warn((Object)("Ignoring " + annotation.getLinkCount() + "links added to AlignmentAnnotation."));
            }
            if (annotation.getModifiable() == null || annotation.getModifiable().length() == 0) {
                jan.editable = true;
            }
            try {
                if (annotation.getGroup() != null && annotation.getGroup().length() > 0) {
                    jan.graphGroup = Integer.parseInt(annotation.getGroup());
                }
            }
            catch (Exception e) {
                Cache.log.info((Object)"UNIMPLEMENTED : Couldn't parse non-integer group value for setting graphGroup correctly.");
            }
            return jan;
        }
        Cache.log.debug((Object)"Inserting empty annotation row elements for a whole-alignment annotation.");
        return null;
    }

    private int[] getBounds(RangeType dseta) {
        if (dseta != null) {
            int[] se = null;
            if (dseta.getSegCount() > 0 && dseta.getPosCount() > 0) {
                throw new Error(MessageManager.getString("error.invalid_vamsas_rangetype_cannot_resolve_lists"));
            }
            if (dseta.getSegCount() > 0) {
                se = this.getSegRange(dseta.getSeg(0), true);
                int sSize = dseta.getSegCount();
                for (int s = 1; s < sSize; ++s) {
                    int[] nse = this.getSegRange(dseta.getSeg(s), true);
                    if (se[0] > nse[0]) {
                        se[0] = nse[0];
                    }
                    if (se[1] >= nse[1]) continue;
                    se[1] = nse[1];
                }
            }
            if (dseta.getPosCount() > 0) {
                int pos = dseta.getPos(0).getI();
                se = new int[]{pos, pos};
                int pSize = dseta.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = dseta.getPos(p).getI();
                    if (se[0] > pos) {
                        se[0] = pos;
                    }
                    if (se[1] >= pos) continue;
                    se[1] = pos;
                }
            }
            return se;
        }
        return null;
    }

    private int[] getMapping(RangeType dseta) {
        Vector<Integer> posList = new Vector<Integer>();
        if (dseta != null) {
            int[] se = null;
            if (dseta.getSegCount() > 0 && dseta.getPosCount() > 0) {
                throw new Error(MessageManager.getString("error.invalid_vamsas_rangetype_cannot_resolve_lists"));
            }
            if (dseta.getSegCount() > 0) {
                int sSize = dseta.getSegCount();
                for (int s = 0; s < sSize; ++s) {
                    se = this.getSegRange(dseta.getSeg(s), false);
                    int se_end = se[1 - se[2]] + (se[2] == 0 ? 1 : -1);
                    for (int p = se[se[2]]; p != se_end; p += se[2] == 0 ? 1 : -1) {
                        posList.add(p);
                    }
                }
            } else if (dseta.getPosCount() > 0) {
                int pos = dseta.getPos(0).getI();
                int pSize = dseta.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = dseta.getPos(p).getI();
                    posList.add(pos);
                }
            }
        }
        if (posList != null && posList.size() > 0) {
            int[] range = new int[posList.size()];
            for (int i = 0; i < range.length; ++i) {
                range[i] = (Integer)posList.elementAt(i);
            }
            posList.clear();
            return range;
        }
        return null;
    }

    private MapList parsemapType(MapType maprange, int localu, int mappedu) {
        MapList ml = null;
        int[] localRange = this.getMapping((RangeType)maprange.getLocal());
        int[] mappedRange = this.getMapping((RangeType)maprange.getMapped());
        long lu = maprange.getLocal().hasUnit() ? maprange.getLocal().getUnit() : (long)localu;
        long mu = maprange.getMapped().hasUnit() ? maprange.getMapped().getUnit() : (long)mappedu;
        ml = new MapList(localRange, mappedRange, (int)lu, (int)mu);
        return ml;
    }

    private void initRangeType(RangeType mrt, List<int[]> ranges) {
        for (int[] range : ranges) {
            Seg vSeg = new Seg();
            vSeg.setStart(range[0]);
            vSeg.setEnd(range[1]);
            mrt.addSeg(vSeg);
        }
    }

    private void initMapType(MapType maprange, MapList ml, boolean setUnits) {
        maprange.setLocal(new Local());
        maprange.setMapped(new Mapped());
        this.initRangeType((RangeType)maprange.getLocal(), ml.getFromRanges());
        this.initRangeType((RangeType)maprange.getMapped(), ml.getToRanges());
        if (setUnits) {
            maprange.getLocal().setUnit((long)ml.getFromRatio());
            maprange.getLocal().setUnit((long)ml.getToRatio());
        }
    }

    jalview.datamodel.Provenance getJalviewProvenance(Provenance prov) {
        jalview.datamodel.Provenance jprov = new jalview.datamodel.Provenance();
        for (int i = 0; i < prov.getEntryCount(); ++i) {
            jprov.addEntry(prov.getEntry(i).getUser(), prov.getEntry(i).getAction(), prov.getEntry(i).getDate(), prov.getEntry(i).getId());
        }
        return jprov;
    }

    Provenance dummyProvenance() {
        return this.dummyProvenance(null);
    }

    Entry dummyPEntry(String action) {
        Entry entry = new Entry();
        entry.setApp(this.provEntry.getApp());
        if (action != null) {
            entry.setAction(action);
        } else {
            entry.setAction("created.");
        }
        entry.setDate(new Date());
        entry.setUser(this.provEntry.getUser());
        return entry;
    }

    Provenance dummyProvenance(String action) {
        Provenance prov = new Provenance();
        prov.addEntry(this.dummyPEntry(action));
        return prov;
    }

    Entry addProvenance(Provenance p, String action) {
        Entry dentry = this.dummyPEntry(action);
        p.addEntry(dentry);
        return dentry;
    }

    public Entry getProvEntry() {
        return this.provEntry;
    }

    public IClientDocument getClientDocument() {
        return this.cdoc;
    }

    public IdentityHashMap getJvObjectBinding() {
        return this.jv2vobj;
    }

    public Hashtable getVamsasObjectBinding() {
        return this.vobj2jv;
    }

    public void storeSequenceMappings(AlignmentViewport viewport, String title) throws Exception {
        AlignmentViewport av = viewport;
        try {
            List<AlignedCodonFrame> cframes;
            AlignmentI jal = av.getAlignment();
            DataSet dataset = null;
            if (jal.getDataset() == null) {
                Cache.log.warn((Object)"Creating new dataset for an alignment.");
                jal.setDataset(null);
            }
            if ((dataset = (DataSet)((uk.ac.vamsas.objects.core.Alignment)this.getjv2vObj(viewport.getSequenceSetId())).getV_parent()) == null) {
                dataset = (DataSet)this.getjv2vObj(jal.getDataset());
                Cache.log.error((Object)"Can't find the correct dataset for the alignment in this view. Creating new one.");
            }
            if ((cframes = av.getAlignment().getCodonFrames()) != null) {
                for (AlignedCodonFrame acf : cframes) {
                    if (acf.getdnaSeqs() == null || acf.getdnaSeqs().length <= 0) continue;
                    SequenceI[] dmps = acf.getdnaSeqs();
                    Mapping[] mps = acf.getProtMappings();
                    for (int smp = 0; smp < mps.length; ++smp) {
                        SequenceType mfrom = (SequenceType)this.getjv2vObj(dmps[smp]);
                        if (mfrom != null) {
                            new Sequencemapping(this, mps[smp], mfrom, dataset);
                            continue;
                        }
                        Cache.log.warn((Object)("NO Vamsas Binding for local sequence! NOT CREATING MAPPING FOR " + dmps[smp].getDisplayId(true) + " to " + mps[smp].getTo().getName()));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception(MessageManager.formatMessage("exception.couldnt_store_sequence_mappings", new String[]{title}), e);
        }
    }

    public void clearSkipList() {
        if (this.skipList != null) {
            this.skipList.clear();
        }
    }

    public Hashtable getSkipList() {
        return this.skipList;
    }

    public void setSkipList(Hashtable skipList) {
        this.skipList = skipList;
    }

    public DatastoreRegistry getDatastoreRegisty() {
        if (this.dsReg == null) {
            this.dsReg = new DatastoreRegistry();
        }
        return this.dsReg;
    }
}

