/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import com.stevesoft.pat.Regex;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.rna.RNA;
import jalview.analysis.Rna;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.util.DBRefUtils;
import jalview.util.Format;
import jalview.util.MapList;
import jalview.util.MessageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class StockholmFile
extends AlignFile {
    private static final String ANNOTATION = "annotation";
    public static final Regex DETECT_BRACKETS = new Regex("(<|>|\\[|\\]|\\(|\\)|\\{|\\})");
    public static final String RNASS_BRACKETS = "<>[](){}AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz";
    private static final Regex NOT_RNASS = new Regex("^[^<>[\\](){}A-DF-Za-df-z]*$");
    StringBuffer out;
    AlignmentI al;
    private static Hashtable typeIds = null;

    public StockholmFile() {
    }

    public StockholmFile(AlignmentI al) {
        this.al = al;
    }

    public StockholmFile(String inFile, DataSourceType type) throws IOException {
        super(inFile, type);
    }

    public StockholmFile(FileParse source) throws IOException {
        super(source);
    }

    @Override
    public void initData() {
        super.initData();
    }

    public void parse_with_VARNA(File inFile) throws IOException {
        FileReader fr = null;
        fr = new FileReader(inFile);
        BufferedReader r = new BufferedReader(fr);
        ArrayList result = null;
        try {
            result = RNAFactory.loadSecStrStockholm((BufferedReader)r);
        }
        catch (ExceptionUnmatchedClosingParentheses umcp) {
            this.errormessage = "Unmatched parentheses in annotation. Aborting (" + umcp.getMessage() + ")";
            throw new IOException(umcp);
        }
        SequenceI[] seqs = new SequenceI[result.size()];
        String id = null;
        for (int i = 0; i < result.size(); ++i) {
            RNA current = (RNA)result.get(i);
            String seq = current.getSeq();
            String rna = current.getStructDBN(true);
            int begin = 0;
            int end = seq.length() - 1;
            id = this.safeName(this.getDataName());
            seqs[i] = new Sequence(id, seq, begin, end);
            String[] annot = new String[rna.length()];
            Annotation[] ann = new Annotation[rna.length()];
            for (int j = 0; j < rna.length(); ++j) {
                annot[j] = rna.substring(j, j + 1);
            }
            for (int k = 0; k < rna.length(); ++k) {
                ann[k] = new Annotation(annot[k], "", Rna.getRNASecStrucState(annot[k]).charAt(0), 0.0f);
            }
            AlignmentAnnotation align = new AlignmentAnnotation("Sec. str.", current.getID(), ann);
            seqs[i].addAlignmentAnnotation(align);
            seqs[i].setRNA((RNA)result.get(i));
            this.annotations.addElement(align);
        }
        this.setSeqs(seqs);
    }

    @Override
    public void parse() throws IOException {
        String line;
        StringBuffer treeString = new StringBuffer();
        String treeName = null;
        Hashtable<String, Hashtable> seqAnn = new Hashtable<String, Hashtable>();
        LinkedHashMap<String, String> seqs = new LinkedHashMap<String, String>();
        Regex r = new Regex("# STOCKHOLM ([\\d\\.]+)");
        if (!r.search(this.nextLine())) {
            throw new IOException(MessageManager.getString("exception.stockholm_invalid_format"));
        }
        String version = r.stringMatched(1);
        Regex rend = new Regex("^\\s*\\/\\/");
        Regex p = new Regex("(\\S+)\\/(\\d+)\\-(\\d+)");
        Regex s = new Regex("(\\S+)\\s+(\\S*)\\s+(.*)");
        r = new Regex("#=(G[FSRC]?)\\s+(.*)");
        Regex x = new Regex("(\\S+)\\s+(\\S+)");
        Regex openparen = new Regex("(<|\\[)", "(");
        Regex closeparen = new Regex("(>|\\])", ")");
        rend.optimize();
        p.optimize();
        s.optimize();
        r.optimize();
        x.optimize();
        openparen.optimize();
        closeparen.optimize();
        while ((line = this.nextLine()) != null) {
            String type;
            String acc;
            if (line.length() == 0) continue;
            if (rend.search(line)) {
                this.noSeqs = seqs.size();
                String dbsource = null;
                Regex pf = new Regex("PF[0-9]{5}(.*)");
                Regex rf = new Regex("RF[0-9]{5}(.*)");
                if (this.getAlignmentProperty("AC") != null) {
                    String dbType = this.getAlignmentProperty("AC").toString();
                    if (pf.search(dbType)) {
                        dbsource = "PFAM";
                    } else if (rf.search(dbType)) {
                        dbsource = "RFAM";
                    }
                }
                for (Map.Entry entry : seqs.entrySet()) {
                    String dbr;
                    String acc2 = (String)entry.getKey();
                    String seq = (String)entry.getValue();
                    if (this.maxLength < seq.length()) {
                        this.maxLength = seq.length();
                    }
                    int start = 1;
                    int end = -1;
                    String sid = acc2;
                    Hashtable accAnnotations = null;
                    if (seqAnn != null && seqAnn.containsKey(acc2)) {
                        accAnnotations = (Hashtable)seqAnn.remove(acc2);
                    }
                    if (p.search(acc2)) {
                        sid = p.stringMatched(1);
                        start = Integer.parseInt(p.stringMatched(2));
                        end = Integer.parseInt(p.stringMatched(3));
                    }
                    Sequence seqO = new Sequence(sid, seq, start, end);
                    if (accAnnotations != null && accAnnotations.containsKey("DE")) {
                        String desc = (String)accAnnotations.get("DE");
                        seqO.setDescription(desc == null ? "" : desc);
                    }
                    if (accAnnotations != null && accAnnotations.containsKey("DR") && (dbr = (String)accAnnotations.get("DR")) != null && dbr.indexOf(";") > -1) {
                        String src = dbr.substring(0, dbr.indexOf(";"));
                        String acn = dbr.substring(dbr.indexOf(";") + 1);
                        DBRefUtils.parseToDbRef(seqO, src, "0", acn);
                    }
                    if (accAnnotations != null && accAnnotations.containsKey("AC") && (dbr = (String)accAnnotations.get("AC")) != null) {
                        this.guessDatabaseFor(seqO, dbr, dbsource);
                    }
                    Hashtable features = null;
                    try {
                        features = (Hashtable)accAnnotations.remove("features");
                    }
                    catch (NullPointerException src) {
                        // empty catch block
                    }
                    if (features != null) {
                        int[] posmap = seqO.findPositionMap();
                        Enumeration i = features.keys();
                        while (i.hasMoreElements()) {
                            String type2 = i.nextElement().toString();
                            Hashtable content = (Hashtable)features.remove(type2);
                            String key = StockholmFile.type2id(type2);
                            boolean annotsAdded = false;
                            if (key != null && accAnnotations != null && accAnnotations.containsKey(key)) {
                                Vector vv = (Vector)accAnnotations.get(key);
                                for (int ii = 0; ii < vv.size(); ++ii) {
                                    annotsAdded = true;
                                    AlignmentAnnotation an = (AlignmentAnnotation)vv.elementAt(ii);
                                    seqO.addAlignmentAnnotation(an);
                                    this.annotations.add(an);
                                }
                            }
                            Enumeration j = content.keys();
                            while (j.hasMoreElements()) {
                                String desc = j.nextElement().toString();
                                if (ANNOTATION.equals(desc) && annotsAdded) continue;
                                String ns = content.get(desc).toString();
                                char[] byChar = ns.toCharArray();
                                for (int k = 0; k < byChar.length; ++k) {
                                    char c = byChar[k];
                                    if (c == ' ' || c == '_' || c == '-' || c == '.') continue;
                                    int new_pos = posmap[k];
                                    SequenceFeature feat = new SequenceFeature(type2, desc, new_pos, new_pos, null);
                                    seqO.addSequenceFeature(feat);
                                }
                            }
                        }
                    }
                    this.seqs.addElement(seqO);
                }
                return;
            }
            if (!r.search(line)) {
                if (!x.search(line)) {
                    throw new IOException(MessageManager.formatMessage("exception.couldnt_parse_sequence_line", new String[]{line}));
                }
                String ns = (String)seqs.get(x.stringMatched(1));
                if (ns == null) {
                    ns = "";
                }
                ns = ns + x.stringMatched(2);
                seqs.put(x.stringMatched(1), ns);
                continue;
            }
            String annType = r.stringMatched(1);
            String annContent = r.stringMatched(2);
            if (annType.equals("GF")) {
                Regex an = new Regex("(\\w+)\\s*(.*)");
                if (!an.search(annContent)) continue;
                if (an.stringMatched(1).equals("NH")) {
                    treeString.append(an.stringMatched(2));
                } else if (an.stringMatched(1).equals("TN")) {
                    if (treeString.length() > 0) {
                        if (treeName == null) {
                            treeName = "Tree " + (this.getTreeCount() + 1);
                        }
                        this.addNewickTree(treeName, treeString.toString());
                    }
                    treeName = an.stringMatched(2);
                    treeString = new StringBuffer();
                }
                this.setAlignmentProperty(an.stringMatched(1), an.stringMatched(2));
                continue;
            }
            if (annType.equals("GS")) {
                if (s.search(annContent)) {
                    acc = s.stringMatched(1);
                    type = s.stringMatched(2);
                    String string = s.stringMatched(3);
                    Hashtable ann = seqAnn.containsKey(acc) ? (Hashtable)seqAnn.get(acc) : new Hashtable();
                    ann.put(type, string);
                    seqAnn.put(acc, ann);
                    continue;
                }
                System.err.println(">> missing annotation: " + line);
                continue;
            }
            if (annType.equals("GC")) {
                if (!x.search(annContent)) continue;
                StockholmFile.parseAnnotationRow(this.annotations, x.stringMatched(1), x.stringMatched(2));
                continue;
            }
            if (annType.equals("GR")) {
                if (s.search(annContent)) {
                    Hashtable content;
                    Hashtable features;
                    Hashtable ann;
                    acc = s.stringMatched(1);
                    type = s.stringMatched(2);
                    String string = s.stringMatched(3);
                    String seq = new String(string);
                    if (seqAnn.containsKey(acc)) {
                        ann = (Hashtable)seqAnn.get(acc);
                    } else {
                        ann = new Hashtable();
                        seqAnn.put(acc, ann);
                    }
                    if (ann.containsKey("features")) {
                        features = (Hashtable)ann.get("features");
                    } else {
                        features = new Hashtable();
                        ann.put("features", features);
                    }
                    if (features.containsKey(StockholmFile.id2type(type))) {
                        content = (Hashtable)features.get(StockholmFile.id2type(type));
                    } else {
                        content = new Hashtable();
                        features.put(StockholmFile.id2type(type), content);
                    }
                    String ns = (String)content.get(ANNOTATION);
                    if (ns == null) {
                        ns = "";
                    }
                    ns = ns + seq;
                    content.put(ANNOTATION, ns);
                    Hashtable strucAnn = seqAnn.containsKey(acc) ? (Hashtable)seqAnn.get(acc) : new Hashtable();
                    Vector<AlignmentAnnotation> newStruc = new Vector<AlignmentAnnotation>();
                    StockholmFile.parseAnnotationRow(newStruc, type, ns);
                    for (AlignmentAnnotation alan : newStruc) {
                        alan.visible = false;
                    }
                    strucAnn.put(type, newStruc);
                    seqAnn.put(acc, strucAnn);
                    continue;
                }
                System.err.println("Warning - couldn't parse sequence annotation row line:\n" + line);
                continue;
            }
            throw new IOException(MessageManager.formatMessage("exception.unknown_annotation_detected", new String[]{annType, annContent}));
        }
        if (treeString.length() > 0) {
            if (treeName == null) {
                treeName = "Tree " + (1 + this.getTreeCount());
            }
            this.addNewickTree(treeName, treeString.toString());
        }
    }

    private void guessDatabaseFor(Sequence seqO, String dbr, String dbsource) {
        DBRefEntry dbrf = null;
        ArrayList<DBRefEntry> dbrs = new ArrayList<DBRefEntry>();
        String seqdb = "Unknown";
        String sdbac = "" + dbr;
        int st = -1;
        int en = -1;
        st = sdbac.indexOf("/");
        if (st > -1) {
            String num;
            String range = sdbac.substring(st + 1);
            sdbac = sdbac.substring(0, st);
            int p = range.indexOf("-");
            if (p > -1) {
                if (++p < range.length()) {
                    num = range.substring(p).trim();
                    try {
                        en = Integer.parseInt(num);
                    }
                    catch (NumberFormatException x) {
                        en = -1;
                    }
                }
            } else {
                p = range.length();
            }
            num = range.substring(0, p).trim();
            try {
                st = Integer.parseInt(num);
            }
            catch (NumberFormatException x) {
                st = -1;
            }
        }
        if (dbsource == null) {
            String string = dbsource = seqO.isProtein() ? "PFAM" : "RFAM";
        }
        if (dbsource.equals("PFAM")) {
            seqdb = "UNIPROT";
            if (sdbac.indexOf(".") > -1 && (dbrf = DBRefUtils.parseToDbRef(seqO, seqdb, dbsource, sdbac = sdbac.substring(0, sdbac.indexOf(".")))) != null) {
                dbrs.add(dbrf);
            }
            dbrf = DBRefUtils.parseToDbRef(seqO, dbsource, dbsource, dbr);
            if (dbr != null) {
                dbrs.add(dbrf);
            }
        } else {
            seqdb = "EMBL";
            if (sdbac.indexOf(".") > -1 && (dbrf = DBRefUtils.parseToDbRef(seqO, seqdb, dbsource, sdbac = sdbac.substring(0, sdbac.indexOf(".")))) != null) {
                dbrs.add(dbrf);
            }
            if ((dbrf = DBRefUtils.parseToDbRef(seqO, dbsource, dbsource, dbr)) != null) {
                dbrs.add(dbrf);
            }
        }
        if (st != -1 && en != -1) {
            for (DBRefEntry d : dbrs) {
                MapList mp = new MapList(new int[]{seqO.getStart(), seqO.getEnd()}, new int[]{st, en}, 1, 1);
                Mapping mping = new Mapping(mp);
                d.setMap(mping);
            }
        }
    }

    protected static AlignmentAnnotation parseAnnotationRow(Vector<AlignmentAnnotation> annotation, String label, String annots) {
        Object convert2 = null;
        String type = label;
        if (label.contains("_cons")) {
            type = label.indexOf("_cons") == label.length() - 5 ? label.substring(0, label.length() - 5) : label;
        }
        boolean ss = false;
        boolean posterior = false;
        type = StockholmFile.id2type(type);
        boolean isrnass = false;
        if (type.equalsIgnoreCase("secondary structure")) {
            ss = true;
            boolean bl = isrnass = !NOT_RNASS.search(annots);
        }
        if (type.equalsIgnoreCase("posterior probability")) {
            posterior = true;
        }
        Annotation[] els = new Annotation[annots.length()];
        for (int i = 0; i < annots.length(); ++i) {
            String pos = annots.substring(i, i + 1);
            Annotation ann = new Annotation(pos, "", ' ', 0.0f);
            if (ss) {
                if (isrnass && RNASS_BRACKETS.indexOf(pos) >= 0) {
                    ann.secondaryStructure = Rna.getRNASecStrucState(pos).charAt(0);
                    ann.displayCharacter = "" + pos.charAt(0);
                } else {
                    ann.secondaryStructure = ResidueProperties.getDssp3state(pos).charAt(0);
                    ann.displayCharacter = ann.secondaryStructure == pos.charAt(0) ? "" : " " + ann.displayCharacter;
                }
            }
            if (posterior && !ann.isWhitespace() && !Comparison.isGap(pos.charAt(0))) {
                float val = 0.0f;
                if (pos.charAt(0) == '*') {
                    val = 10.0f;
                } else {
                    val = pos.charAt(0) - 48;
                    if (val > 9.0f) {
                        val = 10.0f;
                    }
                }
                ann.value = val;
            }
            els[i] = ann;
        }
        AlignmentAnnotation annot = null;
        Enumeration<AlignmentAnnotation> e = annotation.elements();
        while (e.hasMoreElements()) {
            annot = e.nextElement();
            if (annot.label.equals(type)) break;
            annot = null;
        }
        if (annot == null) {
            annot = new AlignmentAnnotation(type, type, els);
            annotation.addElement(annot);
        } else {
            Annotation[] anns = new Annotation[annot.annotations.length + els.length];
            System.arraycopy(annot.annotations, 0, anns, 0, annot.annotations.length);
            System.arraycopy(els, 0, anns, annot.annotations.length, els.length);
            annot.annotations = anns;
        }
        return annot;
    }

    private String dbref_to_ac_record(DBRefEntry ref) {
        return ref.getSource().toString() + " ; " + ref.getAccessionId().toString();
    }

    @Override
    public String print(SequenceI[] s, boolean jvSuffix) {
        SequenceI seq;
        int in;
        this.out = new StringBuffer();
        this.out.append("# STOCKHOLM 1.0");
        this.out.append(this.newline);
        int max = 0;
        int maxid = 0;
        int slen = s.length;
        Hashtable<String, String> dataRef = null;
        boolean isAA = s[in].isProtein();
        block0: for (in = 0; in < slen && (seq = s[in]) != null; ++in) {
            List<DBRefEntry> primrefs;
            int ndb;
            Sequence.DBModList<DBRefEntry> seqrefs;
            String tmp = this.printId(seq, jvSuffix);
            max = Math.max(max, seq.getLength());
            if (tmp.length() > maxid) {
                maxid = tmp.length();
            }
            if ((seqrefs = seq.getDBRefs()) == null || (ndb = seqrefs.size()) <= 0) continue;
            if (dataRef == null) {
                dataRef = new Hashtable<String, String>();
            }
            if ((primrefs = seq.getPrimaryDBRefs()).size() >= 1) {
                dataRef.put(tmp, this.dbref_to_ac_record(primrefs.get(0)));
                continue;
            }
            for (int idb = 0; idb < seq.getDBRefs().size(); ++idb) {
                DBRefEntry dbref = (DBRefEntry)seq.getDBRefs().get(idb);
                dataRef.put(tmp, this.dbref_to_ac_record(dbref));
                if (isAA && "UNIPROT".equals(DBRefUtils.getCanonicalName(dbref.getSource())) || !isAA && "EMBL".equals(DBRefUtils.getCanonicalName(dbref.getSource()))) continue block0;
            }
        }
        maxid += 9;
        int i = 0;
        if (this.al.getProperties() != null && !this.al.getProperties().isEmpty()) {
            Enumeration key = this.al.getProperties().keys();
            Enumeration val = this.al.getProperties().elements();
            while (key.hasMoreElements()) {
                this.out.append("#=GF " + key.nextElement() + " " + val.nextElement());
                this.out.append(this.newline);
            }
        }
        if (dataRef != null) {
            Enumeration en = dataRef.keys();
            while (en.hasMoreElements()) {
                Object idd = en.nextElement();
                String type = (String)dataRef.remove(idd);
                this.out.append(new Format("%-" + (maxid - 2) + "s").form("#=GS " + idd.toString() + " "));
                if (isAA && type.contains("UNIPROT") || !isAA && type.contains("EMBL")) {
                    this.out.append(" AC " + type.substring(type.indexOf(";") + 1));
                } else {
                    this.out.append(" DR " + type + " ");
                }
                this.out.append(this.newline);
            }
        }
        while (i < slen && (seq = s[i]) != null) {
            AlignmentAnnotation[] alAnot = seq.getAnnotation();
            if (alAnot != null) {
                int nj = alAnot.length;
                for (int j = 0; j < nj; ++j) {
                    String key = StockholmFile.type2id(alAnot[j].label);
                    boolean isrna = alAnot[j].isValidStruc();
                    if (isrna) {
                        key = "SS";
                    }
                    if (key == null) continue;
                    this.out.append(new Format("%-" + maxid + "s").form("#=GR " + this.printId(seq, jvSuffix) + " " + key + " "));
                    Annotation[] ann = alAnot[j].annotations;
                    String sseq = "";
                    int nk = ann.length;
                    for (int k = 0; k < nk; ++k) {
                        sseq = sseq + this.outputCharacter(key, k, isrna, ann, seq);
                    }
                    this.out.append(sseq);
                    this.out.append(this.newline);
                }
            }
            this.out.append(new Format("%-" + maxid + "s").form(this.printId(seq, jvSuffix) + " "));
            this.out.append(seq.getSequenceAsString());
            this.out.append(this.newline);
            ++i;
        }
        AlignmentAnnotation[] an = this.al.getAlignmentAnnotation();
        if (an != null) {
            for (AlignmentAnnotation aa : an) {
                if (aa.autoCalculated || !aa.visible || aa.sequenceRef != null) continue;
                String sseq = "";
                String key = "";
                String label = aa.label.equals("seq") ? "seq_cons" : ((key = StockholmFile.type2id(aa.label.toLowerCase())) == null ? aa.label : key + "_cons");
                if (label == null) {
                    label = aa.label;
                }
                label = label.replace(" ", "_");
                this.out.append(new Format("%-" + maxid + "s").form("#=GC " + label + " "));
                boolean isrna = aa.isValidStruc();
                int nj = aa.annotations.length;
                for (int j = 0; j < nj; ++j) {
                    sseq = sseq + this.outputCharacter(key, j, isrna, aa.annotations, null);
                }
                this.out.append(sseq);
                this.out.append(this.newline);
            }
        }
        this.out.append("//");
        this.out.append(this.newline);
        return this.out.toString();
    }

    private char outputCharacter(String key, int k, boolean isrna, Annotation[] ann, SequenceI sequenceI) {
        String ch;
        int seq = 32;
        Annotation annot = ann[k];
        String string = annot == null ? (sequenceI == null ? "-" : Character.toString(sequenceI.getCharAt(k))) : (ch = annot.displayCharacter == null ? String.valueOf(annot.secondaryStructure) : annot.displayCharacter);
        if (ch == null) {
            ch = " ";
        }
        if (key != null && key.equals("SS")) {
            int ssannotchar = 32;
            boolean charset = false;
            if (annot == null) {
                ssannotchar = 32;
                charset = true;
            } else if (annot.secondaryStructure > ' ' && ch.length() < 2) {
                ssannotchar = annot.secondaryStructure;
                charset = true;
            }
            if (charset) {
                return (char)(ssannotchar == 32 && isrna ? 46 : ssannotchar);
            }
        }
        if (ch.length() == 0) {
            seq = 46;
        } else if (ch.length() == 1) {
            seq = ch.charAt(0);
        } else if (ch.length() > 1) {
            seq = ch.charAt(1);
        }
        return (char)(seq == 32 && key != null && key.equals("SS") && isrna ? 46 : seq);
    }

    public String print() {
        this.out = new StringBuffer();
        this.out.append("# STOCKHOLM 1.0");
        this.out.append(this.newline);
        this.print(this.getSeqsAsArray(), false);
        this.out.append("//");
        this.out.append(this.newline);
        return this.out.toString();
    }

    protected static String id2type(String id) {
        if (typeIds.containsKey(id)) {
            return (String)typeIds.get(id);
        }
        System.err.println("Warning : Unknown Stockholm annotation type code " + id);
        return id;
    }

    protected static String type2id(String type) {
        String key = null;
        Enumeration e = typeIds.keys();
        while (e.hasMoreElements()) {
            Object ll = e.nextElement();
            if (!typeIds.get(ll).toString().equalsIgnoreCase(type)) continue;
            key = (String)ll;
            break;
        }
        if (key != null) {
            return key;
        }
        System.err.println("Warning : Unknown Stockholm annotation type: " + type);
        return key;
    }

    private String safeName(String dataName) {
        int b = 0;
        while ((b = dataName.indexOf("/")) > -1 && b < dataName.length()) {
            dataName = dataName.substring(b + 1).trim();
        }
        int e = dataName.length() - dataName.indexOf(".") + 1;
        dataName = dataName.substring(1, e).trim();
        return dataName;
    }

    static {
        if (typeIds == null) {
            typeIds = new Hashtable();
            typeIds.put("SS", "Secondary Structure");
            typeIds.put("SA", "Surface Accessibility");
            typeIds.put("TM", "transmembrane");
            typeIds.put("PP", "Posterior Probability");
            typeIds.put("LI", "ligand binding");
            typeIds.put("AS", "active site");
            typeIds.put("IN", "intron");
            typeIds.put("IR", "interacting residue");
            typeIds.put("AC", "accession");
            typeIds.put("OS", "organism");
            typeIds.put("CL", "class");
            typeIds.put("DE", "description");
            typeIds.put("DR", "reference");
            typeIds.put("LO", "look");
            typeIds.put("RF", "Reference Positions");
        }
    }
}

