/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.AlignmentFileReaderI;
import jalview.io.FileFormatException;
import jalview.io.FileParse;
import java.io.IOException;
import java.util.StringTokenizer;

public class ScoreMatrixFile
extends AlignFile
implements AlignmentFileReaderI {
    public static final String SCOREMATRIX = "SCOREMATRIX";
    private static final String DELIMITERS = " ,\t";
    private static final String COMMENT_CHAR = "#";
    private String matrixName;
    boolean isLowerDiagonalOnly;
    boolean hasGuideColumn;

    public ScoreMatrixFile(FileParse source) throws IOException {
        super(false, source);
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        return null;
    }

    @Override
    public void parse() throws IOException {
        ScoreMatrix sm = this.parseMatrix();
        ScoreModels.getInstance().registerScoreModel(sm);
    }

    public ScoreMatrix parseMatrix() throws IOException {
        String data;
        ScoreMatrix sm = null;
        int lineNo = 0;
        String name = null;
        char[] alphabet = null;
        float[][] scores = null;
        int size = 0;
        int row = 0;
        String err = null;
        this.isLowerDiagonalOnly = false;
        while ((data = this.nextLine()) != null) {
            ++lineNo;
            if ((data = data.trim()).startsWith(COMMENT_CHAR) || data.length() == 0) continue;
            if (data.regionMatches(true, 0, SCOREMATRIX, 0, SCOREMATRIX.length())) {
                if (name != null) {
                    throw new FileFormatException("Error: 'ScoreMatrix' repeated in file at line " + lineNo);
                }
                StringTokenizer nameLine = new StringTokenizer(data, DELIMITERS);
                if (nameLine.countTokens() < 2) {
                    err = "Format error: expected 'ScoreMatrix <name>', found '" + data + "' at line " + lineNo;
                    throw new FileFormatException(err);
                }
                nameLine.nextToken();
                name = nameLine.nextToken();
                name = data.substring(1).substring(data.substring(1).indexOf(name));
                continue;
            }
            if (data.startsWith("H ") && name == null) {
                return this.parseAAIndexFormat(lineNo, data);
            }
            if (name == null) {
                err = "Format error: 'ScoreMatrix <name>' should be the first non-comment line";
                throw new FileFormatException(err);
            }
            if (alphabet == null) {
                StringTokenizer columnHeadings = new StringTokenizer(data, DELIMITERS);
                size = columnHeadings.countTokens();
                alphabet = new char[size];
                int col = 0;
                while (columnHeadings.hasMoreTokens()) {
                    alphabet[col++] = columnHeadings.nextToken().charAt(0);
                }
                scores = new float[size][];
                continue;
            }
            if (row >= size) {
                err = "Unexpected extra input line in score model file: '" + data + "'";
                throw new FileFormatException(err);
            }
            this.parseValues(data, lineNo, scores, row, alphabet);
            ++row;
        }
        if (row < size) {
            err = String.format("Expected %d rows of score data in score matrix but only found %d", size, row);
            throw new FileFormatException(err);
        }
        sm = new ScoreMatrix(name, alphabet, scores);
        this.matrixName = name;
        return sm;
    }

    protected ScoreMatrix parseAAIndexFormat(int lineNo, String data) throws IOException {
        String name = data.substring(2).trim();
        String description = null;
        float[][] scores = null;
        char[] alphabet = null;
        int row = 0;
        int size = 0;
        while ((data = this.nextLine()) != null) {
            ++lineNo;
            if (this.skipAAindexLine(data = data.trim())) continue;
            if (data.startsWith("D ")) {
                description = data.substring(2).trim();
                continue;
            }
            if (data.startsWith("M ")) {
                alphabet = this.parseAAindexRowsColumns(lineNo, data);
                size = alphabet.length;
                scores = new float[size][size];
                continue;
            }
            if (scores == null) {
                throw new FileFormatException("No alphabet specified in matrix file");
            }
            if (row >= size) {
                throw new FileFormatException("Too many data rows in matrix file");
            }
            this.parseValues(data, lineNo, scores, row, alphabet);
            ++row;
        }
        ScoreMatrix sm = new ScoreMatrix(name, description, alphabet, scores);
        this.matrixName = name;
        return sm;
    }

    protected void parseValues(String data, int lineNo, float[][] scores, int row, char[] alphabet) throws FileFormatException {
        int size = alphabet.length;
        StringTokenizer scoreLine = new StringTokenizer(data, DELIMITERS);
        int tokenCount = scoreLine.countTokens();
        if (row == 0) {
            if (data.startsWith(String.valueOf(alphabet[0]))) {
                this.hasGuideColumn = true;
            }
            if (tokenCount == (this.hasGuideColumn ? 2 : 1)) {
                this.isLowerDiagonalOnly = true;
            }
        }
        if (this.hasGuideColumn) {
            String symbol = scoreLine.nextToken();
            if (symbol.length() > 1 || symbol.charAt(0) != alphabet[row]) {
                String err = String.format("Error parsing score matrix at line %d, expected '%s' but found '%s'", lineNo, Character.valueOf(alphabet[row]), symbol);
                throw new FileFormatException(err);
            }
            tokenCount = scoreLine.countTokens();
        }
        if (this.isLowerDiagonalOnly && tokenCount != row + 1) {
            String err = String.format("Expected %d scores at line %d: '%s' but found %d", row + 1, lineNo, data, tokenCount);
            throw new FileFormatException(err);
        }
        if (!this.isLowerDiagonalOnly && tokenCount != size) {
            String err = String.format("Expected %d scores at line %d: '%s' but found %d", size, lineNo, data, scoreLine.countTokens());
            throw new FileFormatException(err);
        }
        scores[row] = new float[size];
        int col = 0;
        String value = null;
        while (scoreLine.hasMoreTokens()) {
            try {
                value = scoreLine.nextToken();
                scores[row][col] = Float.valueOf(value).floatValue();
                if (this.isLowerDiagonalOnly) {
                    scores[col][row] = scores[row][col];
                }
                ++col;
            }
            catch (NumberFormatException e) {
                String err = String.format("Invalid score value '%s' at line %d column %d", value, lineNo, col);
                throw new FileFormatException(err);
            }
        }
    }

    protected char[] parseAAindexRowsColumns(int lineNo, String data) throws FileFormatException {
        String err = "Unexpected aaIndex score matrix data at line " + lineNo + ": " + data;
        try {
            String[] toks = data.split(",");
            String rowsAlphabet = toks[0].split("=")[1].trim();
            String colsAlphabet = toks[1].split("=")[1].trim();
            if (!rowsAlphabet.equals(colsAlphabet)) {
                throw new FileFormatException("rows != cols");
            }
            return rowsAlphabet.toCharArray();
        }
        catch (Throwable t) {
            throw new FileFormatException(err + " " + t.getMessage());
        }
    }

    protected boolean skipAAindexLine(String data) {
        if (data.startsWith(COMMENT_CHAR) || data.length() == 0) {
            return true;
        }
        return data.startsWith("*") || data.startsWith("R ") || data.startsWith("A ") || data.startsWith("T ") || data.startsWith("J ") || data.startsWith("//");
    }

    public String getMatrixName() {
        return this.matrixName;
    }
}

