/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import com.stevesoft.pat.Regex;
import jalview.datamodel.SequenceNode;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.util.MessageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class NewickFile
extends FileParse {
    SequenceNode root;
    private boolean HasBootstrap = false;
    private boolean HasDistances = false;
    private boolean RootHasDistance = false;
    boolean ReplaceUnderscores = false;
    boolean printRootInfo = true;
    private Regex[] NodeSafeName;
    char QuoteChar;

    public NewickFile(String inStr) throws IOException {
        super(inStr, DataSourceType.PASTE);
        Regex[] regexArray = new Regex[3];
        new Regex();
        regexArray[0] = Regex.perlCode("m/[\\[,:'()]/");
        new Regex();
        regexArray[1] = Regex.perlCode("s/'/''/");
        new Regex();
        regexArray[2] = Regex.perlCode("s/\\/w/_/");
        this.NodeSafeName = regexArray;
        this.QuoteChar = (char)39;
    }

    public NewickFile(String inFile, DataSourceType protocol) throws IOException {
        super(inFile, protocol);
        Regex[] regexArray = new Regex[3];
        new Regex();
        regexArray[0] = Regex.perlCode("m/[\\[,:'()]/");
        new Regex();
        regexArray[1] = Regex.perlCode("s/'/''/");
        new Regex();
        regexArray[2] = Regex.perlCode("s/\\/w/_/");
        this.NodeSafeName = regexArray;
        this.QuoteChar = (char)39;
    }

    public NewickFile(FileParse source) throws IOException {
        super(source);
        Regex[] regexArray = new Regex[3];
        new Regex();
        regexArray[0] = Regex.perlCode("m/[\\[,:'()]/");
        new Regex();
        regexArray[1] = Regex.perlCode("s/'/''/");
        new Regex();
        regexArray[2] = Regex.perlCode("s/\\/w/_/");
        this.NodeSafeName = regexArray;
        this.QuoteChar = (char)39;
    }

    public NewickFile(SequenceNode newtree) {
        Regex[] regexArray = new Regex[3];
        new Regex();
        regexArray[0] = Regex.perlCode("m/[\\[,:'()]/");
        new Regex();
        regexArray[1] = Regex.perlCode("s/'/''/");
        new Regex();
        regexArray[2] = Regex.perlCode("s/\\/w/_/");
        this.NodeSafeName = regexArray;
        this.QuoteChar = (char)39;
        this.root = newtree;
    }

    public NewickFile(SequenceNode newtree, boolean bootstrap) {
        Regex[] regexArray = new Regex[3];
        new Regex();
        regexArray[0] = Regex.perlCode("m/[\\[,:'()]/");
        new Regex();
        regexArray[1] = Regex.perlCode("s/'/''/");
        new Regex();
        regexArray[2] = Regex.perlCode("s/\\/w/_/");
        this.NodeSafeName = regexArray;
        this.QuoteChar = (char)39;
        this.HasBootstrap = bootstrap;
        this.root = newtree;
    }

    public NewickFile(SequenceNode newtree, boolean bootstrap, boolean distances) {
        Regex[] regexArray = new Regex[3];
        new Regex();
        regexArray[0] = Regex.perlCode("m/[\\[,:'()]/");
        new Regex();
        regexArray[1] = Regex.perlCode("s/'/''/");
        new Regex();
        regexArray[2] = Regex.perlCode("s/\\/w/_/");
        this.NodeSafeName = regexArray;
        this.QuoteChar = (char)39;
        this.root = newtree;
        this.HasBootstrap = bootstrap;
        this.HasDistances = distances;
    }

    public NewickFile(SequenceNode newtree, boolean bootstrap, boolean distances, boolean rootdistance) {
        Regex[] regexArray = new Regex[3];
        new Regex();
        regexArray[0] = Regex.perlCode("m/[\\[,:'()]/");
        new Regex();
        regexArray[1] = Regex.perlCode("s/'/''/");
        new Regex();
        regexArray[2] = Regex.perlCode("s/\\/w/_/");
        this.NodeSafeName = regexArray;
        this.QuoteChar = (char)39;
        this.root = newtree;
        this.HasBootstrap = bootstrap;
        this.HasDistances = distances;
        this.RootHasDistance = rootdistance;
    }

    private String ErrorStringrange(String Error2, String Er, int r, int p, String s) {
        return (Error2 == null ? "" : Error2) + Er + " at position " + p + " ( " + s.substring(p - r < 0 ? 0 : p - r, p + r > s.length() ? s.length() : p + r) + " )\n";
    }

    public boolean HasBootstrap() {
        return this.HasBootstrap;
    }

    public boolean HasDistances() {
        return this.HasDistances;
    }

    public boolean HasRootDistance() {
        return this.RootHasDistance;
    }

    public void parse() throws IOException {
        String nf;
        StringBuffer file = new StringBuffer();
        while ((nf = this.nextLine()) != null) {
            file.append(nf);
        }
        nf = file.toString();
        this.root = new SequenceNode();
        SequenceNode realroot = null;
        SequenceNode c = this.root;
        int d = -1;
        int cp = 0;
        String Error2 = null;
        String nodename = null;
        String commentString2 = null;
        float DefDistance = 0.001f;
        int DefBootstrap = -1;
        float distance = DefDistance;
        int bootstrap = DefBootstrap;
        boolean ascending = false;
        Regex majorsyms = new Regex("[(\\['),;]");
        int nextcp = 0;
        int ncp = cp;
        boolean parsednodename = false;
        block9: while (majorsyms.searchFrom(nf, cp) && Error2 == null) {
            int fcp = majorsyms.matchedFrom();
            char schar = nf.charAt(fcp);
            switch (schar) {
                case '(': {
                    if (ascending) {
                        Error2 = this.ErrorStringrange(Error2, "Unexpected '('", 7, fcp, nf);
                        continue block9;
                    }
                    ++d;
                    if (c.right() == null) {
                        c.setRight(new SequenceNode(null, c, null, DefDistance, DefBootstrap, false));
                        c = (SequenceNode)c.right();
                    } else {
                        if (c.left() != null) {
                            SequenceNode tmpn = new SequenceNode(null, c, null, 0.0f, 0, true);
                            tmpn.SetChildren(c.left(), c.right());
                            c.setRight(tmpn);
                        }
                        c.setLeft(new SequenceNode(null, c, null, DefDistance, DefBootstrap, false));
                        c = (SequenceNode)c.left();
                    }
                    if (realroot == null) {
                        realroot = c;
                    }
                    nodename = null;
                    distance = DefDistance;
                    bootstrap = DefBootstrap;
                    cp = fcp + 1;
                    break;
                }
                case '\'': {
                    Regex qnodename = new Regex("'([^']|'')+'");
                    if (qnodename.searchFrom(nf, fcp)) {
                        String widernodename;
                        int nl = qnodename.stringMatched().length();
                        nodename = new String(qnodename.stringMatched().substring(1, nl - 1));
                        Regex xpandquotes = Regex.perlCode("s/''/'/");
                        nodename = widernodename = xpandquotes.replaceAll(nodename);
                        nextcp = fcp + nl + 1;
                        parsednodename = true;
                        break;
                    }
                    Error2 = this.ErrorStringrange(Error2, "Unterminated quotes for nodename", 7, fcp, nf);
                    break;
                }
                default: {
                    if (schar == ';' && d != -1) {
                        Error2 = this.ErrorStringrange(Error2, "Wayward semicolon (depth=" + d + ")", 7, fcp, nf);
                    }
                    if (schar == '[') {
                        Regex comment = new Regex("]");
                        if (comment.searchFrom(nf, fcp)) {
                            nextcp = comment.matchedFrom() + 1;
                            this.warningMessage = "Tree file contained comments which may confuse input algorithm.";
                            break;
                        }
                        Error2 = this.ErrorStringrange(Error2, "Unterminated comment", 3, fcp, nf);
                    }
                    String fstring = nf.substring(ncp, fcp);
                    while (fstring.indexOf(93) > -1) {
                        int cstart = fstring.indexOf(91);
                        int cend = fstring.indexOf(93);
                        commentString2 = fstring.substring(cstart + 1, cend);
                        fstring = fstring.substring(0, cstart) + fstring.substring(cend + 1);
                    }
                    Regex uqnodename = new Regex("\\b([^' :;\\](),]+)");
                    Regex nbootstrap = new Regex("\\s*([0-9+]+)\\s*:");
                    Regex ndist = new Regex(":([-0-9Ee.+]+)");
                    if (!parsednodename && uqnodename.search(fstring) && (uqnodename.matchedFrom(1) == 0 || fstring.charAt(uqnodename.matchedFrom(1) - 1) != ':')) {
                        if (nodename == null) {
                            nodename = this.ReplaceUnderscores ? uqnodename.stringMatched(1).replace('_', ' ') : uqnodename.stringMatched(1);
                        } else {
                            Error2 = this.ErrorStringrange(Error2, "File has broken algorithm - overwritten nodename", 10, fcp, nf);
                        }
                    }
                    if (nbootstrap.search(fstring)) {
                        if (nbootstrap.stringMatched(1).equals(uqnodename.stringMatched(1))) {
                            nodename = null;
                        }
                        if (nodename == null || nodename.length() == 0 || nbootstrap.matchedFrom(1) > uqnodename.matchedFrom(1) + uqnodename.stringMatched().length()) {
                            try {
                                bootstrap = Integer.valueOf(nbootstrap.stringMatched(1));
                                this.HasBootstrap = true;
                            }
                            catch (Exception e) {
                                Error2 = this.ErrorStringrange(Error2, "Can't parse bootstrap value", 4, ncp + nbootstrap.matchedFrom(), nf);
                            }
                        }
                    }
                    boolean nodehasdistance = false;
                    if (ndist.search(fstring)) {
                        try {
                            distance = Float.valueOf(ndist.stringMatched(1)).floatValue();
                            this.HasDistances = true;
                            nodehasdistance = true;
                        }
                        catch (Exception e) {
                            Error2 = this.ErrorStringrange(Error2, "Can't parse node distance value", 7, ncp + ndist.matchedFrom(), nf);
                        }
                    }
                    if (ascending) {
                        c.setName(nodename);
                        c.dist = this.HasDistances ? (double)distance : (double)DefDistance;
                        c.setBootstrap(this.HasBootstrap ? bootstrap : DefBootstrap);
                        if (c == realroot) {
                            this.RootHasDistance = nodehasdistance;
                        }
                        this.parseNHXNodeProps(c, commentString2);
                        commentString2 = null;
                    } else {
                        SequenceNode newnode = new SequenceNode(null, c, nodename, this.HasDistances ? distance : DefDistance, this.HasBootstrap ? bootstrap : DefBootstrap, false);
                        this.parseNHXNodeProps(c, commentString2);
                        commentString2 = null;
                        if (c.right() == null) {
                            c.setRight(newnode);
                        } else if (c.left() == null) {
                            c.setLeft(newnode);
                        } else {
                            SequenceNode newdummy = new SequenceNode(null, c, null, this.HasDistances ? 0.0f : DefDistance, 0, true);
                            newdummy.SetChildren(c.left(), newnode);
                            c.setLeft(newdummy);
                        }
                    }
                    if (ascending) {
                        c = c.AscendTree();
                        if (d > -1 && c == null) {
                            Error2 = this.ErrorStringrange(Error2, "File broke algorithm: Lost place in tree (is there an extra ')' ?)", 7, fcp, nf);
                        }
                    }
                    if (nf.charAt(fcp) == ')') {
                        --d;
                        ascending = true;
                    } else if (nf.charAt(fcp) == ',') {
                        if (ascending) {
                            ascending = false;
                        } else if (c.left() != null && !c.left().isLeaf()) {
                            c = (SequenceNode)c.left();
                        }
                    }
                    nodename = null;
                    distance = DefDistance;
                    bootstrap = DefBootstrap;
                    commentString2 = null;
                    parsednodename = false;
                }
            }
            if (nextcp == 0) {
                ncp = cp = fcp + 1;
                continue;
            }
            cp = nextcp;
            nextcp = 0;
        }
        if (Error2 != null) {
            throw new IOException(MessageManager.formatMessage("exception.newfile", new String[]{Error2.toString()}));
        }
        if (this.root == null) {
            throw new IOException(MessageManager.formatMessage("exception.newfile", new String[]{MessageManager.getString("label.no_tree_read_in")}));
        }
        this.root = (SequenceNode)this.root.right().detach();
        if (!this.RootHasDistance) {
            this.root.dist = this.HasDistances ? 0.0 : (double)DefDistance;
        }
    }

    private void parseNHXNodeProps(SequenceNode c, String commentString) {
        if (commentString != null && commentString.startsWith("&&NHX")) {
            StringTokenizer st = new StringTokenizer(commentString.substring(5), ":");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int colpos = tok.indexOf("=");
                if (colpos <= -1) continue;
                String code = tok.substring(0, colpos);
                String value = tok.substring(colpos + 1);
                try {
                    if (!code.toLowerCase().equals("b")) continue;
                    int v = -1;
                    Float iv = Float.valueOf(value);
                    v = iv.intValue();
                    c.setBootstrap(v);
                    this.HasBootstrap = true;
                }
                catch (Exception e) {
                    System.err.println("Couldn't parse code '" + code + "' = '" + value + "'");
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public SequenceNode getTree() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print() {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            StringBuffer tf = new StringBuffer();
            this.print(tf, this.root);
            return tf.append(";").toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print(boolean withbootstraps) {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            boolean boots = this.HasBootstrap;
            this.HasBootstrap = withbootstraps;
            String rv = this.print();
            this.HasBootstrap = boots;
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print(boolean withbootstraps, boolean withdists) {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            boolean dists = this.HasDistances;
            this.HasDistances = withdists;
            String rv = this.print(withbootstraps);
            this.HasDistances = dists;
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print(boolean withbootstraps, boolean withdists, boolean printRootInfo) {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            boolean rootinfo = printRootInfo;
            this.printRootInfo = printRootInfo;
            String rv = this.print(withbootstraps, withdists);
            this.printRootInfo = rootinfo;
            return rv;
        }
    }

    char getQuoteChar() {
        return this.QuoteChar;
    }

    char setQuoteChar(char c) {
        char old = this.QuoteChar;
        this.QuoteChar = c;
        return old;
    }

    private String nodeName(String name) {
        if (this.NodeSafeName[0].search(name)) {
            return this.QuoteChar + this.NodeSafeName[1].replaceAll(name) + this.QuoteChar;
        }
        return this.NodeSafeName[2].replaceAll(name);
    }

    private String printNodeField(SequenceNode c) {
        return (c.getName() == null ? "" : this.nodeName(c.getName())) + (this.HasBootstrap ? (c.getBootstrap() > -1 ? (c.getName() != null ? " " : "") + c.getBootstrap() : "") : "") + (this.HasDistances ? ":" + c.dist : "");
    }

    private String printRootField(SequenceNode root) {
        return this.printRootInfo ? (root.getName() == null ? "" : this.nodeName(root.getName())) + (this.HasBootstrap ? (root.getBootstrap() > -1 ? (root.getName() != null ? " " : "") + root.getBootstrap() : "") : "") + (this.RootHasDistance ? ":" + root.dist : "") : "";
    }

    public void print(StringBuffer tf, SequenceNode root) {
        if (root != null) {
            if (root.isLeaf() && this.printRootInfo) {
                tf.append(this.printRootField(root));
            } else if (root.isDummy()) {
                this._print(tf, (SequenceNode)root.right());
                this._print(tf, (SequenceNode)root.left());
            } else {
                tf.append("(");
                this._print(tf, (SequenceNode)root.right());
                if (root.left() != null) {
                    tf.append(",");
                }
                this._print(tf, (SequenceNode)root.left());
                tf.append(")" + this.printRootField(root));
            }
        }
    }

    public void _print(StringBuffer tf, SequenceNode c) {
        if (c != null) {
            if (c.isLeaf()) {
                tf.append(this.printNodeField(c));
            } else if (c.isDummy()) {
                this._print(tf, (SequenceNode)c.left());
                if (c.left() != null) {
                    tf.append(",");
                }
                this._print(tf, (SequenceNode)c.right());
            } else {
                tf.append("(");
                this._print(tf, (SequenceNode)c.right());
                if (c.left() != null) {
                    tf.append(",");
                }
                this._print(tf, (SequenceNode)c.left());
                tf.append(")" + this.printNodeField(c));
            }
        }
    }

    public static void main(String[] args) {
        try {
            String l;
            if (args == null || args.length != 1) {
                System.err.println("Takes one argument - file name of a newick tree file.");
                System.exit(0);
            }
            File fn = new File(args[0]);
            StringBuffer newickfile = new StringBuffer();
            BufferedReader treefile = new BufferedReader(new FileReader(fn));
            while ((l = treefile.readLine()) != null) {
                newickfile.append(l);
            }
            treefile.close();
            System.out.println("Read file :\n");
            NewickFile trf = new NewickFile(args[0], DataSourceType.FILE);
            trf.parse();
            System.out.println("Original file :\n");
            Regex nonl = new Regex("\n+", "");
            System.out.println(nonl.replaceAll(newickfile.toString()) + "\n");
            System.out.println("Parsed file.\n");
            System.out.println("Default output type for original input.\n");
            System.out.println(trf.print());
            System.out.println("Without bootstraps.\n");
            System.out.println(trf.print(false));
            System.out.println("Without distances.\n");
            System.out.println(trf.print(true, false));
            System.out.println("Without bootstraps but with distanecs.\n");
            System.out.println(trf.print(false, true));
            System.out.println("Without bootstraps or distanecs.\n");
            System.out.println(trf.print(false, false));
            System.out.println("With bootstraps and with distances.\n");
            System.out.println(trf.print(true, true));
        }
        catch (IOException e) {
            System.err.println("Exception\n" + e);
            e.printStackTrace();
        }
    }
}

