/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.AlignExportSettingsI;
import jalview.api.AlignmentViewPanel;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AlignmentFileReaderI;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormatI;
import jalview.io.FileParse;
import jalview.util.Comparison;
import java.io.File;
import java.io.IOException;

public class FormatAdapter
extends AppletFormatAdapter {
    public FormatAdapter(AlignmentViewPanel viewpanel) {
        super(viewpanel);
        this.init();
    }

    public FormatAdapter() {
        this.init();
    }

    public FormatAdapter(AlignmentViewPanel alignPanel, AlignExportSettingsI settings) {
        super(alignPanel, settings);
    }

    private void init() {
        if (Cache.getDefault("STRUCT_FROM_PDB", true)) {
            this.annotFromStructure = Cache.getDefault("ADD_TEMPFACT_ANN", true);
            this.localSecondaryStruct = Cache.getDefault("ADD_SS_ANN", true);
            this.serviceSecondaryStruct = Cache.getDefault("USE_RNAVIEW", true);
        } else {
            this.annotFromStructure = false;
            this.localSecondaryStruct = false;
            this.serviceSecondaryStruct = false;
        }
    }

    public String formatSequences(FileFormatI format, SequenceI[] seqs, String[] omitHiddenColumns, int[] exportRange) {
        return this.formatSequences(format, this.replaceStrings(seqs, omitHiddenColumns, exportRange));
    }

    public SequenceI[] replaceStrings(SequenceI[] seqs, String[] omitHiddenColumns, int[] startEnd) {
        if (omitHiddenColumns != null) {
            SequenceI[] tmp = new SequenceI[seqs.length];
            for (int i = 0; i < seqs.length; ++i) {
                int startRes = seqs[i].getStart();
                int endRes = seqs[i].getEnd();
                if (startEnd != null) {
                    int startIndex;
                    int endIndex = startEnd[1];
                    for (startIndex = startEnd[0]; Comparison.isGap(seqs[i].getCharAt(startIndex)) && startIndex < endIndex; ++startIndex) {
                    }
                    while (Comparison.isGap(seqs[i].getCharAt(endIndex)) && endIndex > startIndex) {
                        --endIndex;
                    }
                    startRes = seqs[i].findPosition(startIndex);
                    endRes = seqs[i].findPosition(endIndex);
                }
                tmp[i] = new Sequence(seqs[i].getName(), omitHiddenColumns[i], startRes, endRes);
                tmp[i].setDescription(seqs[i].getDescription());
            }
            seqs = tmp;
        }
        return seqs;
    }

    public String formatSequences(FileFormatI format, SequenceI[] seqs) {
        boolean withSuffix = this.getCacheSuffixDefault(format);
        return format.getWriter(null).print(seqs, withSuffix);
    }

    public boolean getCacheSuffixDefault(FileFormatI format) {
        return Cache.getDefault(format.getName().toUpperCase() + "_JVSUFFIX", true);
    }

    public String formatSequences(FileFormatI format, AlignmentI alignment, String[] omitHidden, int[] exportRange, HiddenColumns hidden) {
        return this.formatSequences(format, alignment, omitHidden, exportRange, this.getCacheSuffixDefault(format), hidden, null);
    }

    public String formatSequences(FileFormatI format, AlignmentI alignment, String[] omitHidden, int[] exportRange, boolean suffix, HiddenColumns hidden) {
        return this.formatSequences(format, alignment, omitHidden, exportRange, suffix, hidden, null);
    }

    public String formatSequences(FileFormatI format, AlignmentI alignment, String[] omitHidden, int[] exportRange, boolean suffix, HiddenColumns hidden, SequenceGroup selgp) {
        if (omitHidden != null) {
            Alignment alv = new Alignment(this.replaceStrings(alignment.getSequencesArray(), omitHidden, exportRange));
            AlignmentAnnotation[] ala = alignment.getAlignmentAnnotation();
            if (ala != null) {
                for (int i = 0; i < ala.length; ++i) {
                    AlignmentAnnotation na = new AlignmentAnnotation(ala[i]);
                    if (selgp != null) {
                        na.makeVisibleAnnotation(selgp.getStartRes(), selgp.getEndRes(), hidden);
                    } else {
                        na.makeVisibleAnnotation(hidden);
                    }
                    alv.addAnnotation(na);
                }
            }
            return this.formatSequences(format, alv, suffix);
        }
        return this.formatSequences(format, alignment, suffix);
    }

    @Override
    public AlignmentI readFile(String file, DataSourceType sourceType, FileFormatI fileFormat) throws IOException {
        AlignmentI al = super.readFile(file, sourceType, fileFormat);
        return al;
    }

    public AlignmentI readFile(File file, DataSourceType sourceType, FileFormatI fileFormat) throws IOException {
        AlignmentI al = super.readFile(file, null, sourceType, fileFormat);
        return al;
    }

    @Override
    public AlignmentI readFromFile(FileParse source, FileFormatI format) throws IOException {
        AlignmentI al = super.readFromFile(source, format);
        return al;
    }

    public String formatSequences(FileFormatI format, AlignmentViewPanel ap, boolean selectedOnly) {
        return this.formatSequences(format, this.getCacheSuffixDefault(format), ap, selectedOnly);
    }

    public AlignmentI readFromFile(AlignmentFileReaderI source, FileFormatI format) throws IOException {
        FileParse fp = new FileParse(source.getInFile(), source.getDataSourceType());
        return this.readFromFile(fp, format);
    }
}

