/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import compbio.metadata.Argument;
import compbio.metadata.Option;
import compbio.metadata.Parameter;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OptsAndParamsPage;
import jalview.gui.OptsParametersContainerI;
import jalview.util.MessageManager;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.jws2.ParameterUtils;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.OptionI;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParameterI;
import jalview.ws.params.WsParamSetI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class WsJobParameters
extends JPanel
implements ItemListener,
ActionListener,
DocumentListener,
OptsParametersContainerI {
    URL linkImageURL = this.getClass().getResource("/images/link.gif");
    private static final String SVC_DEF = "Defaults";
    OptsAndParamsPage opanp = new OptsAndParamsPage(this);
    JPanel jobOptions = new JPanel();
    JPanel paramList = new JPanel();
    JPanel SetNamePanel = new JPanel();
    JPanel setDetails = new JPanel();
    JSplitPane settingsPanel = new JSplitPane();
    JPanel jobPanel = new JPanel();
    JScrollPane jobOptionsPane = new JScrollPane();
    JButton createpref = new JButton();
    JButton deletepref = new JButton();
    JButton revertpref = new JButton();
    JButton updatepref = new JButton();
    JButton startjob = new JButton();
    JButton canceljob = new JButton();
    JComboBox setName = new JComboBox();
    JTextArea setDescr = new JTextArea();
    JScrollPane paramPane = new JScrollPane();
    JPanel optsAndparams = new JPanel();
    RunnerConfig serviceOptions;
    ParamDatastoreI paramStore;
    private int MAX_OPTWIDTH = 200;
    int response = -1;
    JDialog frame = null;
    Jws2Instance service;
    Hashtable servicePresets = null;
    boolean settingDialog = false;
    private Hashtable modifiedElements = new Hashtable();
    String lastParmSet = null;
    boolean isUserPreset = false;
    String curSetName = null;
    String lastSetName = null;
    String lastDescrText = null;

    WsJobParameters(Jws2Instance service) {
        this(service, null);
    }

    public WsJobParameters(Jws2Instance service, WsParamSetI preset) {
        this(null, service, preset, null);
    }

    public WsJobParameters(JFrame parent, Jws2Instance service, WsParamSetI preset, List<Argument> jobArgset) {
        this(parent, null, service, preset, jobArgset);
    }

    public WsJobParameters(JFrame parent, ParamDatastoreI paramStorei, Jws2Instance service, WsParamSetI preset, List<Argument> jobArgset) {
        this.jbInit();
        this.paramStore = paramStorei;
        if (this.paramStore == null) {
            this.paramStore = service.getParamStore();
        }
        this.service = service;
        this.initForService(service, preset, jobArgset);
        this.validate();
    }

    public boolean showRunDialog() {
        this.frame = new JDialog((Frame)Desktop.instance, true);
        this.frame.setTitle(MessageManager.formatMessage("label.edit_params_for", new String[]{this.service.getActionText()}));
        Rectangle deskr = Desktop.instance.getBounds();
        Dimension pref = this.getPreferredSize();
        this.frame.setBounds(new Rectangle((int)(deskr.getCenterX() - (double)(pref.width / 2)), (int)(deskr.getCenterY() - (double)(pref.height / 2)), pref.width, pref.height));
        this.frame.setContentPane(this);
        this.frame.validate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
        this.frame.setVisible(true);
        return this.response > 0;
    }

    private void jbInit() {
        this.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorResized(HierarchyEvent arg0) {
                WsJobParameters.this.refreshParamLayout();
            }

            @Override
            public void ancestorMoved(HierarchyEvent arg0) {
            }
        });
        this.updatepref = JvSwingUtils.makeButton(MessageManager.getString("action.update"), MessageManager.getString("label.update_user_parameter_set"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WsJobParameters.this.update_actionPerformed(e);
            }
        });
        this.deletepref = JvSwingUtils.makeButton(MessageManager.getString("action.delete"), MessageManager.getString("label.delete_user_parameter_set"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WsJobParameters.this.delete_actionPerformed(e);
            }
        });
        this.createpref = JvSwingUtils.makeButton(MessageManager.getString("action.create"), MessageManager.getString("label.create_user_parameter_set"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WsJobParameters.this.create_actionPerformed(e);
            }
        });
        this.revertpref = JvSwingUtils.makeButton(MessageManager.getString("action.revert"), MessageManager.getString("label.revert_changes_user_parameter_set"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WsJobParameters.this.revert_actionPerformed(e);
            }
        });
        this.startjob = JvSwingUtils.makeButton(MessageManager.getString("action.start_job"), MessageManager.getString("label.start_job_current_settings"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WsJobParameters.this.startjob_actionPerformed(e);
            }
        });
        this.canceljob = JvSwingUtils.makeButton(MessageManager.getString("action.cancel_job"), MessageManager.getString("label.cancel_job_close_dialog"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WsJobParameters.this.canceljob_actionPerformed(e);
            }
        });
        this.setDetails.setBorder(new TitledBorder(MessageManager.getString("label.details")));
        this.setDetails.setLayout(new BorderLayout());
        this.setDescr.setColumns(40);
        this.setDescr.setWrapStyleWord(true);
        this.setDescr.setLineWrap(true);
        this.setDescr.setBackground(this.getBackground());
        this.setDescr.setEditable(true);
        this.setDescr.getDocument().addDocumentListener(this);
        this.setDescr.setToolTipText(MessageManager.getString("label.edit_notes_parameter_set"));
        JScrollPane setDescrView = new JScrollPane();
        setDescrView.getViewport().setView(this.setDescr);
        this.setName.setEditable(true);
        this.setName.addItemListener(this);
        this.setName.getEditor().addActionListener(this);
        JPanel setNameInfo = new JPanel(new FlowLayout(0));
        GridBagLayout gbl = new GridBagLayout();
        this.SetNamePanel.setLayout(gbl);
        JLabel setNameLabel = new JLabel(MessageManager.getString("label.current_parameter_set_name"));
        setNameLabel.setFont(new Font("Verdana", 0, 10));
        setNameInfo.add(setNameLabel);
        setNameInfo.add(this.setName);
        this.updatepref.setVisible(false);
        this.deletepref.setVisible(false);
        this.revertpref.setVisible(false);
        this.createpref.setVisible(false);
        JPanel setsavebuts = new JPanel();
        setsavebuts.setLayout(new FlowLayout(0));
        ((FlowLayout)setsavebuts.getLayout()).setHgap(10);
        ((FlowLayout)setsavebuts.getLayout()).setVgap(0);
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(2, 30));
        setsavebuts.add(spacer);
        setsavebuts.add(this.deletepref);
        setsavebuts.add(this.revertpref);
        setsavebuts.add(this.createpref);
        setsavebuts.add(this.updatepref);
        JPanel buttonArea = new JPanel(new GridLayout(1, 1));
        buttonArea.add(setsavebuts);
        this.SetNamePanel.add(setNameInfo);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 2;
        gbl.setConstraints(setNameInfo, gbc);
        this.SetNamePanel.add(buttonArea);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbl.setConstraints(buttonArea, gbc);
        this.setDetails.add((Component)setDescrView, "Center");
        this.jobOptions.setBorder(new TitledBorder(MessageManager.getString("label.options")));
        this.jobOptions.setOpaque(true);
        this.paramList.setBorder(new TitledBorder(MessageManager.getString("label.parameters")));
        this.paramList.setOpaque(true);
        JPanel bjo = new JPanel(new BorderLayout());
        JPanel bjp = new JPanel(new BorderLayout());
        bjo.add((Component)this.jobOptions, "Center");
        bjp.add((Component)this.paramList, "Center");
        bjp.setOpaque(true);
        bjo.setOpaque(true);
        this.optsAndparams.setLayout(new BorderLayout());
        this.optsAndparams.add((Component)this.jobOptions, "North");
        this.optsAndparams.add((Component)this.paramList, "Center");
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)this.optsAndparams, "Center");
        this.paramPane.getViewport().setView(jp);
        this.paramPane.setBorder(null);
        this.setLayout(new BorderLayout());
        this.jobPanel.setPreferredSize(null);
        this.jobPanel.setLayout(new BorderLayout());
        this.jobPanel.add((Component)this.setDetails, "North");
        this.jobPanel.add((Component)this.paramPane, "Center");
        this.add((Component)this.SetNamePanel, "North");
        this.add((Component)this.jobPanel, "Center");
        JPanel dialogpanel = new JPanel();
        dialogpanel.add(this.startjob);
        dialogpanel.add(this.canceljob);
        int windowHeight = Desktop.instance == null ? 540 : Desktop.instance.getHeight();
        this.setPreferredSize(new Dimension(540, windowHeight));
        this.add((Component)dialogpanel, "South");
        this.validate();
    }

    protected void revert_actionPerformed(ActionEvent e) {
        this.reInitDialog(this.lastParmSet);
        this.updateWebServiceMenus();
    }

    protected void update_actionPerformed(ActionEvent e) {
        if (this.isUserPreset) {
            String curname = ((String)this.setName.getSelectedItem()).trim();
            this._updatePreset(this.lastParmSet, curname);
            this.lastParmSet = curname;
            this.isUserPreset = true;
            this.initArgSetModified();
            this.syncSetNamesWithStore();
        }
    }

    private void _deleteUserPreset(String lastParmSet2) {
        this.paramStore.deletePreset(lastParmSet2);
    }

    protected void delete_actionPerformed(ActionEvent e) {
        if (this.isUserPreset) {
            this._deleteUserPreset(this.lastParmSet);
        }
        this.reInitDialog(null);
        this.updateWebServiceMenus();
    }

    protected void create_actionPerformed(ActionEvent e) {
        String curname = ((String)this.setName.getSelectedItem()).trim();
        if (curname.length() > 0) {
            this._storeCurrentPreset(curname);
            this.lastParmSet = curname;
            this.isUserPreset = true;
            this.reInitDialog(curname);
            this.initArgSetModified();
            this.updateWebServiceMenus();
        } else {
            System.err.println("Invalid name. Not saved.");
        }
    }

    protected void canceljob_actionPerformed(ActionEvent e) {
        this.response = 0;
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    protected void startjob_actionPerformed(ActionEvent e) {
        this.response = 1;
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    void initForService(Jws2Instance service, WsParamSetI jabap, List<Argument> jabajobArgset) {
        WsParamSetI p = null;
        List<ArgumentI> jobArgset = null;
        this.settingDialog = true;
        jobArgset = jabajobArgset == null ? null : JabaParamStore.getJwsArgsfromJaba(jabajobArgset);
        p = jabap;
        Hashtable<Object, Object> exnames = new Hashtable<Object, Object>();
        int iSize = this.setName.getItemCount();
        for (int i = 0; i < iSize; ++i) {
            exnames.put(this.setName.getItemAt(i), this.setName.getItemAt(i));
        }
        this.servicePresets = new Hashtable();
        if (!exnames.contains(SVC_DEF)) {
            this.setName.addItem(SVC_DEF);
            exnames.put(SVC_DEF, SVC_DEF);
            this.servicePresets.put(SVC_DEF, SVC_DEF);
        }
        String curname = p == null ? "" : p.getName();
        for (WsParamSetI pr : this.paramStore.getPresets()) {
            if (!pr.isModifiable()) {
                this.servicePresets.put(pr.getName(), "preset");
            }
            if (exnames.contains(pr.getName())) continue;
            this.setName.addItem(pr.getName());
        }
        if (p != null) {
            this.reInitDialog(p.getName());
            this.initArgSetModified();
        } else if (jobArgset != null && jobArgset.size() > 0) {
            this.curSetName = "Supplied Settings";
            this.isUserPreset = false;
            this.updateTable(p, jobArgset);
            this.setName.setSelectedItem(this.curSetName);
            this.updateButtonDisplay();
        } else {
            this.curSetName = null;
            this.reInitDialog(null);
        }
        this.settingDialog = false;
    }

    private void updateTable(WsParamSetI p, List<ArgumentI> jobArgset) {
        boolean setDefaultParams = false;
        if (this.lastParmSet == null) {
            this.isUserPreset = false;
            this.lastSetName = SVC_DEF;
            this.setName.setSelectedItem(SVC_DEF);
        }
        if (p == null && SVC_DEF.equals("" + this.setName.getSelectedItem())) {
            setDefaultParams = true;
        }
        List<ArgumentI> args = this.paramStore.getServiceParameters();
        int cw = 0;
        boolean optset = false;
        for (ArgumentI myarg : args) {
            if (myarg instanceof ParameterI) {
                ParameterI parm = (ParameterI)myarg;
                this.opanp.addParameter(parm).validate();
                continue;
            }
            if (myarg instanceof OptionI) {
                OptionI opt = (OptionI)myarg;
                OptsAndParamsPage.OptionBox ob = this.opanp.addOption(opt);
                ob.resetToDefault(setDefaultParams);
                if (this.MAX_OPTWIDTH < ob.getPreferredSize().width) {
                    this.MAX_OPTWIDTH = ob.getPreferredSize().width;
                }
                ob.validate();
                cw += ob.getPreferredSize().width + 5;
                continue;
            }
            System.err.println("Ignoring unknown service argument type " + myarg.getClass().getName());
        }
        args = null;
        if (p != null) {
            this.isUserPreset = false;
            this.lastSetName = p.getName();
            this.setName.setSelectedItem(this.lastSetName);
            this.lastDescrText = p.getDescription();
            this.setDescr.setText(this.lastDescrText);
            try {
                args = p.getArguments();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (jobArgset != null) {
            this.argSetModified(jobArgset, true);
            args = jobArgset;
        }
        if (args != null) {
            for (ArgumentI arg : args) {
                if (arg instanceof ParameterI) {
                    this.opanp.setParameter((ParameterI)arg);
                    continue;
                }
                if (!(arg instanceof OptionI)) continue;
                this.opanp.selectOption((OptionI)arg, arg.getValue());
            }
        }
        this.refreshParamLayout();
        this.revalidate();
    }

    private boolean isModified() {
        return this.modifiedElements.size() > 0;
    }

    private void initArgSetModified() {
        this.curSetName = null;
        this.modifiedElements.clear();
        this.updateButtonDisplay();
    }

    private void updateButtonDisplay() {
        boolean _update = false;
        boolean _create = false;
        boolean _delete = false;
        boolean _revert = false;
        if (this.modifiedElements.size() > 0) {
            _revert = true;
            _update = this.isUserPreset;
            if (!this.isUserPreset || this.modifiedElements.containsKey(this.setName)) {
                _create = true;
            }
        }
        _delete = this.isUserPreset;
        this.createpref.setVisible(_create);
        this.updatepref.setVisible(_update);
        this.deletepref.setVisible(_delete);
        this.revertpref.setVisible(_revert);
        this.validate();
    }

    @Override
    public void argSetModified(Object modifiedElement, boolean b) {
        if (this.settingDialog) {
            return;
        }
        if (!b) {
            this.modifiedElements.remove(modifiedElement);
        } else {
            if (b && modifiedElement == this.setName && this.modifiedElements.contains(modifiedElement)) {
                b = false;
            }
            this.modifiedElements.put(modifiedElement, modifiedElement);
        }
        if (b && this.modifiedElements.size() > 0) {
            this.makeSetNameValid(!this.isUserPreset);
            this.SetNamePanel.revalidate();
        }
        this.updateButtonDisplay();
    }

    private boolean isServicePreset(String selectedItem) {
        return selectedItem.equals(SVC_DEF) || this.servicePresets.containsKey(selectedItem);
    }

    private void makeSetNameValid(boolean newuserset) {
        String nm;
        boolean stn = this.settingDialog;
        boolean renamed = false;
        this.settingDialog = true;
        String string = nm = this.curSetName != null ? this.curSetName : (String)this.setName.getSelectedItem();
        if (this.isServicePreset(nm)) {
            nm = "User " + nm;
            renamed = true;
        }
        String tnm = nm;
        if (newuserset) {
            int i = 0;
            while (this.paramStore.getPreset(tnm) != null) {
                tnm = nm + " (" + ++i + ")";
                renamed = true;
            }
            if (i > 0) {
                nm = tnm;
            }
        }
        boolean makeupdate = false;
        int iS = this.setName.getItemCount();
        for (int i = 0; i < iS; ++i) {
            String snm = (String)this.setName.getItemAt(i);
            if (!snm.equals(nm)) continue;
            makeupdate = true;
        }
        if (!makeupdate) {
            this.curSetName = nm;
            this.setName.addItem(this.curSetName);
            this.setName.setSelectedItem(this.curSetName);
        }
        if (renamed) {
            this.settingDialog = false;
            this.argSetModified(this.setName, renamed);
        }
        this.settingDialog = stn;
    }

    @Override
    public void refreshParamLayout() {
        int hgap;
        int s;
        FlowLayout fl = new FlowLayout(0);
        int sep = fl.getVgap();
        boolean fh = true;
        boolean os = false;
        int finalh = s = this.jobOptions.getBorder().getBorderInsets((Component)this.jobOptions).bottom + this.jobOptions.getBorder().getBorderInsets((Component)this.jobOptions).top + 2 * sep;
        int panewidth = this.paramPane.getViewport().getSize().width - 120 - this.jobOptions.getBorder().getBorderInsets((Component)this.jobOptions).left + this.jobOptions.getBorder().getBorderInsets((Component)this.jobOptions).right;
        int w = 2 * fl.getHgap() + (this.MAX_OPTWIDTH > 340 ? this.MAX_OPTWIDTH : 340);
        int cw = hgap = fl.getHgap();
        if (this.opanp.getOptSet().size() > 0) {
            this.jobOptions.setLayout((LayoutManager)new MigLayout("", "", ""));
            this.jobOptions.removeAll();
            for (OptsAndParamsPage.OptionBox optionBox : this.opanp.getOptSet().values()) {
                optionBox.validate();
                if ((cw += optionBox.getSize().width + hgap) + 120 > panewidth) {
                    this.jobOptions.add((Component)optionBox, "wrap");
                    cw = hgap + optionBox.getSize().width;
                    fh = true;
                } else {
                    this.jobOptions.add(optionBox);
                }
                if (!fh) continue;
                finalh += optionBox.getSize().height + fl.getVgap();
                fh = false;
            }
            this.jobOptions.revalidate();
        } else {
            this.jobOptions.setVisible(false);
        }
        fl = new FlowLayout(0);
        fl.setAlignOnBaseline(true);
        if (this.opanp.getParamSet().size() > 0) {
            this.paramList.removeAll();
            this.paramList.setLayout((LayoutManager)new MigLayout("", "", ""));
            fh = true;
            for (OptsAndParamsPage.ParamBox paramBox : this.opanp.getParamSet().values()) {
                paramBox.validate();
                if ((cw += paramBox.getSize().width + hgap) + 160 > panewidth) {
                    this.paramList.add((Component)paramBox, "wrap");
                    cw = paramBox.getSize().width + hgap;
                    fh = true;
                } else {
                    this.paramList.add(paramBox);
                }
                if (!fh) continue;
                finalh += paramBox.getSize().height + fl.getVgap();
                fh = false;
            }
            this.paramList.revalidate();
        } else {
            this.paramList.setVisible(false);
        }
        this.paramPane.getViewport().setAutoscrolls(true);
        this.paramPane.revalidate();
        this.revalidate();
    }

    public static void main(String[] args) {
        Jws2Discoverer disc = Jws2Discoverer.getDiscoverer();
        int p = 0;
        if (args.length > 0) {
            Vector<String> services = new Vector<String>();
            services.addElement(args[p++]);
            Jws2Discoverer.getDiscoverer().setServiceUrls(services);
        }
        try {
            disc.run();
        }
        catch (Exception e) {
            System.err.println("Aborting. Problem discovering services.");
            e.printStackTrace();
            return;
        }
        Jws2Instance lastserv = null;
        Iterator<Jws2Instance> iterator = disc.getServices().iterator();
        while (iterator.hasNext()) {
            Iterator en;
            PresetManager prman;
            Jws2Instance service;
            lastserv = service = iterator.next();
            if (p < args.length && !service.serviceType.equalsIgnoreCase(args[p]) || lastserv == null) continue;
            List prl = null;
            Preset pr = null;
            if (++p < args.length) {
                prman = lastserv.getPresets();
                if (prman != null && (pr = prman.getPresetByName(args[p])) == null) {
                    prl = prman.getPresets();
                }
            } else {
                prman = lastserv.getPresets();
                if (prman != null) {
                    prl = prman.getPresets();
                }
            }
            Iterator iterator2 = en = prl == null ? null : prl.iterator();
            while (en != null && en.hasNext()) {
                if (en != null) {
                    if (!en.hasNext()) {
                        en = prl.iterator();
                    }
                    pr = (Preset)en.next();
                }
                System.out.println("Testing opts dupes for " + lastserv.getUri() + " : " + lastserv.getActionText() + ":" + pr.getName());
                List rg = lastserv.getRunnerConfig().getOptions();
                for (Option o : rg) {
                    try {
                        Option option = ParameterUtils.copyOption(o);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to copy " + o.getName());
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        System.err.println("Failed to copy " + o.getName());
                        e.printStackTrace();
                    }
                }
                System.out.println("Testing param dupes:");
                rg = lastserv.getRunnerConfig().getParameters();
                for (Option o : rg) {
                    try {
                        Parameter e = ParameterUtils.copyParameter((Parameter)o);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to copy " + o.getName());
                        e.printStackTrace();
                    }
                    catch (Error e) {
                        System.err.println("Failed to copy " + o.getName());
                        e.printStackTrace();
                    }
                }
                System.out.println("Testing param write:");
                List<String> writeparam = null;
                List<String> readparam = null;
                try {
                    writeparam = ParameterUtils.writeParameterSet(pr.getArguments(lastserv.getRunnerConfig()), " ");
                    System.out.println("Testing param read :");
                    List<Option> pset = ParameterUtils.processParameters(writeparam, lastserv.getRunnerConfig(), " ");
                    readparam = ParameterUtils.writeParameterSet(pset, " ");
                    Iterator o = pr.getOptions().iterator();
                    Iterator<String> s = writeparam.iterator();
                    Iterator<String> t = readparam.iterator();
                    boolean failed = false;
                    while (s.hasNext() && t.hasNext()) {
                        String st;
                        String on = (String)o.next();
                        String sn = s.next();
                        if (sn.equals(st = t.next())) continue;
                        System.out.println("Original was " + on + " Phase 1 wrote " + sn + "\tPhase 2 wrote " + st);
                        failed = true;
                    }
                    if (failed) {
                        System.out.println("Original parameters:\n" + pr.getOptions());
                        System.out.println("Wrote parameters in first set:\n" + writeparam);
                        System.out.println("Wrote parameters in second set:\n" + readparam);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                WsJobParameters pgui = new WsJobParameters(lastserv, new JabaPreset(lastserv, pr));
                JFrame jf = new JFrame(MessageManager.formatMessage("label.ws_parameters_for", new String[]{lastserv.getActionText()}));
                JPanel cont = new JPanel(new BorderLayout());
                pgui.validate();
                cont.setPreferredSize(pgui.getPreferredSize());
                cont.add((Component)pgui, "Center");
                jf.setLayout(new BorderLayout());
                jf.add((Component)cont, "Center");
                jf.validate();
                final Thread thr = Thread.currentThread();
                jf.addWindowListener(new WindowListener(){

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        thr.interrupt();
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }
                });
                jf.setVisible(true);
                boolean inter = false;
                while (!inter) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        inter = true;
                    }
                }
                jf.dispose();
            }
        }
    }

    public boolean isServiceDefaults() {
        return !this.isModified() && this.lastParmSet != null && this.lastParmSet.equals(SVC_DEF);
    }

    public List<ArgumentI> getJobParams() {
        return this.opanp.getCurrentSettings();
    }

    private void syncSetNamesWithStore() {
        int n = 0;
        Vector<String> items = new Vector<String>();
        while (n < this.setName.getItemCount()) {
            String item = (String)this.setName.getItemAt(n);
            if (!item.equals(SVC_DEF) && !this.paramStore.presetExists(item)) {
                this.setName.removeItemAt(n);
                continue;
            }
            items.addElement(item);
            ++n;
        }
        if (!items.contains(SVC_DEF)) {
            this.setName.addItem(SVC_DEF);
        }
        for (WsParamSetI upn : this.paramStore.getPresets()) {
            if (items.contains(upn.getName())) continue;
            this.setName.addItem(upn.getName());
        }
    }

    private void reInitDialog(String nextPreset) {
        this.settingDialog = true;
        WsParamSetI pset = null;
        if (nextPreset != null && nextPreset.length() > 0) {
            pset = this.paramStore.getPreset(nextPreset);
        }
        if (pset != null) {
            if (pset.isModifiable()) {
                this.isUserPreset = true;
                this.setDescr.setText(pset.getDescription());
                this.updateTable(null, pset.getArguments());
                this.lastParmSet = nextPreset;
            } else {
                this.isUserPreset = false;
                this.setDescr.setText("");
                this.updateTable(pset, null);
                this.lastParmSet = nextPreset;
            }
        } else {
            this.isUserPreset = false;
            this.setDescr.setText("");
            this.updateTable(null, null);
            this.lastParmSet = SVC_DEF;
        }
        this.initArgSetModified();
        this.syncSetNamesWithStore();
        this.setName.setSelectedItem(this.lastParmSet);
        this.SetNamePanel.validate();
        this.validate();
        this.settingDialog = false;
    }

    protected void updateWebServiceMenus() {
        for (AlignFrame alignFrame : Desktop.getAlignFrames()) {
            alignFrame.BuildWebServiceMenu();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.setName) {
            if (e.getStateChange() == 1) {
                final String setname = (String)this.setName.getSelectedItem();
                System.out.println("Item state changed for " + setname + " (handling ? " + !this.settingDialog + ")");
                if (this.settingDialog) {
                    return;
                }
                if (setname == null) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WsJobParameters.this.doPreferenceComboStateChange(setname);
                    }
                });
            }
        }
    }

    private void doPreferenceComboStateChange(String setname) {
        if (this.isModified()) {
            String lsetname;
            String string = lsetname = this.curSetName != null ? this.curSetName : this.lastParmSet;
            if (lsetname.equals(setname)) {
                return;
            }
            this.settingDialog = true;
            System.out.println("Prompting to save " + lsetname);
            if (JvOptionPane.showConfirmDialog(this, "Parameter set '" + lsetname + "' is modifed, and your changes will be lost.\nReally change preset ?", "Warning: Unsaved Changes", 2) != 0) {
                this.settingDialog = true;
                this.setName.setSelectedItem(lsetname);
                this.settingDialog = false;
                return;
            }
        }
        this.settingDialog = true;
        this.reInitDialog(setname);
        this.settingDialog = false;
    }

    private void _renameExistingPreset(String oldName, String curSetName2) {
        this.paramStore.updatePreset(oldName, curSetName2, this.setDescr.getText(), this.getJobParams());
    }

    private void _storeCurrentPreset(String curSetName2) {
        this.paramStore.storePreset(curSetName2, this.setDescr.getText(), this.getJobParams());
    }

    private void _updatePreset(String lastParmSet2, String curname) {
        this.paramStore.updatePreset(lastParmSet2, curname, this.setDescr.getText(), this.getJobParams());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component src;
        if (e.getSource() instanceof Component && (src = (Component)e.getSource()).getParent() == this.setName) {
            String newname = e.getActionCommand().trim();
            Object msg = null;
            if (this.isServicePreset(newname)) {
                String oldname = this.curSetName != null ? this.curSetName : this.lastParmSet;
                final WsJobParameters ourframe = this;
                this.settingDialog = true;
                this.setName.getEditor().setItem(oldname);
                this.settingDialog = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JvOptionPane.showMessageDialog(ourframe, MessageManager.getString("label.invalid_name_preset_exists"), MessageManager.getString("label.invalid_name"), 2);
                    }
                });
                return;
            }
            this.curSetName = newname;
            System.err.println("New name for user setting " + this.curSetName + " (was " + this.setName.getSelectedItem() + ")");
            if (this.curSetName.equals(this.setName.getSelectedItem())) {
                this.curSetName = null;
            }
            if (this.curSetName != null) {
                this.argSetModified(this.setName, true);
                return;
            }
        }
    }

    private void checkDescrModified() {
        if (!this.settingDialog) {
            this.argSetModified(this.setDescr, this.lastDescrText == null ? this.setDescr.getText().trim().length() > 0 : !this.setDescr.getText().equals(this.lastDescrText));
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDescrModified();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDescrModified();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDescrModified();
    }

    public WsParamSetI getPreset() {
        if (this.isUserPreset || this.isModified() || this.lastParmSet != null && this.lastParmSet.equals(SVC_DEF)) {
            return null;
        }
        return this.paramStore.getPreset(this.lastParmSet);
    }
}

