/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewControllerGuiI;
import jalview.api.FeatureSettingsControllerI;
import jalview.api.SplitContainerI;
import jalview.controller.FeatureSettingsControllerGuiI;
import jalview.datamodel.AlignmentI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.Finder;
import jalview.jbgui.GAlignFrame;
import jalview.jbgui.GSplitFrame;
import jalview.structure.StructureSelectionManager;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.ShortcutKeyMaskExWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SplitFrame
extends GSplitFrame
implements SplitContainerI {
    private static final int WINDOWS_INSETS_WIDTH = 28;
    private static final int MAC_INSETS_WIDTH = 28;
    private static final int WINDOWS_INSETS_HEIGHT = 50;
    private static final int MAC_INSETS_HEIGHT = 50;
    private static final int DESKTOP_DECORATORS_HEIGHT = 65;
    private static final long serialVersionUID = 1L;
    private static final int FS_MIN_WIDTH = 400;
    private static final int FS_MIN_HEIGHT = 400;
    JInternalFrame featureSettingsUI;
    JTabbedPane featureSettingsPanels;
    private String[] tabName = new String[]{MessageManager.getString("label.CDS"), MessageManager.getString("label.protein")};

    public SplitFrame(GAlignFrame top, GAlignFrame bottom) {
        super(top, bottom);
        this.init();
    }

    protected void init() {
        this.getTopFrame().setSplitFrame(this);
        this.getBottomFrame().setSplitFrame(this);
        this.getTopFrame().setVisible(true);
        this.getBottomFrame().setVisible(true);
        ((AlignFrame)this.getTopFrame()).getViewport().setCodingComplement(((AlignFrame)this.getBottomFrame()).getViewport());
        int widthFudge = Platform.isAMacAndNotJS() ? 28 : 28;
        int heightFudge = Platform.isAMacAndNotJS() ? 50 : 50;
        int width = ((AlignFrame)this.getTopFrame()).getWidth() + widthFudge;
        int height = ((AlignFrame)this.getTopFrame()).getHeight() + ((AlignFrame)this.getBottomFrame()).getHeight() + 5 + heightFudge;
        height = this.fitHeightToDesktop(height);
        this.setSize(width, height);
        this.adjustLayout();
        this.addCloseFrameListener();
        this.addKeyListener();
        this.addKeyBindings();
        this.addCommandListeners();
    }

    public int fitHeightToDesktop(int height) {
        int newHeight = Math.min(height, Desktop.instance.getHeight() - 65);
        if (newHeight != height) {
            int oldDividerLocation = this.getDividerLocation();
            this.setDividerLocation(oldDividerLocation * newHeight / height);
        }
        return newHeight;
    }

    protected void addCommandListeners() {
        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(Desktop.instance);
        ssm.addCommandListener(((AlignFrame)this.getTopFrame()).getViewport());
        ssm.addCommandListener(((AlignFrame)this.getBottomFrame()).getViewport());
    }

    public void adjustLayout() {
        AlignViewport protein;
        AlignViewport cdna;
        AlignViewport topViewport = ((AlignFrame)this.getTopFrame()).viewport;
        AlignViewport bottomViewport = ((AlignFrame)this.getBottomFrame()).viewport;
        int w1 = topViewport.getIdWidth();
        int w2 = bottomViewport.getIdWidth();
        int w3 = Math.max(w1, w2);
        topViewport.setIdWidth(w3);
        bottomViewport.setIdWidth(w3);
        AlignmentI topAlignment = topViewport.getAlignment();
        AlignmentI bottomAlignment = bottomViewport.getAlignment();
        AlignViewport alignViewport = topAlignment.isNucleotide() ? topViewport : (cdna = bottomAlignment.isNucleotide() ? bottomViewport : null);
        AlignViewport alignViewport2 = !topAlignment.isNucleotide() ? topViewport : (protein = !bottomAlignment.isNucleotide() ? bottomViewport : null);
        if (protein != null && cdna != null) {
            int scale = protein.isScaleProteinAsCdna() ? 3 : 1;
            protein.setCharWidth(scale * cdna.getViewStyle().getCharWidth());
        }
    }

    protected void adjustInitialLayout() {
        AlignFrame topFrame = (AlignFrame)this.getTopFrame();
        AlignFrame bottomFrame = (AlignFrame)this.getBottomFrame();
        topFrame.alignPanel.adjustAnnotationHeight();
        bottomFrame.alignPanel.adjustAnnotationHeight();
        AlignViewport topViewport = topFrame.viewport;
        AlignViewport bottomViewport = bottomFrame.viewport;
        AlignmentI topAlignment = topViewport.getAlignment();
        AlignmentI bottomAlignment = bottomViewport.getAlignment();
        boolean topAnnotations = topViewport.isShowAnnotation();
        boolean bottomAnnotations = bottomViewport.isShowAnnotation();
        int topCount = topAlignment.getHeight();
        int bottomCount = bottomAlignment.getHeight();
        int topCharHeight = topViewport.getViewStyle().getCharHeight();
        int bottomCharHeight = bottomViewport.getViewStyle().getCharHeight();
        int topPanelHeight = topFrame.getHeight();
        int bottomPanelHeight = bottomFrame.getHeight();
        int topSequencesHeight = topFrame.alignPanel.getSeqPanel().seqCanvas.getHeight();
        int topPanelMinHeight = topPanelHeight - Math.max(0, topSequencesHeight - 3 * topCharHeight);
        double totalHeight = (double)topPanelHeight + (double)bottomPanelHeight;
        double minRatio = (double)topPanelMinHeight / totalHeight;
        int bottomSequencesHeight = bottomFrame.alignPanel.getSeqPanel().seqCanvas.getHeight();
        int bottomPanelMinHeight = bottomPanelHeight - Math.max(0, bottomSequencesHeight - 3 * bottomCharHeight);
        double maxRatio = (totalHeight - (double)bottomPanelMinHeight) / totalHeight;
        int insets = Platform.isAMacAndNotJS() ? 50 : 50;
        int topHeight = insets + (3 + topCount) * topCharHeight + (topAnnotations ? topViewport.calcPanelHeight() : 0);
        int bottomHeight = insets + (3 + bottomCount) * bottomCharHeight + (bottomAnnotations ? bottomViewport.calcPanelHeight() : 0);
        double ratio = (double)topHeight / (double)(topHeight + bottomHeight);
        ratio = Math.min(ratio, maxRatio);
        ratio = Math.max(ratio, minRatio);
        this.setRelativeDividerLocation(ratio);
    }

    protected void addCloseFrameListener() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                SplitFrame.this.close();
            }
        });
    }

    protected void addKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AlignFrame af = (AlignFrame)SplitFrame.this.getFrameAtMouse();
                if (!SplitFrame.this.overrideKey(e, af) && af != null) {
                    for (KeyListener kl : af.getKeyListeners()) {
                        kl.keyPressed(e);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                GAlignFrame c = SplitFrame.this.getFrameAtMouse();
                if (c != null) {
                    for (KeyListener kl : c.getKeyListeners()) {
                        kl.keyReleased(e);
                    }
                }
            }
        });
    }

    protected boolean overrideKey(KeyEvent e, AlignFrame af) {
        boolean actioned = false;
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 40: {
                if (!e.isAltDown() && af.viewport.cursorMode) break;
                ((AlignFrame)this.getTopFrame()).moveSelectedSequences(false);
                ((AlignFrame)this.getBottomFrame()).moveSelectedSequences(false);
                actioned = true;
                e.consume();
                break;
            }
            case 38: {
                if (!e.isAltDown() && af.viewport.cursorMode) break;
                ((AlignFrame)this.getTopFrame()).moveSelectedSequences(true);
                ((AlignFrame)this.getBottomFrame()).moveSelectedSequences(true);
                actioned = true;
                e.consume();
                break;
            }
        }
        return actioned;
    }

    private void addKeyBindings() {
        this.overrideDelegatedKeyBindings();
        this.overrideImplementedKeyBindings();
    }

    protected void overrideImplementedKeyBindings() {
        this.overrideFind();
        this.overrideNewView();
        this.overrideCloseView();
        this.overrideExpandViews();
        this.overrideGatherViews();
    }

    protected void overrideCloseView() {
        KeyStroke key_cmdW = KeyStroke.getKeyStroke(87, ShortcutKeyMaskExWrapper.getMenuShortcutKeyMaskEx(), false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitFrame.this.closeView_actionPerformed();
            }
        };
        this.overrideKeyBinding(key_cmdW, action);
    }

    protected void overrideNewView() {
        KeyStroke key_cmdT = KeyStroke.getKeyStroke(84, ShortcutKeyMaskExWrapper.getMenuShortcutKeyMaskEx(), false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitFrame.this.newView_actionPerformed();
            }
        };
        this.overrideKeyBinding(key_cmdT, action);
    }

    protected void overrideDelegatedKeyBindings() {
        if (this.getTopFrame() instanceof AlignFrame) {
            for (Map.Entry<KeyStroke, JMenuItem> acc : ((AlignFrame)this.getTopFrame()).getAccelerators().entrySet()) {
                this.overrideKeyBinding(acc);
            }
        }
    }

    private void overrideKeyBinding(Map.Entry<KeyStroke, JMenuItem> acc) {
        final KeyStroke ks = acc.getKey();
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(ks, ks);
        this.getActionMap().put(ks, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame c = SplitFrame.this.getFrameAtMouse();
                if (c != null && c instanceof AlignFrame) {
                    for (ActionListener a : ((AlignFrame)c).getAccelerators().get(ks).getActionListeners()) {
                        a.actionPerformed(null);
                    }
                }
            }
        });
    }

    protected void overrideKeyBinding(KeyStroke ks, AbstractAction action) {
        this.getActionMap().put(ks, action);
        this.overrideMenuItem(ks, action);
    }

    protected void newView_actionPerformed() {
        AlignFrame topFrame = (AlignFrame)this.getTopFrame();
        AlignFrame bottomFrame = (AlignFrame)this.getBottomFrame();
        boolean scaleProteinAsCdna = topFrame.viewport.isScaleProteinAsCdna();
        AlignmentPanel newTopPanel = topFrame.newView(null, true);
        AlignmentPanel newBottomPanel = bottomFrame.newView(null, true);
        if (topFrame.getTabIndex() != bottomFrame.getTabIndex()) {
            topFrame.setDisplayedView(newTopPanel);
        }
        newBottomPanel.av.setViewName(newTopPanel.av.getViewName());
        newTopPanel.av.setCodingComplement(newBottomPanel.av);
        newTopPanel.av.setScaleProteinAsCdna(scaleProteinAsCdna);
        newBottomPanel.av.setScaleProteinAsCdna(scaleProteinAsCdna);
        this.adjustLayout();
        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(Desktop.instance);
        ssm.addCommandListener(newTopPanel.av);
        ssm.addCommandListener(newBottomPanel.av);
    }

    protected void closeView_actionPerformed() {
        int viewCount = ((AlignFrame)this.getTopFrame()).getAlignPanels().size();
        if (viewCount < 2) {
            this.close();
            return;
        }
        AlignmentPanel topPanel = ((AlignFrame)this.getTopFrame()).alignPanel;
        AlignmentPanel bottomPanel = ((AlignFrame)this.getBottomFrame()).alignPanel;
        ((AlignFrame)this.getTopFrame()).closeView(topPanel);
        ((AlignFrame)this.getBottomFrame()).closeView(bottomPanel);
    }

    public void close() {
        ((AlignFrame)this.getTopFrame()).closeMenuItem_actionPerformed(true);
        ((AlignFrame)this.getBottomFrame()).closeMenuItem_actionPerformed(true);
        try {
            this.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void overrideExpandViews() {
        KeyStroke key_X = KeyStroke.getKeyStroke(88, 0, false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitFrame.this.expandViews_actionPerformed();
            }
        };
        this.overrideMenuItem(key_X, action);
    }

    protected void overrideGatherViews() {
        KeyStroke key_G = KeyStroke.getKeyStroke(71, 0, false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitFrame.this.gatherViews_actionPerformed();
            }
        };
        this.overrideMenuItem(key_G, action);
    }

    private void overrideMenuItem(KeyStroke ks, AbstractAction action) {
        this.overrideMenuItem(ks, action, this.getTopFrame());
        this.overrideMenuItem(ks, action, this.getBottomFrame());
    }

    private void overrideMenuItem(KeyStroke key, final AbstractAction action, JComponent comp) {
        JMenuItem mi;
        if (comp instanceof AlignFrame && (mi = ((AlignFrame)comp).getAccelerators().get(key)) != null) {
            for (ActionListener al : mi.getActionListeners()) {
                mi.removeActionListener(al);
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.actionPerformed(e);
                }
            });
        }
    }

    protected void expandViews_actionPerformed() {
        Desktop.instance.explodeViews(this);
    }

    protected void gatherViews_actionPerformed() {
        Desktop.instance.gatherViews(this);
    }

    @Override
    public AlignmentI getComplement(Object alignFrame) {
        if (alignFrame == this.getTopFrame()) {
            return ((AlignFrame)this.getBottomFrame()).viewport.getAlignment();
        }
        if (alignFrame == this.getBottomFrame()) {
            return ((AlignFrame)this.getTopFrame()).viewport.getAlignment();
        }
        return null;
    }

    @Override
    public String getComplementTitle(Object alignFrame) {
        if (alignFrame == this.getTopFrame()) {
            return ((AlignFrame)this.getBottomFrame()).getTitle();
        }
        if (alignFrame == this.getBottomFrame()) {
            return ((AlignFrame)this.getTopFrame()).getTitle();
        }
        return null;
    }

    @Override
    public void setComplementVisible(Object alignFrame, boolean show) {
        if (alignFrame == this.getTopFrame()) {
            ((AlignFrame)this.getBottomFrame()).alignPanel.setVisible(show);
        } else if (alignFrame == this.getBottomFrame()) {
            ((AlignFrame)this.getTopFrame()).alignPanel.setVisible(show);
        }
        super.setComplementVisible(alignFrame, show);
    }

    public List<AlignFrame> getAlignFrames() {
        return Arrays.asList((AlignFrame)this.getTopFrame(), (AlignFrame)this.getBottomFrame());
    }

    @Override
    public AlignFrame getComplementAlignFrame(AlignViewControllerGuiI alignFrame) {
        if (this.getTopFrame() == alignFrame) {
            return (AlignFrame)this.getBottomFrame();
        }
        if (this.getBottomFrame() == alignFrame) {
            return (AlignFrame)this.getTopFrame();
        }
        return null;
    }

    protected void overrideFind() {
        KeyStroke key_cmdF = KeyStroke.getKeyStroke(70, ShortcutKeyMaskExWrapper.getMenuShortcutKeyMaskEx(), false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignFrame c = SplitFrame.this.getFrameAtMouse();
                if (c != null && c instanceof AlignFrame) {
                    AlignFrame af = (AlignFrame)c;
                    new Finder(af.alignPanel);
                }
            }
        };
        this.overrideKeyBinding(key_cmdF, action);
    }

    @Override
    public void setSelected(boolean selected) throws PropertyVetoException {
        JInternalFrame fr;
        JDesktopPane desktopPane = this.getDesktopPane();
        JInternalFrame jInternalFrame = fr = desktopPane == null ? null : desktopPane.getSelectedFrame();
        if (fr == this.getTopFrame() || fr == this.getBottomFrame()) {
            if (selected) {
                this.moveToFront();
            }
            return;
        }
        super.setSelected(selected);
    }

    @Override
    public void addFeatureSettingsUI(FeatureSettingsControllerGuiI featureSettings) {
        boolean showInternalFrame = false;
        if (this.featureSettingsUI == null || this.featureSettingsPanels == null) {
            showInternalFrame = true;
            this.featureSettingsPanels = new JTabbedPane();
            this.featureSettingsPanels.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() != SplitFrame.this.featureSettingsPanels || SplitFrame.this.featureSettingsUI == null || SplitFrame.this.featureSettingsUI.isClosed() || !SplitFrame.this.featureSettingsUI.isVisible()) {
                        return;
                    }
                    int tab = SplitFrame.this.featureSettingsPanels.getSelectedIndex();
                    if (tab < 0 || SplitFrame.this.featureSettingsPanels.getSelectedComponent() instanceof FeatureSettingsControllerGuiI) {
                        return;
                    }
                    SplitFrame.this.getAlignFrames().get(tab).showFeatureSettingsUI();
                }
            });
            this.featureSettingsUI = new JInternalFrame(MessageManager.getString("label.sequence_feature_settings_for_CDS_and_Protein"));
            this.featureSettingsPanels.setOpaque(true);
            JPanel dialog = new JPanel();
            dialog.setOpaque(true);
            dialog.setLayout(new BorderLayout());
            dialog.add((Component)this.featureSettingsPanels, "Center");
            JPanel buttons = new JPanel();
            JButton ok = new JButton(MessageManager.getString("action.ok"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        SplitFrame.this.featureSettingsUI.setClosed(true);
                    }
                    catch (PropertyVetoException pv) {
                        pv.printStackTrace();
                    }
                }
            });
            JButton cancel = new JButton(MessageManager.getString("action.cancel"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        for (Component fspanel : SplitFrame.this.featureSettingsPanels.getComponents()) {
                            if (!(fspanel instanceof FeatureSettingsControllerGuiI)) continue;
                            ((FeatureSettingsControllerGuiI)((Object)fspanel)).revert();
                        }
                        SplitFrame.this.featureSettingsUI.setClosed(true);
                    }
                    catch (Exception pv) {
                        pv.printStackTrace();
                    }
                }
            });
            buttons.add(ok);
            buttons.add(cancel);
            dialog.add((Component)buttons, "South");
            this.featureSettingsUI.setContentPane(dialog);
            this.createDummyTabs();
        }
        if (this.featureSettingsPanels.indexOfTabComponent((Component)((Object)featureSettings)) > -1) {
            this.featureSettingsPanels.setSelectedComponent((Component)((Object)featureSettings));
            return;
        }
        int pos = this.getAlignFrames().indexOf(featureSettings.getAlignframe());
        if (pos == 0) {
            this.featureSettingsPanels.removeTabAt(0);
            this.featureSettingsPanels.insertTab(this.tabName[0], null, (Component)((Object)featureSettings), MessageManager.formatMessage("label.sequence_feature_settings_for", this.tabName[0]), 0);
        }
        if (pos == 1) {
            this.featureSettingsPanels.removeTabAt(1);
            this.featureSettingsPanels.insertTab(this.tabName[1], null, (Component)((Object)featureSettings), MessageManager.formatMessage("label.sequence_feature_settings_for", this.tabName[1]), 1);
        }
        this.featureSettingsPanels.setSelectedComponent((Component)((Object)featureSettings));
        if (showInternalFrame) {
            if (Platform.isAMacAndNotJS()) {
                Desktop.addInternalFrame(this.featureSettingsUI, MessageManager.getString("label.sequence_feature_settings_for_CDS_and_Protein"), 600, 480);
            } else {
                Desktop.addInternalFrame(this.featureSettingsUI, MessageManager.getString("label.sequence_feature_settings_for_CDS_and_Protein"), 600, 450);
            }
            this.featureSettingsUI.setMinimumSize(new Dimension(400, 400));
            this.featureSettingsUI.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent evt) {
                    int tab = 0;
                    while (tab < SplitFrame.this.featureSettingsPanels.getTabCount()) {
                        FeatureSettingsControllerGuiI fsettings = (FeatureSettingsControllerGuiI)((Object)SplitFrame.this.featureSettingsPanels.getTabComponentAt(tab));
                        if (fsettings != null) {
                            SplitFrame.this.featureSettingsPanels.removeTabAt(tab);
                            fsettings.featureSettings_isClosed();
                            continue;
                        }
                        ++tab;
                    }
                    SplitFrame.this.featureSettingsPanels = null;
                    SplitFrame.this.featureSettingsUI = null;
                }
            });
            this.featureSettingsUI.setLayer(JLayeredPane.PALETTE_LAYER);
        }
    }

    private void createDummyTabs() {
        for (int tabIndex = 0; tabIndex < 2; ++tabIndex) {
            JPanel dummyTab = new JPanel();
            this.featureSettingsPanels.addTab(this.tabName[tabIndex], dummyTab);
        }
    }

    private void replaceWithDummyTab(FeatureSettingsControllerI toClose) {
        Component dummyTab = null;
        for (int tabIndex = 0; tabIndex < 2; ++tabIndex) {
            if (this.featureSettingsPanels.getTabCount() <= tabIndex || !((dummyTab = this.featureSettingsPanels.getTabComponentAt(tabIndex)) instanceof FeatureSettingsControllerGuiI) || dummyTab.isVisible()) continue;
            this.featureSettingsPanels.removeTabAt(tabIndex);
            ((FeatureSettingsControllerGuiI)((Object)dummyTab)).featureSettings_isClosed();
            dummyTab = new JPanel();
            this.featureSettingsPanels.insertTab(this.tabName[tabIndex], null, dummyTab, MessageManager.formatMessage("label.sequence_feature_settings_for", this.tabName[tabIndex]), tabIndex);
        }
    }

    @Override
    public void closeFeatureSettings(FeatureSettingsControllerI featureSettings, boolean closeContainingFrame) {
        if (this.featureSettingsUI != null) {
            if (closeContainingFrame) {
                try {
                    this.featureSettingsUI.setClosed(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.featureSettingsUI = null;
            } else {
                this.replaceWithDummyTab(featureSettings);
            }
        }
    }

    @Override
    public boolean isFeatureSettingsOpen() {
        return this.featureSettingsUI != null && !this.featureSettingsUI.isClosed();
    }
}

