/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.Conservation;
import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.jbgui.GSliderPanel;
import jalview.renderer.ResidueShaderI;
import jalview.util.MessageManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SliderPanel
extends GSliderPanel {
    private static final String BACKGROUND = "Background";
    static JInternalFrame conservationSlider;
    static JInternalFrame PIDSlider;
    AlignmentPanel ap;
    boolean forConservation = true;
    ResidueShaderI cs;

    public static SliderPanel getSliderPanel() {
        if (conservationSlider != null && conservationSlider.isVisible()) {
            return (SliderPanel)conservationSlider.getContentPane();
        }
        if (PIDSlider != null && PIDSlider.isVisible()) {
            return (SliderPanel)PIDSlider.getContentPane();
        }
        return null;
    }

    public SliderPanel(final AlignmentPanel ap, int value, boolean forConserve, ResidueShaderI scheme) {
        this.ap = ap;
        this.cs = scheme;
        this.forConservation = forConserve;
        this.undoButton.setVisible(false);
        this.applyButton.setVisible(false);
        if (this.forConservation) {
            this.label.setText(MessageManager.getString("label.enter_value_increase_conservation_visibility"));
            this.slider.setMinimum(0);
            this.slider.setMaximum(100);
        } else {
            this.label.setText(MessageManager.getString("label.enter_percentage_identity_above_which_colour_residues"));
            this.slider.setMinimum(0);
            this.slider.setMaximum(100);
        }
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SliderPanel.this.valueField.setText(String.valueOf(SliderPanel.this.slider.getValue()));
                SliderPanel.this.valueChanged(SliderPanel.this.slider.getValue());
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ap.paintAlignment(true, true);
            }
        });
        this.slider.setValue(value);
        this.valueField.setText(String.valueOf(value));
    }

    public static int setConservationSlider(AlignmentPanel ap, ResidueShaderI rs, String source) {
        SliderPanel sliderPanel = null;
        if (conservationSlider == null) {
            sliderPanel = new SliderPanel(ap, rs.getConservationInc(), true, rs);
            conservationSlider = new JInternalFrame();
            conservationSlider.setContentPane(sliderPanel);
            conservationSlider.setLayer(JLayeredPane.PALETTE_LAYER);
        } else {
            sliderPanel = (SliderPanel)conservationSlider.getContentPane();
            sliderPanel.valueField.setText(String.valueOf(rs.getConservationInc()));
            sliderPanel.cs = rs;
            sliderPanel.ap = ap;
            sliderPanel.slider.setValue(rs.getConservationInc());
        }
        conservationSlider.setTitle(MessageManager.formatMessage("label.conservation_colour_increment", new String[]{source == null ? BACKGROUND : source}));
        List<SequenceGroup> groups = ap.av.getAlignment().getGroups();
        if (groups != null && !groups.isEmpty()) {
            sliderPanel.setAllGroupsCheckEnabled(true);
        } else {
            sliderPanel.setAllGroupsCheckEnabled(false);
        }
        return sliderPanel.getValue();
    }

    public static void hidePIDSlider() {
        if (PIDSlider != null) {
            try {
                PIDSlider.setClosed(true);
                PIDSlider = null;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public static void hideConservationSlider() {
        if (conservationSlider != null) {
            try {
                conservationSlider.setClosed(true);
                conservationSlider = null;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public static void showConservationSlider() {
        SliderPanel.hidePIDSlider();
        if (!conservationSlider.isVisible()) {
            Desktop.addInternalFrame(conservationSlider, conservationSlider.getTitle(), true, 420, 120, false, true);
            conservationSlider.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    conservationSlider = null;
                }
            });
            conservationSlider.setLayer(JLayeredPane.PALETTE_LAYER);
        }
    }

    public static int setPIDSliderSource(AlignmentPanel ap, ResidueShaderI rs, String source) {
        int threshold = rs.getThreshold();
        SliderPanel sliderPanel = null;
        if (PIDSlider == null) {
            sliderPanel = new SliderPanel(ap, threshold, false, rs);
            PIDSlider = new JInternalFrame();
            PIDSlider.setContentPane(sliderPanel);
            PIDSlider.setLayer(JLayeredPane.PALETTE_LAYER);
        } else {
            sliderPanel = (SliderPanel)PIDSlider.getContentPane();
            sliderPanel.cs = rs;
            sliderPanel.ap = ap;
            sliderPanel.valueField.setText(String.valueOf(rs.getThreshold()));
            sliderPanel.slider.setValue(rs.getThreshold());
        }
        PIDSlider.setTitle(MessageManager.formatMessage("label.percentage_identity_threshold", new String[]{source == null ? BACKGROUND : source}));
        if (ap.av.getAlignment().getGroups() != null) {
            sliderPanel.setAllGroupsCheckEnabled(true);
        } else {
            sliderPanel.setAllGroupsCheckEnabled(false);
        }
        return sliderPanel.getValue();
    }

    public static JInternalFrame showPIDSlider() {
        SliderPanel.hideConservationSlider();
        if (!PIDSlider.isVisible()) {
            Desktop.addInternalFrame(PIDSlider, PIDSlider.getTitle(), true, 420, 120, false, true);
            PIDSlider.setLayer(JLayeredPane.PALETTE_LAYER);
            PIDSlider.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    PIDSlider = null;
                }
            });
            PIDSlider.setLayer(JLayeredPane.PALETTE_LAYER);
        }
        return PIDSlider;
    }

    public void valueChanged(int percent) {
        if (!this.forConservation) {
            this.ap.av.setThreshold(percent);
        }
        this.updateColourScheme(percent, this.cs, null);
        if (this.allGroupsCheck.isSelected()) {
            List<SequenceGroup> groups = this.ap.av.getAlignment().getGroups();
            for (SequenceGroup sg : groups) {
                this.updateColourScheme(percent, sg.getGroupColourScheme(), sg);
            }
        }
        this.ap.getSeqPanel().seqCanvas.repaint();
    }

    protected void updateColourScheme(int percent, ResidueShaderI scheme, SequenceGroup sg) {
        if (scheme == null) {
            return;
        }
        if (this.forConservation) {
            if (!scheme.conservationApplied() && sg != null) {
                Conservation c = new Conservation("Group", sg.getSequences(null), sg.getStartRes(), sg.getEndRes());
                c.calculate();
                c.verdict(false, this.ap.av.getConsPercGaps());
                sg.cs.setConservation(c);
            }
            scheme.setConservationApplied(true);
            scheme.setConservationInc(percent);
        } else {
            scheme.setThreshold(percent, this.ap.av.isIgnoreGapsConsensus());
        }
    }

    public void setAllGroupsCheckEnabled(boolean b) {
        this.allGroupsCheck.setEnabled(b);
    }

    @Override
    public void valueField_actionPerformed() {
        try {
            int i = Integer.parseInt(this.valueField.getText());
            this.slider.setValue(i);
        }
        catch (NumberFormatException ex) {
            this.valueField.setText(this.slider.getValue() + "");
        }
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public int getValue() {
        return Integer.parseInt(this.valueField.getText());
    }

    @Override
    public void slider_mouseReleased(MouseEvent e) {
        if (this.ap.overviewPanel != null) {
            this.ap.overviewPanel.updateOverviewImage();
        }
    }

    public static int getConservationValue() {
        return SliderPanel.getValue(conservationSlider);
    }

    static int getValue(JInternalFrame slider) {
        return slider == null ? 0 : ((SliderPanel)slider.getContentPane()).getValue();
    }

    public static int getPIDValue() {
        return SliderPanel.getValue(PIDSlider);
    }

    public boolean isForConservation() {
        return this.forConservation;
    }

    public String getTitle() {
        String title = null;
        if (this.isForConservation()) {
            if (conservationSlider != null) {
                title = conservationSlider.getTitle();
            }
        } else if (PIDSlider != null) {
            title = PIDSlider.getTitle();
        }
        return title;
    }
}

