/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.FeatureSettingsModelI;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.SequenceI;
import jalview.fts.core.GFTSPanel;
import jalview.fts.service.pdb.PDBFTSPanel;
import jalview.fts.service.uniprot.UniprotFTSPanel;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OOMWarning;
import jalview.io.FileFormatI;
import jalview.util.DBRefUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SequenceFetcher
extends JPanel
implements Runnable {
    private static jalview.ws.SequenceFetcher sfetch = null;
    JLabel exampleAccession;
    JComboBox<String> database;
    JCheckBox replacePunctuation;
    JButton okBtn;
    JButton exampleBtn;
    JButton closeBtn;
    JButton backBtn;
    JTextArea textArea;
    JInternalFrame frame;
    IProgressIndicator guiWindow;
    AlignFrame alignFrame;
    GFTSPanel parentSearchPanel;
    IProgressIndicator progressIndicator;
    volatile boolean _isConstructing = false;

    public static jalview.ws.SequenceFetcher getSequenceFetcherSingleton() {
        if (sfetch == null) {
            sfetch = new jalview.ws.SequenceFetcher();
        }
        return sfetch;
    }

    public SequenceFetcher(IProgressIndicator guiIndic) {
        this(guiIndic, null, null);
    }

    public SequenceFetcher(IProgressIndicator guiIndic, String selectedDb, String queryString) {
        this(guiIndic, selectedDb, queryString, true);
    }

    public SequenceFetcher(IProgressIndicator guiIndic, String selectedDb, String queryString, boolean interactive) {
        this.progressIndicator = guiIndic;
        SequenceFetcher.getSequenceFetcherSingleton();
        this.guiWindow = this.progressIndicator;
        if (this.progressIndicator instanceof AlignFrame) {
            this.alignFrame = (AlignFrame)this.progressIndicator;
        }
        this.jbInit(selectedDb, interactive);
        this.textArea.setText(queryString);
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        Desktop.addInternalFrame(this.frame, this.getFrameTitle(), true, 400, Platform.isAMacAndNotJS() ? 240 : 180);
    }

    private String getFrameTitle() {
        return this.alignFrame == null ? MessageManager.getString("label.new_sequence_fetcher") : MessageManager.getString("label.additional_sequence_fetcher");
    }

    private void jbInit(String selectedDb, boolean interactive) {
        this.setLayout(new BorderLayout());
        this.database = new JComboBox();
        this.database.setFont(JvSwingUtils.getLabelFont());
        this.database.setPrototypeDisplayValue("ENSEMBLGENOMES   ");
        String[] sources = new jalview.ws.SequenceFetcher().getSupportedDb();
        Arrays.sort(sources, String.CASE_INSENSITIVE_ORDER);
        this.database.addItem(MessageManager.getString("action.select_ddbb"));
        for (String source : sources) {
            this.database.addItem(source);
        }
        this.database.setSelectedItem(selectedDb);
        if (this.database.getSelectedIndex() == -1) {
            this.database.setSelectedIndex(0);
        }
        this.database.setMaximumRowCount(this.database.getItemCount());
        this.database.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentSelection = (String)SequenceFetcher.this.database.getSelectedItem();
                SequenceFetcher.this.updateExampleQuery(currentSelection);
                if ("pdb".equalsIgnoreCase(currentSelection)) {
                    SequenceFetcher.this.frame.dispose();
                    new PDBFTSPanel(SequenceFetcher.this);
                } else if ("uniprot".equalsIgnoreCase(currentSelection)) {
                    SequenceFetcher.this.frame.dispose();
                    new UniprotFTSPanel(SequenceFetcher.this);
                } else {
                    SequenceFetcher.this.otherSourceAction();
                }
            }
        });
        this.exampleAccession = new JLabel("");
        this.exampleAccession.setFont(new Font("Verdana", 1, 11));
        JLabel jLabel1 = new JLabel(MessageManager.getString("label.separate_multiple_accession_ids"));
        jLabel1.setFont(new Font("Verdana", 2, 11));
        jLabel1.setHorizontalAlignment(2);
        this.replacePunctuation = new JCheckBox(MessageManager.getString("label.replace_commas_semicolons"));
        this.replacePunctuation.setHorizontalAlignment(2);
        this.replacePunctuation.setFont(new Font("Verdana", 2, 11));
        this.okBtn = new JButton(MessageManager.getString("action.ok"));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.ok_actionPerformed();
            }
        });
        JButton clear = new JButton(MessageManager.getString("action.clear"));
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.clear_actionPerformed();
            }
        });
        this.exampleBtn = new JButton(MessageManager.getString("label.example"));
        this.exampleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.example_actionPerformed();
            }
        });
        this.closeBtn = new JButton(MessageManager.getString("action.cancel"));
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.close_actionPerformed(e);
            }
        });
        this.backBtn = new JButton(MessageManager.getString("action.back"));
        this.backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.parentSearchPanel.btn_back_ActionPerformed();
            }
        });
        this.backBtn.setVisible(false);
        this.textArea = new JTextArea();
        this.textArea.setFont(JvSwingUtils.getLabelFont());
        this.textArea.setLineWrap(true);
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SequenceFetcher.this.ok_actionPerformed();
                }
            }
        });
        JPanel actionPanel = new JPanel();
        actionPanel.add(this.backBtn);
        actionPanel.add(this.exampleBtn);
        actionPanel.add(clear);
        actionPanel.add(this.okBtn);
        actionPanel.add(this.closeBtn);
        JPanel databasePanel = new JPanel();
        databasePanel.setLayout(new BorderLayout());
        databasePanel.add(this.database, "North");
        databasePanel.add((Component)this.exampleAccession, "Center");
        JPanel jPanel2a = new JPanel(new BorderLayout());
        jPanel2a.add((Component)jLabel1, "North");
        jPanel2a.add((Component)this.replacePunctuation, "South");
        databasePanel.add((Component)jPanel2a, "South");
        JPanel idsPanel = new JPanel();
        idsPanel.setLayout(new BorderLayout(0, 5));
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add(this.textArea);
        idsPanel.add((Component)jScrollPane1, "Center");
        this.database.setEnabled(interactive);
        this.exampleAccession.setVisible(interactive);
        this.replacePunctuation.setVisible(interactive);
        this.okBtn.setVisible(interactive);
        this.exampleBtn.setVisible(interactive);
        this.closeBtn.setVisible(interactive);
        this.backBtn.setVisible(interactive);
        jLabel1.setVisible(interactive);
        clear.setVisible(interactive);
        this.textArea.setEnabled(interactive);
        this.add((Component)actionPanel, "South");
        this.add((Component)idsPanel, "Center");
        this.add((Component)databasePanel, "North");
    }

    protected String getExampleQueries(String db) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> hs = new HashSet<String>();
        for (DbSourceProxy dbs : sfetch.getSourceProxy(db)) {
            String tq = dbs.getTestQuery();
            if (!hs.add(tq)) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(tq);
        }
        return sb.toString();
    }

    protected void otherSourceAction() {
        try {
            String eq = this.exampleAccession.getText();
            boolean enablePunct = eq == null || eq.indexOf(",") <= -1;
            this.replacePunctuation.setEnabled(enablePunct);
        }
        catch (Exception ex) {
            this.exampleAccession.setText("");
            this.replacePunctuation.setEnabled(true);
        }
        this.repaint();
    }

    protected String updateExampleQuery(String selectedDatabase) {
        String eq = this.getExampleQueries(selectedDatabase);
        this.exampleAccession.setText(MessageManager.formatMessage("label.example_query_param", new String[]{eq}));
        return eq;
    }

    protected void example_actionPerformed() {
        String eq = this.getExampleQueries((String)this.database.getSelectedItem());
        this.textArea.setText(eq);
        this.repaint();
    }

    protected void clear_actionPerformed() {
        this.textArea.setText("");
        this.repaint();
    }

    public void close_actionPerformed(ActionEvent e) {
        try {
            this.frame.setClosed(true);
            if (this.parentSearchPanel != null) {
                this.parentSearchPanel.btn_cancel_ActionPerformed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ok_actionPerformed() {
        this.ok_actionPerformed(false, null);
    }

    public CompletableFuture<Void> ok_actionPerformed(boolean returnFuture, String id) {
        String t0 = this.textArea.getText();
        String text = t0.trim();
        if (this.replacePunctuation.isEnabled() && this.replacePunctuation.isSelected()) {
            text = text.replace(",", ";");
        }
        if (!t0.equals(text = text.replaceAll("(\\s|[; ])+", ";"))) {
            this.textArea.setText(text);
        }
        if (text.isEmpty()) {
            this.showErrorMessage("Please enter a (semi-colon separated list of) database id(s)");
            this.resetDialog();
            return null;
        }
        if (this.database.getSelectedIndex() == 0) {
            this.showErrorMessage("Please choose a database");
            this.resetDialog();
            return null;
        }
        this.exampleBtn.setEnabled(false);
        this.textArea.setEnabled(false);
        this.okBtn.setEnabled(false);
        this.closeBtn.setEnabled(false);
        this.backBtn.setEnabled(false);
        CompletableFuture<Void> worker = CompletableFuture.runAsync(() -> this.runAndCacheAlignFrame(returnFuture, id));
        return returnFuture ? worker : null;
    }

    private void runAndCacheAlignFrame(boolean cacheAlignFrame, String id) {
        AlignFrame af = this.run(cacheAlignFrame);
        if (cacheAlignFrame && id != null && af != null) {
            af.cacheAlignFrameFromRestId(id);
        }
    }

    private void resetDialog() {
        this.exampleBtn.setEnabled(true);
        this.textArea.setEnabled(true);
        this.okBtn.setEnabled(true);
        this.closeBtn.setEnabled(true);
        this.backBtn.setEnabled(this.parentSearchPanel != null);
    }

    @Override
    public void run() {
        this.run(false);
    }

    public AlignFrame run(boolean returnAlignFrame) {
        boolean addToLast = false;
        ArrayList<String> aresultq = new ArrayList<String>();
        ArrayList<String> presultTitle = new ArrayList<String>();
        ArrayList<AlignmentI> presult = new ArrayList<AlignmentI>();
        ArrayList<AlignmentI> aresult = new ArrayList<AlignmentI>();
        List<DbSourceProxy> sources = sfetch.getSourceProxy((String)this.database.getSelectedItem());
        Iterator<DbSourceProxy> proxies = sources.iterator();
        String[] qries = this.textArea.getText().trim().split(";");
        List<String> nextFetch = Arrays.asList(qries);
        Iterator<String> en = Arrays.asList(new String[0]).iterator();
        int nqueries = qries.length;
        FeatureSettingsModelI preferredFeatureColours = null;
        while (proxies.hasNext() && (en.hasNext() || nextFetch.size() > 0)) {
            if (!en.hasNext() && nextFetch.size() > 0) {
                en = nextFetch.iterator();
                nqueries = nextFetch.size();
                qries = nextFetch.toArray(new String[nqueries]);
                nextFetch = new ArrayList<String>();
            }
            DbSourceProxy proxy = proxies.next();
            try {
                this.guiWindow.setProgressBar(MessageManager.formatMessage("status.fetching_sequence_queries_from", new String[]{Integer.valueOf(nqueries).toString(), proxy.getDbName()}), Thread.currentThread().hashCode());
                if (proxy.getMaximumQueryCount() == 1) {
                    while (en.hasNext()) {
                        String acc = en.next();
                        if (this.fetchSingleAccession(proxy, acc, aresultq, aresult)) continue;
                        nextFetch.add(acc);
                    }
                } else {
                    this.fetchMultipleAccessions(proxy, en, aresultq, aresult, nextFetch);
                }
            }
            catch (Exception e) {
                this.showErrorMessage("Error retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem());
                System.err.println("Retrieval failed for source ='" + this.database.getSelectedItem() + "' and query\n'" + this.textArea.getText() + "'\n");
                e.printStackTrace();
            }
            catch (OutOfMemoryError e) {
                this.showErrorMessage("Out of Memory when retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem() + "\nPlease see the Jalview FAQ for instructions for increasing the memory available to Jalview.\n");
                e.printStackTrace();
            }
            catch (Error e) {
                this.showErrorMessage("Serious Error retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem());
                e.printStackTrace();
            }
            if (aresult != null && aresult.size() > 0) {
                FeatureSettingsModelI proxyColourScheme = proxy.getFeatureColourScheme();
                if (proxyColourScheme != null) {
                    preferredFeatureColours = proxyColourScheme;
                }
                AlignmentI ar = null;
                if (proxy.isAlignmentSource()) {
                    addToLast = false;
                    while (aresult.size() > 0) {
                        presult.add((AlignmentI)aresult.remove(0));
                        presultTitle.add((String)aresultq.remove(0) + " " + this.getDefaultRetrievalTitle());
                    }
                } else {
                    String titl = null;
                    if (addToLast && presult.size() > 0) {
                        ar = (AlignmentI)presult.remove(presult.size() - 1);
                        titl = (String)presultTitle.remove(presultTitle.size() - 1);
                    }
                    while (aresult.size() > 0) {
                        if (ar == null) {
                            ar = (AlignmentI)aresult.remove(0);
                            continue;
                        }
                        ar.append((AlignmentI)aresult.remove(0));
                    }
                    addToLast = true;
                    presult.add(ar);
                    presultTitle.add(titl);
                }
            }
            this.guiWindow.setProgressBar(MessageManager.getString("status.finshed_querying"), Thread.currentThread().hashCode());
        }
        this.guiWindow.setProgressBar(presult.size() > 0 ? MessageManager.getString("status.parsing_results") : MessageManager.getString("status.processing"), Thread.currentThread().hashCode());
        AlignFrame af = null;
        while (presult.size() > 0) {
            af = this.parseResult((AlignmentI)presult.remove(0), (String)presultTitle.remove(0), null, preferredFeatureColours);
        }
        this.guiWindow.setProgressBar(null, Thread.currentThread().hashCode());
        if (nextFetch.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Didn't retrieve the following " + (nextFetch.size() == 1 ? "query" : nextFetch.size() + " queries") + ": \n");
            int l = sb.length();
            int lr = 0;
            for (String s : nextFetch) {
                if (l != sb.length()) {
                    sb.append("; ");
                }
                if (lr - sb.length() > 40) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            this.showErrorMessage(sb.toString());
        }
        this.resetDialog();
        return returnAlignFrame ? af : null;
    }

    void fetchMultipleAccessions(DbSourceProxy proxy, Iterator<String> accessions, List<String> aresultq, List<AlignmentI> aresult, List<String> nextFetch) throws Exception {
        StringBuilder multiacc = new StringBuilder();
        ArrayList<String> tosend = new ArrayList<String>();
        while (accessions.hasNext()) {
            String nel = accessions.next();
            tosend.add(nel);
            multiacc.append(nel);
            if (!accessions.hasNext()) continue;
            multiacc.append(proxy.getAccessionSeparator());
        }
        try {
            String query = multiacc.toString();
            AlignmentI rslt = proxy.getSequenceRecords(query);
            if (rslt == null || rslt.getHeight() == 0) {
                nextFetch.addAll(tosend);
            } else {
                aresultq.add(query);
                aresult.add(rslt);
                if (tosend.size() > 1) {
                    this.checkResultForQueries(rslt, tosend, nextFetch, proxy);
                }
            }
        }
        catch (OutOfMemoryError oome) {
            new OOMWarning("fetching " + multiacc + " from " + this.database.getSelectedItem(), oome, this);
        }
    }

    boolean fetchSingleAccession(DbSourceProxy proxy, String accession, List<String> aresultq, List<AlignmentI> aresult) {
        boolean success = false;
        try {
            if (aresult != null) {
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AlignmentI indres = null;
            try {
                indres = proxy.getSequenceRecords(accession);
            }
            catch (OutOfMemoryError oome) {
                new OOMWarning("fetching " + accession + " from " + proxy.getDbName(), oome, this);
            }
            if (indres != null) {
                aresultq.add(accession);
                aresult.add(indres);
                success = true;
            }
        }
        catch (Exception e) {
            Cache.log.info((Object)("Error retrieving " + accession + " from " + proxy.getDbName()), (Throwable)e);
        }
        return success;
    }

    void checkResultForQueries(AlignmentI rslt, List<String> queries, List<String> nextFetch, DbSourceProxy proxy) {
        SequenceI[] rs = rslt.getSequencesArray();
        for (String q : queries) {
            String accId = proxy.getAccessionIdFromQuery(q);
            boolean rfound = false;
            int nr = rs.length;
            for (int r = 0; r < nr; ++r) {
                List<DBRefEntry> found;
                if (rs[r] == null || (found = DBRefUtils.searchRefs(rs[r].getDBRefs(), accId)).isEmpty()) continue;
                rfound = true;
                break;
            }
            if (rfound) continue;
            nextFetch.add(q);
        }
    }

    public String getDefaultRetrievalTitle() {
        return "Retrieved from " + this.database.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AlignFrame parseResult(AlignmentI al, String title, FileFormatI currentFileFormat, FeatureSettingsModelI preferredFeatureColours) {
        AlignFrame af = this.alignFrame;
        if (al != null && al.getHeight() > 0) {
            if (title == null) {
                title = this.getDefaultRetrievalTitle();
            }
            if (af == null) {
                List<SequenceI> alsqs;
                af = new AlignFrame(al, 700, 500);
                if (currentFileFormat != null) {
                    af.currentFileFormat = currentFileFormat;
                }
                List<SequenceI> list = alsqs = al.getSequences();
                synchronized (list) {
                    for (SequenceI sq : alsqs) {
                        if (!sq.getFeatures().hasFeatures()) continue;
                        af.setShowSeqFeatures(true);
                        break;
                    }
                }
                if (preferredFeatureColours != null) {
                    af.getViewport().applyFeaturesStyle(preferredFeatureColours);
                }
                if (Cache.getDefault("HIDE_INTRONS", true)) {
                    af.hideFeatureColumns("exon", false);
                }
                Desktop.addInternalFrame(af, title, 700, 500);
                af.setStatus(MessageManager.getString("label.successfully_pasted_alignment_file"));
                try {
                    af.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
                }
                catch (Exception exception) {}
            } else {
                af.viewport.addAlignment(al, title);
            }
        }
        return af;
    }

    void showErrorMessage(final String error) {
        this.resetDialog();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, error, MessageManager.getString("label.error_retrieving_data"), 2);
            }
        });
    }

    public IProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    public void setProgressIndicator(IProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    void hidePanel() {
        this.frame.setVisible(false);
    }

    public void setQuery(String ids) {
        this.textArea.setText(ids);
    }

    public void embedIn(GFTSPanel parentPanel) {
        this.database.setVisible(false);
        this.backBtn.setVisible(true);
        this.parentSearchPanel = parentPanel;
    }
}

