/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.VisibleContigsIterator;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationPanel;
import jalview.gui.FeatureRenderer;
import jalview.gui.PaintRefresher;
import jalview.gui.SequenceRenderer;
import jalview.renderer.ScaleRenderer;
import jalview.util.Comparison;
import jalview.viewmodel.ViewportListenerI;
import jalview.viewmodel.ViewportRanges;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public class SeqCanvas
extends JPanel
implements ViewportListenerI {
    static final int SEQS_ANNOTATION_GAP = 3;
    private static final String ZEROS = "0000000000";
    final FeatureRenderer fr;
    BufferedImage img;
    AlignViewport av;
    int cursorX = 0;
    int cursorY = 0;
    private final SequenceRenderer seqRdr;
    boolean fastPaint = false;
    private boolean fastpainting = false;
    private AnnotationPanel annotations;
    private int labelWidthEast;
    private int labelWidthWest;
    int wrappedSpaceAboveAlignment;
    int wrappedRepeatHeightPx;
    private int wrappedVisibleWidths;

    public SeqCanvas(AlignmentPanel ap) {
        this.av = ap.av;
        this.fr = new FeatureRenderer(ap);
        this.seqRdr = new SequenceRenderer(this.av);
        this.setLayout(new BorderLayout());
        PaintRefresher.Register(this, this.av.getSequenceSetId());
        this.setBackground(Color.white);
        this.av.getRanges().addPropertyChangeListener(this);
    }

    public SequenceRenderer getSequenceRenderer() {
        return this.seqRdr;
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.fr;
    }

    private void drawNorthScale(Graphics g, int startx, int endx, int ypos) {
        int charHeight = this.av.getCharHeight();
        int charWidth = this.av.getCharWidth();
        g.setColor(Color.white);
        g.fillRect(0, ypos - charHeight - charHeight / 2, this.getWidth(), charHeight * 3 / 2 + 2);
        g.setColor(Color.black);
        List<ScaleRenderer.ScaleMark> marks = new ScaleRenderer().calculateMarks(this.av, startx, endx);
        for (ScaleRenderer.ScaleMark mark : marks) {
            int mpos = mark.column;
            if (mpos < 0) continue;
            String mstring = mark.text;
            if (!mark.major) continue;
            if (mstring != null) {
                g.drawString(mstring, mpos * charWidth, ypos - charHeight / 2);
            }
            int xpos = mpos * charWidth + charWidth / 2;
            g.drawLine(xpos, ypos + 2 - charHeight / 2, xpos, ypos - 2);
        }
    }

    void drawVerticalScale(Graphics g, int startx, int endx, int ypos, boolean left) {
        int charHeight = this.av.getCharHeight();
        int charWidth = this.av.getCharWidth();
        int yPos = ypos + charHeight;
        int startX = startx;
        int endX = endx;
        if (this.av.hasHiddenColumns()) {
            HiddenColumns hiddenColumns = this.av.getAlignment().getHiddenColumns();
            startX = hiddenColumns.visibleToAbsoluteColumn(startx);
            endX = hiddenColumns.visibleToAbsoluteColumn(endx);
        }
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        for (int i = 0; i < this.av.getAlignment().getHeight(); ++i) {
            SequenceI seq = this.av.getAlignment().getSequenceAt(i);
            int index = left ? startX : endX;
            int value = -1;
            while (index >= startX && index <= endX) {
                if (!Comparison.isGap(seq.getCharAt(index))) {
                    value = seq.findPosition(index);
                    break;
                }
                if (left) {
                    ++index;
                    continue;
                }
                --index;
            }
            g.setColor(Color.white);
            int y = yPos + i * charHeight - charHeight / 5;
            g.fillRect(0, y - charHeight, left ? this.labelWidthWest : this.labelWidthEast, charHeight + 1);
            if (value == -1) continue;
            int labelSpace = left ? this.labelWidthWest : this.labelWidthEast;
            String valueAsString = String.valueOf(value);
            int labelLength = fm.stringWidth(valueAsString);
            int xOffset = (labelSpace -= charWidth / 2) - labelLength;
            g.setColor(Color.black);
            g.drawString(valueAsString, xOffset, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastPaint(int horizontal, int vertical) {
        if (this.fastpainting || this.img == null) {
            return;
        }
        this.fastpainting = true;
        this.fastPaint = true;
        try {
            int charHeight = this.av.getCharHeight();
            int charWidth = this.av.getCharWidth();
            ViewportRanges ranges = this.av.getRanges();
            int startRes = ranges.getStartRes();
            int endRes = ranges.getEndRes();
            int startSeq = ranges.getStartSeq();
            int endSeq = ranges.getEndSeq();
            int transX = 0;
            int transY = 0;
            if (horizontal > 0) {
                transX = (endRes - startRes - horizontal) * charWidth;
                startRes = endRes - horizontal;
            } else if (horizontal < 0) {
                endRes = startRes - horizontal;
            }
            if (vertical > 0) {
                startSeq = endSeq - vertical;
                if (startSeq < ranges.getStartSeq()) {
                    startSeq = ranges.getStartSeq();
                } else {
                    transY = this.img.getHeight() - (vertical + 1) * charHeight;
                }
            } else if (vertical < 0 && (endSeq = startSeq - vertical) > ranges.getEndSeq()) {
                endSeq = ranges.getEndSeq();
            }
            Graphics gg = this.img.getGraphics();
            gg.copyArea(horizontal * charWidth, vertical * charHeight, this.img.getWidth(), this.img.getHeight(), -horizontal * charWidth, -vertical * charHeight);
            gg.translate(transX, transY);
            this.drawPanel(gg, startRes, endRes, startSeq, endSeq, 0);
            gg.translate(-transX, -transY);
            gg.dispose();
            this.av.getAlignPanel().repaint();
        }
        finally {
            this.fastpainting = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void paintComponent(Graphics g) {
        charHeight = this.av.getCharHeight();
        charWidth = this.av.getCharWidth();
        width = this.getWidth();
        height = this.getHeight();
        width -= width % charWidth;
        height -= height % charHeight;
        if (width == 0 || height == 0) {
            return;
        }
        ranges = this.av.getRanges();
        startRes = ranges.getStartRes();
        startSeq = ranges.getStartSeq();
        endRes = ranges.getEndRes();
        endSeq = ranges.getEndSeq();
        if (this.img == null) ** GOTO lbl-1000
        if (this.fastPaint) ** GOTO lbl-1000
        vis = this.getVisibleRect();
        clip = g.getClipBounds();
        if (vis.width != clip.width || vis.height != clip.height) lbl-1000:
        // 2 sources

        {
            g.drawImage(this.img, 0, 0, this);
            this.drawSelectionGroup((Graphics2D)g, startRes, endRes, startSeq, endSeq);
            this.fastPaint = false;
        } else lbl-1000:
        // 2 sources

        {
            if (this.img == null || width != this.img.getWidth() || height != this.img.getHeight()) {
                this.img = new BufferedImage(width, height, 1);
            }
            gg = (Graphics2D)this.img.getGraphics();
            gg.setFont(this.av.getFont());
            if (this.av.antiAlias) {
                gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            gg.setColor(Color.white);
            gg.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
            if (this.av.getWrapAlignment()) {
                this.drawWrappedPanel(gg, this.getWidth(), this.getHeight(), ranges.getStartRes());
            } else {
                this.drawPanel(gg, startRes, endRes, startSeq, endSeq, 0);
            }
            this.drawSelectionGroup(gg, startRes, endRes, startSeq, endSeq);
            g.drawImage(this.img, 0, 0, this);
            gg.dispose();
        }
        if (this.av.cursorMode) {
            this.drawCursor(g, startRes, endRes, startSeq, endSeq);
        }
    }

    public void drawPanelForPrinting(Graphics g1, int startRes, int endRes, int startSeq, int endSeq) {
        this.drawPanel(g1, startRes, endRes, startSeq, endSeq, 0);
        this.drawSelectionGroup((Graphics2D)g1, startRes, endRes, startSeq, endSeq);
    }

    public void drawWrappedPanelForPrinting(Graphics g, int canvasWidth, int canvasHeight, int startRes) {
        this.drawWrappedPanel(g, canvasWidth, canvasHeight, startRes);
        SequenceGroup group = this.av.getSelectionGroup();
        if (group != null) {
            this.drawWrappedSelection((Graphics2D)g, group, canvasWidth, canvasHeight, startRes);
        }
    }

    public int getWrappedCanvasWidth(int canvasWidth) {
        int charWidth = this.av.getCharWidth();
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        int labelWidth = 0;
        if (this.av.getScaleRightWrapped() || this.av.getScaleLeftWrapped()) {
            labelWidth = this.getLabelWidth(fm);
        }
        this.labelWidthEast = this.av.getScaleRightWrapped() ? labelWidth : 0;
        this.labelWidthWest = this.av.getScaleLeftWrapped() ? labelWidth : 0;
        return (canvasWidth - this.labelWidthEast - this.labelWidthWest) / charWidth;
    }

    protected int getLabelWidth(FontMetrics fm) {
        int maxWidth = 0;
        AlignmentI alignment = this.av.getAlignment();
        for (int i = 0; i < alignment.getHeight(); ++i) {
            maxWidth = Math.max(maxWidth, alignment.getSequenceAt(i).getEnd());
        }
        int length = 0;
        for (int i = maxWidth; i > 0; i /= 10) {
            ++length;
        }
        return fm.stringWidth(ZEROS.substring(0, length)) + this.av.getCharWidth();
    }

    public void drawWrappedPanel(Graphics g, int canvasWidth, int canvasHeight, int startColumn) {
        int wrappedWidthInResidues = this.calculateWrappedGeometry(canvasWidth, canvasHeight);
        this.av.setWrappedWidth(wrappedWidthInResidues);
        ViewportRanges ranges = this.av.getRanges();
        ranges.setViewportStartAndWidth(startColumn, wrappedWidthInResidues);
        this.calculateWrappedGeometry(canvasWidth, canvasHeight);
        int ypos = this.wrappedSpaceAboveAlignment;
        int maxWidth = ranges.getVisibleAlignmentWidth();
        int start = startColumn;
        for (int currentWidth = 0; currentWidth < this.wrappedVisibleWidths && start < maxWidth; start += wrappedWidthInResidues, ++currentWidth) {
            int endColumn = Math.min(maxWidth, start + wrappedWidthInResidues - 1);
            this.drawWrappedWidth(g, ypos, start, endColumn, canvasHeight);
            ypos += this.wrappedRepeatHeightPx;
        }
        this.drawWrappedDecorators(g, startColumn);
    }

    protected int calculateWrappedGeometry(int canvasWidth, int canvasHeight) {
        int charHeight = this.av.getCharHeight();
        this.wrappedRepeatHeightPx = this.wrappedSpaceAboveAlignment = charHeight * (this.av.getScaleAboveWrapped() ? 2 : 1);
        this.wrappedRepeatHeightPx += this.av.getAlignment().getHeight() * charHeight;
        if (this.av.isShowAnnotation()) {
            this.wrappedRepeatHeightPx += this.getAnnotationHeight();
            this.wrappedRepeatHeightPx += 3;
        }
        ViewportRanges ranges = this.av.getRanges();
        this.wrappedVisibleWidths = canvasHeight / this.wrappedRepeatHeightPx;
        int remainder = canvasHeight % this.wrappedRepeatHeightPx;
        if (remainder >= this.wrappedSpaceAboveAlignment + charHeight) {
            ++this.wrappedVisibleWidths;
        }
        int wrappedWidthInResidues = this.getWrappedCanvasWidth(canvasWidth);
        int xMax = ranges.getVisibleAlignmentWidth();
        int startToEnd = xMax - ranges.getStartRes();
        int maxWidths = startToEnd / wrappedWidthInResidues;
        if (startToEnd % wrappedWidthInResidues > 0) {
            ++maxWidths;
        }
        this.wrappedVisibleWidths = Math.min(this.wrappedVisibleWidths, maxWidths);
        return wrappedWidthInResidues;
    }

    protected void drawWrappedWidth(Graphics g, int ypos, int startColumn, int endColumn, int canvasHeight) {
        ViewportRanges ranges = this.av.getRanges();
        int viewportWidth = ranges.getViewportWidth();
        int endx = Math.min(startColumn + viewportWidth - 1, endColumn);
        int charWidth = this.av.getCharWidth();
        int xOffset = this.labelWidthWest + (startColumn - ranges.getStartRes()) % viewportWidth * charWidth;
        g.translate(xOffset, 0);
        g.setColor(Color.white);
        g.fillRect(0, ypos, (endx - startColumn + 1) * charWidth, this.wrappedRepeatHeightPx);
        this.drawPanel(g, startColumn, endx, 0, this.av.getAlignment().getHeight() - 1, ypos);
        int cHeight = this.av.getAlignment().getHeight() * this.av.getCharHeight();
        if (this.av.isShowAnnotation()) {
            int yShift = cHeight + ypos + 3;
            g.translate(0, yShift);
            if (this.annotations == null) {
                this.annotations = new AnnotationPanel(this.av);
            }
            this.annotations.renderer.drawComponent(this.annotations, this.av, g, -1, startColumn, endx + 1);
            g.translate(0, -yShift);
        }
        g.translate(-xOffset, 0);
    }

    protected void drawWrappedDecorators(Graphics g, int startColumn) {
        int charWidth = this.av.getCharWidth();
        g.setFont(this.av.getFont());
        g.setColor(Color.black);
        int ypos = this.wrappedSpaceAboveAlignment;
        ViewportRanges ranges = this.av.getRanges();
        int viewportWidth = ranges.getViewportWidth();
        int maxWidth = ranges.getVisibleAlignmentWidth();
        int startCol = startColumn;
        for (int widthsDrawn = 0; widthsDrawn < this.wrappedVisibleWidths; ++widthsDrawn) {
            int endColumn = Math.min(maxWidth, startCol + viewportWidth - 1);
            if (this.av.getScaleLeftWrapped()) {
                this.drawVerticalScale(g, startCol, endColumn - 1, ypos, true);
            }
            if (this.av.getScaleRightWrapped()) {
                int x = this.labelWidthWest + viewportWidth * charWidth;
                g.translate(x, 0);
                this.drawVerticalScale(g, startCol, endColumn, ypos, false);
                g.translate(-x, 0);
            }
            g.translate(this.labelWidthWest, 0);
            g.setColor(Color.white);
            g.fillRect(0, ypos - this.wrappedSpaceAboveAlignment, viewportWidth * charWidth + this.labelWidthWest, this.wrappedSpaceAboveAlignment);
            g.setColor(Color.black);
            g.translate(-this.labelWidthWest, 0);
            g.translate(this.labelWidthWest, 0);
            if (this.av.getScaleAboveWrapped()) {
                this.drawNorthScale(g, startCol, endColumn, ypos);
            }
            if (this.av.hasHiddenColumns() && this.av.getShowHiddenMarkers()) {
                this.drawHiddenColumnMarkers(g, ypos, startCol, endColumn);
            }
            g.translate(-this.labelWidthWest, 0);
            ypos += this.wrappedRepeatHeightPx;
            startCol += viewportWidth;
        }
    }

    protected void drawHiddenColumnMarkers(Graphics g, int ypos, int startColumn, int endColumn) {
        int charHeight = this.av.getCharHeight();
        int charWidth = this.av.getCharWidth();
        g.setColor(Color.blue);
        HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
        Iterator<Integer> it = hidden.getStartRegionIterator(startColumn, endColumn);
        while (it.hasNext()) {
            int res = it.next() - startColumn;
            if (res < 0 || res > endColumn - startColumn + 1) continue;
            int xMiddle = res * charWidth;
            int[] xPoints = new int[]{xMiddle - charHeight / 4, xMiddle + charHeight / 4, xMiddle};
            int yTop = ypos - charHeight / 2;
            int[] yPoints = new int[]{yTop, yTop, yTop + 8};
            g.fillPolygon(xPoints, yPoints, 3);
        }
    }

    private void drawWrappedSelection(Graphics2D g, SequenceGroup group, int canvasWidth, int canvasHeight, int startRes) {
        g.setStroke(new BasicStroke(1.0f, 0, 1, 3.0f, new float[]{5.0f, 3.0f}, 0.0f));
        g.setColor(Color.RED);
        int charWidth = this.av.getCharWidth();
        int cWidth = (canvasWidth - this.labelWidthEast - this.labelWidthWest) / charWidth;
        int startx = startRes;
        int maxwidth = this.av.getAlignment().getVisibleWidth();
        for (int ypos = this.wrappedSpaceAboveAlignment; ypos <= canvasHeight && startx < maxwidth; ypos += this.wrappedRepeatHeightPx, startx += cWidth) {
            int endx = startx + cWidth - 1;
            if (endx > maxwidth) {
                endx = maxwidth;
            }
            g.translate(this.labelWidthWest, 0);
            this.drawUnwrappedSelection(g, group, startx, endx, 0, this.av.getAlignment().getHeight() - 1, ypos);
            g.translate(-this.labelWidthWest, 0);
        }
        g.setStroke(new BasicStroke());
    }

    int getAnnotationHeight() {
        if (!this.av.isShowAnnotation()) {
            return 0;
        }
        if (this.annotations == null) {
            this.annotations = new AnnotationPanel(this.av);
        }
        return this.annotations.adjustPanelHeight();
    }

    public void drawPanel(Graphics g1, int startRes, int endRes, int startSeq, int endSeq, int yOffset) {
        int charHeight = this.av.getCharHeight();
        int charWidth = this.av.getCharWidth();
        if (!this.av.hasHiddenColumns()) {
            this.draw(g1, startRes, endRes, startSeq, endSeq, yOffset);
        } else {
            int screenY = 0;
            HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
            VisibleContigsIterator regions = hidden.getVisContigsIterator(startRes, endRes + 1, true);
            while (regions.hasNext()) {
                int[] region = regions.next();
                int blockEnd = region[1];
                int blockStart = region[0];
                g1.translate(screenY * charWidth, 0);
                this.draw(g1, blockStart, blockEnd, startSeq, endSeq, yOffset);
                if (this.av.getShowHiddenMarkers() && (regions.hasNext() || regions.endsAtHidden())) {
                    g1.setColor(Color.blue);
                    g1.drawLine((blockEnd - blockStart + 1) * charWidth - 1, 0 + yOffset, (blockEnd - blockStart + 1) * charWidth - 1, (endSeq - startSeq + 1) * charHeight + yOffset);
                }
                g1.translate(-screenY * charWidth, 0);
                screenY += blockEnd - blockStart + 1;
            }
        }
    }

    private void draw(Graphics g, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        int charHeight = this.av.getCharHeight();
        int charWidth = this.av.getCharWidth();
        g.setFont(this.av.getFont());
        this.seqRdr.prepare(g, this.av.isRenderGaps());
        for (int i = startSeq; i <= endSeq; ++i) {
            SearchResultsI searchResults;
            int[] visibleResults;
            SequenceI nextSeq = this.av.getAlignment().getSequenceAt(i);
            if (nextSeq == null) continue;
            this.seqRdr.drawSequence(nextSeq, this.av.getAlignment().findAllGroups(nextSeq), startRes, endRes, offset + (i - startSeq) * charHeight);
            if (this.av.isShowSequenceFeatures()) {
                this.fr.drawSequence(g, nextSeq, startRes, endRes, offset + (i - startSeq) * charHeight, false);
            }
            if (!this.av.hasSearchResults() || (visibleResults = (searchResults = this.av.getSearchResults()).getResults(nextSeq, startRes, endRes)) == null) continue;
            for (int r = 0; r < visibleResults.length; r += 2) {
                this.seqRdr.drawHighlightedText(nextSeq, visibleResults[r], visibleResults[r + 1], (visibleResults[r] - startRes) * charWidth, offset + (i - startSeq) * charHeight);
            }
        }
        if (this.av.getSelectionGroup() != null || this.av.getAlignment().getGroups().size() > 0) {
            this.drawGroupsBoundaries(g, startRes, endRes, startSeq, endSeq, offset);
        }
    }

    void drawGroupsBoundaries(Graphics g1, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        Graphics2D g = (Graphics2D)g1;
        SequenceGroup group = null;
        int groupIndex = -1;
        if (this.av.getAlignment().getGroups().size() > 0) {
            group = this.av.getAlignment().getGroups().get(0);
            groupIndex = 0;
        }
        if (group != null) {
            do {
                g.setColor(group.getOutlineColour());
                this.drawPartialGroupOutline(g, group, startRes, endRes, startSeq, endSeq, offset);
                if (++groupIndex >= this.av.getAlignment().getGroups().size()) break;
                group = this.av.getAlignment().getGroups().get(groupIndex);
            } while (groupIndex < this.av.getAlignment().getGroups().size());
        }
    }

    private void drawSelectionGroup(Graphics2D g, int startRes, int endRes, int startSeq, int endSeq) {
        SequenceGroup group = this.av.getSelectionGroup();
        if (group == null) {
            return;
        }
        g.setStroke(new BasicStroke(1.0f, 0, 1, 3.0f, new float[]{5.0f, 3.0f}, 0.0f));
        g.setColor(Color.RED);
        if (!this.av.getWrapAlignment()) {
            this.drawUnwrappedSelection(g, group, startRes, endRes, startSeq, endSeq, 0);
        } else {
            this.drawWrappedSelection(g, group, this.getWidth(), this.getHeight(), this.av.getRanges().getStartRes());
        }
        g.setStroke(new BasicStroke());
    }

    private void drawCursor(Graphics g, int startRes, int endRes, int startSeq, int endSeq) {
        int cursor_ypos = this.cursorY;
        if (cursor_ypos >= startSeq && cursor_ypos <= endSeq) {
            int yoffset = 0;
            int xoffset = 0;
            int startx = startRes;
            int endx = endRes;
            int cursor_xpos = this.av.getAlignment().getHiddenColumns().absoluteToVisibleColumn(this.cursorX);
            if (this.av.getAlignment().getHiddenColumns().isVisible(this.cursorX)) {
                if (this.av.getWrapAlignment()) {
                    int ypos;
                    int charHeight = this.av.getCharHeight();
                    int charWidth = this.av.getCharWidth();
                    int canvasWidth = this.getWidth();
                    int canvasHeight = this.getHeight();
                    int hgap = charHeight;
                    if (this.av.getScaleAboveWrapped()) {
                        hgap += charHeight;
                    }
                    int cWidth = (canvasWidth - this.labelWidthEast - this.labelWidthWest) / charWidth;
                    int cHeight = this.av.getAlignment().getHeight() * charHeight;
                    endx = startx + cWidth - 1;
                    for (ypos = hgap; ypos <= canvasHeight && endx < cursor_xpos; ypos += cHeight + this.getAnnotationHeight() + hgap) {
                        endx = (startx += cWidth) + cWidth - 1;
                    }
                    yoffset = ypos;
                    xoffset = this.labelWidthWest;
                }
                if (cursor_xpos >= startx && cursor_xpos <= endx) {
                    SequenceI seq = this.av.getAlignment().getSequenceAt(this.cursorY);
                    char s = seq.getCharAt(this.cursorX);
                    this.seqRdr.drawCursor(g, s, xoffset + (cursor_xpos - startx) * this.av.getCharWidth(), yoffset + (cursor_ypos - startSeq) * this.av.getCharHeight());
                }
            }
        }
    }

    private void drawUnwrappedSelection(Graphics2D g, SequenceGroup group, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        int charWidth = this.av.getCharWidth();
        if (!this.av.hasHiddenColumns()) {
            this.drawPartialGroupOutline(g, group, startRes, endRes, startSeq, endSeq, offset);
        } else {
            int screenY = 0;
            HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
            VisibleContigsIterator regions = hidden.getVisContigsIterator(startRes, endRes + 1, true);
            while (regions.hasNext()) {
                int[] region = regions.next();
                int blockEnd = region[1];
                int blockStart = region[0];
                g.translate(screenY * charWidth, 0);
                this.drawPartialGroupOutline(g, group, blockStart, blockEnd, startSeq, endSeq, offset);
                g.translate(-screenY * charWidth, 0);
                screenY += blockEnd - blockStart + 1;
            }
        }
    }

    private void drawPartialGroupOutline(Graphics2D g, SequenceGroup group, int startRes, int endRes, int startSeq, int endSeq, int verticalOffset) {
        int xwidth;
        int charHeight = this.av.getCharHeight();
        int charWidth = this.av.getCharWidth();
        int visWidth = (endRes - startRes + 1) * charWidth;
        int oldY = -1;
        int i = 0;
        boolean inGroup = false;
        int top = -1;
        int bottom = -1;
        int sy = -1;
        List<SequenceI> seqs = group.getSequences(null);
        int sx = (group.getStartRes() - startRes) * charWidth;
        if (sx + (xwidth = (group.getEndRes() + 1 - group.getStartRes()) * charWidth - 1) >= 0 && sx <= visWidth) {
            for (i = startSeq; i <= endSeq; ++i) {
                sy = verticalOffset + (i - startSeq) * charHeight;
                if (sx <= (endRes - startRes) * charWidth && seqs.contains(this.av.getAlignment().getSequenceAt(i))) {
                    if (bottom == -1 && !seqs.contains(this.av.getAlignment().getSequenceAt(i + 1))) {
                        bottom = sy + charHeight;
                    }
                    if (inGroup) continue;
                    if (top == -1 && i == 0 || !seqs.contains(this.av.getAlignment().getSequenceAt(i - 1))) {
                        top = sy;
                    }
                    oldY = sy;
                    inGroup = true;
                    continue;
                }
                if (!inGroup) continue;
                this.drawVerticals(g, sx, xwidth, visWidth, oldY, sy);
                this.drawHorizontals(g, sx, xwidth, visWidth, top, bottom);
                top = -1;
                bottom = -1;
                inGroup = false;
            }
            if (inGroup) {
                sy = verticalOffset + (i - startSeq) * charHeight;
                this.drawVerticals(g, sx, xwidth, visWidth, oldY, sy);
                this.drawHorizontals(g, sx, xwidth, visWidth, top, bottom);
            }
        }
    }

    private void drawHorizontals(Graphics2D g, int sx, int xwidth, int visWidth, int top, int bottom) {
        int width = xwidth;
        int startx = sx;
        if (startx < 0) {
            width += startx;
            startx = 0;
        }
        if (startx + width >= visWidth) {
            width = visWidth - startx;
        }
        if (top != -1) {
            g.drawLine(startx, top, startx + width, top);
        }
        if (bottom != -1) {
            g.drawLine(startx, bottom - 1, startx + width, bottom - 1);
        }
    }

    private void drawVerticals(Graphics2D g, int sx, int xwidth, int visWidth, int oldY, int sy) {
        if (sx >= 0 && sx < visWidth) {
            g.drawLine(sx, oldY, sx, sy);
        }
        if (sx + xwidth < visWidth) {
            g.drawLine(sx + xwidth, oldY, sx + xwidth, sy);
        }
    }

    public boolean highlightSearchResults(SearchResultsI results) {
        return this.highlightSearchResults(results, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean highlightSearchResults(SearchResultsI results, boolean doFastPaint) {
        if (this.fastpainting) {
            return false;
        }
        boolean wrapped = this.av.getWrapAlignment();
        try {
            this.fastpainting = this.fastPaint = doFastPaint;
            SearchResultsI previous = this.av.getSearchResults();
            this.av.setSearchResults(results);
            boolean redrawn = false;
            boolean drawn = false;
            if (wrapped) {
                redrawn = this.drawMappedPositionsWrapped(previous);
                drawn = this.drawMappedPositionsWrapped(results);
                redrawn |= drawn;
            } else {
                redrawn = this.drawMappedPositions(previous);
                drawn = this.drawMappedPositions(results);
                redrawn |= drawn;
            }
            if (redrawn) {
                this.repaint();
            }
            boolean bl = drawn;
            return bl;
        }
        finally {
            this.fastpainting = false;
        }
    }

    protected boolean drawMappedPositions(SearchResultsI results) {
        if (results == null || this.img == null) {
            return false;
        }
        int firstSeq = Integer.MAX_VALUE;
        int lastSeq = -1;
        int firstCol = Integer.MAX_VALUE;
        int lastCol = -1;
        boolean matchFound = false;
        ViewportRanges ranges = this.av.getRanges();
        int firstVisibleColumn = ranges.getStartRes();
        int lastVisibleColumn = ranges.getEndRes();
        AlignmentI alignment = this.av.getAlignment();
        if (this.av.hasHiddenColumns()) {
            firstVisibleColumn = alignment.getHiddenColumns().visibleToAbsoluteColumn(firstVisibleColumn);
            lastVisibleColumn = alignment.getHiddenColumns().visibleToAbsoluteColumn(lastVisibleColumn);
        }
        for (int seqNo = ranges.getStartSeq(); seqNo <= ranges.getEndSeq(); ++seqNo) {
            SequenceI seq = alignment.getSequenceAt(seqNo);
            int[] visibleResults = results.getResults(seq, firstVisibleColumn, lastVisibleColumn);
            if (visibleResults == null) continue;
            for (int i = 0; i < visibleResults.length - 1; i += 2) {
                int firstMatchedColumn = visibleResults[i];
                int lastMatchedColumn = visibleResults[i + 1];
                if (firstMatchedColumn > lastVisibleColumn || lastMatchedColumn < firstVisibleColumn) continue;
                matchFound = true;
                firstSeq = Math.min(firstSeq, seqNo);
                lastSeq = Math.max(lastSeq, seqNo);
                firstMatchedColumn = Math.max(firstMatchedColumn, firstVisibleColumn);
                lastMatchedColumn = Math.min(lastMatchedColumn, lastVisibleColumn);
                firstCol = Math.min(firstCol, firstMatchedColumn);
                lastCol = Math.max(lastCol, lastMatchedColumn);
            }
        }
        if (matchFound) {
            if (this.av.hasHiddenColumns()) {
                firstCol = alignment.getHiddenColumns().absoluteToVisibleColumn(firstCol);
                lastCol = alignment.getHiddenColumns().absoluteToVisibleColumn(lastCol);
            }
            int transX = (firstCol - ranges.getStartRes()) * this.av.getCharWidth();
            int transY = (firstSeq - ranges.getStartSeq()) * this.av.getCharHeight();
            Graphics gg = this.img.getGraphics();
            gg.translate(transX, transY);
            this.drawPanel(gg, firstCol, lastCol, firstSeq, lastSeq, 0);
            gg.translate(-transX, -transY);
            gg.dispose();
        }
        return matchFound;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if (eventName.equals("Sequence group changed")) {
            this.fastPaint = true;
            this.repaint();
            return;
        }
        if (eventName.equals("move_viewport")) {
            this.fastPaint = false;
            this.repaint();
            return;
        }
        int scrollX = 0;
        if (eventName.equals("startres") || eventName.equals("startresandseq")) {
            ViewportRanges vpRanges;
            int range;
            scrollX = eventName.equals("startres") ? (Integer)evt.getNewValue() - (Integer)evt.getOldValue() : ((int[])evt.getNewValue())[0] - ((int[])evt.getOldValue())[0];
            if (scrollX > (range = (vpRanges = this.av.getRanges()).getEndRes() - vpRanges.getStartRes() + 1)) {
                scrollX = range;
            } else if (scrollX < -range) {
                scrollX = -range;
            }
        }
        if (eventName.equals("startres")) {
            if (this.av.getWrapAlignment()) {
                this.fastPaintWrapped(scrollX);
            } else {
                this.fastPaint(scrollX, 0);
            }
        } else if (eventName.equals("startseq")) {
            this.fastPaint(0, (Integer)evt.getNewValue() - (Integer)evt.getOldValue());
        } else if (eventName.equals("startresandseq")) {
            if (this.av.getWrapAlignment()) {
                this.fastPaintWrapped(scrollX);
            } else {
                this.fastPaint(scrollX, 0);
            }
        } else if (eventName.equals("startseq")) {
            this.fastPaint(0, (Integer)evt.getNewValue() - (Integer)evt.getOldValue());
        } else if (eventName.equals("startresandseq") && this.av.getWrapAlignment()) {
            this.fastPaintWrapped(scrollX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fastPaintWrapped(int scrollX) {
        ViewportRanges ranges = this.av.getRanges();
        if (Math.abs(scrollX) >= ranges.getViewportWidth()) {
            this.fastPaint = false;
            this.repaint();
            return;
        }
        if (this.fastpainting || this.img == null) {
            return;
        }
        this.fastPaint = true;
        this.fastpainting = true;
        try {
            Graphics gg = this.img.getGraphics();
            this.calculateWrappedGeometry(this.getWidth(), this.getHeight());
            this.shiftWrappedAlignment(-scrollX);
            if (scrollX < 0) {
                int startRes = ranges.getStartRes();
                this.drawWrappedWidth(gg, this.wrappedSpaceAboveAlignment, startRes, startRes - scrollX - 1, this.getHeight());
            } else {
                this.fastPaintWrappedAddRight(scrollX);
            }
            this.drawWrappedDecorators(gg, ranges.getStartRes());
            gg.dispose();
            this.repaint();
        }
        finally {
            this.fastpainting = false;
        }
    }

    protected void fastPaintWrappedAddRight(int columns) {
        int heightBelow;
        int xOffset;
        int startRes;
        int endRes;
        int ypos;
        int widthsAbove;
        boolean lastWidthPartHeight;
        if (columns == 0) {
            return;
        }
        Graphics gg = this.img.getGraphics();
        ViewportRanges ranges = this.av.getRanges();
        int viewportWidth = ranges.getViewportWidth();
        int charWidth = this.av.getCharWidth();
        int visibleWidths = this.wrappedVisibleWidths;
        int canvasHeight = this.getHeight();
        boolean bl = lastWidthPartHeight = this.wrappedVisibleWidths * this.wrappedRepeatHeightPx > canvasHeight;
        if (lastWidthPartHeight) {
            widthsAbove = Math.max(0, visibleWidths - 2);
            ypos = this.wrappedRepeatHeightPx * widthsAbove + this.wrappedSpaceAboveAlignment;
            endRes = ranges.getEndRes();
            startRes = (endRes += widthsAbove * viewportWidth) - columns;
            xOffset = (startRes - ranges.getStartRes()) % viewportWidth * charWidth;
            gg.translate(xOffset, 0);
            gg.setColor(Color.white);
            gg.fillRect(this.labelWidthWest, ypos, (endRes - startRes + 1) * charWidth, this.wrappedRepeatHeightPx);
            gg.translate(-xOffset, 0);
            this.drawWrappedWidth(gg, ypos, startRes, endRes, canvasHeight);
        }
        widthsAbove = visibleWidths - 1;
        ypos = this.wrappedRepeatHeightPx * widthsAbove + this.wrappedSpaceAboveAlignment;
        endRes = ranges.getEndRes();
        startRes = (endRes += widthsAbove * viewportWidth) - columns + 1;
        xOffset = (startRes - ranges.getStartRes()) % viewportWidth * charWidth;
        gg.translate(xOffset, 0);
        gg.setColor(Color.white);
        int width = viewportWidth * charWidth - xOffset;
        gg.fillRect(this.labelWidthWest, ypos, width, this.wrappedRepeatHeightPx);
        gg.translate(-xOffset, 0);
        gg.setFont(this.av.getFont());
        gg.setColor(Color.black);
        if (startRes < ranges.getVisibleAlignmentWidth()) {
            this.drawWrappedWidth(gg, ypos, startRes, endRes, canvasHeight);
        }
        if ((heightBelow = canvasHeight - visibleWidths * this.wrappedRepeatHeightPx) > 0) {
            gg.setColor(Color.white);
            gg.fillRect(0, canvasHeight - heightBelow, this.getWidth(), heightBelow);
        }
        gg.dispose();
    }

    protected void shiftWrappedAlignment(int positions) {
        if (positions == 0) {
            return;
        }
        Graphics gg = this.img.getGraphics();
        int charWidth = this.av.getCharWidth();
        int canvasHeight = this.getHeight();
        ViewportRanges ranges = this.av.getRanges();
        int viewportWidth = ranges.getViewportWidth();
        int widthToCopy = (ranges.getViewportWidth() - Math.abs(positions)) * charWidth;
        int heightToCopy = this.wrappedRepeatHeightPx - this.wrappedSpaceAboveAlignment;
        int xMax = ranges.getVisibleAlignmentWidth();
        if (positions > 0) {
            int y = canvasHeight / this.wrappedRepeatHeightPx * this.wrappedRepeatHeightPx;
            y += this.wrappedSpaceAboveAlignment;
            int copyFromLeftStart = this.labelWidthWest;
            int copyFromRightStart = copyFromLeftStart + widthToCopy;
            while (y >= 0) {
                gg.copyArea(copyFromLeftStart, y, widthToCopy, heightToCopy, positions * charWidth, 0);
                if (y > 0) {
                    gg.copyArea(copyFromRightStart, y - this.wrappedRepeatHeightPx, positions * charWidth, heightToCopy, -widthToCopy, this.wrappedRepeatHeightPx);
                }
                y -= this.wrappedRepeatHeightPx;
            }
        } else {
            int xpos = this.av.getRanges().getStartRes();
            int y = this.wrappedSpaceAboveAlignment;
            int copyFromRightStart = this.labelWidthWest - positions * charWidth;
            while (y < canvasHeight) {
                gg.copyArea(copyFromRightStart, y, widthToCopy, heightToCopy, positions * charWidth, 0);
                if (y + this.wrappedRepeatHeightPx < canvasHeight - this.wrappedRepeatHeightPx && xpos + viewportWidth <= xMax) {
                    gg.copyArea(this.labelWidthWest, y + this.wrappedRepeatHeightPx, -positions * charWidth, heightToCopy, widthToCopy, -this.wrappedRepeatHeightPx);
                }
                y += this.wrappedRepeatHeightPx;
                xpos += viewportWidth;
            }
        }
        gg.dispose();
    }

    protected boolean drawMappedPositionsWrapped(SearchResultsI results) {
        if (results == null || this.img == null) {
            return false;
        }
        int charHeight = this.av.getCharHeight();
        boolean matchFound = false;
        this.calculateWrappedGeometry(this.getWidth(), this.getHeight());
        int wrappedWidth = this.av.getWrappedWidth();
        int wrappedHeight = this.wrappedRepeatHeightPx;
        ViewportRanges ranges = this.av.getRanges();
        int canvasHeight = this.getHeight();
        int repeats = canvasHeight / wrappedHeight;
        if (canvasHeight / wrappedHeight > 0) {
            ++repeats;
        }
        int firstVisibleColumn = ranges.getStartRes();
        int lastVisibleColumn = ranges.getStartRes() + repeats * ranges.getViewportWidth() - 1;
        AlignmentI alignment = this.av.getAlignment();
        if (this.av.hasHiddenColumns()) {
            firstVisibleColumn = alignment.getHiddenColumns().visibleToAbsoluteColumn(firstVisibleColumn);
            lastVisibleColumn = alignment.getHiddenColumns().visibleToAbsoluteColumn(lastVisibleColumn);
        }
        int gapHeight = charHeight * (this.av.getScaleAboveWrapped() ? 2 : 1);
        Graphics gg = this.img.getGraphics();
        for (int seqNo = ranges.getStartSeq(); seqNo <= ranges.getEndSeq(); ++seqNo) {
            SequenceI seq = alignment.getSequenceAt(seqNo);
            int[] visibleResults = results.getResults(seq, firstVisibleColumn, lastVisibleColumn);
            if (visibleResults == null) continue;
            for (int i = 0; i < visibleResults.length - 1; i += 2) {
                int firstMatchedColumn = visibleResults[i];
                int lastMatchedColumn = visibleResults[i + 1];
                if (firstMatchedColumn > lastVisibleColumn || lastMatchedColumn < firstVisibleColumn) continue;
                firstMatchedColumn = Math.max(firstMatchedColumn, firstVisibleColumn);
                lastMatchedColumn = Math.min(lastMatchedColumn, lastVisibleColumn);
                for (int mappedPos = firstMatchedColumn; mappedPos <= lastMatchedColumn; ++mappedPos) {
                    int displayColumn = mappedPos;
                    if (this.av.hasHiddenColumns()) {
                        displayColumn = alignment.getHiddenColumns().absoluteToVisibleColumn(displayColumn);
                    }
                    int transX = this.labelWidthWest + (displayColumn - ranges.getStartRes()) % wrappedWidth * this.av.getCharWidth();
                    int transY = gapHeight;
                    transY += (displayColumn - ranges.getStartRes()) / wrappedWidth * wrappedHeight;
                    int yOffset = 0;
                    if ((transY += (seqNo - ranges.getStartSeq()) * this.av.getCharHeight()) >= this.getHeight()) continue;
                    matchFound = true;
                    gg.translate(transX, transY);
                    this.drawPanel(gg, displayColumn, displayColumn, seqNo, seqNo, yOffset);
                    gg.translate(-transX, -transY);
                }
            }
        }
        gg.dispose();
        return matchFound;
    }

    int getLabelWidthWest() {
        return this.labelWidthWest;
    }
}

