/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignSeq;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.jbgui.GPairwiseAlignPanel;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class PairwiseAlignPanel
extends GPairwiseAlignPanel {
    private static final String DASHES = "---------------------\n";
    AlignmentViewport av;
    Vector<SequenceI> sequences;

    public PairwiseAlignPanel(AlignmentViewport viewport) {
        this.av = viewport;
        this.sequences = new Vector();
        SequenceGroup selectionGroup = viewport.getSelectionGroup();
        boolean isSelection = selectionGroup != null && selectionGroup.getSize() > 0;
        AlignmentView view = viewport.getAlignmentView(isSelection);
        String[] seqStrings = view.getSequenceStrings(viewport.getGapCharacter());
        SequenceI[] seqs = isSelection ? (SequenceI[])view.getAlignmentAndHiddenColumns(viewport.getGapCharacter())[0] : this.av.getAlignment().getSequencesArray();
        String type = viewport.getAlignment().isNucleotide() ? "dna" : "pep";
        float[][] scores = new float[seqs.length][seqs.length];
        double totscore = 0.0;
        int count = seqs.length;
        boolean first = true;
        for (int i = 1; i < count; ++i) {
            for (int j = 0; j < i; ++j) {
                AlignSeq as = new AlignSeq(seqs[i], seqStrings[i], seqs[j], seqStrings[j], type);
                if (as.s1str.length() == 0 || as.s2str.length() == 0) continue;
                as.calcScoreMatrix();
                as.traceAlignment();
                if (!first) {
                    System.out.println(DASHES);
                    this.textarea.append(DASHES);
                }
                first = false;
                as.printAlignment(System.out);
                scores[i][j] = as.getMaxScore() / (float)as.getASeq1().length;
                totscore += (double)scores[i][j];
                this.textarea.append(as.getOutput());
                this.sequences.add(as.getAlignedSeq1());
                this.sequences.add(as.getAlignedSeq2());
            }
        }
        if (count > 2) {
            this.printScoreMatrix(seqs, scores, totscore);
        }
    }

    protected void printScoreMatrix(SequenceI[] seqs, float[][] scores, double totscore) {
        int i;
        System.out.println("Pairwise alignment scaled similarity score matrix\n");
        for (i = 0; i < seqs.length; ++i) {
            System.out.println(String.format("%3d %s", i + 1, seqs[i].getDisplayId(true)));
        }
        System.out.print("\n ");
        for (i = 0; i < seqs.length; ++i) {
            System.out.print(String.format("%7d", i + 1));
        }
        System.out.println();
        for (i = 0; i < seqs.length; ++i) {
            System.out.print(String.format("%3d", i + 1));
            for (int j = 0; j < i; ++j) {
                System.out.print(String.format("%7.3f", (double)scores[i][j] / totscore));
            }
            System.out.println();
        }
        System.out.println("\n");
    }

    @Override
    protected void viewInEditorButton_actionPerformed(ActionEvent e) {
        SequenceI[] seq = new SequenceI[this.sequences.size()];
        for (int i = 0; i < this.sequences.size(); ++i) {
            seq[i] = this.sequences.elementAt(i);
        }
        AlignFrame af = new AlignFrame(new Alignment(seq), 700, 500);
        Desktop.addInternalFrame(af, MessageManager.getString("label.pairwise_aligned_sequences"), 700, 500);
    }
}

