/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import jalview.util.BrowserLauncher;
import jalview.util.Platform;
import java.awt.Point;
import java.io.IOException;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;

public class Help {
    private static final String HELP_PAGE_ROOT = "http://www.jalview.org/help/";
    private static HelpBroker hb;

    private Help() {
    }

    public static void showHelpWindow(HelpId id) throws HelpSetException {
        if (Platform.isJS()) {
            try {
                BrowserLauncher.openURL(HELP_PAGE_ROOT + id.getPath());
            }
            catch (IOException iOException) {}
        } else {
            ClassLoader cl = Desktop.class.getClassLoader();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)"help/help");
            HelpSet hs = new HelpSet(cl, url);
            if (hb == null) {
                hb = hs.createHelpBroker();
            }
            try {
                hb.setCurrentID(id.getId());
            }
            catch (BadIDException bad) {
                System.out.println("Bad help link: " + id.getId() + ": must match a target in help.jhm");
                throw bad;
            }
            Point p = hb.getLocation();
            hb.setLocation(p);
            hb.setDisplayed(true);
        }
    }

    public static void showHelpWindow() throws HelpSetException {
        Help.showHelpWindow(HelpId.Home);
    }

    public static enum HelpId {
        Home("home", "help.html"),
        SequenceFeatureSettings("seqfeatures.settings", "html/features/featuresettings.html"),
        StructureViewer("viewingpdbs", "html/features/viewingpdbs.html"),
        PdbFts("pdbfts", "html/features/pdbsequencefetcher.html#pdbfts"),
        UniprotFts("uniprotfts", "html/features/uniprotsequencefetcher.html#uniprotfts");

        private String id;
        private String path;

        private HelpId(String hepLoc, String htmlPath) {
            this.id = hepLoc;
            this.path = htmlPath;
        }

        String getId() {
            return this.id;
        }

        String getPath() {
            return this.path;
        }
    }
}

