/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewControllerGuiI;
import jalview.api.AlignViewportI;
import jalview.api.FeatureColourI;
import jalview.api.FeatureSettingsControllerI;
import jalview.api.SplitContainerI;
import jalview.api.ViewStyleI;
import jalview.controller.FeatureSettingsControllerGuiI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.FeatureMatcher;
import jalview.datamodel.features.FeatureMatcherI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.FeatureIcon;
import jalview.gui.FeatureRenderer;
import jalview.gui.FeatureTypeSettings;
import jalview.gui.Help;
import jalview.gui.JalviewColourChooser;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.project.Jalview2XML;
import jalview.schemes.FeatureColour;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.QuickSort;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import jalview.viewmodel.styles.ViewStyle;
import jalview.xml.binding.jalview.FeatureMatcherSet;
import jalview.xml.binding.jalview.JalviewUserColours;
import jalview.xml.binding.jalview.ObjectFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.help.HelpSetException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class FeatureSettings
extends JPanel
implements FeatureSettingsControllerI,
FeatureSettingsControllerGuiI {
    private static final String SEQUENCE_FEATURE_COLOURS = MessageManager.getString("label.sequence_feature_colours");
    static final int TYPE_COLUMN = 0;
    static final int COLOUR_COLUMN = 1;
    static final int FILTER_COLUMN = 2;
    static final int SHOW_COLUMN = 3;
    private static final int COLUMN_COUNT = 4;
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 400;
    private static final String BASE_TOOLTIP = MessageManager.getString("label.click_to_edit");
    final FeatureRenderer fr;
    public final AlignFrame af;
    Object[][] originalData;
    private float originalTransparency;
    private ViewStyleI originalViewStyle;
    private Map<String, FeatureMatcherSetI> originalFilters;
    final JInternalFrame frame;
    JScrollPane scrollPane = new JScrollPane();
    JTable table;
    JPanel groupPanel;
    JSlider transparency = new JSlider();
    private JCheckBox showComplementOnTop;
    private JCheckBox showComplement;
    protected volatile boolean inConstruction = true;
    int selectedRow = -1;
    boolean resettingTable = false;
    private boolean handlingUpdate = false;
    private PropertyChangeListener change;
    Map<String, float[]> typeWidth = null;

    private void storeOriginalSettings() {
        this.originalTransparency = this.fr.getTransparency();
        this.updateTransparencySliderFromFR();
        this.originalFilters = new HashMap<String, FeatureMatcherSetI>(this.fr.getFeatureFilters());
        this.originalViewStyle = new ViewStyle(this.af.viewport.getViewStyle());
    }

    private void updateTransparencySliderFromFR() {
        boolean incon = this.inConstruction;
        this.inConstruction = true;
        int transparencyAsPercent = (int)(this.fr.getTransparency() * 100.0f);
        this.transparency.setValue(100 - transparencyAsPercent);
        this.inConstruction = incon;
    }

    public FeatureSettings(AlignFrame alignFrame) {
        this.af = alignFrame;
        this.fr = this.af.getFeatureRenderer();
        this.storeOriginalSettings();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.table = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                int column = FeatureSettings.this.table.columnAtPoint(e.getPoint());
                int row = FeatureSettings.this.table.rowAtPoint(e.getPoint());
                switch (column) {
                    case 0: {
                        tip = JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.feature_settings_click_drag"));
                        break;
                    }
                    case 1: {
                        FeatureColourI colour = (FeatureColourI)FeatureSettings.this.table.getValueAt(row, column);
                        tip = FeatureSettings.getColorTooltip(colour, true);
                        break;
                    }
                    case 2: {
                        jalview.datamodel.features.FeatureMatcherSet o = (jalview.datamodel.features.FeatureMatcherSet)FeatureSettings.this.table.getValueAt(row, column);
                        tip = o.isEmpty() ? MessageManager.getString("label.configure_feature_tooltip") : o.toString();
                        break;
                    }
                }
                return tip;
            }

            @Override
            public Point getToolTipLocation(MouseEvent e) {
                Point point = e.getPoint();
                int column = FeatureSettings.this.table.columnAtPoint(point);
                int row = FeatureSettings.this.table.rowAtPoint(point);
                Rectangle r = this.getCellRect(row, column, false);
                Point loc = new Point(r.x + r.width / 2, r.y + r.height - 3);
                return loc;
            }
        };
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.setFont(new Font("Verdana", 0, 12));
        tableHeader.setReorderingAllowed(false);
        this.table.setFont(new Font("Verdana", 0, 12));
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this.table.setDefaultEditor(FeatureColour.class, new ColorEditor());
        this.table.setDefaultRenderer(FeatureColour.class, new ColorRenderer());
        this.table.setDefaultEditor(jalview.datamodel.features.FeatureMatcherSet.class, new FilterEditor());
        this.table.setDefaultRenderer(jalview.datamodel.features.FeatureMatcherSet.class, new FilterRenderer());
        TableColumn colourColumn = new TableColumn(1, 75, new ColorRenderer(), new ColorEditor());
        this.table.addColumn(colourColumn);
        TableColumn filterColumn = new TableColumn(2, 75, new FilterRenderer(), new FilterEditor());
        this.table.addColumn(filterColumn);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Point pt = evt.getPoint();
                FeatureSettings.this.selectedRow = FeatureSettings.this.table.rowAtPoint(pt);
                String type = (String)FeatureSettings.this.table.getValueAt(FeatureSettings.this.selectedRow, 0);
                if (evt.isPopupTrigger()) {
                    Object colour = FeatureSettings.this.table.getValueAt(FeatureSettings.this.selectedRow, 1);
                    FeatureSettings.this.showPopupMenu(FeatureSettings.this.selectedRow, type, colour, evt.getPoint());
                } else if (evt.getClickCount() == 2 && FeatureSettings.this.table.columnAtPoint(pt) == 0) {
                    boolean invertSelection = evt.isAltDown();
                    boolean toggleSelection = Platform.isControlDown(evt);
                    boolean extendSelection = evt.isShiftDown();
                    FeatureSettings.this.fr.ap.alignFrame.avc.markColumnsContainingFeatures(invertSelection, extendSelection, toggleSelection, type);
                    FeatureSettings.this.fr.ap.av.sendSelection();
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                FeatureSettings.this.selectedRow = FeatureSettings.this.table.rowAtPoint(evt.getPoint());
                if (evt.isPopupTrigger()) {
                    String type = (String)FeatureSettings.this.table.getValueAt(FeatureSettings.this.selectedRow, 0);
                    Object colour = FeatureSettings.this.table.getValueAt(FeatureSettings.this.selectedRow, 1);
                    FeatureSettings.this.showPopupMenu(FeatureSettings.this.selectedRow, type, colour, evt.getPoint());
                }
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                int newRow = FeatureSettings.this.table.rowAtPoint(evt.getPoint());
                if (newRow != FeatureSettings.this.selectedRow && FeatureSettings.this.selectedRow != -1 && newRow != -1) {
                    Object[][] data = ((FeatureTableModel)FeatureSettings.this.table.getModel()).getData();
                    int direction = newRow < FeatureSettings.this.selectedRow ? -1 : 1;
                    for (int i = FeatureSettings.this.selectedRow; i != newRow; i += direction) {
                        Object[] temp = data[i];
                        data[i] = data[i + direction];
                        data[i + direction] = temp;
                    }
                    FeatureSettings.this.updateFeatureRenderer(data);
                    FeatureSettings.this.table.repaint();
                    FeatureSettings.this.selectedRow = newRow;
                }
            }
        });
        this.scrollPane.setViewportView(this.table);
        if (this.af.getViewport().isShowSequenceFeatures() || !this.fr.hasRenderOrder()) {
            this.fr.findAllFeatures(true);
        }
        this.discoverAllFeatureData();
        final FeatureSettings fs = this;
        this.change = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!fs.resettingTable && !fs.handlingUpdate) {
                    fs.handlingUpdate = true;
                    fs.resetTable(null);
                    fs.handlingUpdate = false;
                }
            }
        };
        this.fr.addPropertyChangeListener(this.change);
        SplitContainerI splitframe = this.af.getSplitViewContainer();
        if (splitframe != null) {
            this.frame = null;
            splitframe.addFeatureSettingsUI(this);
        } else {
            this.frame = new JInternalFrame();
            this.frame.setContentPane(this);
            Rectangle bounds = this.af.getFeatureSettingsGeometry();
            String title = this.af.getAlignPanels().size() > 1 || Desktop.getAlignmentPanels(this.af.alignPanel.av.getSequenceSetId()).length > 1 ? MessageManager.formatMessage("label.sequence_feature_settings_for_view", this.af.alignPanel.getViewName()) : MessageManager.getString("label.sequence_feature_settings");
            if (bounds == null) {
                if (Platform.isAMacAndNotJS()) {
                    Desktop.addInternalFrame(this.frame, title, 600, 480);
                } else {
                    Desktop.addInternalFrame(this.frame, title, 600, 450);
                }
            } else {
                Desktop.addInternalFrame(this.frame, title, false, bounds.width, bounds.height);
                this.frame.setBounds(bounds);
                this.frame.setVisible(true);
            }
            this.frame.setMinimumSize(new Dimension(400, 400));
            this.frame.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent evt) {
                    FeatureSettings.this.featureSettings_isClosed();
                }
            });
            this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        }
        this.inConstruction = false;
    }

    private void updateComplementButtons() {
        this.showComplement.setSelected(this.af.getViewport().isShowComplementFeatures());
        this.showComplementOnTop.setSelected(this.af.getViewport().isShowComplementFeaturesOnTop());
    }

    @Override
    public AlignViewControllerGuiI getAlignframe() {
        return this.af;
    }

    @Override
    public void featureSettings_isClosed() {
        this.fr.removePropertyChangeListener(this.change);
        this.change = null;
    }

    protected void showPopupMenu(final int rowSelected, final String type, Object typeCol, Point pt) {
        final JPopupMenu men = new JPopupMenu(MessageManager.formatMessage("label.settings_for_param", new String[]{type}));
        final FeatureColourI featureColour = (FeatureColourI)typeCol;
        final JCheckBoxMenuItem variableColourCB = new JCheckBoxMenuItem(MessageManager.getString("label.variable_colour"));
        variableColourCB.setSelected(!featureColour.isSimpleColour());
        men.add(variableColourCB);
        variableColourCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == variableColourCB) {
                    men.setVisible(true);
                    men.setVisible(false);
                    if (featureColour.isSimpleColour()) {
                        FeatureTypeSettings fc = new FeatureTypeSettings(FeatureSettings.this.fr, type);
                        fc.addActionListener(this);
                    } else {
                        String title = MessageManager.formatMessage("label.select_colour_for", type);
                        JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

                            @Override
                            public void colourSelected(Color c) {
                                FeatureSettings.this.table.setValueAt(new FeatureColour(c), rowSelected, 1);
                                FeatureSettings.this.table.validate();
                                FeatureSettings.this.updateFeatureRenderer(((FeatureTableModel)FeatureSettings.this.table.getModel()).getData(), false);
                            }
                        };
                        JalviewColourChooser.showColourChooser(FeatureSettings.this, title, featureColour.getMaxColour(), listener);
                    }
                } else if (e.getSource() instanceof FeatureTypeSettings) {
                    FeatureColourI fci = FeatureSettings.this.fr.getFeatureColours().get(type);
                    FeatureSettings.this.table.setValueAt(fci, rowSelected, 1);
                }
            }
        });
        men.addSeparator();
        JMenuItem scr = new JMenuItem(MessageManager.getString("label.sort_by_score"));
        men.add(scr);
        scr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.sortByScore(Arrays.asList(type));
            }
        });
        JMenuItem dens = new JMenuItem(MessageManager.getString("label.sort_by_density"));
        dens.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.sortByDensity(Arrays.asList(type));
            }
        });
        men.add(dens);
        JMenuItem selCols = new JMenuItem(MessageManager.getString("label.select_columns_containing"));
        selCols.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FeatureSettings.this.fr.ap.alignFrame.avc.markColumnsContainingFeatures(false, false, false, type);
                FeatureSettings.this.fr.ap.av.sendSelection();
            }
        });
        JMenuItem clearCols = new JMenuItem(MessageManager.getString("label.select_columns_not_containing"));
        clearCols.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FeatureSettings.this.fr.ap.alignFrame.avc.markColumnsContainingFeatures(true, false, false, type);
                FeatureSettings.this.fr.ap.av.sendSelection();
            }
        });
        JMenuItem hideCols = new JMenuItem(MessageManager.getString("label.hide_columns_containing"));
        hideCols.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FeatureSettings.this.fr.ap.alignFrame.hideFeatureColumns(type, true);
                FeatureSettings.this.fr.ap.av.sendSelection();
            }
        });
        JMenuItem hideOtherCols = new JMenuItem(MessageManager.getString("label.hide_columns_not_containing"));
        hideOtherCols.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FeatureSettings.this.fr.ap.alignFrame.hideFeatureColumns(type, false);
                FeatureSettings.this.fr.ap.av.sendSelection();
            }
        });
        men.add(selCols);
        men.add(clearCols);
        men.add(hideCols);
        men.add(hideOtherCols);
        men.show(this.table, pt.x, pt.y);
    }

    protected void sortByDensity(List<String> featureTypes) {
        this.af.avc.sortAlignmentByFeatureDensity(featureTypes);
    }

    protected void sortByScore(List<String> featureTypes) {
        this.af.avc.sortAlignmentByFeatureScore(featureTypes);
    }

    private boolean canSortBy(String title) {
        if (this.fr.getDisplayedFeatureTypes().isEmpty()) {
            JvOptionPane.showMessageDialog((Component)this, MessageManager.getString("label.no_features_to_sort_by"), title, 0);
            return false;
        }
        return true;
    }

    @Override
    public synchronized void discoverAllFeatureData() {
        HashSet<String> allGroups = new HashSet<String>();
        AlignmentI alignment = this.af.getViewport().getAlignment();
        for (int i = 0; i < alignment.getHeight(); ++i) {
            SequenceI seq = alignment.getSequenceAt(i);
            for (String group : seq.getFeatures().getFeatureGroups(true, new String[0])) {
                if (group == null || allGroups.contains(group)) continue;
                allGroups.add(group);
                this.checkGroupState(group);
            }
        }
        this.resetTable(null);
        this.validate();
    }

    private boolean checkGroupState(String group) {
        boolean visible = this.fr.checkGroupVisibility(group, true);
        for (int g = 0; g < this.groupPanel.getComponentCount(); ++g) {
            if (!((JCheckBox)this.groupPanel.getComponent(g)).getText().equals(group)) continue;
            ((JCheckBox)this.groupPanel.getComponent(g)).setSelected(visible);
            return visible;
        }
        final String grp = group;
        final JCheckBox check = new JCheckBox(group, visible);
        check.setFont(new Font("Serif", 1, 12));
        check.setToolTipText(group);
        check.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FeatureSettings.this.fr.setGroupVisibility(check.getText(), check.isSelected());
                FeatureSettings.this.resetTable(new String[]{grp});
                FeatureSettings.this.refreshDisplay();
            }
        });
        this.groupPanel.add(check);
        return visible;
    }

    synchronized void resetTable(String[] groupChanged) {
        if (this.resettingTable) {
            return;
        }
        this.resettingTable = true;
        this.typeWidth = new Hashtable<String, float[]>();
        HashSet<String> displayableTypes = new HashSet<String>();
        HashSet<String> foundGroups = new HashSet<String>();
        for (int i = 0; i < this.af.getViewport().getAlignment().getHeight(); ++i) {
            SequenceI seq = this.af.getViewport().getAlignment().getSequenceAt(i);
            Set<String> groups = seq.getFeatures().getFeatureGroups(true, new String[0]);
            HashSet<String> visibleGroups = new HashSet<String>();
            for (String string : groups) {
                if (string != null && !this.checkGroupState(string)) continue;
                visibleGroups.add(string);
            }
            foundGroups.addAll(groups);
            Set<String> types = seq.getFeatures().getFeatureTypesForGroups(true, visibleGroups.toArray(new String[visibleGroups.size()]));
            for (String type : types) {
                displayableTypes.add(type);
                float[] avWidth = this.typeWidth.get(type);
                if (avWidth == null) {
                    avWidth = new float[2];
                    this.typeWidth.put(type, avWidth);
                }
                avWidth[0] = avWidth[0] + (float)seq.getFeatures().getFeatureCount(true, type);
                avWidth[1] = avWidth[1] + (float)seq.getFeatures().getTotalFeatureLength(type);
            }
        }
        Object[][] data = new Object[displayableTypes.size()][4];
        int dataIndex = 0;
        if (this.fr.hasRenderOrder()) {
            if (!this.handlingUpdate) {
                this.fr.findAllFeatures(groupChanged != null);
            }
            List<String> frl = this.fr.getRenderOrder();
            for (int ro = frl.size() - 1; ro > -1; --ro) {
                String type = frl.get(ro);
                if (!displayableTypes.contains(type)) continue;
                data[dataIndex][0] = type;
                data[dataIndex][1] = this.fr.getFeatureStyle(type);
                FeatureMatcherSetI featureMatcherSetI = this.fr.getFeatureFilter(type);
                data[dataIndex][2] = featureMatcherSetI == null ? new jalview.datamodel.features.FeatureMatcherSet() : featureMatcherSetI;
                data[dataIndex][3] = this.af.getViewport().getFeaturesDisplayed().isVisible(type);
                ++dataIndex;
                displayableTypes.remove(type);
            }
        }
        while (!displayableTypes.isEmpty()) {
            String type = (String)displayableTypes.iterator().next();
            data[dataIndex][0] = type;
            data[dataIndex][1] = this.fr.getFeatureStyle(type);
            if (data[dataIndex][1] == null) {
                this.fr.clearRenderOrder();
                return;
            }
            FeatureMatcherSetI featureFilter = this.fr.getFeatureFilter(type);
            data[dataIndex][2] = featureFilter == null ? new jalview.datamodel.features.FeatureMatcherSet() : featureFilter;
            data[dataIndex][3] = true;
            ++dataIndex;
            displayableTypes.remove(type);
        }
        if (this.originalData == null) {
            this.originalData = new Object[data.length][4];
            for (int i = 0; i < data.length; ++i) {
                System.arraycopy(data[i], 0, this.originalData[i], 0, 4);
            }
        } else {
            this.updateOriginalData(data);
        }
        this.table.setModel(new FeatureTableModel(data));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.groupPanel.setLayout(new GridLayout(this.fr.getFeatureGroupsSize() / 4 + 1, 4));
        this.pruneGroups(foundGroups);
        this.groupPanel.validate();
        this.updateFeatureRenderer(data, groupChanged != null);
        this.resettingTable = false;
    }

    protected void updateOriginalData(Object[][] foundData) {
        Object[][] currentData = ((FeatureTableModel)this.table.getModel()).getData();
        for (Object[] row : foundData) {
            String type = (String)row[0];
            boolean found = false;
            block1: for (Object[] current : currentData) {
                if (!type.equals(current[0])) continue;
                found = true;
                if (row[1].equals(current[1])) break;
                for (Object[] original : this.originalData) {
                    if (!type.equals(original[0])) continue;
                    original[1] = row[1];
                    break block1;
                }
                break;
            }
            if (found) continue;
            Object[][] newData = new Object[this.originalData.length + 1][4];
            for (int i = 0; i < this.originalData.length; ++i) {
                System.arraycopy(this.originalData[i], 0, newData[i + 1], 0, 4);
            }
            newData[0] = row;
            this.originalData = newData;
        }
    }

    protected void pruneGroups(Set<String> foundGroups) {
        for (int g = 0; g < this.groupPanel.getComponentCount(); ++g) {
            JCheckBox checkbox = (JCheckBox)this.groupPanel.getComponent(g);
            if (foundGroups.contains(checkbox.getText())) continue;
            this.groupPanel.remove(checkbox);
        }
    }

    private void ensureOrder(Object[][] data) {
        boolean sort = false;
        float[] order = new float[data.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = this.fr.getOrder(data[i][0].toString());
            if (order[i] < 0.0f) {
                order[i] = this.fr.setOrder(data[i][0].toString(), i / order.length);
            }
            if (i <= 1) continue;
            sort = sort || order[i - 1] > order[i];
        }
        if (sort) {
            QuickSort.sort(order, (Object[])data);
        }
    }

    void load() {
        final JalviewFileChooser chooser = new JalviewFileChooser("fc", SEQUENCE_FEATURE_COLOURS);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.load_feature_colours"));
        chooser.setToolTipText(MessageManager.getString("action.load"));
        chooser.setResponseHandler(0, new Runnable(){

            @Override
            public void run() {
                File file = chooser.getSelectedFile();
                FeatureSettings.this.load(file);
            }
        });
        chooser.showOpenDialog(this);
    }

    void load(File file) {
        try {
            int i;
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            JAXBContext jc = JAXBContext.newInstance((String)"jalview.xml.binding.jalview");
            Unmarshaller um = jc.createUnmarshaller();
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            JAXBElement jbe = um.unmarshal(streamReader, JalviewUserColours.class);
            JalviewUserColours jucs = (JalviewUserColours)jbe.getValue();
            for (i = jucs.getColour().size() - 1; i >= 0; --i) {
                JalviewUserColours.Colour newcol = jucs.getColour().get(i);
                FeatureColourI colour = Jalview2XML.parseColour(newcol);
                this.fr.setColour(newcol.getName(), colour);
                this.fr.setOrder(newcol.getName(), (float)i / (float)jucs.getColour().size());
            }
            for (i = 0; i < jucs.getFilter().size(); ++i) {
                JalviewUserColours.Filter filterModel = jucs.getFilter().get(i);
                String featureType = filterModel.getFeatureType();
                FeatureMatcherSetI filter = Jalview2XML.parseFilter(featureType, filterModel.getMatcherSet());
                if (filter.isEmpty()) continue;
                this.fr.setFeatureFilter(featureType, filter);
            }
            if (this.table != null) {
                this.resetTable(null);
                Object[][] data = ((FeatureTableModel)this.table.getModel()).getData();
                this.ensureOrder(data);
                this.updateFeatureRenderer(data, false);
                this.table.repaint();
            }
        }
        catch (Exception ex) {
            System.out.println("Error loading User Colour File\n" + ex);
        }
    }

    void save() {
        JalviewFileChooser chooser = new JalviewFileChooser("fc", SEQUENCE_FEATURE_COLOURS);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.save_feature_colours"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            File file = chooser.getSelectedFile();
            this.save(file);
        }
    }

    void save(File file) {
        JalviewUserColours ucs = new JalviewUserColours();
        ucs.setSchemeName("Sequence Features");
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            Set<String> fr_colours = this.fr.getAllFeatureColours();
            String[] sortedTypes = fr_colours.toArray(new String[fr_colours.size()]);
            Arrays.sort(sortedTypes, new Comparator<String>(){

                @Override
                public int compare(String type1, String type2) {
                    return Float.compare(FeatureSettings.this.fr.getOrder(type1), FeatureSettings.this.fr.getOrder(type2));
                }
            });
            for (String featureType : sortedTypes) {
                FeatureColourI fcol = this.fr.getFeatureStyle(featureType);
                JalviewUserColours.Colour col = Jalview2XML.marshalColour(featureType, fcol);
                ucs.getColour().add(col);
            }
            for (String featureType : sortedTypes) {
                FeatureMatcherSetI filter = this.fr.getFeatureFilter(featureType);
                if (filter == null || filter.isEmpty()) continue;
                Iterator<FeatureMatcherI> iterator = filter.getMatchers().iterator();
                FeatureMatcherI firstMatcher = iterator.next();
                FeatureMatcherSet ms = Jalview2XML.marshalFilter(firstMatcher, iterator, filter.isAnded());
                JalviewUserColours.Filter filterModel = new JalviewUserColours.Filter();
                filterModel.setFeatureType(featureType);
                filterModel.setMatcherSet(ms);
                ucs.getFilter().add(filterModel);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{JalviewUserColours.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.marshal(new ObjectFactory().createJalviewUserColours(ucs), (Writer)out);
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void invertSelection() {
        Object[][] data = ((FeatureTableModel)this.table.getModel()).getData();
        for (int i = 0; i < data.length; ++i) {
            data[i][3] = (Boolean)data[i][3] == false;
        }
        this.updateFeatureRenderer(data, true);
        this.table.repaint();
    }

    public void orderByAvWidth() {
        if (this.table == null || this.table.getModel() == null) {
            return;
        }
        Object[][] data = ((FeatureTableModel)this.table.getModel()).getData();
        float[] width = new float[data.length];
        float max = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            float[] awidth = this.typeWidth.get(data[i][0]);
            width[i] = awidth[0] > 0.0f ? awidth[1] / awidth[0] : 0.0f;
            if (!(max < width[i])) continue;
            max = width[i];
        }
        boolean sort = false;
        for (int i = 0; i < width.length; ++i) {
            if (width[i] == 0.0f) {
                width[i] = this.fr.getOrder(data[i][0].toString());
                if (width[i] < 0.0f) {
                    width[i] = this.fr.setOrder(data[i][0].toString(), i / data.length);
                }
            } else {
                int n = i;
                width[n] = width[n] / max;
                this.fr.setOrder(data[i][0].toString(), width[i]);
            }
            if (i <= 0) continue;
            sort = sort || width[i - 1] > width[i];
        }
        if (sort) {
            QuickSort.sort(width, (Object[])data);
        }
        this.updateFeatureRenderer(data, false);
        this.table.repaint();
    }

    public void closeOldSettings() {
        this.closeDialog(false);
    }

    public void close() {
        this.closeDialog(true);
    }

    private void closeDialog(boolean closeContainingFrame) {
        try {
            if (this.frame != null) {
                this.af.setFeatureSettingsGeometry(this.frame.getBounds());
                this.frame.setClosed(true);
            } else {
                SplitContainerI sc = this.af.getSplitViewContainer();
                sc.closeFeatureSettings(this, closeContainingFrame);
                this.af.featureSettings = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateFeatureRenderer(Object[][] data) {
        this.updateFeatureRenderer(data, true);
    }

    void updateFeatureRenderer(Object[][] data, boolean visibleNew) {
        FeatureRendererModel.FeatureSettingsBean[] rowData = this.getTableAsBeans(data);
        if (this.fr.setFeaturePriority(rowData, visibleNew)) {
            this.refreshDisplay();
        }
    }

    private FeatureRendererModel.FeatureSettingsBean[] getTableAsBeans(Object[][] data) {
        FeatureRendererModel.FeatureSettingsBean[] rowData = new FeatureRendererModel.FeatureSettingsBean[data.length];
        for (int i = 0; i < data.length; ++i) {
            String type = (String)data[i][0];
            FeatureColourI colour = (FeatureColourI)data[i][1];
            FeatureMatcherSetI theFilter = (FeatureMatcherSetI)data[i][2];
            Boolean isShown = (Boolean)data[i][3];
            rowData[i] = new FeatureRendererModel.FeatureSettingsBean(type, colour, theFilter, isShown);
        }
        return rowData;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        final boolean hasComplement = this.af.getViewport().getCodingComplement() != null;
        JPanel settingsPane = new JPanel();
        settingsPane.setLayout(new BorderLayout());
        JPanel bigPanel = new JPanel();
        bigPanel.setLayout(new BorderLayout());
        this.groupPanel = new JPanel();
        bigPanel.add((Component)this.groupPanel, "North");
        JButton invert = new JButton(MessageManager.getString("label.invert_selection"));
        invert.setFont(JvSwingUtils.getLabelFont());
        invert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.invertSelection();
            }
        });
        JButton optimizeOrder = new JButton(MessageManager.getString("label.optimise_order"));
        optimizeOrder.setFont(JvSwingUtils.getLabelFont());
        optimizeOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.orderByAvWidth();
            }
        });
        final String byScoreLabel = MessageManager.getString("label.seq_sort_by_score");
        JButton sortByScore = new JButton(byScoreLabel);
        sortByScore.setFont(JvSwingUtils.getLabelFont());
        sortByScore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FeatureSettings.this.canSortBy(byScoreLabel)) {
                    FeatureSettings.this.sortByScore(null);
                }
            }
        });
        final String byDensityLabel = MessageManager.getString("label.sequence_sort_by_density");
        JButton sortByDens = new JButton(byDensityLabel);
        sortByDens.setFont(JvSwingUtils.getLabelFont());
        sortByDens.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FeatureSettings.this.canSortBy(byDensityLabel)) {
                    FeatureSettings.this.sortByDensity(null);
                }
            }
        });
        JButton help = new JButton(MessageManager.getString("action.help"));
        help.setFont(JvSwingUtils.getLabelFont());
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Help.showHelpWindow(Help.HelpId.SequenceFeatureSettings);
                }
                catch (HelpSetException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JButton cancel = new JButton(MessageManager.getString(hasComplement ? "action.revert" : "action.cancel"));
        cancel.setToolTipText(MessageManager.getString(hasComplement ? "action.undo_changes_to_feature_settings" : "action.undo_changes_to_feature_settings_and_close_the_dialog"));
        cancel.setFont(JvSwingUtils.getLabelFont());
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.revert();
                FeatureSettings.this.refreshDisplay();
                if (!hasComplement) {
                    FeatureSettings.this.close();
                }
            }
        });
        JButton ok = new JButton(MessageManager.getString(hasComplement ? "action.apply" : "action.ok"));
        ok.setFont(JvSwingUtils.getLabelFont());
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!hasComplement) {
                    FeatureSettings.this.close();
                } else {
                    FeatureSettings.this.storeOriginalSettings();
                }
            }
        });
        JButton loadColours = new JButton(MessageManager.getString("label.load_colours"));
        loadColours.setFont(JvSwingUtils.getLabelFont());
        loadColours.setToolTipText(MessageManager.getString("label.load_colours_tooltip"));
        loadColours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.load();
            }
        });
        JButton saveColours = new JButton(MessageManager.getString("label.save_colours"));
        saveColours.setFont(JvSwingUtils.getLabelFont());
        saveColours.setToolTipText(MessageManager.getString("label.save_colours_tooltip"));
        saveColours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.save();
            }
        });
        this.transparency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (!FeatureSettings.this.inConstruction) {
                    FeatureSettings.this.fr.setTransparency((float)(100 - FeatureSettings.this.transparency.getValue()) / 100.0f);
                    FeatureSettings.this.refreshDisplay();
                }
            }
        });
        this.transparency.setMaximum(70);
        this.transparency.setToolTipText(MessageManager.getString("label.transparency_tip"));
        boolean nucleotide = this.af.getViewport().getAlignment().isNucleotide();
        String text = MessageManager.formatMessage("label.show_linked_features", nucleotide ? MessageManager.getString("label.protein").toLowerCase() : "CDS");
        this.showComplement = new JCheckBox(text);
        this.showComplement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.af.getViewport().setShowComplementFeatures(FeatureSettings.this.showComplement.isSelected());
                FeatureSettings.this.refreshDisplay();
            }
        });
        this.showComplementOnTop = new JCheckBox(MessageManager.getString("label.on_top"));
        this.showComplementOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.af.getViewport().setShowComplementFeaturesOnTop(FeatureSettings.this.showComplementOnTop.isSelected());
                FeatureSettings.this.refreshDisplay();
            }
        });
        this.updateComplementButtons();
        JPanel lowerPanel = new JPanel(new GridLayout(1, 2));
        bigPanel.add((Component)lowerPanel, "South");
        JPanel transbuttons = new JPanel(new GridLayout(5, 1));
        transbuttons.add(optimizeOrder);
        transbuttons.add(invert);
        transbuttons.add(sortByScore);
        transbuttons.add(sortByDens);
        transbuttons.add(help);
        JPanel transPanelLeft = new JPanel(new GridLayout(hasComplement ? 4 : 2, 1));
        transPanelLeft.add(new JLabel(" Colour transparency:"));
        transPanelLeft.add(this.transparency);
        if (hasComplement) {
            JPanel cp = new JPanel(new FlowLayout(0));
            cp.add(this.showComplement);
            cp.add(this.showComplementOnTop);
            transPanelLeft.add(cp);
        }
        lowerPanel.add(transPanelLeft);
        lowerPanel.add(transbuttons);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        buttonPanel.add(loadColours);
        buttonPanel.add(saveColours);
        bigPanel.add((Component)this.scrollPane, "Center");
        settingsPane.add((Component)bigPanel, "Center");
        settingsPane.add((Component)buttonPanel, "South");
        this.add(settingsPane);
    }

    void refreshDisplay() {
        this.af.alignPanel.paintAlignment(true, true);
        AlignViewportI complement = this.af.getViewport().getCodingComplement();
        if (complement != null && complement.isShowComplementFeatures()) {
            AlignFrame af2 = Desktop.getAlignFrameFor(complement);
            af2.alignPanel.paintAlignment(true, true);
        }
    }

    public static String getColorTooltip(FeatureColourI fcol, boolean withHint) {
        if (fcol == null) {
            return null;
        }
        if (fcol.isSimpleColour()) {
            return withHint ? BASE_TOOLTIP : null;
        }
        String description = fcol.getDescription();
        description = description.replaceAll("<", "&lt;");
        description = description.replaceAll(">", "&gt;");
        StringBuilder tt = new StringBuilder(description);
        if (withHint) {
            tt.append("<br>").append(BASE_TOOLTIP).append("</br>");
        }
        return JvSwingUtils.wrapTooltip(true, tt.toString());
    }

    public static void renderGraduatedColor(JLabel comp, FeatureColourI gcol, int w, int h) {
        boolean thr = false;
        StringBuilder tx = new StringBuilder();
        if (gcol.isColourByAttribute()) {
            tx.append(FeatureMatcher.toAttributeDisplayName(gcol.getAttributeName()));
        } else if (!gcol.isColourByLabel()) {
            tx.append(MessageManager.getString("label.score"));
        }
        tx.append(" ");
        if (gcol.isAboveThreshold()) {
            thr = true;
            tx.append(">");
        }
        if (gcol.isBelowThreshold()) {
            thr = true;
            tx.append("<");
        }
        if (gcol.isColourByLabel()) {
            if (thr) {
                tx.append(" ");
            }
            if (!gcol.isColourByAttribute()) {
                tx.append("Label");
            }
            comp.setIcon(null);
        } else {
            Color newColor = gcol.getMaxColour();
            comp.setBackground(newColor);
            FeatureIcon ficon = new FeatureIcon(gcol, comp.getBackground(), w, h, thr);
            comp.setIcon(ficon);
        }
        comp.setHorizontalAlignment(0);
        comp.setText(tx.toString());
    }

    public static void renderGraduatedColor(JLabel comp, FeatureColourI gcol) {
        int w = comp.getWidth();
        int h = comp.getHeight();
        if (w < 20) {
            w = (int)comp.getPreferredSize().getWidth();
            h = (int)comp.getPreferredSize().getHeight();
            if (w < 20) {
                w = 80;
                h = 12;
            }
        }
        FeatureSettings.renderGraduatedColor(comp, gcol, w, h);
    }

    public boolean isOpen() {
        if (this.af.getSplitViewContainer() != null) {
            return this.af.getSplitViewContainer().isFeatureSettingsOpen();
        }
        return this.frame != null && !this.frame.isClosed();
    }

    @Override
    public void revert() {
        this.fr.setTransparency(this.originalTransparency);
        this.fr.setFeatureFilters(this.originalFilters);
        this.updateFeatureRenderer(this.originalData);
        this.af.getViewport().setViewStyle(this.originalViewStyle);
        this.updateTransparencySliderFromFR();
        this.updateComplementButtons();
        this.refreshDisplay();
    }

    class FilterEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        FeatureMatcherSetI currentFilter;
        Point lastLocation;
        String type;
        JButton button = new JButton();
        protected static final String EDIT = "edit";
        int rowSelected = 0;

        public FilterEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.button == e.getSource()) {
                FeatureTypeSettings chooser = new FeatureTypeSettings(FeatureSettings.this.fr, this.type);
                chooser.addActionListener(this);
                chooser.setRequestFocusEnabled(true);
                chooser.requestFocus();
                if (this.lastLocation != null) {
                    chooser.setBounds(this.lastLocation.x, this.lastLocation.y, chooser.getWidth(), chooser.getHeight());
                    chooser.validate();
                }
                this.fireEditingStopped();
            } else if (e.getSource() instanceof Component) {
                FeatureColourI currentColor = FeatureSettings.this.fr.getFeatureColours().get(this.type);
                this.currentFilter = FeatureSettings.this.fr.getFeatureFilter(this.type);
                if (this.currentFilter == null) {
                    this.currentFilter = new jalview.datamodel.features.FeatureMatcherSet();
                }
                Object[] data = ((FeatureTableModel)FeatureSettings.this.table.getModel()).getData()[this.rowSelected];
                data[1] = currentColor;
                data[2] = this.currentFilter;
                this.fireEditingStopped();
                FeatureSettings.this.table.validate();
                FeatureSettings.this.table.repaint();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentFilter;
        }

        @Override
        public Component getTableCellEditorComponent(JTable theTable, Object value, boolean isSelected, int row, int column) {
            this.currentFilter = (FeatureMatcherSetI)value;
            this.rowSelected = row;
            this.type = FeatureSettings.this.table.getValueAt(row, 0).toString();
            this.button.setOpaque(true);
            this.button.setBackground(FeatureSettings.this.getBackground());
            this.button.setText(this.currentFilter.toString());
            this.button.setIcon(null);
            return this.button;
        }
    }

    class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        FeatureColourI currentColor;
        FeatureTypeSettings chooser;
        String type;
        JButton button = new JButton();
        protected static final String EDIT = "edit";
        int rowSelected = 0;

        public ColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.button == e.getSource()) {
                if (this.currentColor.isSimpleColour()) {
                    String ttl = MessageManager.formatMessage("label.select_colour_for", this.type);
                    JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

                        @Override
                        public void colourSelected(Color c) {
                            ColorEditor.this.currentColor = new FeatureColour(c);
                            FeatureSettings.this.table.setValueAt(ColorEditor.this.currentColor, ColorEditor.this.rowSelected, 1);
                            ColorEditor.this.fireEditingStopped();
                        }

                        @Override
                        public void cancel() {
                            ColorEditor.this.fireEditingStopped();
                        }
                    };
                    JalviewColourChooser.showColourChooser(this.button, ttl, this.currentColor.getColour(), listener);
                } else {
                    this.chooser = new FeatureTypeSettings(FeatureSettings.this.fr, this.type);
                    if (!Platform.isJS()) {
                        this.chooser.setRequestFocusEnabled(true);
                        this.chooser.requestFocus();
                    }
                    this.chooser.addActionListener(this);
                    this.fireEditingStopped();
                }
            } else {
                this.currentColor = FeatureSettings.this.fr.getFeatureColours().get(this.type);
                FeatureMatcherSetI currentFilter = FeatureSettings.this.fr.getFeatureFilter(this.type);
                if (currentFilter == null) {
                    currentFilter = new jalview.datamodel.features.FeatureMatcherSet();
                }
                Object[] data = ((FeatureTableModel)FeatureSettings.this.table.getModel()).getData()[this.rowSelected];
                data[1] = this.currentColor;
                data[2] = currentFilter;
                this.fireEditingStopped();
                FeatureSettings.this.table.validate();
                FeatureSettings.this.table.repaint();
            }
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable theTable, Object value, boolean isSelected, int row, int column) {
            this.currentColor = (FeatureColourI)value;
            this.rowSelected = row;
            this.type = FeatureSettings.this.table.getValueAt(row, 0).toString();
            this.button.setOpaque(true);
            this.button.setBackground(FeatureSettings.this.getBackground());
            if (!this.currentColor.isSimpleColour()) {
                JLabel btn = new JLabel();
                btn.setSize(this.button.getSize());
                FeatureSettings.renderGraduatedColor(btn, this.currentColor);
                this.button.setBackground(btn.getBackground());
                this.button.setIcon(btn.getIcon());
                this.button.setText(btn.getText());
            } else {
                this.button.setText("");
                this.button.setIcon(null);
                this.button.setBackground(this.currentColor.getColour());
            }
            return this.button;
        }
    }

    class FilterRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;

        public FilterRenderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object filter, boolean isSelected, boolean hasFocus, int row, int column) {
            FeatureMatcherSetI theFilter = (FeatureMatcherSetI)filter;
            this.setOpaque(true);
            String asText = theFilter.toString();
            this.setBackground(tbl.getBackground());
            this.setText(asText);
            this.setIcon(null);
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, tbl.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, tbl.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
            return this;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;

        public ColorRenderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            FeatureColourI cellColour = (FeatureColourI)color;
            this.setOpaque(true);
            this.setBackground(tbl.getBackground());
            if (!cellColour.isSimpleColour()) {
                Rectangle cr = tbl.getCellRect(row, column, false);
                FeatureSettings.renderGraduatedColor(this, cellColour, (int)cr.getWidth(), (int)cr.getHeight());
            } else {
                this.setText("");
                this.setIcon(null);
                this.setBackground(cellColour.getColour());
            }
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, tbl.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, tbl.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
            return this;
        }
    }

    class FeatureTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{MessageManager.getString("label.feature_type"), MessageManager.getString("action.colour"), MessageManager.getString("label.configuration"), MessageManager.getString("label.show")};
        private Object[][] data;

        FeatureTableModel(Object[][] data) {
            this.data = data;
        }

        public Object[][] getData() {
            return this.data;
        }

        public void setData(Object[][] data) {
            this.data = data;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object[] getRow(int row) {
            return this.data[row];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return FeatureColour.class;
                }
                case 2: {
                    return jalview.datamodel.features.FeatureMatcherSet.class;
                }
            }
            return Boolean.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            FeatureSettings.this.updateFeatureRenderer(this.data);
        }
    }
}

