/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.ComplexAlignFile;
import jalview.api.FeatureSettingsModelI;
import jalview.api.FeaturesDisplayedI;
import jalview.api.FeaturesSourceI;
import jalview.bin.Cache;
import jalview.bin.Jalview;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.io.AlignmentFileReaderI;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormatException;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GCutAndPasteTransfer;
import jalview.json.binding.biojson.v1.ColourSchemeMapper;
import jalview.schemes.ColourSchemeI;
import jalview.util.MessageManager;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class CutAndPasteTransfer
extends GCutAndPasteTransfer {
    AlignmentViewPanel alignpanel;
    AlignViewportI viewport;
    AlignmentFileReaderI source = null;

    public CutAndPasteTransfer() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CutAndPasteTransfer.this.textarea.requestFocus();
            }
        });
    }

    public void setForInput(AlignmentViewPanel viewpanel) {
        this.alignpanel = viewpanel;
        if (this.alignpanel != null) {
            this.viewport = this.alignpanel.getAlignViewport();
        }
        if (this.viewport != null) {
            this.ok.setText(MessageManager.getString("action.add"));
        }
        this.getContentPane().add((Component)this.inputButtonPanel, "South");
    }

    public String getText() {
        return this.textarea.getText();
    }

    public void setText(String text) {
        this.textarea.setText(text);
    }

    public void appendText(String text) {
        this.textarea.append(text);
    }

    @Override
    public void save_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.save_text_to_file"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(chooser.getSelectedFile()));
                out.print(this.getText());
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void copyItem_actionPerformed(ActionEvent e) {
        this.textarea.getSelectedText();
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        c.setContents(new StringSelection(this.textarea.getSelectedText()), null);
    }

    @Override
    public void pasteMenu_actionPerformed(ActionEvent e) {
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = c.getContents(this);
        if (contents == null) {
            return;
        }
        try {
            this.textarea.append((String)contents.getTransferData(DataFlavor.stringFlavor));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ok_actionPerformed(ActionEvent e) {
        String text = this.getText();
        if (text.trim().length() < 1) {
            return;
        }
        FileFormatI format = null;
        try {
            format = new IdentifyFile().identify(text, DataSourceType.PASTE);
        }
        catch (FileFormatException fileFormatException) {
            // empty catch block
        }
        if (format == null) {
            System.err.println(MessageManager.getString("label.couldnt_read_data"));
            if (!Jalview.isHeadlessMode()) {
                JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, AppletFormatAdapter.getSupportedFormats(), MessageManager.getString("label.couldnt_read_data"), 2);
            }
            return;
        }
        AlignmentI al = null;
        try {
            FormatAdapter fa = new FormatAdapter(this.alignpanel);
            al = fa.readFile(this.getText(), DataSourceType.PASTE, format);
            this.source = fa.getAlignFile();
        }
        catch (IOException ex) {
            JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.couldnt_read_pasted_text", new String[]{ex.toString()}), MessageManager.getString("label.error_parsing_text"), 2);
        }
        if (al != null && al.hasValidSequence()) {
            String title = MessageManager.formatMessage("label.input_cut_paste_params", new String[]{format.getName()});
            FeatureSettingsModelI proxyColourScheme = this.source.getFeatureColourScheme();
            if (this.viewport != null && this.viewport.getAlignment() != null) {
                if (proxyColourScheme != null) {
                    this.viewport.applyFeaturesStyle(proxyColourScheme);
                }
                ((AlignViewport)this.viewport).addAlignment(al, title);
            } else {
                AlignFrame af;
                if (this.source instanceof ComplexAlignFile) {
                    HiddenColumns hidden = ((ComplexAlignFile)((Object)this.source)).getHiddenColumns();
                    SequenceI[] hiddenSeqs = ((ComplexAlignFile)((Object)this.source)).getHiddenSequences();
                    boolean showSeqFeatures = ((ComplexAlignFile)((Object)this.source)).isShowSeqFeatures();
                    String colourSchemeName = ((ComplexAlignFile)((Object)this.source)).getGlobalColourScheme();
                    FeaturesDisplayedI fd = ((ComplexAlignFile)((Object)this.source)).getDisplayedFeatures();
                    af = new AlignFrame(al, hiddenSeqs, hidden, 700, 500);
                    af.getViewport().setShowSequenceFeatures(showSeqFeatures);
                    af.getViewport().setFeaturesDisplayed(fd);
                    af.setMenusForViewport();
                    ColourSchemeI cs = ColourSchemeMapper.getJalviewColourScheme(colourSchemeName, al);
                    if (cs != null) {
                        af.changeColour(cs);
                    }
                } else {
                    af = new AlignFrame(al, 700, 500);
                    if (this.source instanceof FeaturesSourceI) {
                        af.getViewport().setShowSequenceFeatures(true);
                    }
                }
                if (proxyColourScheme != null) {
                    af.getViewport().applyFeaturesStyle(proxyColourScheme);
                }
                af.currentFileFormat = format;
                Desktop.addInternalFrame(af, title, 700, 500);
                af.setStatus(MessageManager.getString("label.successfully_pasted_alignment_file"));
                try {
                    af.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
                }
                catch (Exception exception) {}
            }
        } else {
            System.err.println(MessageManager.getString("label.couldnt_read_data"));
            if (!Jalview.isHeadlessMode()) {
                JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, AppletFormatAdapter.getSupportedFormats(), MessageManager.getString("label.couldnt_read_data"), 2);
            }
        }
    }

    @Override
    public void cancel_actionPerformed(ActionEvent e) {
        try {
            this.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void textarea_mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu(MessageManager.getString("action.edit"));
            JMenuItem item = new JMenuItem(MessageManager.getString("action.copy"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CutAndPasteTransfer.this.copyItem_actionPerformed(e);
                }
            });
            popup.add(item);
            item = new JMenuItem(MessageManager.getString("action.paste"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CutAndPasteTransfer.this.pasteMenu_actionPerformed(e);
                }
            });
            popup.add(item);
            popup.show(this, e.getX() + 10, e.getY() + this.textarea.getY() + 40);
        }
    }
}

