/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.jmol.JalviewJmolBinding;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.SeqPanel;
import jalview.gui.SequenceRenderer;
import jalview.io.DataSourceType;
import jalview.structure.StructureSelectionManager;
import jalview.util.BrowserLauncher;
import jalview.util.Platform;
import java.awt.Container;
import java.io.File;
import java.util.List;
import java.util.Map;
import javajs.util.BS;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolViewer;
import org.openscience.jmol.app.jmolpanel.console.AppConsole;

public class AppJmolBinding
extends JalviewJmolBinding {
    public AppJmolBinding(AppJmol appJmol, StructureSelectionManager sSm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        super(sSm, pdbentry, sequenceIs, protocol);
        this.setViewer(appJmol);
    }

    @Override
    public SequenceRenderer getSequenceRenderer(AlignmentViewPanel alignment) {
        return new SequenceRenderer(((AlignmentPanel)alignment).av);
    }

    @Override
    public void sendConsoleEcho(String strEcho) {
        if (this.console != null) {
            this.console.sendConsoleEcho(strEcho);
        }
    }

    @Override
    public void sendConsoleMessage(String strStatus) {
        if (this.console != null && strStatus != null) {
            this.console.sendConsoleMessage(strStatus);
        }
    }

    @Override
    public void showUrl(String url, String target) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception e) {
            Cache.log.error((Object)("Failed to launch Jmol-associated url " + url), (Throwable)e);
        }
    }

    @Override
    public void refreshGUI() {
        if (this.getMappedStructureCount() == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JalviewStructureDisplayI theViewer = AppJmolBinding.this.getViewer();
                theViewer.updateTitleAndMenus();
                ((JComponent)((Object)theViewer)).revalidate();
            }
        });
    }

    @Override
    public void notifyScriptTermination(String strStatus, int msWalltime) {
    }

    public void showUrl(String url) {
        this.showUrl(url, "jmol");
    }

    public void newJmolPopup(String menuName) {
    }

    @Override
    public void selectionChanged(BS arg0) {
    }

    @Override
    public void showConsole(boolean b) {
        this.getViewer().showConsole(b);
    }

    @Override
    protected JmolAppConsoleInterface createJmolConsole(Container consolePanel, String buttonsToShow) {
        this.jmolViewer.setJmolCallbackListener((JmolCallbackListener)this);
        return Platform.isJS() ? null : new AppConsole((JmolViewer)this.jmolViewer, consolePanel, buttonsToShow);
    }

    @Override
    protected void releaseUIResources() {
        this.setViewer(null);
        this.closeConsole();
    }

    @Override
    public void releaseReferences(Object svl) {
        if (svl instanceof SeqPanel) {
            this.getViewer().removeAlignmentPanel(((SeqPanel)svl).ap);
        }
    }

    public Map<String, Object> getJSpecViewProperty(String arg0) {
        return null;
    }

    public void cacheFiles(List<File> files) {
        if (files == null) {
            return;
        }
        for (File f : files) {
            Platform.cacheFileData(f);
        }
    }
}

