/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignSeq;
import jalview.analysis.AlignmentUtils;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.VisibleContigsIterator;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationExporter;
import jalview.gui.Desktop;
import jalview.gui.EditNameDialog;
import jalview.gui.PaintRefresher;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class AnnotationLabels
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final String HTML_END_TAG = "</html>";
    private static final String HTML_START_TAG = "<html>";
    private static final int HEIGHT_ADJUSTER_WIDTH = 50;
    private static int HEIGHT_ADJUSTER_HEIGHT = 10;
    private static final Font font = new Font("Arial", 0, 11);
    private static final String TOGGLE_LABELSCALE = MessageManager.getString("label.scale_label_to_column");
    private static final String ADDNEW = MessageManager.getString("label.add_new_row");
    private static final String EDITNAME = MessageManager.getString("label.edit_label_description");
    private static final String HIDE = MessageManager.getString("label.hide_row");
    private static final String DELETE = MessageManager.getString("label.delete_row");
    private static final String SHOWALL = MessageManager.getString("label.show_all_hidden_rows");
    private static final String OUTPUT_TEXT = MessageManager.getString("label.export_annotation");
    private static final String COPYCONS_SEQ = MessageManager.getString("label.copy_consensus_sequence");
    private final boolean debugRedraw = false;
    private AlignmentPanel ap;
    AlignViewport av;
    private MouseEvent dragEvent;
    private int oldY;
    private int selectedRow;
    private int scrollOffset = 0;
    private boolean hasHiddenRows;
    private boolean resizePanel = false;

    public AnnotationLabels(AlignmentPanel ap) {
        this.ap = ap;
        this.av = ap.av;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(ap.getAnnotationPanel());
    }

    public AnnotationLabels(AlignViewport av) {
        this.av = av;
    }

    public void setScrollOffset(int y) {
        this.scrollOffset = y;
        this.repaint();
    }

    void getSelectedRow(int y) {
        int height = 0;
        AlignmentAnnotation[] aa = this.ap.av.getAlignment().getAlignmentAnnotation();
        this.selectedRow = -2;
        if (aa != null) {
            for (int i = 0; i < aa.length; ++i) {
                this.selectedRow = -1;
                if (!aa[i].visible || y >= (height += aa[i].height)) continue;
                this.selectedRow = i;
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        AlignmentAnnotation[] aa = this.ap.av.getAlignment().getAlignmentAnnotation();
        String action = evt.getActionCommand();
        if (ADDNEW.equals(action)) {
            AlignmentAnnotation newAnnotation = new AlignmentAnnotation(null, null, new Annotation[this.ap.av.getAlignment().getWidth()]);
            this.editLabelDescription(newAnnotation, true);
        } else if (EDITNAME.equals(action)) {
            this.editLabelDescription(aa[this.selectedRow], false);
        } else if (HIDE.equals(action)) {
            aa[this.selectedRow].visible = false;
        } else if (DELETE.equals(action)) {
            this.ap.av.getAlignment().deleteAnnotation(aa[this.selectedRow]);
            this.ap.av.getCalcManager().removeWorkerForAnnotation(aa[this.selectedRow]);
        } else if (SHOWALL.equals(action)) {
            for (int i = 0; i < aa.length; ++i) {
                if (aa[i].visible || aa[i].annotations == null) continue;
                aa[i].visible = true;
            }
        } else if (OUTPUT_TEXT.equals(action)) {
            new AnnotationExporter(this.ap).exportAnnotation(aa[this.selectedRow]);
        } else if (COPYCONS_SEQ.equals(action)) {
            SequenceI cons = null;
            cons = aa[this.selectedRow].groupRef != null ? aa[this.selectedRow].groupRef.getConsensusSeq() : this.av.getConsensusSeq();
            if (cons != null) {
                this.copy_annotseqtoclipboard(cons);
            }
        } else if (TOGGLE_LABELSCALE.equals(action)) {
            aa[this.selectedRow].scaleColLabel = !aa[this.selectedRow].scaleColLabel;
        }
        this.ap.refresh(true);
    }

    void editLabelDescription(final AlignmentAnnotation annotation, final boolean addNew) {
        String name = MessageManager.getString("label.annotation_name");
        String description = MessageManager.getString("label.annotation_description");
        String title = MessageManager.getString("label.edit_annotation_name_description");
        final EditNameDialog dialog = new EditNameDialog(annotation.label, annotation.description, name, description);
        dialog.showDialog(this.ap.alignFrame, title, new Runnable(){

            @Override
            public void run() {
                annotation.label = dialog.getName();
                String text = dialog.getDescription();
                if (text != null && text.length() == 0) {
                    text = null;
                }
                annotation.description = text;
                if (addNew) {
                    ((AnnotationLabels)AnnotationLabels.this).ap.av.getAlignment().addAnnotation(annotation);
                    ((AnnotationLabels)AnnotationLabels.this).ap.av.getAlignment().setAnnotationIndex(annotation, 0);
                }
                AnnotationLabels.this.ap.refresh(true);
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.getSelectedRow(evt.getY() - this.getScrollOffset());
        this.oldY = evt.getY();
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt);
        }
    }

    void showPopupMenu(MouseEvent evt) {
        String label;
        evt.consume();
        AlignmentAnnotation[] aa = this.ap.av.getAlignment().getAlignmentAnnotation();
        JPopupMenu pop = new JPopupMenu(MessageManager.getString("label.annotations"));
        JMenuItem item = new JMenuItem(ADDNEW);
        item.addActionListener(this);
        pop.add(item);
        if (this.selectedRow < 0) {
            if (this.hasHiddenRows) {
                item = new JMenuItem(SHOWALL);
                item.addActionListener(this);
                pop.add(item);
            }
            pop.show(this, evt.getX(), evt.getY());
            return;
        }
        item = new JMenuItem(EDITNAME);
        item.addActionListener(this);
        pop.add(item);
        item = new JMenuItem(HIDE);
        item.addActionListener(this);
        pop.add(item);
        if (this.selectedRow < aa.length && aa[this.selectedRow].sequenceRef != null) {
            label = aa[this.selectedRow].label;
            JMenuItem hideType = new JMenuItem();
            String text = MessageManager.getString("label.hide_all") + " " + label;
            hideType.setText(text);
            hideType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlignmentUtils.showOrHideSequenceAnnotations(((AnnotationLabels)AnnotationLabels.this).ap.av.getAlignment(), Collections.singleton(label), null, false, false);
                    AnnotationLabels.this.ap.refresh(true);
                }
            });
            pop.add(hideType);
        }
        item = new JMenuItem(DELETE);
        item.addActionListener(this);
        pop.add(item);
        if (this.hasHiddenRows) {
            item = new JMenuItem(SHOWALL);
            item.addActionListener(this);
            pop.add(item);
        }
        item = new JMenuItem(OUTPUT_TEXT);
        item.addActionListener(this);
        pop.add(item);
        if (this.selectedRow < aa.length) {
            label = aa[this.selectedRow].label;
            if (!aa[this.selectedRow].autoCalculated) {
                if (aa[this.selectedRow].graph == 0) {
                    pop.addSeparator();
                    item = new JCheckBoxMenuItem(TOGGLE_LABELSCALE, aa[this.selectedRow].scaleColLabel);
                    item.addActionListener(this);
                    pop.add(item);
                }
            } else if (label.indexOf("Consensus") > -1) {
                AnnotationLabels.addConsensusMenuOptions(this.ap, aa[this.selectedRow], pop);
                JMenuItem consclipbrd = new JMenuItem(COPYCONS_SEQ);
                consclipbrd.addActionListener(this);
                pop.add(consclipbrd);
            }
        }
        pop.show(this, evt.getX(), evt.getY());
    }

    static void addConsensusMenuOptions(final AlignmentPanel ap, AlignmentAnnotation ann, JPopupMenu pop) {
        pop.addSeparator();
        final JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(MessageManager.getString("label.ignore_gaps_consensus"), ann.groupRef != null ? ann.groupRef.getIgnoreGapsConsensus() : ap.av.isIgnoreGapsConsensus());
        final AlignmentAnnotation aaa = ann;
        cbmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (aaa.groupRef != null) {
                    aaa.groupRef.setIgnoreGapsConsensus(cbmi.getState());
                    ap.getAnnotationPanel().paint(ap.getAnnotationPanel().getGraphics());
                } else {
                    ap.av.setIgnoreGapsConsensus(cbmi.getState(), ap);
                }
                ap.alignmentChanged();
            }
        });
        pop.add(cbmi);
        if (aaa.groupRef != null) {
            final JCheckBoxMenuItem chist = new JCheckBoxMenuItem(MessageManager.getString("label.show_group_histogram"), ann.groupRef.isShowConsensusHistogram());
            chist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    aaa.groupRef.setShowConsensusHistogram(chist.getState());
                    ap.repaint();
                }
            });
            pop.add(chist);
            final JCheckBoxMenuItem cprofl = new JCheckBoxMenuItem(MessageManager.getString("label.show_group_logo"), ann.groupRef.isShowSequenceLogo());
            cprofl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    aaa.groupRef.setshowSequenceLogo(cprofl.getState());
                    ap.repaint();
                }
            });
            pop.add(cprofl);
            final JCheckBoxMenuItem cproflnorm = new JCheckBoxMenuItem(MessageManager.getString("label.normalise_group_logo"), ann.groupRef.isNormaliseSequenceLogo());
            cproflnorm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    aaa.groupRef.setNormaliseSequenceLogo(cproflnorm.getState());
                    aaa.groupRef.setshowSequenceLogo(true);
                    ap.repaint();
                }
            });
            pop.add(cproflnorm);
        } else {
            final JCheckBoxMenuItem chist = new JCheckBoxMenuItem(MessageManager.getString("label.show_histogram"), ap.av.isShowConsensusHistogram());
            chist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ap.av.setShowConsensusHistogram(chist.getState());
                    ap.alignFrame.setMenusForViewport();
                    ap.repaint();
                }
            });
            pop.add(chist);
            final JCheckBoxMenuItem cprof = new JCheckBoxMenuItem(MessageManager.getString("label.show_logo"), ap.av.isShowSequenceLogo());
            cprof.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ap.av.setShowSequenceLogo(cprof.getState());
                    ap.alignFrame.setMenusForViewport();
                    ap.repaint();
                }
            });
            pop.add(cprof);
            final JCheckBoxMenuItem cprofnorm = new JCheckBoxMenuItem(MessageManager.getString("label.normalise_logo"), ap.av.isNormaliseSequenceLogo());
            cprofnorm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ap.av.setShowSequenceLogo(true);
                    ap.av.setNormaliseSequenceLogo(cprofnorm.getState());
                    ap.alignFrame.setMenusForViewport();
                    ap.repaint();
                }
            });
            pop.add(cprofnorm);
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt);
            return;
        }
        int start = this.selectedRow;
        this.getSelectedRow(evt.getY() - this.getScrollOffset());
        int end = this.selectedRow;
        if (start != end) {
            AlignmentAnnotation startAA = this.ap.av.getAlignment().getAlignmentAnnotation()[start];
            if (end == -1) {
                end = this.ap.av.getAlignment().getAlignmentAnnotation().length - 1;
            }
            AlignmentAnnotation endAA = this.ap.av.getAlignment().getAlignmentAnnotation()[end];
            this.ap.av.getAlignment().getAlignmentAnnotation()[end] = startAA;
            this.ap.av.getAlignment().getAlignmentAnnotation()[start] = endAA;
        }
        this.resizePanel = false;
        this.dragEvent = null;
        this.repaint();
        this.ap.getAnnotationPanel().repaint();
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        if (this.resizePanel && this.dragEvent == null) {
            this.resizePanel = false;
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.dragEvent = evt;
        if (this.resizePanel) {
            Dimension d = this.ap.annotationScroller.getPreferredSize();
            int dif = evt.getY() - this.oldY;
            dif /= this.ap.av.getCharHeight();
            if (d.height - (dif *= this.ap.av.getCharHeight()) > 20) {
                this.ap.annotationScroller.setPreferredSize(new Dimension(d.width, d.height - dif));
                d = this.ap.annotationSpaceFillerHolder.getPreferredSize();
                this.ap.annotationSpaceFillerHolder.setPreferredSize(new Dimension(d.width, d.height - dif));
                this.ap.paintAlignment(true, false);
            }
            this.ap.addNotify();
        } else {
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.showOrHideAdjuster(evt);
        this.getSelectedRow(evt.getY() - this.getScrollOffset());
        if (this.selectedRow > -1 && this.ap.av.getAlignment().getAlignmentAnnotation().length > this.selectedRow) {
            AlignmentAnnotation[] anns = this.ap.av.getAlignment().getAlignmentAnnotation();
            AlignmentAnnotation aa = anns[this.selectedRow];
            String desc = AnnotationLabels.getTooltip(aa);
            this.setToolTipText(desc);
            String msg = AnnotationLabels.getStatusMessage(aa, anns);
            this.ap.alignFrame.setStatus(msg);
        }
    }

    static String getStatusMessage(AlignmentAnnotation aa, AlignmentAnnotation[] anns) {
        if (aa == null) {
            return null;
        }
        StringBuilder msg = new StringBuilder(32);
        if (aa.sequenceRef != null) {
            msg.append(aa.sequenceRef.getName()).append(" : ");
        }
        if (aa.graphGroup == -1) {
            msg.append(aa.label);
        } else if (anns != null) {
            boolean first = true;
            for (int i = anns.length - 1; i >= 0; --i) {
                if (anns[i].graphGroup != aa.graphGroup) continue;
                if (!first) {
                    msg.append(", ");
                }
                msg.append(anns[i].label);
                first = false;
            }
        }
        return msg.toString();
    }

    static String getTooltip(AlignmentAnnotation aa) {
        if (aa == null) {
            return null;
        }
        StringBuilder tooltip = new StringBuilder();
        if (aa.description != null && !aa.description.equals("New description")) {
            String desc = aa.getDescription(true).trim();
            if (!desc.toLowerCase().startsWith(HTML_START_TAG)) {
                tooltip.append(HTML_START_TAG);
                desc = desc.replace("<", "&lt;");
            } else if (desc.toLowerCase().endsWith(HTML_END_TAG)) {
                desc = desc.substring(0, desc.length() - HTML_END_TAG.length());
            }
            tooltip.append(desc);
        } else {
            tooltip.append(HTML_START_TAG);
        }
        if (aa.hasScore()) {
            if (tooltip.length() > HTML_START_TAG.length()) {
                tooltip.append("<br/>");
            }
            tooltip.append(" Score: ").append(String.valueOf(aa.score));
        }
        if (tooltip.length() > HTML_START_TAG.length()) {
            return tooltip.append(HTML_END_TAG).toString();
        }
        return null;
    }

    protected void showOrHideAdjuster(MouseEvent evt) {
        boolean was = this.resizePanel;
        boolean bl = this.resizePanel = evt.getY() < HEIGHT_ADJUSTER_HEIGHT && evt.getX() < 50;
        if (this.resizePanel != was) {
            this.setCursor(Cursor.getPredefinedCursor(this.resizePanel ? 9 : 0));
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        AlignmentAnnotation[] aa = this.ap.av.getAlignment().getAlignmentAnnotation();
        if (!evt.isPopupTrigger() && SwingUtilities.isLeftMouseButton(evt)) {
            if (this.selectedRow > -1 && this.selectedRow < aa.length) {
                if (aa[this.selectedRow].groupRef != null) {
                    if (evt.getClickCount() >= 2) {
                        this.ap.getSeqPanel().ap.getIdPanel().highlightSearchResults(null);
                        SequenceGroup sg = this.ap.av.getSelectionGroup();
                        if (sg == null || sg == aa[this.selectedRow].groupRef || !Platform.isControlDown(evt) && !evt.isShiftDown()) {
                            if (Platform.isControlDown(evt) || evt.isShiftDown()) {
                                this.ap.av.setSelectionGroup(new SequenceGroup(aa[this.selectedRow].groupRef));
                            } else {
                                this.ap.av.setSelectionGroup(aa[this.selectedRow].groupRef);
                            }
                        } else {
                            int remainToAdd = aa[this.selectedRow].groupRef.getSize();
                            for (SequenceI sgs : aa[this.selectedRow].groupRef.getSequences()) {
                                if (Platform.isControlDown(evt)) {
                                    sg.addOrRemove(sgs, --remainToAdd == 0);
                                    continue;
                                }
                                sg.addSequence(sgs, --remainToAdd == 0);
                            }
                        }
                        this.ap.paintAlignment(false, false);
                        PaintRefresher.Refresh(this.ap, this.ap.av.getSequenceSetId());
                        this.ap.av.sendSelection();
                    } else {
                        this.ap.getSeqPanel().ap.getIdPanel().highlightSearchResults(aa[this.selectedRow].groupRef.getSequences(null));
                    }
                    return;
                }
                if (aa[this.selectedRow].sequenceRef != null) {
                    if (evt.getClickCount() == 1) {
                        this.ap.getSeqPanel().ap.getIdPanel().highlightSearchResults(Arrays.asList(aa[this.selectedRow].sequenceRef));
                    } else if (evt.getClickCount() >= 2) {
                        this.ap.getSeqPanel().ap.getIdPanel().highlightSearchResults(null);
                        SequenceGroup sg = this.ap.av.getSelectionGroup();
                        if (sg != null) {
                            if (!Platform.isControlDown(evt) && !evt.isShiftDown()) {
                                sg = new SequenceGroup(sg);
                                sg.clear();
                                sg.addSequence(aa[this.selectedRow].sequenceRef, false);
                            } else if (Platform.isControlDown(evt)) {
                                sg.addOrRemove(aa[this.selectedRow].sequenceRef, true);
                            } else {
                                sg.addSequence(aa[this.selectedRow].sequenceRef, true);
                            }
                        } else {
                            sg = new SequenceGroup();
                            sg.setStartRes(0);
                            sg.setEndRes(this.ap.av.getAlignment().getWidth() - 1);
                            sg.addSequence(aa[this.selectedRow].sequenceRef, false);
                        }
                        this.ap.av.setSelectionGroup(sg);
                        this.ap.paintAlignment(false, false);
                        PaintRefresher.Refresh(this.ap, this.ap.av.getSequenceSetId());
                        this.ap.av.sendSelection();
                    }
                }
            }
            return;
        }
    }

    protected void copy_annotseqtoclipboard(SequenceI sq) {
        SequenceI[] seqs = new SequenceI[]{sq};
        String[] omitHidden = null;
        SequenceI[] dseqs = new SequenceI[]{sq.getDatasetSequence()};
        if (dseqs[0] == null) {
            dseqs[0] = new Sequence(sq);
            dseqs[0].setSequence(AlignSeq.extractGaps(Comparison.GapChars, sq.getSequenceAsString()));
            sq.setDatasetSequence(dseqs[0]);
        }
        Alignment ds = new Alignment(dseqs);
        if (this.av.hasHiddenColumns()) {
            VisibleContigsIterator it = this.av.getAlignment().getHiddenColumns().getVisContigsIterator(0, sq.getLength(), false);
            omitHidden = new String[]{sq.getSequenceStringFromIterator(it)};
        }
        int[] alignmentStartEnd = new int[]{0, ds.getWidth() - 1};
        if (this.av.hasHiddenColumns()) {
            alignmentStartEnd = this.av.getAlignment().getHiddenColumns().getVisibleStartAndEndIndex(this.av.getAlignment().getWidth());
        }
        String output = new FormatAdapter().formatSequences((FileFormatI)FileFormat.Fasta, seqs, omitHidden, alignmentStartEnd);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(output), Desktop.instance);
        HiddenColumns hiddenColumns = null;
        if (this.av.hasHiddenColumns()) {
            hiddenColumns = new HiddenColumns(this.av.getAlignment().getHiddenColumns());
        }
        Desktop.jalviewClipboard = new Object[]{seqs, ds, hiddenColumns};
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        if (width == 0) {
            width = this.ap.calculateIdWidth().width;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.av.antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawComponent(g2, true, width);
    }

    public void drawComponent(Graphics g, int width) {
        this.drawComponent(g, false, width);
    }

    public void drawComponent(Graphics g, boolean clip, int width) {
        int[] visr;
        if (this.av.getFont().getSize() < 10) {
            g.setFont(font);
        } else {
            g.setFont(this.av.getFont());
        }
        FontMetrics fm = g.getFontMetrics(g.getFont());
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(0, this.getScrollOffset());
        g.setColor(Color.black);
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        int fontHeight = g.getFont().getSize();
        int y = 0;
        int x = 0;
        int graphExtras = 0;
        int offset = 0;
        Font baseFont = g.getFont();
        FontMetrics baseMetrics = fm;
        int ofontH = fontHeight;
        int sOffset = 0;
        int visHeight = 0;
        int[] nArray = visr = this.ap != null && this.ap.getAnnotationPanel() != null ? this.ap.getAnnotationPanel().getVisibleVRange() : null;
        if (clip && visr != null) {
            sOffset = visr[0];
            visHeight = visr[1];
        }
        boolean visible = true;
        boolean before = false;
        boolean after = false;
        if (aa != null) {
            this.hasHiddenRows = false;
            int olY = 0;
            for (int i = 0; i < aa.length; ++i) {
                visible = true;
                if (!aa[i].visible) {
                    this.hasHiddenRows = true;
                    continue;
                }
                olY = y;
                y += aa[i].height;
                if (clip) {
                    if (y < sOffset) {
                        if (before) continue;
                        before = true;
                        continue;
                    }
                    if (olY > visHeight) {
                        if (after) continue;
                        after = true;
                        continue;
                    }
                }
                g.setColor(Color.black);
                offset = -aa[i].height / 2;
                if (aa[i].hasText) {
                    offset += fm.getHeight() / 2;
                    offset -= fm.getDescent();
                } else {
                    offset += fm.getDescent();
                }
                x = width - fm.stringWidth(aa[i].label) - 3;
                if (aa[i].graphGroup > -1) {
                    int gg;
                    int groupSize = 0;
                    for (gg = 0; gg < aa.length; ++gg) {
                        if (aa[gg].graphGroup != aa[i].graphGroup) continue;
                        ++groupSize;
                    }
                    if (groupSize * (fontHeight + 8) < aa[i].height) {
                        graphExtras = (aa[i].height - groupSize * (fontHeight + 8)) / 2;
                    } else {
                        float h = (float)aa[i].height / (float)groupSize;
                        if (h < 9.0f) {
                            visible = false;
                        } else {
                            fontHeight = -8 + (int)h;
                            float s = (float)fontHeight / (float)ofontH;
                            Font f = baseFont.deriveFont(AffineTransform.getScaleInstance(s, s));
                            g.setFont(f);
                            fm = g.getFontMetrics();
                            graphExtras = (aa[i].height - groupSize * (fontHeight + 8)) / 2;
                        }
                    }
                    if (visible) {
                        for (gg = 0; gg < aa.length; ++gg) {
                            if (aa[gg].graphGroup != aa[i].graphGroup) continue;
                            x = width - fm.stringWidth(aa[gg].label) - 3;
                            g.drawString(aa[gg].label, x, y - graphExtras);
                            if (aa[gg]._linecolour != null) {
                                g.setColor(aa[gg]._linecolour);
                                g.drawLine(x, y - graphExtras + 3, x + fm.stringWidth(aa[gg].label), y - graphExtras + 3);
                            }
                            g.setColor(Color.black);
                            graphExtras += fontHeight + 8;
                        }
                    }
                    g.setFont(baseFont);
                    fm = baseMetrics;
                    fontHeight = ofontH;
                    continue;
                }
                g.drawString(aa[i].label, x, y + offset);
            }
        }
        if (!this.resizePanel && this.dragEvent != null && aa != null) {
            g.setColor(Color.lightGray);
            g.drawString(aa[this.selectedRow].label, this.dragEvent.getX(), this.dragEvent.getY() - this.getScrollOffset());
        }
        if (!(this.av.getWrapAlignment() || aa != null && aa.length >= 1)) {
            g.drawString(MessageManager.getString("label.right_click"), 2, 8);
            g.drawString(MessageManager.getString("label.to_add_annotation"), 2, 18);
        }
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

