/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.varna;

import jalview.api.SequenceRenderer;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.structure.StructureMapping;
import jalview.structure.StructureSelectionManager;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.ArrayList;

public class VarnaCommands {
    public static String[] getColourBySequenceCommand(StructureSelectionManager ssm, String[] files, SequenceI[][] sequence, SequenceRenderer sr, FeatureColourFinder finder, AlignmentI alignment) {
        ArrayList<String> str = new ArrayList<String>();
        StringBuffer command = new StringBuffer();
        for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
            StructureMapping[] mapping = ssm.getMapping(files[pdbfnum]);
            if (mapping == null || mapping.length < 1) continue;
            int lastPos = -1;
            block1: for (int s = 0; s < sequence[pdbfnum].length; ++s) {
                for (int m = 0; m < mapping.length; ++m) {
                    int sp;
                    if (mapping[m].getSequence() != sequence[pdbfnum][s] || (sp = alignment.findIndex(sequence[pdbfnum][s])) <= -1) continue;
                    SequenceI asp = alignment.getSequenceAt(sp);
                    for (int r = 0; r < asp.getLength(); ++r) {
                        int pos;
                        if (Comparison.isGap(asp.getCharAt(r)) || (pos = mapping[m].getPDBResNum(asp.findPosition(r))) < 1 || pos == lastPos) continue;
                        lastPos = pos;
                        Color col = sr.getResidueColour(sequence[pdbfnum][s], r, finder);
                        String newSelcom = (mapping[m].getChain() != " " ? ":" + mapping[m].getChain() : "") + "/" + (pdbfnum + 1) + ".1;color[" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "]";
                        if (command.length() > newSelcom.length() && command.substring(command.length() - newSelcom.length()).equals(newSelcom)) {
                            command = VarnaCommands.condenseCommand(command, pos);
                            continue;
                        }
                        command.append(";");
                        if (command.length() > 51200) {
                            str.add(command.toString());
                            command.setLength(0);
                        }
                        command.append("select " + pos);
                        command.append(newSelcom);
                    }
                    continue block1;
                }
            }
        }
        str.add(command.toString());
        command.setLength(0);
        return str.toArray(new String[str.size()]);
    }

    public static StringBuffer condenseCommand(StringBuffer command, int pos) {
        int p;
        int q = p = command.length();
        do {
            if ((p -= 6) >= 1) continue;
            p = 0;
        } while ((q = command.indexOf("select", p)) == -1 && p > 0);
        StringBuffer sb = new StringBuffer(command.substring(0, q + 7));
        String start = (command = command.delete(0, q + 7)).indexOf("-") > -1 ? command.substring(0, command.indexOf("-")) : command.substring(0, command.indexOf(":"));
        sb.append(start + "-" + pos + command.substring(command.indexOf(":")));
        return sb;
    }
}

