/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.rbvi.chimera;

import jalview.ext.rbvi.chimera.JalviewChimeraBinding;
import jalview.httpserver.AbstractRequestHandler;
import jalview.structure.SelectionSource;
import java.net.BindException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChimeraListener
extends AbstractRequestHandler
implements SelectionSource {
    private static final String CHIMERA_NOTIFICATION = "chimeraNotification";
    private static final String MODEL_CHANGED = "ModelChanged: ";
    private static final String SELECTION_CHANGED = "SelectionChanged: selection changed\n";
    private static int chimeraId = 0;
    private static final String PATH_PREFIX = "chimera";
    private int myChimeraId = chimeraId++;
    private JalviewChimeraBinding chimeraBinding;

    public ChimeraListener(JalviewChimeraBinding binding) throws BindException {
        this.chimeraBinding = binding;
        this.setPath(PATH_PREFIX + this.myChimeraId);
        this.registerHandler();
    }

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) {
        String message = request.getParameter(CHIMERA_NOTIFICATION);
        if (message == null) {
            message = request.getParameter("chimerax_notification");
        }
        if (message != null) {
            if (message.startsWith("SelectionChanged")) {
                this.chimeraBinding.highlightChimeraSelection();
            } else if (message.startsWith(MODEL_CHANGED)) {
                System.err.println(message);
                this.processModelChanged(message.substring(MODEL_CHANGED.length()));
            } else {
                System.err.println("Unexpected chimeraNotification: " + message);
            }
        }
    }

    protected void processModelChanged(String message) {
    }

    @Override
    public String getName() {
        return "ChimeraListener";
    }
}

