/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.rbvi.chimera;

import jalview.structure.AtomSpecModel;
import jalview.structure.StructureCommand;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureCommandsBase;
import jalview.util.ColorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ChimeraCommands
extends StructureCommandsBase {
    private static final StructureCommand FOCUS_VIEW = new StructureCommand("focus", new String[0]);
    private static final StructureCommand LIST_RESIDUE_ATTRIBUTES = new StructureCommand("list resattr", new String[0]);
    private static final StructureCommand CLOSE_CHIMERA = new StructureCommand("stop really", new String[0]);
    private static final StructureCommand STOP_NOTIFY_SELECTION = new StructureCommand("listen stop selection", new String[0]);
    private static final StructureCommand STOP_NOTIFY_MODELS = new StructureCommand("listen stop models", new String[0]);
    private static final StructureCommand GET_SELECTION = new StructureCommand("list selection level residue", new String[0]);
    private static final StructureCommand SHOW_BACKBONE = new StructureCommand("~display all;~ribbon;chain @CA|P", new String[0]);
    private static final StructureCommandI COLOUR_BY_CHARGE = new StructureCommand("color white;color red ::ASP,GLU;color blue ::LYS,ARG;color yellow ::CYS", new String[0]);
    private static final StructureCommandI COLOUR_BY_CHAIN = new StructureCommand("rainbow chain", new String[0]);
    private static final String NO_ALTLOCS = "&~@.B-Z&~@.2-9";

    @Override
    public StructureCommandI colourResidues(String atomSpec, Color colour) {
        String colourCode = this.getColourString(colour);
        return new StructureCommand("color " + colourCode + " " + atomSpec, new String[0]);
    }

    protected String getColourString(Color colour) {
        return ColorUtils.toTkCode(colour);
    }

    @Override
    public List<StructureCommandI> setAttributes(Map<String, Map<Object, AtomSpecModel>> featureMap) {
        ArrayList<StructureCommandI> commands = new ArrayList<StructureCommandI>();
        for (String featureType : featureMap.keySet()) {
            String attributeName = this.makeAttributeName(featureType);
            Map<Object, AtomSpecModel> values = featureMap.get(featureType);
            for (Object value : values.keySet()) {
                AtomSpecModel atomSpecModel = values.get(value);
                String featureValue = value.toString();
                featureValue = featureValue.replaceAll("\\'", "&#39;");
                StructureCommandI cmd = this.setAttribute(attributeName, featureValue, atomSpecModel);
                commands.add(cmd);
            }
        }
        return commands;
    }

    protected StructureCommandI setAttribute(String attributeName, String attributeValue, AtomSpecModel atomSpecModel) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("setattr res ").append(attributeName).append(" '").append(attributeValue).append("' ");
        sb.append(this.getAtomSpec(atomSpecModel, false));
        return new StructureCommand(sb.toString(), new String[0]);
    }

    @Override
    protected String makeAttributeName(String featureType) {
        String attName = super.makeAttributeName(featureType);
        if (attName.toUpperCase().endsWith("COLOR")) {
            attName = attName + "_";
        }
        return attName;
    }

    @Override
    public StructureCommandI colourByChain() {
        return COLOUR_BY_CHAIN;
    }

    @Override
    public List<StructureCommandI> colourByCharge() {
        return Arrays.asList(COLOUR_BY_CHARGE);
    }

    @Override
    public String getResidueSpec(String residue) {
        return "::" + residue;
    }

    @Override
    public StructureCommandI setBackgroundColour(Color col) {
        return new StructureCommand("set bgColor " + ColorUtils.toTkCode(col), new String[0]);
    }

    @Override
    public StructureCommandI focusView() {
        return FOCUS_VIEW;
    }

    @Override
    public List<StructureCommandI> showChains(List<String> toShow) {
        StringBuilder cmd = new StringBuilder(64);
        boolean first = true;
        for (String chain : toShow) {
            String[] tokens = chain.split(":");
            if (tokens.length != 2) continue;
            String showChainCmd = tokens[0] + ":." + tokens[1];
            if (!first) {
                cmd.append(",");
            }
            cmd.append(showChainCmd);
            first = false;
        }
        String command = "~display #*; ~ribbon #*; ribbon :" + cmd.toString();
        return Arrays.asList(new StructureCommand(command, new String[0]));
    }

    @Override
    public List<StructureCommandI> superposeStructures(AtomSpecModel ref, AtomSpecModel spec) {
        StringBuilder cmd = new StringBuilder();
        String atomSpecAlphaOnly = this.getAtomSpec(spec, true);
        String refSpecAlphaOnly = this.getAtomSpec(ref, true);
        cmd.append("match ").append(atomSpecAlphaOnly).append(" ").append(refSpecAlphaOnly);
        String atomSpec = this.getAtomSpec(spec, false);
        String refSpec = this.getAtomSpec(ref, false);
        cmd.append("; ribbon ");
        cmd.append(atomSpec).append("|").append(refSpec).append("; focus");
        return Arrays.asList(new StructureCommand(cmd.toString(), new String[0]));
    }

    @Override
    public StructureCommandI openCommandFile(String path) {
        return new StructureCommand("open cmd:" + path, new String[0]);
    }

    @Override
    public StructureCommandI saveSession(String filepath) {
        return new StructureCommand("save " + filepath, new String[0]);
    }

    @Override
    public String getAtomSpec(AtomSpecModel atomSpec, boolean alphaOnly) {
        StringBuilder sb = new StringBuilder(128);
        boolean firstModel = true;
        for (String model : atomSpec.getModels()) {
            if (!firstModel) {
                sb.append("|");
            }
            firstModel = false;
            this.appendModel(sb, model, atomSpec, alphaOnly);
        }
        return sb.toString();
    }

    protected void appendModel(StringBuilder sb, String model, AtomSpecModel atomSpec, boolean alphaOnly) {
        sb.append("#").append(model).append(":");
        boolean firstPositionForModel = true;
        for (String chain : atomSpec.getChains(model)) {
            chain = " ".equals(chain) ? chain : chain.trim();
            List<int[]> rangeList = atomSpec.getRanges(model, chain);
            for (int[] range : rangeList) {
                this.appendRange(sb, range[0], range[1], chain, firstPositionForModel, false);
                firstPositionForModel = false;
            }
        }
        if (alphaOnly) {
            sb.append("@CA").append(NO_ALTLOCS);
        }
    }

    @Override
    public List<StructureCommandI> showBackbone() {
        return Arrays.asList(SHOW_BACKBONE);
    }

    @Override
    public StructureCommandI loadFile(String file) {
        return new StructureCommand("open " + file, new String[0]);
    }

    @Override
    public StructureCommandI openSession(String filepath) {
        return new StructureCommand("open chimera:" + filepath, new String[0]);
    }

    @Override
    public StructureCommandI closeViewer() {
        return CLOSE_CHIMERA;
    }

    @Override
    public List<StructureCommandI> startNotifications(String uri) {
        ArrayList<StructureCommandI> cmds = new ArrayList<StructureCommandI>();
        cmds.add(new StructureCommand("listen start models url " + uri, new String[0]));
        cmds.add(new StructureCommand("listen start select prefix SelectionChanged url " + uri, new String[0]));
        return cmds;
    }

    @Override
    public List<StructureCommandI> stopNotifications() {
        ArrayList<StructureCommandI> cmds = new ArrayList<StructureCommandI>();
        cmds.add(STOP_NOTIFY_MODELS);
        cmds.add(STOP_NOTIFY_SELECTION);
        return cmds;
    }

    @Override
    public StructureCommandI getSelectedResidues() {
        return GET_SELECTION;
    }

    @Override
    public StructureCommandI listResidueAttributes() {
        return LIST_RESIDUE_ATTRIBUTES;
    }

    @Override
    public StructureCommandI getResidueAttributes(String attName) {
        return new StructureCommand("list residues attr '" + attName + "'", new String[0]);
    }
}

