/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.ext.ensembl.EnsemblRestClient;
import jalview.util.DBRefUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.ParseException;

class EnsemblXref
extends EnsemblRestClient {
    private static final String GO_GENE_ONTOLOGY = "GO";
    private String dbName = "ENSEMBL (xref)";
    private String xrefVersion = "ENSEMBL:0";

    public EnsemblXref(String d, String dbSource, String version) {
        super(d);
        this.dbName = dbSource;
        this.xrefVersion = dbSource + ":" + version;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return null;
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        return this.getUrl(ids.get(0));
    }

    @Override
    protected boolean useGetRequest() {
        return true;
    }

    public List<DBRefEntry> getCrossReferences(String identifier) {
        ArrayList<DBRefEntry> result = new ArrayList<DBRefEntry>();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(identifier);
        try {
            Iterator rvals = (Iterator)this.getJSON(this.getUrl(identifier), ids, -1, 2, null);
            while (rvals.hasNext()) {
                Map val = (Map)rvals.next();
                String db = val.get("dbname").toString();
                String id = val.get("primary_id").toString();
                if (db == null || id == null || GO_GENE_ONTOLOGY.equals(db)) continue;
                db = DBRefUtils.getCanonicalName(db);
                DBRefEntry dbref = new DBRefEntry(db, this.getXRefVersion(), id);
                result.add(dbref);
            }
        }
        catch (IOException | ParseException exception) {
            // empty catch block
        }
        return result;
    }

    public String getXRefVersion() {
        return this.xrefVersion;
    }

    protected URL getUrl(String identifier) {
        String url = this.getDomain() + "/xrefs/id/" + identifier + "?content-type=application/json" + "&all_levels=1";
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

