/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import com.stevesoft.pat.Regex;
import jalview.api.FeatureColourI;
import jalview.api.FeatureSettingsModelI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.GeneLociI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.SequenceFeatures;
import jalview.ext.ensembl.EnsemblCdna;
import jalview.ext.ensembl.EnsemblLookup;
import jalview.ext.ensembl.EnsemblSeqProxy;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import jalview.ext.ensembl.EnsemblSymbol;
import jalview.io.gff.SequenceOntologyFactory;
import jalview.io.gff.SequenceOntologyI;
import jalview.schemes.FeatureColour;
import jalview.schemes.FeatureSettingsAdapter;
import jalview.util.MapList;
import jalview.util.Platform;
import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EnsemblGene
extends EnsemblSeqProxy {
    private static final Regex ACCESSION_REGEX = new Regex(".*");
    private static final EnsemblSequenceFetcher.EnsemblFeatureType[] FEATURES_TO_FETCH = new EnsemblSequenceFetcher.EnsemblFeatureType[]{EnsemblSequenceFetcher.EnsemblFeatureType.gene, EnsemblSequenceFetcher.EnsemblFeatureType.transcript, EnsemblSequenceFetcher.EnsemblFeatureType.exon, EnsemblSequenceFetcher.EnsemblFeatureType.cds, EnsemblSequenceFetcher.EnsemblFeatureType.variation};
    private static final String CHROMOSOME = "chromosome";

    public EnsemblGene() {
    }

    public EnsemblGene(String d) {
        super(d);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL";
    }

    @Override
    protected EnsemblSequenceFetcher.EnsemblFeatureType[] getFeaturesToFetch() {
        return FEATURES_TO_FETCH;
    }

    @Override
    protected EnsemblSeqProxy.EnsemblSeqType getSourceEnsemblType() {
        return EnsemblSeqProxy.EnsemblSeqType.GENOMIC;
    }

    @Override
    protected String getObjectType() {
        return "Gene";
    }

    @Override
    public AlignmentI getSequenceRecords(String query) throws Exception {
        List<String> geneIds = this.getGeneIds(query);
        AlignmentI al = null;
        for (String geneId : geneIds) {
            AlignmentI geneAlignment = super.getSequenceRecords(geneId);
            if (geneAlignment == null) continue;
            if (geneAlignment.getHeight() == 1) {
                geneId = geneAlignment.getSequenceAt(0).getName();
                this.findGeneLoci(geneAlignment.getSequenceAt(0), geneId);
                this.getTranscripts(geneAlignment, geneId);
            }
            if (al == null) {
                al = geneAlignment;
                continue;
            }
            al.append(geneAlignment);
        }
        return al;
    }

    void findGeneLoci(SequenceI seq, String geneId) {
        GeneLociI geneLoci = new EnsemblLookup(this.getDomain()).getGeneLoci(geneId);
        if (geneLoci != null) {
            seq.setGeneLoci(geneLoci.getSpeciesId(), geneLoci.getAssemblyId(), geneLoci.getChromosomeId(), geneLoci.getMapping());
        } else {
            this.parseChromosomeLocations(seq);
        }
    }

    boolean parseChromosomeLocations(SequenceI seq) {
        String description = seq.getDescription();
        if (description == null) {
            return false;
        }
        String[] tokens = description.split(":");
        if (tokens.length == 6 && tokens[0].startsWith(CHROMOSOME)) {
            String ref = tokens[1];
            String chrom = tokens[2];
            try {
                int chStart = Integer.parseInt(tokens[3]);
                int chEnd = Integer.parseInt(tokens[4]);
                boolean forwardStrand = "1".equals(tokens[5]);
                String species = "";
                int[] from = new int[]{seq.getStart(), seq.getEnd()};
                int[] to = new int[]{forwardStrand ? chStart : chEnd, forwardStrand ? chEnd : chStart};
                MapList map = new MapList(from, to, 1, 1);
                seq.setGeneLoci(species, ref, chrom, map);
                return true;
            }
            catch (NumberFormatException e) {
                System.err.println("Bad integers in description " + description);
            }
        }
        return false;
    }

    List<String> getGeneIds(String accessions) {
        ArrayList<String> geneIds = new ArrayList<String>();
        for (String acc : accessions.split(this.getAccessionSeparator())) {
            String geneId = new EnsemblLookup(this.getDomain()).getGeneId(acc);
            if (geneId != null) {
                if (geneIds.contains(geneId)) continue;
                geneIds.add(geneId);
                continue;
            }
            List<String> ids = new EnsemblSymbol(this.getDomain(), this.getDbSource(), this.getDbVersion()).getGeneIds(acc);
            for (String id : ids) {
                if (geneIds.contains(id)) continue;
                geneIds.add(id);
            }
        }
        return geneIds;
    }

    protected void getTranscripts(AlignmentI al, String accId) throws Exception {
        SequenceI gene = al.getSequenceAt(0);
        List<SequenceFeature> transcriptFeatures = this.getTranscriptFeatures(accId, gene);
        for (SequenceFeature transcriptFeature : transcriptFeatures) {
            this.makeTranscript(transcriptFeature, al, gene);
        }
        this.clearGeneFeatures(gene);
    }

    protected void clearGeneFeatures(SequenceI gene) {
        String[] soTerms = new String[]{"NMD_transcript_variant", "transcript", "exon", "CDS"};
        List<SequenceFeature> sfs = gene.getFeatures().getFeaturesByOntology(soTerms);
        for (SequenceFeature sf : sfs) {
            gene.deleteFeature(sf);
        }
    }

    SequenceI makeTranscript(SequenceFeature transcriptFeature, AlignmentI al, SequenceI gene) {
        String accId = this.getTranscriptId(transcriptFeature);
        if (accId == null) {
            return null;
        }
        char[] seqChars = new char[gene.getLength()];
        Arrays.fill(seqChars, al.getGapCharacter());
        String parentId = accId;
        List<SequenceFeature> splices = this.findFeatures(gene, "exon", parentId);
        if (splices.isEmpty()) {
            splices = this.findFeatures(gene, "CDS", parentId);
        }
        SequenceFeatures.sortFeatures(splices, true);
        int transcriptLength = 0;
        char[] geneChars = gene.getSequence();
        int offset = gene.getStart();
        ArrayList<int[]> mappedFrom = new ArrayList<int[]>();
        for (SequenceFeature sf : splices) {
            int start = sf.getBegin() - offset;
            int end = sf.getEnd() - offset;
            int spliceLength = end - start + 1;
            System.arraycopy(geneChars, start, seqChars, start, spliceLength);
            transcriptLength += spliceLength;
            mappedFrom.add(new int[]{sf.getBegin(), sf.getEnd()});
        }
        Sequence transcript = new Sequence(accId, seqChars, 1, transcriptLength);
        String description = transcriptFeature.getDescription();
        if (description == null) {
            description = (String)transcriptFeature.getValue("description");
        }
        if (description != null) {
            try {
                transcript.setDescription(URLDecoder.decode(description, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        transcript.createDatasetSequence();
        al.addSequence(transcript);
        ArrayList<int[]> mapTo = new ArrayList<int[]>();
        mapTo.add(new int[]{1, transcriptLength});
        MapList mapping = new MapList(mappedFrom, mapTo, 1, 1);
        EnsemblCdna cdna = new EnsemblCdna(this.getDomain());
        cdna.transferFeatures(gene.getFeatures().getPositionalFeatures(new String[0]), transcript.getDatasetSequence(), mapping, parentId);
        this.mapTranscriptToChromosome(transcript, gene, mapping);
        cdna.getCrossReferences(transcript);
        cdna.addProteinProduct(transcript);
        return transcript;
    }

    protected void mapTranscriptToChromosome(SequenceI transcript, SequenceI gene, MapList mapping) {
        GeneLociI loci = gene.getGeneLoci();
        if (loci == null) {
            return;
        }
        MapList geneMapping = loci.getMapping();
        List<int[]> exons = mapping.getFromRanges();
        ArrayList<int[]> transcriptLoci = new ArrayList<int[]>();
        for (int[] exon : exons) {
            transcriptLoci.add(geneMapping.locateInTo(exon[0], exon[1]));
        }
        List<int[]> transcriptRange = Arrays.asList(new int[][]{{transcript.getStart(), transcript.getEnd()}});
        MapList mapList = new MapList(transcriptRange, transcriptLoci, 1, 1);
        transcript.setGeneLoci(loci.getSpeciesId(), loci.getAssemblyId(), loci.getChromosomeId(), mapList);
    }

    protected String getTranscriptId(SequenceFeature feature) {
        return (String)feature.getValue("id");
    }

    protected List<SequenceFeature> getTranscriptFeatures(String accId, SequenceI geneSequence) {
        ArrayList<SequenceFeature> transcriptFeatures = new ArrayList<SequenceFeature>();
        String parentIdentifier = accId;
        List<SequenceFeature> sfs = geneSequence.getFeatures().getFeaturesByOntology("transcript");
        sfs.addAll(geneSequence.getFeatures().getPositionalFeatures("NMD_transcript_variant"));
        for (SequenceFeature sf : sfs) {
            String parent = (String)sf.getValue("Parent");
            if (!parentIdentifier.equalsIgnoreCase(parent)) continue;
            transcriptFeatures.add(sf);
        }
        return transcriptFeatures;
    }

    @Override
    public String getDescription() {
        return "Fetches all transcripts and variant features for a gene or transcript";
    }

    @Override
    public String getTestQuery() {
        return Platform.isJS() ? "ENSG00000123569" : "ENSG00000157764";
    }

    @Override
    protected List<SequenceFeature> getIdentifyingFeatures(SequenceI seq, String accId) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        List<SequenceFeature> sfs = seq.getFeatures().getFeaturesByOntology("gene");
        for (SequenceFeature sf : sfs) {
            String id = (String)sf.getValue("id");
            if (!accId.equalsIgnoreCase(id)) continue;
            result.add(sf);
        }
        return result;
    }

    @Override
    protected boolean retainFeature(SequenceFeature sf, String accessionId) {
        String parent;
        String type;
        SequenceOntologyI so = SequenceOntologyFactory.getInstance();
        if (so.isA(type = sf.getType(), "gene")) {
            return false;
        }
        return !EnsemblGene.isTranscript(type) || accessionId.equalsIgnoreCase(parent = (String)sf.getValue("Parent"));
    }

    @Override
    protected void addProteinProduct(SequenceI querySeq) {
    }

    @Override
    public Regex getAccessionValidator() {
        return ACCESSION_REGEX;
    }

    @Override
    public FeatureSettingsModelI getFeatureColourScheme() {
        return new FeatureSettingsAdapter(){
            SequenceOntologyI so = SequenceOntologyFactory.getInstance();

            @Override
            public boolean isFeatureDisplayed(String type) {
                return this.so.isA(type, "exon") || this.so.isA(type, "sequence_variant");
            }

            @Override
            public FeatureColourI getFeatureColour(String type) {
                if (this.so.isA(type, "exon")) {
                    return new FeatureColour(){

                        @Override
                        public boolean isColourByLabel() {
                            return true;
                        }
                    };
                }
                if (this.so.isA(type, "sequence_variant")) {
                    return new FeatureColour(){

                        @Override
                        public Color getColour() {
                            return Color.RED;
                        }
                    };
                }
                return null;
            }

            @Override
            public int compare(String feature1, String feature2) {
                if (this.so.isA(feature1, "sequence_variant")) {
                    return 1;
                }
                if (this.so.isA(feature2, "sequence_variant")) {
                    return -1;
                }
                if (this.so.isA(feature1, "exon")) {
                    return 1;
                }
                if (this.so.isA(feature2, "exon")) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

