/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import com.stevesoft.pat.Regex;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.ext.ensembl.EnsemblSeqProxy;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import java.util.ArrayList;
import java.util.List;

public class EnsemblCdna
extends EnsemblSeqProxy {
    private static final Regex ACCESSION_REGEX = new Regex("(ENS([A-Z]{3}|)[TG][0-9]{11}$)|(CCDS[0-9.]{3,}$)");
    private static final EnsemblSequenceFetcher.EnsemblFeatureType[] FEATURES_TO_FETCH = new EnsemblSequenceFetcher.EnsemblFeatureType[]{EnsemblSequenceFetcher.EnsemblFeatureType.exon, EnsemblSequenceFetcher.EnsemblFeatureType.cds, EnsemblSequenceFetcher.EnsemblFeatureType.variation};

    public EnsemblCdna() {
    }

    public EnsemblCdna(String d) {
        super(d);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL (CDNA)";
    }

    @Override
    protected EnsemblSeqProxy.EnsemblSeqType getSourceEnsemblType() {
        return EnsemblSeqProxy.EnsemblSeqType.CDNA;
    }

    @Override
    public Regex getAccessionValidator() {
        return ACCESSION_REGEX;
    }

    @Override
    protected EnsemblSequenceFetcher.EnsemblFeatureType[] getFeaturesToFetch() {
        return FEATURES_TO_FETCH;
    }

    @Override
    protected boolean retainFeature(SequenceFeature sf, String accessionId) {
        if (EnsemblCdna.isTranscript(sf.getType())) {
            return false;
        }
        return this.featureMayBelong(sf, accessionId);
    }

    @Override
    protected List<SequenceFeature> getIdentifyingFeatures(SequenceI seq, String accId) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        List<SequenceFeature> sfs = seq.getFeatures().getFeaturesByOntology("exon");
        for (SequenceFeature sf : sfs) {
            String parentFeature = (String)sf.getValue("Parent");
            if (!accId.equals(parentFeature)) continue;
            result.add(sf);
        }
        return result;
    }

    @Override
    protected String getObjectType() {
        return "Transcript";
    }
}

