/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel.features;

import jalview.datamodel.SequenceFeature;
import jalview.datamodel.features.FeatureMatcherI;
import jalview.util.MessageManager;
import jalview.util.matcher.Condition;
import jalview.util.matcher.Matcher;
import jalview.util.matcher.MatcherI;

public class FeatureMatcher
implements FeatureMatcherI {
    private static final String SCORE = "Score";
    private static final String LABEL = "Label";
    private static final String SPACE = " ";
    private static final String QUOTE = "'";
    public static final FeatureMatcherI NULL_MATCHER = FeatureMatcher.byLabel(Condition.values()[0], "");
    private static final String COLON = ":";
    private final boolean byLabel;
    private final boolean byScore;
    private final String[] key;
    private final MatcherI matcher;

    public static String[] fromAttributeDisplayName(String attribute) {
        return attribute == null ? null : attribute.split(COLON);
    }

    public static String toAttributeDisplayName(String[] attName) {
        return attName == null ? "" : String.join((CharSequence)COLON, attName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FeatureMatcher fromString(String descriptor) {
        String invalidFormat = "Invalid matcher format: " + descriptor;
        String attName = null;
        boolean byScore = false;
        boolean byLabel = false;
        Condition cond = null;
        String pattern = null;
        String leftToParse = descriptor;
        String firstField = null;
        if (descriptor.startsWith(QUOTE)) {
            int nextQuotePos = descriptor.indexOf(QUOTE, 1);
            if (nextQuotePos == -1) {
                System.err.println(invalidFormat);
                return null;
            }
            firstField = descriptor.substring(1, nextQuotePos);
            leftToParse = descriptor.substring(nextQuotePos + 1).trim();
        } else {
            int nextSpacePos = descriptor.indexOf(SPACE);
            if (nextSpacePos == -1) {
                System.err.println(invalidFormat);
                return null;
            }
            firstField = descriptor.substring(0, nextSpacePos);
            leftToParse = descriptor.substring(nextSpacePos + 1).trim();
        }
        String lower = firstField.toLowerCase();
        if (lower.startsWith(LABEL.toLowerCase())) {
            byLabel = true;
        } else if (lower.startsWith(SCORE.toLowerCase())) {
            byScore = true;
        } else {
            attName = firstField;
        }
        int nextSpacePos = leftToParse.indexOf(SPACE);
        if (nextSpacePos == -1) {
            cond = Condition.fromString(leftToParse);
            if (cond == null || cond.needsAPattern()) {
                System.err.println(invalidFormat);
                return null;
            }
        } else {
            cond = Condition.fromString(leftToParse.substring(0, nextSpacePos));
            if ((leftToParse = leftToParse.substring(nextSpacePos + 1).trim()).startsWith(QUOTE)) {
                if (!leftToParse.endsWith(QUOTE)) {
                    System.err.println(invalidFormat);
                    return null;
                }
                pattern = leftToParse.substring(1, leftToParse.length() - 1);
            } else {
                pattern = leftToParse;
            }
        }
        try {
            if (byLabel) {
                return FeatureMatcher.byLabel(cond, pattern);
            }
            if (byScore) {
                return FeatureMatcher.byScore(cond, pattern);
            }
            String[] attNames = FeatureMatcher.fromAttributeDisplayName(attName);
            return FeatureMatcher.byAttribute(cond, pattern, attNames);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static FeatureMatcher byLabel(Condition cond, String pattern) {
        return new FeatureMatcher(new Matcher(cond, pattern), true, false, null);
    }

    public static FeatureMatcher byScore(Condition cond, String pattern) {
        return new FeatureMatcher(new Matcher(cond, pattern), false, true, null);
    }

    public static FeatureMatcher byAttribute(Condition cond, String pattern, String ... attName) {
        return new FeatureMatcher(new Matcher(cond, pattern), false, false, attName);
    }

    private FeatureMatcher(Matcher m, boolean forLabel, boolean forScore, String[] theKey) {
        this.key = theKey;
        this.matcher = m;
        this.byLabel = forLabel;
        this.byScore = forScore;
    }

    @Override
    public boolean matches(SequenceFeature feature) {
        String value = this.byLabel ? feature.getDescription() : (this.byScore ? String.valueOf(feature.getScore()) : feature.getValueAsString(this.key));
        return this.matcher.matches(value);
    }

    @Override
    public String[] getAttribute() {
        return this.key;
    }

    @Override
    public MatcherI getMatcher() {
        return this.matcher;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.byLabel) {
            sb.append(MessageManager.getString("label.label"));
        } else if (this.byScore) {
            sb.append(MessageManager.getString("label.score"));
        } else {
            sb.append(String.join((CharSequence)COLON, this.key));
        }
        Condition condition = this.matcher.getCondition();
        sb.append(SPACE).append(condition.toString().toLowerCase());
        if (condition.isNumeric()) {
            sb.append(SPACE).append(this.matcher.getPattern());
        } else if (condition.needsAPattern()) {
            sb.append(" '").append(this.matcher.getPattern()).append(QUOTE);
        }
        return sb.toString();
    }

    @Override
    public boolean isByLabel() {
        return this.byLabel;
    }

    @Override
    public boolean isByScore() {
        return this.byScore;
    }

    @Override
    public boolean isByAttribute() {
        return this.getAttribute() != null;
    }

    @Override
    public String toStableString() {
        StringBuilder sb = new StringBuilder();
        if (this.byLabel) {
            sb.append(LABEL);
        } else if (this.byScore) {
            sb.append(SCORE);
        } else {
            String displayName = FeatureMatcher.toAttributeDisplayName(this.key);
            if (displayName.contains(SPACE)) {
                sb.append(QUOTE).append(displayName).append(QUOTE);
            } else {
                sb.append(displayName);
            }
        }
        Condition condition = this.matcher.getCondition();
        sb.append(SPACE).append(condition.getStableName());
        String pattern = this.matcher.getPattern();
        if (condition.needsAPattern()) {
            if (pattern.contains(SPACE)) {
                sb.append(SPACE).append(QUOTE).append(pattern).append(QUOTE);
            } else {
                sb.append(SPACE).append(pattern);
            }
        }
        return sb.toString();
    }
}

