/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.SequenceI;

public class SequenceCursor {
    public final SequenceI sequence;
    public final int residuePosition;
    public final int columnPosition;
    public final int firstColumnPosition;
    public final int lastColumnPosition;
    public final int token;

    public SequenceCursor(SequenceI seq, int resPos, int column, int tok) {
        this(seq, resPos, column, 0, 0, tok);
    }

    public SequenceCursor(SequenceI seq, int resPos, int column, int firstResCol, int lastResCol, int tok) {
        this.sequence = seq;
        this.residuePosition = resPos;
        this.columnPosition = column;
        this.firstColumnPosition = firstResCol;
        this.lastColumnPosition = lastResCol;
        this.token = tok;
    }

    public int hashCode() {
        int hash = 31 * this.residuePosition;
        hash = 31 * hash + this.columnPosition;
        hash = 31 * hash + this.token;
        if (this.sequence != null) {
            hash += this.sequence.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SequenceCursor)) {
            return false;
        }
        SequenceCursor sc = (SequenceCursor)obj;
        return this.sequence == sc.sequence && this.residuePosition == sc.residuePosition && this.columnPosition == sc.columnPosition && this.token == sc.token;
    }

    public String toString() {
        String name = this.sequence == null ? "" : this.sequence.getName();
        return String.format("%s:Pos%d:Col%d:startCol%d:endCol%d:tok%d", name, this.residuePosition, this.columnPosition, this.firstColumnPosition, this.lastColumnPosition, this.token);
    }
}

