/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class SearchResults
implements SearchResultsI {
    private int count;
    private List<SearchResultMatchI> matches = new ArrayList<SearchResultMatchI>();

    @Override
    public SearchResultMatchI addResult(SequenceI seq, int start, int end) {
        Match m = new Match(seq, start, end);
        if (!this.matches.contains(m)) {
            this.matches.add(m);
            ++this.count;
        }
        return m;
    }

    @Override
    public void addResult(SequenceI seq, int[] positions) {
        int beforeCount = this.count;
        for (int i = 0; i < positions.length - 1; i += 2) {
            this.addResult(seq, positions[i], positions[i + 1]);
        }
        if (this.count > beforeCount) {
            this.count = beforeCount + 1;
        }
    }

    @Override
    public boolean involvesSequence(SequenceI sequence) {
        int start = sequence.getStart();
        int end = sequence.getEnd();
        SequenceI ds = sequence.getDatasetSequence();
        for (SearchResultMatchI m : this.matches) {
            SequenceI matched = m.getSequence();
            if (matched == null || matched != sequence && matched != ds || m.getEnd() < start || m.getStart() > end) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] getResults(SequenceI sequence, int start, int end) {
        if (this.matches.isEmpty()) {
            return null;
        }
        int[] result = null;
        int[] tmp = null;
        int matchStart = 0;
        int matchEnd = 0;
        for (SearchResultMatchI _m : this.matches) {
            Match m = (Match)_m;
            boolean mfound = false;
            if (m.sequence == sequence || m.sequence == sequence.getDatasetSequence()) {
                mfound = true;
                matchStart = sequence.findIndex(m.start) - 1;
                int n = matchEnd = m.start == m.end ? matchStart : sequence.findIndex(m.end) - 1;
            }
            if (!mfound || matchStart > end || matchEnd < start) continue;
            if (matchStart < start) {
                matchStart = start;
            }
            if (matchEnd > end) {
                matchEnd = end;
            }
            if (result == null) {
                result = new int[]{matchStart, matchEnd};
                continue;
            }
            int resultLength = result.length;
            tmp = new int[resultLength + 2];
            System.arraycopy(result, 0, tmp, 0, resultLength);
            result = tmp;
            result[resultLength] = matchStart;
            result[resultLength + 1] = matchEnd;
        }
        return result;
    }

    @Override
    public int markColumns(SequenceCollectionI sqcol, BitSet bs) {
        int count = 0;
        BitSet mask = new BitSet();
        int startRes = sqcol.getStartRes();
        int endRes = sqcol.getEndRes();
        for (SequenceI s : sqcol.getSequences()) {
            int[] cols = this.getResults(s, startRes, endRes);
            if (cols == null) continue;
            for (int pair = 0; pair < cols.length; pair += 2) {
                mask.set(cols[pair], cols[pair + 1] + 1);
            }
        }
        BitSet original = (BitSet)bs.clone();
        original.and(mask);
        count = mask.cardinality() - original.cardinality();
        bs.or(mask);
        return count;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.matches.isEmpty();
    }

    @Override
    public List<SearchResultMatchI> getResults() {
        return this.matches;
    }

    public String toString() {
        return this.matches == null ? "" : this.matches.toString();
    }

    public int hashCode() {
        return this.matches.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SearchResultsI)) {
            return false;
        }
        SearchResultsI sr = (SearchResultsI)obj;
        return this.matches.equals(sr.getResults());
    }

    @Override
    public void addSearchResults(SearchResultsI toAdd) {
        this.matches.addAll(toAdd.getResults());
    }

    public class Match
    implements SearchResultMatchI {
        final SequenceI sequence;
        final int start;
        final int end;

        public Match(SequenceI seq, int start, int end) {
            this.sequence = seq;
            if (start <= end) {
                this.start = start;
                this.end = end;
            } else {
                this.start = end;
                this.end = start;
            }
        }

        @Override
        public SequenceI getSequence() {
            return this.sequence;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.sequence != null) {
                sb.append(this.sequence.getName()).append("/");
            }
            sb.append(this.start).append("-").append(this.end);
            return sb.toString();
        }

        public int hashCode() {
            int hash = this.sequence == null ? 0 : this.sequence.hashCode();
            hash += 31 * this.start;
            return hash += 67 * this.end;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof SearchResultMatchI)) {
                return false;
            }
            SearchResultMatchI m = (SearchResultMatchI)obj;
            return this.sequence == m.getSequence() && this.start == m.getStart() && this.end == m.getEnd();
        }

        @Override
        public boolean contains(SequenceI seq, int from, int to) {
            return this.sequence == seq && this.start <= from && this.end >= to;
        }
    }
}

