/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

public class DBRefSource {
    public static final String UNIPROT = "UNIPROT";
    public static final String UP_NAME = "UNIPROT_NAME".toUpperCase();
    public static final String UNIPROTKB = "UniProtKB/TrEMBL".toUpperCase();
    public static final String ENSEMBL = "ENSEMBL";
    public static final String ENSEMBLGENOMES = "ENSEMBLGENOMES";
    public static final String EMBL = "EMBL";
    public static final String EMBLCDS = "EMBLCDS";
    public static final String EMBLCDSProduct = "EMBLCDSProtein".toUpperCase();
    public static final String PDB = "PDB";
    public static final String PFAM = "PFAM";
    public static final String RFAM = "RFAM";
    public static final String GENEDB = "GeneDB".toUpperCase();
    public static final String PDB_CANONICAL_NAME = "PDB";
    public static final String[] allSources = new String[]{"UNIPROT", UP_NAME, UNIPROTKB, "ENSEMBL", "ENSEMBLGENOMES", "EMBL", "EMBLCDS", EMBLCDSProduct, "PDB", "PFAM", "RFAM", GENEDB};
    public static final int UNIPROT_MASK = 1;
    public static final int UP_NAME_MASK = 2;
    public static final int UNIPROT_KB_MASK = 4;
    public static final int ENSEMBL_MASK = 8;
    public static final int ENSEMBL_GENOMES_MASK = 16;
    public static final int EMBL_MASK = 32;
    public static final int EMBL_CDS_MASK = 64;
    public static final int EMBL_CDS_PRODUCT_MASK = 128;
    public static final int PDB_MASK = 256;
    public static final int PFAM_MASK = 512;
    public static final int RFAM_MASK = 1024;
    public static final int GENE_DB_MASK = 2048;
    public static final int MASK_COUNT = 12;
    public static final int ALL_MASKS = 4095;
    public static final int PRIMARY_MASK = 9;
    public static final String[] DNACODINGDBS = new String[]{"ENSEMBL", "ENSEMBLGENOMES", "EMBL", "EMBLCDS", GENEDB};
    public static final int DNA_CODING_MASK = 2168;
    public static final String[] CODINGDBS = new String[]{"EMBLCDS", GENEDB, "ENSEMBL"};
    public static final int CODING_MASK = 2120;
    public static final String[] PROTEINDBS = new String[]{"UNIPROT", UNIPROTKB, "ENSEMBL", EMBLCDSProduct};
    public static final int PROTEIN_MASK = 141;
    public static final int PRIMARY_SOURCES_MASK = 2301;

    public static int getSourceKey(String name) {
        for (int i = 0; i < 12; ++i) {
            if (!name.equals(allSources[i])) continue;
            return 1 << i;
        }
        return 0;
    }

    public static boolean isPrimarySource(String source) {
        return (0x8FD & DBRefSource.getSourceKey(source)) != 0;
    }

    public static boolean isPrimaryCandidate(String ucversion) {
        int i = allSources.length;
        while (--i >= 0) {
            if (!ucversion.startsWith(allSources[i])) continue;
            return false;
        }
        return true;
    }
}

