/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.CigarArray;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.util.ShiftList;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class AlignmentView {
    private SeqCigar[] sequences = null;
    private int[] contigs = null;
    private int width = 0;
    private int firstCol = 0;
    private List<ScGroup> scGroups = null;
    private boolean isNa = false;
    private ScGroup selected;

    public boolean isNa() {
        return this.isNa;
    }

    public AlignmentView(AlignmentI alignment, HiddenColumns hidden, SequenceGroup selection, boolean hasHiddenColumns, boolean selectedRegionOnly, boolean recordGroups) {
        this(new CigarArray(alignment, hasHiddenColumns ? hidden : null, selectedRegionOnly ? selection : null), selectedRegionOnly && selection != null ? selection.getStartRes() : 0);
        SequenceI[] selseqs;
        this.isNa = alignment.isNucleotide();
        if (selection != null && selection.getSize() > 0) {
            this.selected = new ScGroup();
            selseqs = selection.getSequencesInOrder(alignment, selectedRegionOnly);
        } else {
            selseqs = alignment.getSequencesArray();
        }
        ArrayList<List<SequenceI>> seqsets = new ArrayList<List<SequenceI>>();
        ArrayList<SequenceGroup> grps = new ArrayList<SequenceGroup>();
        List<SequenceGroup> gg = alignment.getGroups();
        grps.addAll(gg);
        ScGroup[] sgrps = null;
        boolean[] addedgps = null;
        if (grps != null) {
            if (selection != null && selectedRegionOnly) {
                int ssel = selection.getStartRes();
                int esel = selection.getEndRes();
                ArrayList<SequenceGroup> isg = new ArrayList<SequenceGroup>();
                for (SequenceGroup sg : grps) {
                    if (sg.getStartRes() > esel || sg.getEndRes() < ssel) continue;
                    if (sg.getStartRes() < ssel) {
                        sg.setStartRes(ssel);
                    }
                    if (sg.getEndRes() > esel) {
                        sg.setEndRes(esel);
                    }
                    sg.setStartRes(sg.getStartRes() - ssel + 1);
                    sg.setEndRes(sg.getEndRes() - ssel + 1);
                    isg.add(sg);
                }
                grps = isg;
            }
            sgrps = new ScGroup[grps.size()];
            addedgps = new boolean[grps.size()];
            for (int g = 0; g < sgrps.length; ++g) {
                SequenceGroup sg = (SequenceGroup)grps.get(g);
                sgrps[g] = new ScGroup();
                sgrps[g].sg = new SequenceGroup(sg);
                addedgps[g] = false;
                seqsets.add(sg.getSequences());
            }
        }
        int csi = 0;
        for (int i = 0; i < selseqs.length; ++i) {
            if (selseqs[i] == null) continue;
            if (selection != null && selection.getSize() > 0 && !selectedRegionOnly) {
                this.selected.add(this.sequences[csi]);
            }
            if (seqsets != null) {
                for (int sg = 0; sg < sgrps.length; ++sg) {
                    if (!((List)seqsets.get(sg)).contains(selseqs[i])) continue;
                    sgrps[sg].sg.deleteSequence(selseqs[i], false);
                    sgrps[sg].add(this.sequences[csi]);
                    if (addedgps[sg]) continue;
                    if (this.scGroups == null) {
                        this.scGroups = new ArrayList<ScGroup>();
                    }
                    addedgps[sg] = true;
                    this.scGroups.add(sgrps[sg]);
                }
            }
            ++csi;
        }
        for (int sg = 0; sg < sgrps.length; ++sg) {
            SequenceI[] sqs = sgrps[sg].sg.getSequencesAsArray(null);
            for (int si = 0; si < sqs.length; ++si) {
                sgrps[sg].sg.deleteSequence(sqs[si], false);
            }
            sgrps[sg] = null;
        }
    }

    public AlignmentView(CigarArray seqcigararray) {
        if (!seqcigararray.isSeqCigarArray()) {
            throw new Error("Implementation Error - can only make an alignment view from a CigarArray of sequences.");
        }
        this.contigs = seqcigararray.getDeletedRegions();
        this.sequences = seqcigararray.getSeqCigarArray();
        this.width = seqcigararray.getWidth();
    }

    public AlignmentView(CigarArray sdata, int firstcol) {
        this(sdata);
        this.firstCol = firstcol;
    }

    public void setSequences(SeqCigar[] sequences) {
        this.sequences = sequences;
    }

    public void setContigs(int[] contigs) {
        this.contigs = contigs;
    }

    public SeqCigar[] getSequences() {
        return this.sequences;
    }

    public int[] getContigs() {
        return this.contigs;
    }

    public Object[] getAlignmentAndHiddenColumns(char gapCharacter) {
        HiddenColumns hidden = new HiddenColumns();
        return new Object[]{SeqCigar.createAlignmentSequences(this.sequences, gapCharacter, hidden, this.contigs), hidden};
    }

    public AlignmentI getVisibleAlignment(char c) {
        SequenceI[] aln = this.getVisibleSeqs(c);
        Alignment vcal = new Alignment(aln);
        this.addPrunedGroupsInOrder(vcal, -1, -1, true);
        return vcal;
    }

    private void addPrunedGroupsInOrder(AlignmentI vcal, int gstart, int gend, boolean viscontigs) {
        int nvg;
        boolean r = false;
        if (gstart > -1 && gstart <= gend) {
            r = true;
        }
        SequenceI[] aln = vcal.getSequencesArray();
        int n = nvg = this.scGroups != null ? this.scGroups.size() : 0;
        if (nvg > 0) {
            int g;
            SequenceGroup[] nsg = new SequenceGroup[nvg];
            for (g = 0; g < nvg; ++g) {
                SequenceGroup sg = this.scGroups.get((int)g).sg;
                if (r && (sg.getStartRes() > gend || sg.getEndRes() < gstart)) {
                    nsg[g] = null;
                    continue;
                }
                nsg[g] = new SequenceGroup(sg);
                if (!r || viscontigs) continue;
                if (nsg[g].getStartRes() < gstart) {
                    nsg[g].setStartRes(0);
                } else {
                    nsg[g].setStartRes(nsg[g].getStartRes() - gstart);
                    nsg[g].setEndRes(nsg[g].getEndRes() - gstart);
                }
                if (nsg[g].getEndRes() <= gend - gstart) continue;
                nsg[g].setEndRes(gend - gstart);
            }
            if (viscontigs && this.contigs != null) {
                int p = 0;
                ShiftList prune = new ShiftList();
                if (r) {
                    prune.addShift(gstart, -gstart);
                }
                for (int h = 0; h < this.contigs.length; h += 3) {
                    prune.addShift(p + this.contigs[h + 1], this.contigs[h + 2] - this.contigs[h + 1]);
                    p = this.contigs[h + 1] + this.contigs[h + 2];
                }
                for (int g2 = 0; g2 < nsg.length; ++g2) {
                    if (nsg[g2] == null) continue;
                    int s = nsg[g2].getStartRes();
                    int t = nsg[g2].getEndRes();
                    int w = 1 + t - s;
                    if (r) {
                        if (s < gstart) {
                            s = gstart;
                        }
                        if (t > gend) {
                            t = gend;
                        }
                    }
                    s = prune.shift(s);
                    t = prune.shift(t);
                    nsg[g2].setStartRes(s);
                    nsg[g2].setEndRes(t);
                }
            }
            for (int nsq = 0; nsq < aln.length; ++nsq) {
                for (int g3 = 0; g3 < nvg; ++g3) {
                    if (nsg[g3] == null || !this.sequences[nsq].isMemberOf(this.scGroups.get(g3))) continue;
                    nsg[g3].addSequence(aln[nsq], false);
                }
            }
            for (g = 0; g < nvg; ++g) {
                if (nsg[g] != null && nsg[g].getSize() > 0) {
                    vcal.addGroup(nsg[g]);
                }
                nsg[g] = null;
            }
        }
    }

    private SequenceI[] getVisibleSeqs(char c) {
        SequenceI[] aln = new SequenceI[this.sequences.length];
        int j = this.sequences.length;
        for (int i = 0; i < j; ++i) {
            aln[i] = this.sequences[i].getSeq(c);
            aln[i].setSequence(this.getASequenceString(c, i));
        }
        return aln;
    }

    public AlignmentI[] getVisibleContigAlignments(char c) {
        int nvc = 0;
        int[] vcontigs = this.getVisibleContigs();
        SequenceI[][] contigviews = this.getVisibleContigs(c);
        AlignmentI[] vcals = new AlignmentI[contigviews.length];
        for (nvc = 0; nvc < contigviews.length; ++nvc) {
            vcals[nvc] = new Alignment(contigviews[nvc]);
            if (this.scGroups == null || this.scGroups.size() <= 0) continue;
            this.addPrunedGroupsInOrder(vcals[nvc], vcontigs[nvc * 2], vcontigs[nvc * 2 + 1], true);
        }
        return vcals;
    }

    private String getASequenceString(char c, int n) {
        String sqn;
        String fullseq = this.sequences[n].getSequenceString(c);
        if (this.contigs != null) {
            sqn = "";
            int p = 0;
            for (int h = 0; h < this.contigs.length; h += 3) {
                sqn = sqn + fullseq.substring(p, this.contigs[h + 1]);
                p = this.contigs[h + 1] + this.contigs[h + 2];
            }
            sqn = sqn + fullseq.substring(p);
        } else {
            sqn = fullseq;
        }
        return sqn;
    }

    public String[] getSequenceStrings(char c) {
        String[] seqs = new String[this.sequences.length];
        for (int n = 0; n < this.sequences.length; ++n) {
            seqs[n] = this.getASequenceString(c, n);
        }
        return seqs;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public SequenceI[][] getVisibleContigs(char gapCharacter) {
        SequenceI[][] smsa;
        int njobs = 1;
        if (this.sequences == null || this.width <= 0) {
            return null;
        }
        if (this.contigs != null && this.contigs.length > 0) {
            int start = 0;
            njobs = 0;
            int fwidth = this.width;
            for (int contig = 0; contig < this.contigs.length; contig += 3) {
                if (this.contigs[contig + 1] - start > 0) {
                    ++njobs;
                }
                fwidth += this.contigs[contig + 2];
                start = this.contigs[contig + 1] + this.contigs[contig + 2];
            }
            if (start < fwidth) {
                ++njobs;
            }
            smsa = new SequenceI[njobs][];
            start = 0;
            int j = 0;
            for (int contig = 0; contig < this.contigs.length; contig += 3) {
                if (this.contigs[contig + 1] - start > 0) {
                    SequenceI[] mseq = new SequenceI[this.sequences.length];
                    for (int s = 0; s < mseq.length; ++s) {
                        mseq[s] = this.sequences[s].getSeq(gapCharacter).getSubSequence(start, this.contigs[contig + 1]);
                    }
                    smsa[j] = mseq;
                    ++j;
                }
                start = this.contigs[contig + 1] + this.contigs[contig + 2];
            }
            if (start < fwidth) {
                SequenceI[] mseq = new SequenceI[this.sequences.length];
                for (int s = 0; s < mseq.length; ++s) {
                    mseq[s] = this.sequences[s].getSeq(gapCharacter).getSubSequence(start, fwidth + 1);
                }
                smsa[j] = mseq;
                ++j;
            }
        } else {
            smsa = new SequenceI[][]{new SequenceI[this.sequences.length]};
            for (int s = 0; s < this.sequences.length; ++s) {
                smsa[0][s] = this.sequences[s].getSeq(gapCharacter);
            }
        }
        return smsa;
    }

    public Object[] getUpdatedView(SequenceI[][] nvismsa, AlignmentOrder[] orders, char gapCharacter) {
        if (this.sequences == null || this.width <= 0) {
            throw new Error(MessageManager.getString("error.empty_view_cannot_be_updated"));
        }
        if (nvismsa == null) {
            throw new Error("nvismsa==null. use getAlignmentAndColumnSelection() instead.");
        }
        if (this.contigs != null && this.contigs.length > 0) {
            SequenceI[] alignment = new SequenceI[this.sequences.length];
            HiddenColumns hidden = new HiddenColumns();
            if (this.contigs != null && this.contigs.length > 0) {
                int s;
                int start = 0;
                int nwidth = 0;
                int owidth = this.width;
                int j = 0;
                for (int contig = 0; contig < this.contigs.length; contig += 3) {
                    owidth += this.contigs[contig + 2];
                    if (this.contigs[contig + 1] - start > 0) {
                        int swidth = 0;
                        if (nvismsa[j] != null) {
                            SequenceI[] mseq = nvismsa[j];
                            AlignmentOrder order = orders == null ? null : orders[j];
                            ++j;
                            if (mseq.length != this.sequences.length) {
                                throw new Error(MessageManager.formatMessage("error.mismatch_between_number_of_sequences_in_block", new String[]{Integer.valueOf(j).toString(), Integer.valueOf(mseq.length).toString(), Integer.valueOf(this.sequences.length).toString()}));
                            }
                            swidth = mseq[0].getLength();
                            for (int s2 = 0; s2 < mseq.length; ++s2) {
                                if (alignment[s2] == null) {
                                    alignment[s2] = mseq[s2];
                                    continue;
                                }
                                alignment[s2].setSequence(alignment[s2].getSequenceAsString() + mseq[s2].getSequenceAsString());
                                if (mseq[s2].getStart() <= mseq[s2].getEnd()) {
                                    alignment[s2].setEnd(mseq[s2].getEnd());
                                }
                                if (order == null) continue;
                                order.updateSequence(mseq[s2], alignment[s2]);
                            }
                        } else {
                            for (int s3 = 0; s3 < this.sequences.length; ++s3) {
                                SequenceI oseq = this.sequences[s3].getSeq(gapCharacter).getSubSequence(start, this.contigs[contig + 1]);
                                if (swidth < oseq.getLength()) {
                                    swidth = oseq.getLength();
                                }
                                if (alignment[s3] == null) {
                                    alignment[s3] = oseq;
                                    continue;
                                }
                                alignment[s3].setSequence(alignment[s3].getSequenceAsString() + oseq.getSequenceAsString());
                                if (oseq.getEnd() < oseq.getStart()) continue;
                                alignment[s3].setEnd(oseq.getEnd());
                            }
                            ++j;
                        }
                        nwidth += swidth;
                    }
                    start = this.contigs[contig + 1] + this.contigs[contig + 2];
                    for (s = 0; s < this.sequences.length; ++s) {
                        SequenceI hseq = this.sequences[s].getSeq(gapCharacter).getSubSequence(this.contigs[contig + 1], start);
                        if (alignment[s] == null) {
                            alignment[s] = hseq;
                            continue;
                        }
                        alignment[s].setSequence(alignment[s].getSequenceAsString() + hseq.getSequenceAsString());
                        if (hseq.getEnd() < hseq.getStart()) continue;
                        alignment[s].setEnd(hseq.getEnd());
                    }
                    hidden.hideColumns(nwidth, nwidth + this.contigs[contig + 2] - 1);
                    nwidth += this.contigs[contig + 2];
                }
                if (j < nvismsa.length) {
                    int swidth = 0;
                    if (nvismsa[j] != null) {
                        SequenceI[] mseq = nvismsa[j];
                        AlignmentOrder order = orders != null ? orders[j] : null;
                        swidth = mseq[0].getLength();
                        for (int s4 = 0; s4 < mseq.length; ++s4) {
                            if (alignment[s4] == null) {
                                alignment[s4] = mseq[s4];
                                continue;
                            }
                            alignment[s4].setSequence(alignment[s4].getSequenceAsString() + mseq[s4].getSequenceAsString());
                            if (mseq[s4].getEnd() >= mseq[s4].getStart()) {
                                alignment[s4].setEnd(mseq[s4].getEnd());
                            }
                            if (order == null) continue;
                            order.updateSequence(mseq[s4], alignment[s4]);
                        }
                    } else if (start < owidth) {
                        for (s = 0; s < this.sequences.length; ++s) {
                            SequenceI oseq = this.sequences[s].getSeq(gapCharacter).getSubSequence(start, owidth + 1);
                            if (swidth < oseq.getLength()) {
                                swidth = oseq.getLength();
                            }
                            if (alignment[s] == null) {
                                alignment[s] = oseq;
                                continue;
                            }
                            alignment[s].setSequence(alignment[s].getSequenceAsString() + oseq.getSequenceAsString());
                            if (oseq.getEnd() < oseq.getStart()) continue;
                            alignment[s].setEnd(oseq.getEnd());
                        }
                        nwidth += swidth;
                    }
                }
            }
            return new Object[]{alignment, hidden};
        }
        if (nvismsa.length != 1) {
            throw new Error(MessageManager.formatMessage("error.mismatch_between_visible_blocks_to_update_and_number_of_contigs_in_view", new String[]{Integer.valueOf(nvismsa.length).toString()}));
        }
        if (nvismsa[0] != null) {
            return new Object[]{nvismsa[0], new HiddenColumns()};
        }
        return this.getAlignmentAndHiddenColumns(gapCharacter);
    }

    public int[] getVisibleContigs() {
        if (this.contigs != null && this.contigs.length > 0) {
            int start = 0;
            int nvis = 0;
            int fwidth = this.width;
            for (int contig = 0; contig < this.contigs.length; contig += 3) {
                if (this.contigs[contig + 1] - start > 0) {
                    ++nvis;
                }
                fwidth += this.contigs[contig + 2];
                start = this.contigs[contig + 1] + this.contigs[contig + 2];
            }
            if (start < fwidth) {
                ++nvis;
            }
            int[] viscontigs = new int[nvis * 2];
            nvis = 0;
            start = 0;
            for (int contig = 0; contig < this.contigs.length; contig += 3) {
                if (this.contigs[contig + 1] - start > 0) {
                    viscontigs[nvis] = start;
                    viscontigs[nvis + 1] = this.contigs[contig + 1] - 1;
                    nvis += 2;
                }
                start = this.contigs[contig + 1] + this.contigs[contig + 2];
            }
            if (start < fwidth) {
                viscontigs[nvis] = start;
                viscontigs[nvis + 1] = fwidth - 1;
                nvis += 2;
            }
            return viscontigs;
        }
        return new int[]{0, this.width - 1};
    }

    public int getAlignmentOrigin() {
        return this.firstCol;
    }

    public int[] getVisibleContigMapFor(int[] gapMap) {
        int[] delMap = null;
        int[] viscontigs = this.getVisibleContigs();
        int spos = 0;
        int i = 0;
        if (viscontigs != null) {
            delMap = new int[gapMap.length];
            for (int contig = 0; contig < viscontigs.length; contig += 2) {
                while (spos < gapMap.length && gapMap[spos] < viscontigs[contig]) {
                    ++spos;
                }
                while (spos < gapMap.length && gapMap[spos] <= viscontigs[contig + 1]) {
                    delMap[i++] = spos++;
                }
            }
            int[] tmap = new int[i];
            System.arraycopy(delMap, 0, tmap, 0, i);
            delMap = tmap;
        }
        return delMap;
    }

    public SequenceI[] getEditedSequences(char gc, boolean delete) {
        SeqCigar[] msf = this.getSequences();
        SequenceI[] aln = new SequenceI[msf.length];
        int j = msf.length;
        for (int i = 0; i < j; ++i) {
            aln[i] = msf[i].getSeq(gc);
        }
        if (delete) {
            String[] sqs = this.getSequenceStrings(gc);
            for (int i = 0; i < sqs.length; ++i) {
                aln[i].setSequence(sqs[i]);
                sqs[i] = null;
            }
        }
        return aln;
    }

    public static void summariseAlignmentView(AlignmentView view, PrintStream os) {
        os.print("View has " + view.sequences.length + " of which ");
        if (view.selected == null) {
            os.print("None");
        } else {
            os.print(" " + view.selected.size());
        }
        os.println(" are selected.");
        os.print("View is " + view.getWidth() + " columns wide");
        int viswid = 0;
        int[] contigs = view.getContigs();
        if (contigs != null) {
            viswid = view.width;
            for (int i = 0; i < contigs.length; i += 3) {
                viswid += contigs[i + 2];
            }
            os.println("with " + viswid + " visible columns spread over " + contigs.length / 3 + " regions.");
        } else {
            viswid = view.width;
            os.println(".");
        }
        if (view.scGroups != null) {
            os.println("There are " + view.scGroups.size() + " groups defined on the view.");
            for (int g = 0; g < view.scGroups.size(); ++g) {
                ScGroup sgr = view.scGroups.get(g);
                os.println("Group " + g + ": Name = " + sgr.sg.getName() + " Contains " + sgr.seqs.size() + " Seqs.");
                os.println("This group runs from " + sgr.sg.getStartRes() + " to " + sgr.sg.getEndRes());
                for (int s = 0; s < sgr.seqs.size(); ++s) {
                    if (sgr.seqs.get(s).isMemberOf(sgr)) continue;
                    os.println("** WARNING: sequence " + sgr.seqs.get(s).toString() + " is not marked as member of group.");
                }
            }
            AlignmentI visal = view.getVisibleAlignment('-');
            if (visal != null) {
                os.println("Vis. alignment is " + visal.getWidth() + " wide and has " + visal.getHeight() + " seqs.");
                if (visal.getGroups() != null && visal.getGroups().size() > 0) {
                    int i = 1;
                    for (SequenceGroup sg : visal.getGroups()) {
                        os.println("Group " + i++ + " begins at column " + sg.getStartRes() + " and ends at " + sg.getEndRes());
                    }
                }
            }
        }
    }

    public static void testSelectionViews(AlignmentI alignment, HiddenColumns hidden, SequenceGroup selection) {
        System.out.println("Testing standard view creation:\n");
        AlignmentView view = null;
        try {
            System.out.println("View with no hidden columns, no limit to selection, no groups to be collected:");
            view = new AlignmentView(alignment, hidden, selection, false, false, false);
            AlignmentView.summariseAlignmentView(view, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to generate alignment with selection but no groups marked.");
        }
        try {
            System.out.println("View with no hidden columns, no limit to selection, and all groups to be collected:");
            view = new AlignmentView(alignment, hidden, selection, false, false, true);
            AlignmentView.summariseAlignmentView(view, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to generate alignment with selection marked but no groups marked.");
        }
        try {
            System.out.println("View with no hidden columns, limited to selection and no groups to be collected:");
            view = new AlignmentView(alignment, hidden, selection, false, true, false);
            AlignmentView.summariseAlignmentView(view, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to generate alignment with selection restricted but no groups marked.");
        }
        try {
            System.out.println("View with no hidden columns, limited to selection, and all groups to be collected:");
            view = new AlignmentView(alignment, hidden, selection, false, true, true);
            AlignmentView.summariseAlignmentView(view, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to generate alignment with selection restricted and groups marked.");
        }
        try {
            System.out.println("View *with* hidden columns, no limit to selection, no groups to be collected:");
            view = new AlignmentView(alignment, hidden, selection, true, false, false);
            AlignmentView.summariseAlignmentView(view, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to generate alignment with selection but no groups marked.");
        }
        try {
            System.out.println("View *with* hidden columns, no limit to selection, and all groups to be collected:");
            view = new AlignmentView(alignment, hidden, selection, true, false, true);
            AlignmentView.summariseAlignmentView(view, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to generate alignment with selection marked but no groups marked.");
        }
        try {
            System.out.println("View *with* hidden columns, limited to selection and no groups to be collected:");
            view = new AlignmentView(alignment, hidden, selection, true, true, false);
            AlignmentView.summariseAlignmentView(view, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to generate alignment with selection restricted but no groups marked.");
        }
        try {
            System.out.println("View *with* hidden columns, limited to selection, and all groups to be collected:");
            view = new AlignmentView(alignment, hidden, selection, true, true, true);
            AlignmentView.summariseAlignmentView(view, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to generate alignment with selection restricted and groups marked.");
        }
    }

    private class ScGroup {
        public List<SeqCigar> seqs = new ArrayList<SeqCigar>();
        public SequenceGroup sg;

        ScGroup() {
        }

        public boolean add(SeqCigar seq) {
            if (!seq.isMemberOf(this)) {
                this.seqs.add(seq);
                seq.setGroupMembership(this);
                return true;
            }
            return false;
        }

        public boolean remove(SeqCigar seq) {
            if (seq.removeGroupMembership(this)) {
                this.seqs.remove(seq);
                return true;
            }
            return false;
        }

        public int size() {
            return this.seqs.size();
        }
    }
}

