/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import ch.randelshofer.quaqua.QuaquaManager;
import com.threerings.getdown.util.LaunchUtil;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import jalview.bin.ArgsParser;
import jalview.bin.Cache;
import jalview.bin.JalviewTaskbar;
import jalview.ext.so.SequenceOntology;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.PromptUserConfig;
import jalview.httpserver.HttpServer;
import jalview.io.AppletFormatAdapter;
import jalview.io.BioJsHTMLOutput;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatException;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileLoader;
import jalview.io.HtmlSvgOutput;
import jalview.io.IdentifyFile;
import jalview.io.NewickFile;
import jalview.io.gff.SequenceOntologyFactory;
import jalview.rest.API;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.util.ChannelProperties;
import jalview.util.HttpUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.jws2.Jws2Discoverer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public class Jalview {
    private static Jalview instance;
    private Desktop desktop;
    public static AlignFrame currentAlignFrame;

    public static Jalview getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        instance = new Jalview();
        instance.doMain(args);
    }

    private static void logClass(String name) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        Logger logger = Logger.getLogger(name);
        logger.setLevel(Level.ALL);
        logger.addHandler(consoleHandler);
    }

    private static void setLogging() {
        System.out.println("not in js");
        if (!Platform.isJS()) {
            Logger.getLogger("").setLevel(Level.ALL);
            Jalview.logClass("java.awt.EventDispatchThread");
            Jalview.logClass("java.awt.EventQueue");
            Jalview.logClass("java.awt.Component");
            Jalview.logClass("java.awt.focus.Component");
            Jalview.logClass("java.awt.focus.DefaultKeyboardFocusManager");
        }
    }

    void doMain(String[] args) {
        String appdirString;
        String sPort;
        boolean soDefault;
        if (!Platform.isJS()) {
            System.setSecurityManager(null);
        }
        System.out.println("Java version: " + System.getProperty("java.version"));
        System.out.println("Java Home: " + System.getProperty("java.home"));
        System.out.println(System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        String val = System.getProperty("sys.install4jVersion");
        if (val != null) {
            System.out.println("Install4j version: " + val);
        }
        if ((val = System.getProperty("installer_template_version")) != null) {
            System.out.println("Install4j template version: " + val);
        }
        if ((val = System.getProperty("launcher_version")) != null) {
            System.out.println("Launcher version: " + val);
        }
        Cache.loadBuildProperties(true);
        ArgsParser aparser = new ArgsParser(args);
        boolean headless = false;
        String usrPropsFile = aparser.getValue("props");
        Cache.loadProperties(usrPropsFile);
        if (usrPropsFile != null) {
            System.out.println("CMD [-props " + usrPropsFile + "] executed successfully!");
        }
        if (!Platform.isJS()) {
            String jabawsUrl;
            if (aparser.contains("help") || aparser.contains("h")) {
                Jalview.showUsage();
                System.exit(0);
            }
            if (aparser.contains("nodisplay") || aparser.contains("nogui") || aparser.contains("headless")) {
                System.setProperty("java.awt.headless", "true");
                headless = true;
            }
            if ((jabawsUrl = aparser.getValue("jabaws")) != null) {
                try {
                    Jws2Discoverer.getDiscoverer().setPreferredUrl(jabawsUrl);
                    System.out.println("CMD [-jabaws " + jabawsUrl + "] executed successfully!");
                }
                catch (MalformedURLException e) {
                    System.err.println("Invalid jabaws parameter: " + jabawsUrl + " ignored");
                }
            }
        }
        String defs = aparser.getValue("setprop");
        while (defs != null) {
            int p = defs.indexOf(61);
            if (p == -1) {
                System.err.println("Ignoring invalid setprop argument : " + defs);
            } else {
                System.out.println("Executing setprop argument: " + defs);
                if (Platform.isJS()) {
                    Cache.setProperty(defs.substring(0, p), defs.substring(p + 1));
                }
            }
            defs = aparser.getValue("setprop");
        }
        if (System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true")) {
            headless = true;
        }
        System.setProperty("http.agent", "Jalview Desktop/" + Cache.getDefault("VERSION", "Unknown"));
        try {
            Cache.initLogger();
        }
        catch (NoClassDefFoundError error) {
            error.printStackTrace();
            System.out.println("\nEssential logging libraries not found.\nUse: java -classpath \"$PATH_TO_LIB$/*:$PATH_TO_CLASSES$\" jalview.bin.Jalview");
            System.exit(0);
        }
        this.desktop = null;
        Jalview.setLookAndFeel();
        boolean bl = soDefault = !Platform.isJS();
        if (Cache.getDefault("USE_FULL_SO", soDefault)) {
            SequenceOntologyFactory.setInstance(new SequenceOntology());
        }
        if (!headless) {
            Desktop.nosplash = aparser.contains("nosplash");
            this.desktop = new Desktop();
            this.desktop.setInBatchMode(true);
            try {
                JalviewTaskbar.setTaskbar(this);
            }
            catch (Exception e) {
                Cache.log.info((Object)"Cannot set Taskbar");
                Cache.log.error((Object)e.getMessage());
            }
            catch (Throwable t) {
                Cache.log.info((Object)"Cannot set Taskbar");
                Cache.log.error((Object)t.getMessage());
            }
            Cache.setProxyPropertiesFromPreferences();
            this.desktop.setVisible(true);
            if (!Platform.isJS()) {
                if (!aparser.contains("nowebservicediscovery")) {
                    this.desktop.startServiceDiscovery();
                }
                if (!aparser.contains("nousagestats")) {
                    Jalview.startUsageStats(this.desktop);
                } else {
                    System.err.println("CMD [-nousagestats] executed successfully!");
                }
                if (!aparser.contains("noquestionnaire")) {
                    String url = aparser.getValue("questionnaire");
                    if (url != null) {
                        Cache.log.debug((Object)("Starting questionnaire url at " + url));
                        this.desktop.checkForQuestionnaire(url);
                        System.out.println("CMD questionnaire[-" + url + "] executed successfully!");
                    } else if (Cache.getProperty("NOQUESTIONNAIRES") == null) {
                        String defurl = "http://www.jalview.org/cgi-bin/questionnaire.pl";
                        Cache.log.debug((Object)("Starting questionnaire with default url: " + defurl));
                        this.desktop.checkForQuestionnaire(defurl);
                    }
                } else {
                    System.err.println("CMD [-noquestionnaire] executed successfully!");
                }
                if (!aparser.contains("nonews")) {
                    this.desktop.checkForNews();
                }
                BioJsHTMLOutput.updateBioJS();
            }
        }
        if ((sPort = aparser.getValue("serverport")) != null) {
            int port = 0;
            try {
                port = Integer.parseInt(sPort);
                HttpServer.setSuggestedPort(port);
                Cache.info("Set suggested server port to " + port);
            }
            catch (NumberFormatException e) {
                Cache.warn("server_port '" + sPort + "' not parseable as Integer");
            }
        }
        if (aparser.contains("startapi")) {
            try {
                API api = API.getInstance();
                Cache.info(api.getName() + " started at " + HttpServer.getInstance().getUri().toString());
            }
            catch (BindException e) {
                Cache.warn("Could not open a genomeapi");
                Cache.error(e);
            }
        }
        if ((appdirString = System.getProperty("getdownappdir")) != null && appdirString.length() > 0) {
            final File appdir = new File(appdirString);
            new Thread(){

                @Override
                public void run() {
                    LaunchUtil.upgradeGetdown((File)new File(appdir, "getdown-launcher-old.jar"), (File)new File(appdir, "getdown-launcher.jar"), (File)new File(appdir, "getdown-launcher-new.jar"));
                }
            }.start();
        }
        String file = null;
        String data = null;
        FileFormatI format = null;
        DataSourceType protocol = null;
        FileLoader fileLoader = new FileLoader(!headless);
        String groovyscript = null;
        groovyscript = aparser.getValue("groovy", true);
        file = aparser.getValue("open", true);
        if (file == null && this.desktop == null) {
            System.out.println("No files to open!");
            System.exit(1);
        }
        long progress = -1L;
        if (file != null) {
            if (!headless) {
                progress = System.currentTimeMillis();
                this.desktop.setProgressBar(MessageManager.getString("status.processing_commandline_args"), progress);
            }
            System.out.println("CMD [-open " + file + "] executed successfully!");
            if (!(Platform.isJS() || HttpUtils.startsWithHttpOrHttps(file) || new File(file).exists())) {
                System.out.println("Can't find " + file);
                if (headless) {
                    System.exit(1);
                }
            }
            protocol = AppletFormatAdapter.checkProtocol(file);
            try {
                format = new IdentifyFile().identify(file, protocol);
            }
            catch (FileFormatException fileFormatException) {
                // empty catch block
            }
            AlignFrame af = fileLoader.LoadFileWaitTillLoaded(file, protocol, format);
            if (af == null) {
                System.out.println("error");
            } else {
                Jalview.setCurrentAlignFrame(af);
                data = aparser.getValue("colour", true);
                if (data != null) {
                    data.replaceAll("%20", " ");
                    ColourSchemeI cs = ColourSchemeProperty.getColourScheme(af.getViewport(), af.getViewport().getAlignment(), data);
                    if (cs != null) {
                        System.out.println("CMD [-color " + data + "] executed successfully!");
                    }
                    af.changeColour(cs);
                }
                if ((data = aparser.getValue("groups", true)) != null) {
                    af.parseFeaturesFile(data, AppletFormatAdapter.checkProtocol(data));
                    System.out.println("CMD groups[-" + data + "]  executed successfully!");
                }
                if ((data = aparser.getValue("features", true)) != null) {
                    af.parseFeaturesFile(data, AppletFormatAdapter.checkProtocol(data));
                    System.out.println("CMD [-features " + data + "]  executed successfully!");
                }
                if ((data = aparser.getValue("annotations", true)) != null) {
                    af.loadJalviewDataFile(data, null, null, null);
                    System.out.println("CMD [-annotations " + data + "] executed successfully!");
                }
                if (aparser.contains("sortbytree")) {
                    af.getViewport().setSortByTree(true);
                    if (af.getViewport().getSortByTree()) {
                        System.out.println("CMD [-sortbytree] executed successfully!");
                    }
                }
                if (aparser.contains("no-annotation")) {
                    af.getViewport().setShowAnnotation(false);
                    if (!af.getViewport().isShowAnnotation()) {
                        System.out.println("CMD no-annotation executed successfully!");
                    }
                }
                if (aparser.contains("nosortbytree")) {
                    af.getViewport().setSortByTree(false);
                    if (!af.getViewport().getSortByTree()) {
                        System.out.println("CMD [-nosortbytree] executed successfully!");
                    }
                }
                if ((data = aparser.getValue("tree", true)) != null) {
                    try {
                        System.out.println("CMD [-tree " + data + "] executed successfully!");
                        NewickFile nf = new NewickFile(data, AppletFormatAdapter.checkProtocol(data));
                        af.getViewport().setCurrentTree(af.showNewickTree(nf, data).getTree());
                    }
                    catch (IOException ex) {
                        System.err.println("Couldn't add tree " + data);
                        ex.printStackTrace(System.err);
                    }
                }
                if (groovyscript != null) {
                    System.out.println("Executing script " + groovyscript);
                    this.executeGroovyScript(groovyscript, af);
                    System.out.println("CMD groovy[" + groovyscript + "] executed successfully!");
                    groovyscript = null;
                }
                String imageName = "unnamed.png";
                while (aparser.getSize() > 1) {
                    File imageFile;
                    String outputFormat = aparser.nextValue();
                    file = aparser.nextValue();
                    if (outputFormat.equalsIgnoreCase("png")) {
                        af.createPNG(new File(file));
                        imageName = new File(file).getName();
                        System.out.println("Creating PNG image: " + file);
                        continue;
                    }
                    if (outputFormat.equalsIgnoreCase("svg")) {
                        imageFile = new File(file);
                        imageName = imageFile.getName();
                        af.createSVG(imageFile);
                        System.out.println("Creating SVG image: " + file);
                        continue;
                    }
                    if (outputFormat.equalsIgnoreCase("html")) {
                        imageFile = new File(file);
                        imageName = imageFile.getName();
                        HtmlSvgOutput htmlSVG = new HtmlSvgOutput(af.alignPanel);
                        htmlSVG.exportHTML(file);
                        System.out.println("Creating HTML image: " + file);
                        continue;
                    }
                    if (outputFormat.equalsIgnoreCase("biojsmsa")) {
                        if (file == null) {
                            System.err.println("The output html file must not be null");
                            return;
                        }
                        try {
                            BioJsHTMLOutput.refreshVersionInfo(BioJsHTMLOutput.BJS_TEMPLATES_LOCAL_DIRECTORY);
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        BioJsHTMLOutput bjs = new BioJsHTMLOutput(af.alignPanel);
                        bjs.exportHTML(file);
                        System.out.println("Creating BioJS MSA Viwer HTML file: " + file);
                        continue;
                    }
                    if (outputFormat.equalsIgnoreCase("imgMap")) {
                        af.createImageMap(new File(file), imageName);
                        System.out.println("Creating image map: " + file);
                        continue;
                    }
                    if (outputFormat.equalsIgnoreCase("eps")) {
                        File outputFile = new File(file);
                        System.out.println("Creating EPS file: " + outputFile.getAbsolutePath());
                        af.createEPS(outputFile);
                        continue;
                    }
                    FileFormatI outFormat = null;
                    try {
                        outFormat = FileFormats.getInstance().forName(outputFormat);
                    }
                    catch (Exception formatP) {
                        System.out.println("Couldn't parse " + outFormat + " as a valid Jalview format string.");
                    }
                    if (outFormat == null) continue;
                    if (!outFormat.isWritable()) {
                        System.out.println("This version of Jalview does not support alignment export as " + outputFormat);
                        continue;
                    }
                    af.saveAlignment(file, outFormat);
                    if (af.isSaveAlignmentSuccessful()) {
                        System.out.println("Written alignment in " + outFormat.getName() + " format to " + file);
                        continue;
                    }
                    System.out.println("Error writing file " + file + " in " + outFormat.getName() + " format!!");
                }
                while (aparser.getSize() > 0) {
                    System.out.println("Unknown arg: " + aparser.nextValue());
                }
            }
        }
        AlignFrame startUpAlframe = null;
        if (!Platform.isJS() && !headless && file == null && Cache.getDefault("SHOW_STARTUP_FILE", true)) {
            file = Cache.getDefault("STARTUP_FILE", Cache.getDefault("www.jalview.org", "http://www.jalview.org") + "/examples/exampleFile_2_7.jar");
            if (file.equals("http://www.jalview.org/examples/exampleFile_2_3.jar")) {
                file.replace("_2_3.jar", "_2_7.jar");
                Cache.removeProperty("STARTUP_FILE");
            }
            protocol = AppletFormatAdapter.checkProtocol(file);
            if (file.endsWith(".jar")) {
                format = FileFormat.Jalview;
            } else {
                try {
                    format = new IdentifyFile().identify(file, protocol);
                }
                catch (FileFormatException fileFormatException) {
                    // empty catch block
                }
            }
            startUpAlframe = fileLoader.LoadFileWaitTillLoaded(file, protocol, format);
        }
        if (groovyscript != null) {
            if (Cache.groovyJarsPresent()) {
                System.out.println("Executing script " + groovyscript);
                this.executeGroovyScript(groovyscript, startUpAlframe);
            } else {
                System.err.println("Sorry. Groovy Support is not available, so ignoring the provided groovy script " + groovyscript);
            }
        }
        if (this.desktop != null) {
            if (progress != -1L) {
                this.desktop.setProgressBar(null, progress);
            }
            this.desktop.setInBatchMode(false);
        }
    }

    private static void setLookAndFeel() {
        String lafProp = System.getProperty("laf");
        String lafSetting = Cache.getDefault("PREFERRED_LAF", null);
        String laf = "none";
        if (lafProp != null) {
            laf = lafProp;
        } else if (lafSetting != null) {
            laf = lafSetting;
        }
        boolean lafSet = false;
        switch (laf) {
            case "crossplatform": {
                lafSet = Jalview.setCrossPlatformLookAndFeel();
                if (lafSet) break;
                Cache.log.error((Object)("Could not set requested laf=" + laf));
                break;
            }
            case "system": {
                lafSet = Jalview.setSystemLookAndFeel();
                if (lafSet) break;
                Cache.log.error((Object)("Could not set requested laf=" + laf));
                break;
            }
            case "gtk": {
                lafSet = Jalview.setGtkLookAndFeel();
                if (lafSet) break;
                Cache.log.error((Object)("Could not set requested laf=" + laf));
                break;
            }
            case "metal": {
                lafSet = Jalview.setMetalLookAndFeel();
                if (lafSet) break;
                Cache.log.error((Object)("Could not set requested laf=" + laf));
                break;
            }
            case "nimbus": {
                lafSet = Jalview.setNimbusLookAndFeel();
                if (lafSet) break;
                Cache.log.error((Object)("Could not set requested laf=" + laf));
                break;
            }
            case "quaqua": {
                lafSet = Jalview.setQuaquaLookAndFeel();
                if (lafSet) break;
                Cache.log.error((Object)("Could not set requested laf=" + laf));
                break;
            }
            case "vaqua": {
                lafSet = Jalview.setVaquaLookAndFeel();
                if (lafSet) break;
                Cache.log.error((Object)("Could not set requested laf=" + laf));
                break;
            }
            case "mac": {
                lafSet = Jalview.setMacLookAndFeel();
                if (lafSet) break;
                Cache.log.error((Object)("Could not set requested laf=" + laf));
                break;
            }
            case "none": {
                break;
            }
            default: {
                Cache.log.error((Object)("Requested laf=" + laf + " not implemented"));
            }
        }
        if (!lafSet) {
            Jalview.setSystemLookAndFeel();
            if (Platform.isLinux()) {
                Jalview.setMetalLookAndFeel();
            }
            if (Platform.isMac()) {
                Jalview.setMacLookAndFeel();
            }
        }
    }

    private static boolean setCrossPlatformLookAndFeel() {
        boolean set = false;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            set = true;
        }
        catch (Exception ex) {
            Cache.log.error((Object)"Unexpected Look and Feel Exception");
            Cache.log.error((Object)ex.getMessage());
            Cache.log.debug((Object)Cache.getStackTraceString(ex));
        }
        return set;
    }

    private static boolean setSystemLookAndFeel() {
        boolean set = false;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            set = true;
        }
        catch (Exception ex) {
            Cache.log.error((Object)"Unexpected Look and Feel Exception");
            Cache.log.error((Object)ex.getMessage());
            Cache.log.debug((Object)Cache.getStackTraceString(ex));
        }
        return set;
    }

    private static boolean setSpecificLookAndFeel(String name, String className, boolean nameStartsWith) {
        boolean set = false;
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!(info.getName() != null && nameStartsWith ? info.getName().toLowerCase().startsWith(name.toLowerCase()) : info.getName().toLowerCase().equals(name.toLowerCase()))) continue;
                className = info.getClassName();
                break;
            }
            UIManager.setLookAndFeel(className);
            set = true;
        }
        catch (Exception ex) {
            Cache.log.error((Object)"Unexpected Look and Feel Exception");
            Cache.log.error((Object)ex.getMessage());
            Cache.log.debug((Object)Cache.getStackTraceString(ex));
        }
        return set;
    }

    private static boolean setGtkLookAndFeel() {
        return Jalview.setSpecificLookAndFeel("gtk", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", true);
    }

    private static boolean setMetalLookAndFeel() {
        return Jalview.setSpecificLookAndFeel("metal", "javax.swing.plaf.metal.MetalLookAndFeel", false);
    }

    private static boolean setNimbusLookAndFeel() {
        return Jalview.setSpecificLookAndFeel("nimbus", "javax.swing.plaf.nimbus.NimbusLookAndFeel", false);
    }

    private static boolean setQuaquaLookAndFeel() {
        return Jalview.setSpecificLookAndFeel("quaqua", QuaquaManager.getLookAndFeel().getClass().getName(), false);
    }

    private static boolean setVaquaLookAndFeel() {
        return Jalview.setSpecificLookAndFeel("vaqua", "org.violetlib.aqua.AquaLookAndFeel", false);
    }

    private static boolean setMacLookAndFeel() {
        boolean set = false;
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", ChannelProperties.getProperty("app_name"));
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        set = Jalview.setQuaquaLookAndFeel();
        if (!set || !UIManager.getLookAndFeel().getClass().toString().toLowerCase().contains("quaqua")) {
            set = Jalview.setVaquaLookAndFeel();
        }
        return set;
    }

    private static void showUsage() {
        System.out.println("Usage: jalview -open [FILE] [OUTPUT_FORMAT] [OUTPUT_FILE]\n\n-nodisplay\tRun Jalview without User Interface.\n-props FILE\tUse the given Jalview properties file instead of users default.\n-colour COLOURSCHEME\tThe colourscheme to be applied to the alignment\n-annotations FILE\tAdd precalculated annotations to the alignment.\n-tree FILE\tLoad the given newick format tree file onto the alignment\n-features FILE\tUse the given file to mark features on the alignment.\n-fasta FILE\tCreate alignment file FILE in Fasta format.\n-clustal FILE\tCreate alignment file FILE in Clustal format.\n-pfam FILE\tCreate alignment file FILE in PFAM format.\n-msf FILE\tCreate alignment file FILE in MSF format.\n-pileup FILE\tCreate alignment file FILE in Pileup format\n-pir FILE\tCreate alignment file FILE in PIR format.\n-blc FILE\tCreate alignment file FILE in BLC format.\n-json FILE\tCreate alignment file FILE in JSON format.\n-jalview FILE\tCreate alignment file FILE in Jalview format.\n-png FILE\tCreate PNG image FILE from alignment.\n-svg FILE\tCreate SVG image FILE from alignment.\n-html FILE\tCreate HTML file from alignment.\n-biojsMSA FILE\tCreate BioJS MSA Viewer HTML file from alignment.\n-imgMap FILE\tCreate HTML file FILE with image map of PNG image.\n-eps FILE\tCreate EPS file FILE from alignment.\n-questionnaire URL\tQueries the given URL for information about any Jalview user questionnaires.\n-noquestionnaire\tTurn off questionnaire check.\n-nonews\tTurn off check for Jalview news.\n-nousagestats\tTurn off google analytics tracking for this session.\n-sortbytree OR -nosortbytree\tEnable or disable sorting of the given alignment by the given tree\n-jabaws URL\tSpecify URL for Jabaws services (e.g. for a local installation).\n-fetchfrom nickname\tQuery nickname for features for the alignments and display them.\n-groovy FILE\tExecute groovy script in FILE, after all other arguments have been processed (if FILE is the text 'STDIN' then the file will be read from STDIN)\n-jvmmempc=PERCENT\tOnly available with standalone executable jar or jalview.bin.Launcher. Limit maximum heap size (memory) to PERCENT% of total physical memory detected. This defaults to 90 if total physical memory can be detected. See https://www.jalview.org/help/html/memory.html for more details.\n-jvmmemmax=MAXMEMORY\tOnly available with standalone executable jar or jalview.bin.Launcher. Limit maximum heap size (memory) to MAXMEMORY. MAXMEMORY can be specified in bytes, kilobytes(k), megabytes(m), gigabytes(g) or if you're lucky enough, terabytes(t). This defaults to 32g if total physical memory can be detected, or to 8g if total physical memory cannot be detected. See https://www.jalview.org/help/html/memory.html for more details.\n\n~Read documentation in Application or visit http://www.jalview.org for description of Features and Annotations file~\n\n");
    }

    private static void startUsageStats(Desktop desktop) {
        PromptUserConfig prompter = new PromptUserConfig(Desktop.desktop, "USAGESTATS", "Jalview Usage Statistics", "Do you want to help make Jalview better by enabling the collection of usage statistics with Google Analytics ?\n\n(you can enable or disable usage tracking in the preferences)", new Runnable(){

            @Override
            public void run() {
                Cache.log.debug((Object)"Initialising googletracker for usage stats.");
                Cache.initGoogleTracker();
                Cache.log.debug((Object)"Tracking enabled.");
            }
        }, new Runnable(){

            @Override
            public void run() {
                Cache.log.debug((Object)"Not enabling Google Tracking.");
            }
        }, null, true);
        desktop.addDialogThread(prompter);
    }

    private void executeGroovyScript(String groovyscript, AlignFrame af) {
        File tfile = null;
        URL sfile = null;
        if (groovyscript.trim().equals("STDIN")) {
            try {
                tfile = File.createTempFile("jalview", "groovy");
                PrintWriter outfile = new PrintWriter(new OutputStreamWriter(new FileOutputStream(tfile)));
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String line = null;
                while ((line = br.readLine()) != null) {
                    outfile.write(line + "\n");
                }
                br.close();
                outfile.flush();
                outfile.close();
            }
            catch (Exception ex) {
                System.err.println("Failed to read from STDIN into tempfile " + (tfile == null ? "(tempfile wasn't created)" : tfile.toString()));
                ex.printStackTrace();
                return;
            }
            try {
                sfile = tfile.toURI().toURL();
            }
            catch (Exception x) {
                System.err.println("Unexpected Malformed URL Exception for temporary file created from STDIN: " + tfile.toURI());
                x.printStackTrace();
                return;
            }
        }
        try {
            sfile = new URI(groovyscript).toURL();
        }
        catch (Exception x) {
            tfile = new File(groovyscript);
            if (!tfile.exists()) {
                System.err.println("File '" + groovyscript + "' does not exist.");
                return;
            }
            if (!tfile.canRead()) {
                System.err.println("File '" + groovyscript + "' cannot be read.");
                return;
            }
            if (tfile.length() < 1L) {
                System.err.println("File '" + groovyscript + "' is empty.");
                return;
            }
            try {
                sfile = tfile.getAbsoluteFile().toURI().toURL();
            }
            catch (Exception ex) {
                System.err.println("Failed to create a file URL for " + tfile.getAbsoluteFile());
                return;
            }
        }
        try {
            HashMap<String, Object> vbinding = new HashMap<String, Object>();
            vbinding.put("Jalview", this);
            if (af != null) {
                vbinding.put("currentAlFrame", af);
            }
            Binding gbinding = new Binding(vbinding);
            GroovyScriptEngine gse = new GroovyScriptEngine(new URL[]{sfile});
            gse.run(sfile.toString(), gbinding);
            if ("STDIN".equals(groovyscript)) {
                tfile.delete();
            }
        }
        catch (Exception e) {
            System.err.println("Exception Whilst trying to execute file " + sfile + " as a groovy script.");
            e.printStackTrace(System.err);
        }
    }

    public static boolean isHeadlessMode() {
        String isheadless = System.getProperty("java.awt.headless");
        return isheadless != null && isheadless.equalsIgnoreCase("true");
    }

    public AlignFrame[] getAlignFrames() {
        AlignFrame[] alignFrameArray;
        if (this.desktop == null) {
            AlignFrame[] alignFrameArray2 = new AlignFrame[1];
            alignFrameArray = alignFrameArray2;
            alignFrameArray2[0] = Jalview.getCurrentAlignFrame();
        } else {
            alignFrameArray = Desktop.getAlignFrames();
        }
        return alignFrameArray;
    }

    public void quit() {
        if (this.desktop != null) {
            this.desktop.quit();
        } else {
            System.exit(0);
        }
    }

    public static AlignFrame getCurrentAlignFrame() {
        return currentAlignFrame;
    }

    public static void setCurrentAlignFrame(AlignFrame currentAlignFrame) {
        Jalview.currentAlignFrame = currentAlignFrame;
    }

    static {
        Platform.getURLCommandArguments();
        if (!Platform.isJS()) {
            Policy.setPolicy(new Policy(){

                @Override
                public PermissionCollection getPermissions(CodeSource codesource) {
                    Permissions perms = new Permissions();
                    perms.add(new AllPermission());
                    return perms;
                }

                @Override
                public void refresh() {
                }
            });
        }
    }

    class FeatureFetcher {
        private int queued = 0;
        private int running = 0;

        public void addFetcher(final AlignFrame af, Vector<String> dasSources) {
            final long id = System.currentTimeMillis();
            ++this.queued;
            final FeatureFetcher us = this;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FeatureFetcher featureFetcher = us;
                    synchronized (featureFetcher) {
                        FeatureFetcher.this.queued--;
                        FeatureFetcher.this.running++;
                    }
                    af.setProgressBar(MessageManager.getString("status.das_features_being_retrived"), id);
                    af.featureSettings_actionPerformed(null);
                    af.setProgressBar(null, id);
                    featureFetcher = us;
                    synchronized (featureFetcher) {
                        FeatureFetcher.this.running--;
                    }
                }
            }).start();
        }

        public synchronized boolean allFinished() {
            return this.queued == 0 && this.running == 0;
        }
    }
}

