/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.ScreenInfo;
import java.awt.HeadlessException;

public class HiDPISetting {
    private static final int hidpiThreshold = 160;
    private static final int hidpiMultiThreshold = 240;
    private static final int bigScreenThreshold = 1400;
    public static final String scalePropertyName = "sun.java2d.uiScale";
    private static final boolean isLinux;
    public static final String setHiDPIPropertyName = "setHiDPI";
    public static final String setHiDPIScalePropertyName = "setHiDPIScale";
    private static boolean setHiDPI;
    private static int setHiDPIScale;
    public static int dpi;
    public static int mindimension;
    public static int width;
    public static int scale;
    public static final int MAX_SCALE = 8;
    private static boolean doneInit;
    private static boolean allowScalePropertyArg;
    private static ScreenInfo screenInfo;

    private static void init() {
        int autoScale;
        if (doneInit) {
            return;
        }
        String setHiDPIProperty = System.getProperty(setHiDPIPropertyName);
        boolean setHiDPIPropertyBool = Boolean.parseBoolean(setHiDPIProperty);
        if (setHiDPIProperty != null && !setHiDPIPropertyBool) {
            HiDPISetting.clear();
            doneInit = true;
            return;
        }
        setHiDPI = setHiDPIProperty != null && setHiDPIPropertyBool;
        String setHiDPIScaleProperty = System.getProperty(setHiDPIScalePropertyName);
        if (setHiDPIScaleProperty != null) {
            try {
                setHiDPIScale = Integer.parseInt(setHiDPIScaleProperty);
                if (setHiDPIProperty == null) {
                    setHiDPI = true;
                }
            }
            catch (NumberFormatException e) {
                System.err.println("setHiDPIScale property give (" + setHiDPIScaleProperty + ") but not parseable as integer");
            }
        }
        if (setHiDPI && setHiDPIScale > 0) {
            HiDPISetting.setHiDPIScale(setHiDPIScale);
            return;
        }
        String existingProperty = System.getProperty(scalePropertyName);
        if (existingProperty != null) {
            try {
                int existingPropertyVal = Integer.parseInt(existingProperty);
                System.out.println("Existing sun.java2d.uiScale is " + existingPropertyVal);
                if (existingPropertyVal > 1) {
                    HiDPISetting.setHiDPIScale(existingPropertyVal);
                    return;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Could not convert property sun.java2d.uiScale vale '" + existingProperty + "' to number");
            }
        }
        screenInfo = HiDPISetting.getScreenInfo();
        try {
            dpi = screenInfo.getScreenResolution();
        }
        catch (HeadlessException e) {
            System.err.println("Cannot get screen resolution: " + e.getMessage());
        }
        try {
            int height = screenInfo.getScreenHeight();
            int width = screenInfo.getScreenWidth();
            mindimension = Math.min(height, width);
        }
        catch (HeadlessException e) {
            System.err.println("Cannot get screen size height and width:" + e.getMessage());
        }
        int dpiScale = dpi - 160 > 0 ? 2 + (dpi - 160) / 240 : 1;
        int dimensionScale = 1 + mindimension / 1400;
        if (dpiScale > 8) {
            dpiScale = 1;
        }
        if (dimensionScale > 8) {
            dimensionScale = 1;
        }
        if ((autoScale = Math.max(dpiScale, dimensionScale)) > 1 && isLinux || setHiDPI) {
            HiDPISetting.setHiDPIScale(autoScale);
            return;
        }
        doneInit = true;
    }

    public static void setHiDPIScale(int s) {
        scale = s;
        allowScalePropertyArg = true;
        doneInit = true;
    }

    public static String getScalePropertyArg(int s) {
        return "-Dsun.java2d.uiScale=" + String.valueOf(s);
    }

    public static String getScalePropertyArg() {
        HiDPISetting.init();
        return allowScalePropertyArg ? HiDPISetting.getScalePropertyArg(scale) : null;
    }

    public static void clear() {
        setHiDPI = false;
        setHiDPIScale = 0;
        dpi = 0;
        mindimension = 0;
        width = 0;
        scale = 0;
        doneInit = false;
        allowScalePropertyArg = false;
    }

    public static void setScreenInfo(ScreenInfo si) {
        screenInfo = si;
    }

    public static ScreenInfo getScreenInfo() {
        if (screenInfo == null) {
            screenInfo = new ScreenInfo();
        }
        return screenInfo;
    }

    static {
        String system;
        setHiDPI = false;
        setHiDPIScale = 0;
        dpi = 0;
        mindimension = 0;
        width = 0;
        scale = 0;
        doneInit = false;
        allowScalePropertyArg = false;
        screenInfo = new ScreenInfo();
        String string = system = System.getProperty("os.name") == null ? null : System.getProperty("os.name").toLowerCase();
        isLinux = system != null ? system.indexOf("linux") > -1 : false;
    }
}

