/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AAFrequency;
import jalview.api.FeatureColourI;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.AnnotationColourChooser;
import jalview.appletgui.AppletJmol;
import jalview.appletgui.FeatureColourChooser;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.FeatureSettings;
import jalview.bin.JalviewLite;
import jalview.datamodel.SequenceGroup;
import jalview.renderer.ResidueShader;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.FeatureColour;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.util.MessageManager;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import mc_view.AppletPDBCanvas;

public class UserDefinedColours
extends Panel
implements ActionListener,
AdjustmentListener,
FocusListener {
    AlignmentPanel ap;
    SequenceGroup seqGroup;
    Button selectedButton;
    Vector<Color> oldColours = new Vector();
    ColourSchemeI oldColourScheme;
    Frame frame;
    AppletPDBCanvas pdbcanvas;
    AppletJmol jmol;
    Dialog dialog;
    Object caller;
    String originalLabel;
    FeatureColourI originalColour;
    int R = 0;
    int G = 0;
    int B = 0;
    protected Panel buttonPanel = new Panel();
    protected GridLayout gridLayout = new GridLayout();
    Panel okcancelPanel = new Panel();
    protected Button okButton = new Button();
    protected Button applyButton = new Button();
    protected Button cancelButton = new Button();
    protected Scrollbar rScroller = new Scrollbar();
    Label label1 = new Label();
    protected TextField rText = new TextField();
    Label label4 = new Label();
    protected Scrollbar gScroller = new Scrollbar();
    protected TextField gText = new TextField();
    Label label5 = new Label();
    protected Scrollbar bScroller = new Scrollbar();
    protected TextField bText = new TextField();
    protected Panel target = new Panel();

    public ColourSchemeI loadDefaultColours() {
        return null;
    }

    public UserDefinedColours(AlignmentPanel ap, SequenceGroup sg) {
        this.ap = ap;
        this.seqGroup = sg;
        this.oldColourScheme = this.seqGroup != null ? this.seqGroup.getColourScheme() : ap.av.getGlobalColourScheme();
        this.init();
    }

    public UserDefinedColours(AppletPDBCanvas pdb) {
        this.pdbcanvas = pdb;
        this.init();
    }

    public UserDefinedColours(AppletJmol jmol) {
        this.jmol = jmol;
        this.init();
    }

    public UserDefinedColours(FeatureRenderer fr, Frame alignframe) {
        this.caller = fr;
        this.originalColour = new FeatureColour(fr.colourPanel.getBackground());
        this.originalLabel = "Feature Colour";
        this.setForDialog("Select Feature Colour", alignframe);
        this.setTargetColour(fr.colourPanel.getBackground());
        this.dialog.setVisible(true);
    }

    public UserDefinedColours(Component caller, Color col1, Frame alignframe) {
        this(caller, col1, alignframe, "Select Colour");
    }

    public UserDefinedColours(Component caller, Color col, Frame alignframe, String title) {
        this.caller = caller;
        this.originalColour = new FeatureColour(col);
        this.originalLabel = title;
        this.setForDialog(title, alignframe);
        this.setTargetColour(col);
        this.dialog.setVisible(true);
    }

    public UserDefinedColours(Object caller, String label, Color colour) {
        this(caller, label, new FeatureColour(colour), colour);
    }

    public UserDefinedColours(FeatureSettings me, String type, FeatureColourI graduatedColor) {
        this((Object)me, type, graduatedColor, graduatedColor.getMaxColour());
    }

    private UserDefinedColours(Object caller, String label, FeatureColourI ocolour, Color colour) {
        this.caller = caller;
        this.originalColour = ocolour;
        this.originalLabel = label;
        this.init();
        this.remove(this.buttonPanel);
        this.setTargetColour(colour);
        this.okcancelPanel.setBounds(new Rectangle(0, 113, 400, 35));
        this.frame.setTitle(MessageManager.getString("label.user_defined_colours") + " - " + label);
        this.frame.setSize(420, 200);
    }

    void setForDialog(String title, Container alignframe) {
        this.init();
        this.frame.setVisible(false);
        this.remove(this.buttonPanel);
        if (!(alignframe instanceof Frame)) {
            throw new Error(MessageManager.getString("label.error_unsupported_owwner_user_colour_scheme"));
        }
        this.dialog = new Dialog((Frame)alignframe, title, true);
        this.dialog.add(this);
        this.setSize(400, 123);
        this.okcancelPanel.setBounds(new Rectangle(0, 123, 400, 35));
        int height = 160 + alignframe.getInsets().top + this.getInsets().bottom;
        int width = 400;
        this.dialog.setBounds(alignframe.getBounds().x + (alignframe.getSize().width - width) / 2, alignframe.getBounds().y + (alignframe.getSize().height - height) / 2, width, height);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.okButton) {
            this.okButton_actionPerformed();
        } else if (source == this.applyButton) {
            this.applyButton_actionPerformed();
        } else if (source == this.cancelButton) {
            this.cancelButton_actionPerformed();
        } else if (source == this.rText) {
            this.rText_actionPerformed();
        } else if (source == this.gText) {
            this.gText_actionPerformed();
        } else if (source == this.bText) {
            this.bText_actionPerformed();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (evt.getSource() == this.rScroller) {
            this.rScroller_adjustmentValueChanged();
        } else if (evt.getSource() == this.gScroller) {
            this.gScroller_adjustmentValueChanged();
        } else if (evt.getSource() == this.bScroller) {
            this.bScroller_adjustmentValueChanged();
        }
    }

    void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.frame = new Frame();
        this.frame.add(this);
        JalviewLite.addFrame(this.frame, MessageManager.getString("label.user_defined_colours"), 420, 345);
        if (this.seqGroup != null) {
            this.frame.setTitle(this.frame.getTitle() + " (" + this.seqGroup.getName() + ")");
        }
        for (int i = 0; i < 20; ++i) {
            this.makeButton(ResidueProperties.aa2Triplet.get(ResidueProperties.aa[i]) + "", ResidueProperties.aa[i]);
        }
        this.makeButton("B", "B");
        this.makeButton("Z", "Z");
        this.makeButton("X", "X");
        this.makeButton("Gap", "'.','-',' '");
        this.validate();
    }

    protected void rText_actionPerformed() {
        try {
            int i = Integer.parseInt(this.rText.getText());
            this.rScroller.setValue(i);
            this.rScroller_adjustmentValueChanged();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void gText_actionPerformed() {
        try {
            int i = Integer.parseInt(this.gText.getText());
            this.gScroller.setValue(i);
            this.gScroller_adjustmentValueChanged();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void bText_actionPerformed() {
        try {
            int i = Integer.parseInt(this.bText.getText());
            this.bScroller.setValue(i);
            this.bScroller_adjustmentValueChanged();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void rScroller_adjustmentValueChanged() {
        this.R = this.rScroller.getValue();
        this.rText.setText(this.R + "");
        this.colourChanged();
    }

    protected void gScroller_adjustmentValueChanged() {
        this.G = this.gScroller.getValue();
        this.gText.setText(this.G + "");
        this.colourChanged();
    }

    protected void bScroller_adjustmentValueChanged() {
        this.B = this.bScroller.getValue();
        this.bText.setText(this.B + "");
        this.colourChanged();
    }

    public void colourChanged() {
        Color col = new Color(this.R, this.G, this.B);
        this.target.setBackground(col);
        this.target.repaint();
        if (this.selectedButton != null) {
            this.selectedButton.setBackground(col);
            this.selectedButton.repaint();
        }
    }

    void setTargetColour(Color col) {
        this.R = col.getRed();
        this.G = col.getGreen();
        this.B = col.getBlue();
        this.rScroller.setValue(this.R);
        this.gScroller.setValue(this.G);
        this.bScroller.setValue(this.B);
        this.rText.setText(this.R + "");
        this.gText.setText(this.G + "");
        this.bText.setText(this.B + "");
        this.colourChanged();
    }

    public void colourButtonPressed(MouseEvent e) {
        this.selectedButton = (Button)e.getSource();
        this.setTargetColour(this.selectedButton.getBackground());
    }

    void makeButton(String label, String aa) {
        Button button = new Button();
        Color col = Color.white;
        if (this.oldColourScheme != null && this.oldColourScheme.isSimple()) {
            col = this.oldColourScheme.findColour(aa.charAt(0), 0, null, null, 0.0f);
        }
        button.setBackground(col);
        this.oldColours.addElement(col);
        button.setLabel(label);
        button.setForeground(col.darker().darker().darker());
        button.setFont(new Font("Verdana", 1, 10));
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UserDefinedColours.this.colourButtonPressed(e);
            }
        });
        this.buttonPanel.add((Component)button, null);
    }

    protected void okButton_actionPerformed() {
        this.applyButton_actionPerformed();
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.frame.setVisible(false);
    }

    public Color getColor() {
        return new Color(this.R, this.G, this.B);
    }

    protected void applyButton_actionPerformed() {
        if (this.caller != null) {
            if (this.caller instanceof FeatureSettings) {
                ((FeatureSettings)this.caller).setUserColour(this.originalLabel, new FeatureColour(this.getColor()));
            } else if (this.caller instanceof AnnotationColourChooser) {
                if (this.originalLabel.equals("Min Colour")) {
                    ((AnnotationColourChooser)this.caller).minColour_actionPerformed(this.getColor());
                } else {
                    ((AnnotationColourChooser)this.caller).maxColour_actionPerformed(this.getColor());
                }
            } else if (this.caller instanceof FeatureRenderer) {
                ((FeatureRenderer)this.caller).colourPanel.updateColor(new FeatureColour(this.getColor()));
            } else if (this.caller instanceof FeatureColourChooser) {
                if (this.originalLabel.indexOf("inimum") > -1) {
                    ((FeatureColourChooser)this.caller).minColour_actionPerformed(this.getColor());
                } else {
                    ((FeatureColourChooser)this.caller).maxColour_actionPerformed(this.getColor());
                }
            }
            return;
        }
        Color[] newColours = new Color[24];
        for (int i = 0; i < 24; ++i) {
            Button button = (Button)this.buttonPanel.getComponent(i);
            newColours[i] = button.getBackground();
        }
        UserColourScheme ucs = new UserColourScheme(newColours);
        if (this.ap != null) {
            if (this.seqGroup != null) {
                this.seqGroup.cs = new ResidueShader(ucs);
                this.seqGroup.getGroupColourScheme().setThreshold(0, this.ap.av.isIgnoreGapsConsensus());
            } else {
                this.ap.av.setGlobalColourScheme(ucs);
                this.ap.av.getResidueShading().setThreshold(0, this.ap.av.isIgnoreGapsConsensus());
            }
            this.ap.seqPanel.seqCanvas.img = null;
            this.ap.paintAlignment(true, true);
        } else if (this.jmol != null) {
            this.jmol.colourByJalviewColourScheme(ucs);
        } else if (this.pdbcanvas != null) {
            this.pdbcanvas.setColours(ucs);
        }
    }

    protected void cancelButton_actionPerformed() {
        if (this.caller != null) {
            if (this.caller instanceof FeatureSettings) {
                ((FeatureSettings)this.caller).setUserColour(this.originalLabel, this.originalColour);
            } else if (this.caller instanceof AnnotationColourChooser) {
                if (this.originalLabel.equals("Min Colour")) {
                    ((AnnotationColourChooser)this.caller).minColour_actionPerformed(this.originalColour.getColour());
                } else {
                    ((AnnotationColourChooser)this.caller).maxColour_actionPerformed(this.originalColour.getColour());
                }
            } else if (this.caller instanceof FeatureRenderer) {
                ((FeatureRenderer)this.caller).colourPanel.updateColor(this.originalColour);
            } else if (this.caller instanceof FeatureColourChooser) {
                if (this.originalLabel.indexOf("inimum") > -1) {
                    ((FeatureColourChooser)this.caller).minColour_actionPerformed(this.originalColour.getColour());
                } else {
                    ((FeatureColourChooser)this.caller).maxColour_actionPerformed(this.originalColour.getColour());
                }
            }
            if (this.dialog != null) {
                this.dialog.setVisible(false);
            }
            this.frame.setVisible(false);
            return;
        }
        if (this.ap != null) {
            if (this.seqGroup != null) {
                this.seqGroup.cs = new ResidueShader(this.oldColourScheme);
                if (this.oldColourScheme instanceof PIDColourScheme || this.oldColourScheme instanceof Blosum62ColourScheme) {
                    this.seqGroup.cs.setConsensus(AAFrequency.calculate(this.seqGroup.getSequences(this.ap.av.getHiddenRepSequences()), 0, this.ap.av.getAlignment().getWidth()));
                }
            } else {
                this.ap.av.setGlobalColourScheme(this.oldColourScheme);
            }
            this.ap.paintAlignment(true, true);
        }
        this.frame.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.buttonPanel.setLayout(this.gridLayout);
        this.gridLayout.setColumns(6);
        this.gridLayout.setRows(4);
        this.okButton.setFont(new Font("Verdana", 0, 11));
        this.okButton.setLabel(MessageManager.getString("action.ok"));
        this.okButton.addActionListener(this);
        this.applyButton.setFont(new Font("Verdana", 0, 11));
        this.applyButton.setLabel(MessageManager.getString("action.apply"));
        this.applyButton.addActionListener(this);
        this.cancelButton.setFont(new Font("Verdana", 0, 11));
        this.cancelButton.setLabel(MessageManager.getString("action.cancel"));
        this.cancelButton.addActionListener(this);
        this.setBackground(new Color(212, 208, 223));
        this.okcancelPanel.setBounds(new Rectangle(0, 265, 400, 35));
        this.buttonPanel.setBounds(new Rectangle(0, 123, 400, 142));
        this.rScroller.setMaximum(256);
        this.rScroller.setMinimum(0);
        this.rScroller.setOrientation(0);
        this.rScroller.setUnitIncrement(1);
        this.rScroller.setVisibleAmount(1);
        this.rScroller.setBounds(new Rectangle(36, 27, 119, 19));
        this.rScroller.addAdjustmentListener(this);
        this.label1.setAlignment(2);
        this.label1.setText("R");
        this.label1.setBounds(new Rectangle(19, 30, 16, 15));
        this.rText.setFont(new Font("Dialog", 0, 10));
        this.rText.setText("0        ");
        this.rText.setBounds(new Rectangle(156, 27, 53, 19));
        this.rText.addActionListener(this);
        this.rText.addFocusListener(this);
        this.label4.setAlignment(2);
        this.label4.setText("G");
        this.label4.setBounds(new Rectangle(15, 56, 20, 15));
        this.gScroller.setMaximum(256);
        this.gScroller.setMinimum(0);
        this.gScroller.setOrientation(0);
        this.gScroller.setUnitIncrement(1);
        this.gScroller.setVisibleAmount(1);
        this.gScroller.setBounds(new Rectangle(35, 52, 120, 20));
        this.gScroller.addAdjustmentListener(this);
        this.gText.setFont(new Font("Dialog", 0, 10));
        this.gText.setText("0        ");
        this.gText.setBounds(new Rectangle(156, 52, 53, 20));
        this.gText.addActionListener(this);
        this.gText.addFocusListener(this);
        this.label5.setAlignment(2);
        this.label5.setText("B");
        this.label5.setBounds(new Rectangle(14, 82, 20, 15));
        this.bScroller.setMaximum(256);
        this.bScroller.setMinimum(0);
        this.bScroller.setOrientation(0);
        this.bScroller.setUnitIncrement(1);
        this.bScroller.setVisibleAmount(1);
        this.bScroller.setBounds(new Rectangle(35, 78, 120, 20));
        this.bScroller.addAdjustmentListener(this);
        this.bText.setFont(new Font("Dialog", 0, 10));
        this.bText.setText("0        ");
        this.bText.setBounds(new Rectangle(157, 78, 52, 20));
        this.bText.addActionListener(this);
        this.bText.addFocusListener(this);
        this.target.setBackground(Color.black);
        this.target.setBounds(new Rectangle(229, 26, 134, 79));
        this.add((Component)this.okcancelPanel, null);
        this.okcancelPanel.add((Component)this.okButton, null);
        this.okcancelPanel.add((Component)this.applyButton, null);
        this.okcancelPanel.add((Component)this.cancelButton, null);
        this.add(this.rText);
        this.add(this.gText);
        this.add(this.bText);
        this.add((Component)this.buttonPanel, null);
        this.add((Component)this.target, null);
        this.add(this.gScroller);
        this.add(this.rScroller);
        this.add(this.bScroller);
        this.add(this.label5);
        this.add(this.label4);
        this.add(this.label1);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Component c = e.getComponent();
        if (c == this.rText) {
            this.rText_actionPerformed();
        } else if (c == this.gText) {
            this.gText_actionPerformed();
        } else if (c == this.bText) {
            this.bText_actionPerformed();
        }
    }
}

