/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueColourFinder;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.util.Comparison;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class SequenceRenderer
implements jalview.api.SequenceRenderer {
    static final int CHAR_TO_UPPER = -32;
    AlignViewport av;
    FontMetrics fm;
    boolean renderGaps = true;
    SequenceGroup[] allGroups = null;
    Color resBoxColour;
    Graphics graphics;
    ResidueColourFinder resColourFinder;

    public SequenceRenderer(AlignViewport av) {
        this.av = av;
        this.resColourFinder = new ResidueColourFinder();
    }

    public void prepare(Graphics g, boolean renderGaps) {
        this.graphics = g;
        this.fm = g.getFontMetrics();
        this.renderGaps = renderGaps;
    }

    @Override
    public Color getResidueColour(SequenceI seq, int position, FeatureColourFinder finder) {
        return this.resColourFinder.getResidueColour(this.av.getShowBoxes(), this.av.getResidueShading(), this.allGroups, seq, position, finder);
    }

    public Color findSequenceColour(SequenceI seq, int i) {
        this.allGroups = this.av.getAlignment().findAllGroups(seq);
        this.drawBoxes(seq, i, i, 0);
        return this.resBoxColour;
    }

    public void drawSequence(SequenceI seq, SequenceGroup[] sg, int start, int end, int y1) {
        if (seq == null) {
            return;
        }
        this.allGroups = sg;
        this.drawBoxes(seq, start, end, y1);
        if (this.av.validCharWidth) {
            this.drawText(seq, start, end, y1);
        }
    }

    public void drawBoxes(SequenceI seq, int start, int end, int y1) {
        int length = seq.getLength();
        int curStart = -1;
        int curWidth = this.av.getCharWidth();
        int avCharWidth = this.av.getCharWidth();
        int avCharHeight = this.av.getCharHeight();
        Color resBoxColour = Color.white;
        Color tempColour = null;
        for (int i = start; i <= end; ++i) {
            resBoxColour = Color.white;
            if (i < length) {
                SequenceGroup currentSequenceGroup = this.resColourFinder.getCurrentSequenceGroup(this.allGroups, i);
                if (currentSequenceGroup != null) {
                    if (currentSequenceGroup.getDisplayBoxes()) {
                        resBoxColour = this.resColourFinder.getBoxColour(currentSequenceGroup.getGroupColourScheme(), seq, i);
                    }
                } else if (this.av.getShowBoxes()) {
                    resBoxColour = this.resColourFinder.getBoxColour(this.av.getResidueShading(), seq, i);
                }
            }
            if (resBoxColour != tempColour) {
                if (tempColour != null) {
                    this.graphics.fillRect(avCharWidth * (curStart - start), y1, curWidth, avCharHeight);
                }
                this.graphics.setColor(resBoxColour);
                curStart = i;
                curWidth = avCharWidth;
                tempColour = resBoxColour;
                continue;
            }
            curWidth += avCharWidth;
        }
        this.graphics.fillRect(avCharWidth * (curStart - start), y1, curWidth, avCharHeight);
    }

    public void drawText(SequenceI seq, int start, int end, int y1) {
        int avCharWidth = this.av.getCharWidth();
        int avCharHeight = this.av.getCharHeight();
        Font boldFont = null;
        boolean bold = false;
        if (this.av.isUpperCasebold()) {
            boldFont = new Font(this.av.getFont().getName(), 1, avCharHeight);
            this.graphics.setFont(this.av.getFont());
        }
        y1 += avCharHeight - avCharHeight / 5;
        int charOffset = 0;
        if (end + 1 >= seq.getLength()) {
            end = seq.getLength() - 1;
        }
        char s = ' ';
        boolean srep = this.av.isDisplayReferenceSeq();
        for (int i = start; i <= end; ++i) {
            this.graphics.setColor(Color.black);
            s = seq.getCharAt(i);
            if (!this.renderGaps && Comparison.isGap(s)) continue;
            SequenceGroup currentSequenceGroup = this.resColourFinder.getCurrentSequenceGroup(this.allGroups, i);
            if (currentSequenceGroup != null) {
                if (!currentSequenceGroup.getDisplayText()) continue;
                if (currentSequenceGroup.getColourText()) {
                    this.resBoxColour = this.resColourFinder.getBoxColour(currentSequenceGroup.getGroupColourScheme(), seq, i);
                    this.graphics.setColor(this.resBoxColour.darker());
                }
                if (currentSequenceGroup.getShowNonconserved()) {
                    s = this.getDisplayChar(srep, i, s, '.', currentSequenceGroup);
                }
            } else {
                if (!this.av.getShowText()) continue;
                if (this.av.getColourText()) {
                    this.resBoxColour = this.resColourFinder.getBoxColour(this.av.getResidueShading(), seq, i);
                    if (this.av.getShowBoxes()) {
                        this.graphics.setColor(this.resBoxColour.darker());
                    } else {
                        this.graphics.setColor(this.resBoxColour);
                    }
                }
                if (this.av.getShowUnconserved()) {
                    s = this.getDisplayChar(srep, i, s, '.', null);
                }
            }
            if (this.av.isUpperCasebold()) {
                this.fm = this.graphics.getFontMetrics();
                if ('A' <= s && s <= 'Z') {
                    if (!bold) {
                        this.graphics.setFont(boldFont);
                    }
                    bold = true;
                } else if (bold) {
                    this.graphics.setFont(this.av.font);
                    bold = false;
                }
            }
            charOffset = (avCharWidth - this.fm.charWidth(s)) / 2;
            this.graphics.drawString(String.valueOf(s), charOffset + avCharWidth * (i - start), y1);
        }
    }

    private char getDisplayChar(boolean usesrep, int position, char sequenceChar, char conservedChar, SequenceGroup currentGroup) {
        char conschar;
        char c = usesrep ? (currentGroup == null || position < currentGroup.getStartRes() || position > currentGroup.getEndRes() ? this.av.getAlignment().getSeqrep().getCharAt(position) : (currentGroup.getSeqrep() != null ? currentGroup.getSeqrep().getCharAt(position) : this.av.getAlignment().getSeqrep().getCharAt(position))) : (conschar = currentGroup != null && currentGroup.getConsensus() != null && position >= currentGroup.getStartRes() && position <= currentGroup.getEndRes() && currentGroup.getConsensus().annotations.length > position ? currentGroup.getConsensus().annotations[position].displayCharacter.charAt(0) : this.av.getAlignmentConsensusAnnotation().annotations[position].displayCharacter.charAt(0));
        if (!(Comparison.isGap(conschar) || sequenceChar != conschar && sequenceChar + -32 != conschar)) {
            sequenceChar = conservedChar;
        }
        return sequenceChar;
    }

    public void drawHighlightedText(SequenceI seq, int start, int end, int x1, int y1) {
        int avCharWidth = this.av.getCharWidth();
        int avCharHeight = this.av.getCharHeight();
        int pady = avCharHeight / 5;
        int charOffset = 0;
        this.graphics.setColor(Color.black);
        this.graphics.fillRect(x1, y1, avCharWidth * (end - start + 1), avCharHeight);
        this.graphics.setColor(Color.white);
        char s = '~';
        if (this.av.validCharWidth) {
            for (int i = start; i <= end; ++i) {
                if (i < seq.getLength()) {
                    s = seq.getCharAt(i);
                }
                charOffset = (avCharWidth - this.fm.charWidth(s)) / 2;
                this.graphics.drawString(String.valueOf(s), charOffset + x1 + avCharWidth * (i - start), y1 + avCharHeight - pady);
            }
        }
    }

    public void drawCursor(SequenceI seq, int res, int x1, int y1) {
        int pady = this.av.getCharHeight() / 5;
        int charOffset = 0;
        this.graphics.setColor(Color.black);
        this.graphics.fillRect(x1, y1, this.av.getCharWidth(), this.av.getCharHeight());
        this.graphics.setColor(Color.white);
        this.graphics.setColor(Color.white);
        char s = seq.getCharAt(res);
        if (this.av.validCharWidth) {
            charOffset = (this.av.getCharWidth() - this.fm.charWidth(s)) / 2;
            this.graphics.drawString(String.valueOf(s), charOffset + x1, y1 + this.av.getCharHeight() - pady);
        }
    }
}

