/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.AnnotationRowFilter;
import jalview.appletgui.TitledPanel;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.HiddenColumns;
import jalview.util.MessageManager;
import jalview.viewmodel.annotationfilter.AnnotationFilterParameter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class AnnotationColumnChooser
extends AnnotationRowFilter
implements ActionListener,
AdjustmentListener,
ItemListener,
MouseListener {
    private Choice annotations = new Choice();
    private Panel actionPanel = new Panel();
    private TitledPanel thresholdPanel = new TitledPanel();
    private Panel switchableViewsPanel = new Panel(new CardLayout());
    private CardLayout switchableViewsLayout = (CardLayout)this.switchableViewsPanel.getLayout();
    private Panel noGraphFilterView = new Panel();
    private Panel graphFilterView = new Panel();
    private Panel annotationComboBoxPanel = new Panel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout gBorderLayout = new BorderLayout();
    private BorderLayout ngBorderLayout = new BorderLayout();
    private Choice threshold = new Choice();
    private StructureFilterPanel gStructureFilterPanel;
    private StructureFilterPanel ngStructureFilterPanel;
    private StructureFilterPanel currentStructureFilterPanel;
    private SearchPanel currentSearchPanel;
    private SearchPanel gSearchPanel;
    private SearchPanel ngSearchPanel;
    private FurtherActionPanel currentFurtherActionPanel;
    private FurtherActionPanel gFurtherActionPanel;
    private FurtherActionPanel ngFurtherActionPanel;
    public static final int ACTION_OPTION_SELECT = 1;
    public static int ACTION_OPTION_HIDE = 2;
    public static String NO_GRAPH_VIEW = "0";
    public static String GRAPH_VIEW = "1";
    private int actionOption = 1;
    private HiddenColumns oldHiddenColumns;

    public AnnotationColumnChooser() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public AnnotationColumnChooser(AlignViewport av, AlignmentPanel ap) {
        super(av, ap);
        int i;
        this.frame = new Frame();
        this.frame.add(this);
        JalviewLite.addFrame(this.frame, MessageManager.getString("label.select_by_annotation"), 520, 215);
        this.slider.addAdjustmentListener(this);
        this.slider.addMouseListener(this);
        AlignmentAnnotation[] anns = av.getAlignment().getAlignmentAnnotation();
        if (anns == null) {
            return;
        }
        this.setOldHiddenColumns(av.getAlignment().getHiddenColumns());
        this.adjusting = true;
        Vector<String> list = new Vector<String>();
        int index = 1;
        for (i = 0; i < anns.length; ++i) {
            String label = anns[i].label;
            if (anns[i].sequenceRef != null) {
                label = label + "_" + anns[i].sequenceRef.getName();
            }
            if (!list.contains(label)) {
                list.addElement(label);
                continue;
            }
            list.addElement(label + "_" + index++);
        }
        for (i = 0; i < list.size(); ++i) {
            this.annotations.addItem(((String)list.elementAt(i)).toString());
        }
        this.populateThresholdComboBox(this.threshold);
        AnnotationColumnChooser lastChooser = av.getAnnotationColumnSelectionState();
        if (lastChooser != null) {
            this.currentSearchPanel = lastChooser.getCurrentSearchPanel();
            this.currentStructureFilterPanel = lastChooser.getCurrentStructureFilterPanel();
            this.annotations.select(lastChooser.getAnnotations().getSelectedIndex());
            this.threshold.select(lastChooser.getThreshold().getSelectedIndex());
            this.actionOption = lastChooser.getActionOption();
            this.percentThreshold.setState(lastChooser.percentThreshold.getState());
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adjusting = false;
        this.updateView();
        this.frame.invalidate();
        this.frame.pack();
    }

    private void jbInit() throws Exception {
        this.ok.setLabel(MessageManager.getString("action.ok"));
        this.cancel.setLabel(MessageManager.getString("action.cancel"));
        this.thresholdValue.setEnabled(false);
        this.thresholdValue.setColumns(7);
        this.thresholdValue.setCaretPosition(0);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.annotations.addItemListener(this);
        this.thresholdValue.addActionListener(this);
        this.threshold.addItemListener(this);
        this.slider.setBackground(Color.white);
        this.slider.setEnabled(false);
        this.slider.setPreferredSize(new Dimension(100, 32));
        this.thresholdPanel.setBackground(Color.white);
        this.percentThreshold.setLabel("As percentage");
        this.percentThreshold.addItemListener(this);
        this.actionPanel.setBackground(Color.white);
        this.graphFilterView.setLayout(this.gBorderLayout);
        this.graphFilterView.setBackground(Color.white);
        this.noGraphFilterView.setLayout(this.ngBorderLayout);
        this.noGraphFilterView.setBackground(Color.white);
        this.annotationComboBoxPanel.setBackground(Color.white);
        this.gSearchPanel = new SearchPanel(this);
        this.ngSearchPanel = new SearchPanel(this);
        this.gFurtherActionPanel = new FurtherActionPanel(this);
        this.ngFurtherActionPanel = new FurtherActionPanel(this);
        this.gStructureFilterPanel = new StructureFilterPanel(this);
        this.ngStructureFilterPanel = new StructureFilterPanel(this);
        this.thresholdPanel.setTitle("Threshold Filter");
        this.thresholdPanel.add(this.getThreshold());
        this.thresholdPanel.add(this.slider);
        this.thresholdPanel.add(this.thresholdValue);
        this.thresholdPanel.add(this.percentThreshold);
        this.actionPanel.add(this.ok);
        this.actionPanel.add(this.cancel);
        Panel staticPanel = new Panel();
        staticPanel.setLayout(new BorderLayout());
        staticPanel.setBackground(Color.white);
        staticPanel.add((Component)this.gSearchPanel, "North");
        staticPanel.add((Component)this.gStructureFilterPanel, "South");
        this.graphFilterView.add((Component)staticPanel, "North");
        this.graphFilterView.add((Component)this.thresholdPanel, "Center");
        this.graphFilterView.add((Component)this.gFurtherActionPanel, "South");
        this.noGraphFilterView.add((Component)this.ngSearchPanel, "First");
        this.noGraphFilterView.add((Component)this.ngStructureFilterPanel, "Center");
        this.noGraphFilterView.add((Component)this.ngFurtherActionPanel, "Center");
        this.annotationComboBoxPanel.add(this.getAnnotations());
        this.switchableViewsPanel.add((Component)this.noGraphFilterView, NO_GRAPH_VIEW);
        this.switchableViewsPanel.add((Component)this.graphFilterView, GRAPH_VIEW);
        this.setLayout(this.borderLayout1);
        this.add((Component)this.annotationComboBoxPanel, "First");
        this.add((Component)this.switchableViewsPanel, "Center");
        this.add((Component)this.actionPanel, "South");
        this.selectedAnnotationChanged();
        this.validate();
    }

    @Override
    public void reset() {
        if (this.getOldHiddenColumns() != null) {
            this.av.getColumnSelection().clear();
            if (this.av.getAnnotationColumnSelectionState() != null) {
                HiddenColumns oldHidden = this.av.getAnnotationColumnSelectionState().getOldHiddenColumns();
                this.av.getAlignment().setHiddenColumns(oldHidden);
            }
            this.av.sendSelection();
            this.ap.paintAlignment(true, true);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (!this.adjusting) {
            this.setThresholdValueText();
            this.valueChanged(!this.sliderDragging);
        }
    }

    protected void addSliderMouseListeners() {
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AnnotationColumnChooser.this.sliderDragging = true;
                super.mousePressed(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                AnnotationColumnChooser.this.sliderDragging = true;
                super.mouseDragged(e);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (AnnotationColumnChooser.this.sliderDragging) {
                    AnnotationColumnChooser.this.sliderDragging = false;
                    AnnotationColumnChooser.this.valueChanged(true);
                }
                AnnotationColumnChooser.this.ap.paintAlignment(true, true);
            }
        });
    }

    @Override
    public void valueChanged(boolean updateAllAnnotation) {
        if (this.slider.isEnabled()) {
            this.getCurrentAnnotation().threshold.value = (float)this.slider.getValue() / 1000.0f;
            this.updateView();
        }
    }

    public Choice getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Choice threshold) {
        this.threshold = threshold;
    }

    public Choice getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Choice annotations) {
        this.annotations = annotations;
    }

    @Override
    public void updateView() {
        if (this.adjusting) {
            return;
        }
        AnnotationFilterParameter filterParams = new AnnotationFilterParameter();
        this.setCurrentAnnotation(this.av.getAlignment().getAlignmentAnnotation()[this.getAnnotations().getSelectedIndex()]);
        int selectedThresholdItem = this.getSelectedThresholdItem(this.getThreshold().getSelectedIndex());
        this.slider.setEnabled(true);
        this.thresholdValue.setEnabled(true);
        this.percentThreshold.setEnabled(true);
        if (selectedThresholdItem == -1) {
            this.slider.setEnabled(false);
            this.thresholdValue.setEnabled(false);
            this.thresholdValue.setText("");
            this.percentThreshold.setEnabled(false);
        } else if (selectedThresholdItem != -1) {
            if (this.getCurrentAnnotation().threshold == null) {
                this.getCurrentAnnotation().setThreshold(new GraphLine((this.getCurrentAnnotation().graphMax - this.getCurrentAnnotation().graphMin) / 2.0f, "Threshold", Color.black));
            }
            this.adjusting = true;
            this.slider.setMinimum((int)(this.getCurrentAnnotation().graphMin * 1000.0f));
            this.slider.setMaximum((int)(this.getCurrentAnnotation().graphMax * 1000.0f));
            this.slider.setValue((int)(this.getCurrentAnnotation().threshold.value * 1000.0f));
            this.setThresholdValueText();
            this.slider.setEnabled(true);
            this.thresholdValue.setEnabled(true);
            this.percentThreshold.setEnabled(true);
            this.adjusting = false;
            filterParams.setThresholdType(AnnotationFilterParameter.ThresholdType.NO_THRESHOLD);
            if (this.getCurrentAnnotation().isQuantitative()) {
                filterParams.setThresholdValue(this.getCurrentAnnotation().threshold.value);
                if (selectedThresholdItem == 1) {
                    filterParams.setThresholdType(AnnotationFilterParameter.ThresholdType.ABOVE_THRESHOLD);
                } else if (selectedThresholdItem == 0) {
                    filterParams.setThresholdType(AnnotationFilterParameter.ThresholdType.BELOW_THRESHOLD);
                }
            }
        }
        if (this.currentStructureFilterPanel != null) {
            if (this.currentStructureFilterPanel.alphaHelix.getState()) {
                filterParams.setFilterAlphaHelix(true);
            }
            if (this.currentStructureFilterPanel.betaStrand.getState()) {
                filterParams.setFilterBetaSheet(true);
            }
            if (this.currentStructureFilterPanel.turn.getState()) {
                filterParams.setFilterTurn(true);
            }
        }
        if (this.currentSearchPanel != null) {
            if (!this.currentSearchPanel.searchBox.getText().isEmpty()) {
                this.currentSearchPanel.description.setEnabled(true);
                this.currentSearchPanel.displayName.setEnabled(true);
                filterParams.setRegexString(this.currentSearchPanel.searchBox.getText());
                if (this.currentSearchPanel.displayName.getState()) {
                    filterParams.addRegexSearchField(AnnotationFilterParameter.SearchableAnnotationField.DISPLAY_STRING);
                }
                if (this.currentSearchPanel.description.getState()) {
                    filterParams.addRegexSearchField(AnnotationFilterParameter.SearchableAnnotationField.DESCRIPTION);
                }
            } else {
                this.currentSearchPanel.description.setEnabled(false);
                this.currentSearchPanel.displayName.setEnabled(false);
            }
        }
        this.av.showAllHiddenColumns();
        this.av.getColumnSelection().filterAnnotations(this.getCurrentAnnotation().annotations, filterParams);
        if (this.getActionOption() == ACTION_OPTION_HIDE) {
            this.av.hideSelectedColumns();
        }
        filterParams = null;
        this.av.setAnnotationColumnSelectionState(this);
        this.av.sendSelection();
        this.ap.paintAlignment(true, true);
    }

    public HiddenColumns getOldHiddenColumns() {
        return this.oldHiddenColumns;
    }

    public void setOldHiddenColumns(HiddenColumns currentHiddenColumns) {
        if (currentHiddenColumns != null) {
            this.oldHiddenColumns = new HiddenColumns(currentHiddenColumns);
        }
    }

    public FurtherActionPanel getCurrentFutherActionPanel() {
        return this.currentFurtherActionPanel;
    }

    public void setCurrentFutherActionPanel(FurtherActionPanel currentFutherActionPanel) {
        this.currentFurtherActionPanel = currentFutherActionPanel;
    }

    public SearchPanel getCurrentSearchPanel() {
        return this.currentSearchPanel;
    }

    public void setCurrentSearchPanel(SearchPanel currentSearchPanel) {
        this.currentSearchPanel = currentSearchPanel;
    }

    public int getActionOption() {
        return this.actionOption;
    }

    public void setActionOption(int actionOption) {
        this.actionOption = actionOption;
    }

    public StructureFilterPanel getCurrentStructureFilterPanel() {
        return this.currentStructureFilterPanel;
    }

    public void setCurrentStructureFilterPanel(StructureFilterPanel currentStructureFilterPanel) {
        this.currentStructureFilterPanel = currentStructureFilterPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.annotations) {
            this.selectedAnnotationChanged();
        } else if (e.getSource() == this.threshold) {
            this.threshold_actionPerformed(null);
        } else if (e.getSource() == this.percentThreshold && !this.adjusting) {
            this.percentageValue_actionPerformed();
        }
    }

    public void selectedAnnotationChanged() {
        String currentView = NO_GRAPH_VIEW;
        if (this.av.getAlignment().getAlignmentAnnotation()[this.getAnnotations().getSelectedIndex()].isQuantitative()) {
            currentView = GRAPH_VIEW;
        }
        this.gSearchPanel.syncState();
        this.gFurtherActionPanel.syncState();
        this.gStructureFilterPanel.syncState();
        this.ngSearchPanel.syncState();
        this.ngFurtherActionPanel.syncState();
        this.ngStructureFilterPanel.syncState();
        this.switchableViewsLayout.show(this.switchableViewsPanel, currentView);
        this.updateView();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.ok) {
            this.ok_actionPerformed(null);
        } else if (evt.getSource() == this.cancel) {
            this.cancel_actionPerformed(null);
        } else if (evt.getSource() == this.thresholdValue) {
            this.thresholdValue_actionPerformed(null);
        } else {
            this.updateView();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.slider) {
            this.updateView();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.slider) {
            this.updateView();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.slider) {
            this.updateView();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this.slider) {
            this.updateView();
        }
    }

    public class SearchPanel
    extends TitledPanel
    implements ItemListener {
        private AnnotationColumnChooser aColChooser;
        private Checkbox displayName = new Checkbox();
        private Checkbox description = new Checkbox();
        private TextField searchBox = new TextField(10);

        public SearchPanel(AnnotationColumnChooser aColChooser) {
            this.aColChooser = aColChooser;
            this.searchBox.addTextListener(new TextListener(){

                @Override
                public void textValueChanged(TextEvent e) {
                    SearchPanel.this.searchStringAction();
                }
            });
            this.displayName.setLabel(MessageManager.getString("label.label"));
            this.displayName.setEnabled(false);
            this.displayName.addItemListener(this);
            this.description.setLabel(MessageManager.getString("label.description"));
            this.description.setEnabled(false);
            this.description.addItemListener(this);
            this.setTitle("Search Filter");
            this.syncState();
            this.add(this.searchBox);
            this.add(this.displayName);
            this.add(this.description);
        }

        public void displayNameCheckboxAction() {
            this.aColChooser.setCurrentSearchPanel(this);
            this.aColChooser.updateView();
        }

        public void discriptionCheckboxAction() {
            this.aColChooser.setCurrentSearchPanel(this);
            this.aColChooser.updateView();
        }

        public void searchStringAction() {
            this.aColChooser.setCurrentSearchPanel(this);
            this.aColChooser.updateView();
        }

        public void syncState() {
            SearchPanel sp = this.aColChooser.getCurrentSearchPanel();
            if (sp != null) {
                this.description.setEnabled(sp.description.isEnabled());
                this.description.setState(sp.description.getState());
                this.displayName.setEnabled(sp.displayName.isEnabled());
                this.displayName.setState(sp.displayName.getState());
                this.searchBox.setText(sp.searchBox.getText());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.displayName) {
                this.displayNameCheckboxAction();
            } else if (e.getSource() == this.description) {
                this.discriptionCheckboxAction();
            }
        }
    }

    public class StructureFilterPanel
    extends TitledPanel
    implements ItemListener {
        private AnnotationColumnChooser aColChooser;
        private Checkbox alphaHelix = new Checkbox();
        private Checkbox betaStrand = new Checkbox();
        private Checkbox turn = new Checkbox();
        private Checkbox all = new Checkbox();

        public StructureFilterPanel(AnnotationColumnChooser aColChooser) {
            this.aColChooser = aColChooser;
            this.alphaHelix.setLabel(MessageManager.getString("label.alpha_helix"));
            this.alphaHelix.setBackground(Color.white);
            this.alphaHelix.addItemListener(this);
            this.betaStrand.setLabel(MessageManager.getString("label.beta_strand"));
            this.betaStrand.setBackground(Color.white);
            this.betaStrand.addItemListener(this);
            this.turn.setLabel(MessageManager.getString("label.turn"));
            this.turn.setBackground(Color.white);
            this.turn.addItemListener(this);
            this.all.setLabel(MessageManager.getString("label.select_all"));
            this.all.setBackground(Color.white);
            this.all.addItemListener(this);
            this.setBackground(Color.white);
            this.setTitle("Structure Filter");
            this.add(this.all);
            this.add(this.alphaHelix);
            this.add(this.betaStrand);
            this.add(this.turn);
        }

        public void alphaHelix_actionPerformed() {
            this.updateSelectAllState();
            this.aColChooser.setCurrentStructureFilterPanel(this);
            this.aColChooser.updateView();
        }

        public void betaStrand_actionPerformed() {
            this.updateSelectAllState();
            this.aColChooser.setCurrentStructureFilterPanel(this);
            this.aColChooser.updateView();
        }

        public void turn_actionPerformed() {
            this.updateSelectAllState();
            this.aColChooser.setCurrentStructureFilterPanel(this);
            this.aColChooser.updateView();
        }

        public void all_actionPerformed() {
            if (this.all.getState()) {
                this.alphaHelix.setState(true);
                this.betaStrand.setState(true);
                this.turn.setState(true);
            } else {
                this.alphaHelix.setState(false);
                this.betaStrand.setState(false);
                this.turn.setState(false);
            }
            this.aColChooser.setCurrentStructureFilterPanel(this);
            this.aColChooser.updateView();
        }

        public void updateSelectAllState() {
            if (this.alphaHelix.getState() && this.betaStrand.getState() && this.turn.getState()) {
                this.all.setState(true);
            } else {
                this.all.setState(false);
            }
        }

        public void syncState() {
            StructureFilterPanel sfp = this.aColChooser.getCurrentStructureFilterPanel();
            if (sfp != null) {
                this.alphaHelix.setState(sfp.alphaHelix.getState());
                this.betaStrand.setState(sfp.betaStrand.getState());
                this.turn.setState(sfp.turn.getState());
                if (sfp.all.getState()) {
                    this.all.setState(true);
                    this.alphaHelix.setState(true);
                    this.betaStrand.setState(true);
                    this.turn.setState(true);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.alphaHelix) {
                this.alphaHelix_actionPerformed();
            } else if (e.getSource() == this.betaStrand) {
                this.betaStrand_actionPerformed();
            } else if (e.getSource() == this.turn) {
                this.turn_actionPerformed();
            } else if (e.getSource() == this.all) {
                this.all_actionPerformed();
            }
        }
    }

    public class FurtherActionPanel
    extends Panel
    implements ItemListener {
        private AnnotationColumnChooser aColChooser;
        private Choice furtherAction = new Choice();

        public FurtherActionPanel(AnnotationColumnChooser aColChooser) {
            this.aColChooser = aColChooser;
            this.furtherAction.addItem("Select");
            this.furtherAction.addItem("Hide");
            this.furtherAction.addItemListener(this);
            this.syncState();
            this.add(this.furtherAction);
        }

        public void syncState() {
            if (this.aColChooser.getActionOption() == ACTION_OPTION_HIDE) {
                this.furtherAction.select("Hide");
            } else {
                this.furtherAction.select("Select");
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.aColChooser.setCurrentFutherActionPanel(this);
            if (this.furtherAction.getSelectedItem().equalsIgnoreCase("Select")) {
                AnnotationColumnChooser.this.setActionOption(1);
                AnnotationColumnChooser.this.updateView();
            } else {
                AnnotationColumnChooser.this.setActionOption(ACTION_OPTION_HIDE);
                AnnotationColumnChooser.this.updateView();
            }
        }
    }
}

