/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class Grouping {
    public static SequenceGroup[] makeGroupsFrom(SequenceI[] sequences, String[] selectedChars, List<SequenceGroup> list) {
        int i;
        HashMap gps = new HashMap();
        int width = 0;
        HashMap<String, SequenceGroup> pgroup = new HashMap<String, SequenceGroup>();
        if (list != null) {
            for (SequenceGroup sg : list) {
                for (SequenceI sq : sg.getSequences(null)) {
                    pgroup.put(sq.toString(), sg);
                }
            }
        }
        for (i = 0; i < sequences.length; ++i) {
            ArrayList<SequenceI> svec;
            String schar = selectedChars[i];
            SequenceGroup pgp = (SequenceGroup)pgroup.get(sequences[i].toString());
            if (pgp != null) {
                schar = pgp.getName() + ":" + schar;
            }
            if ((svec = (ArrayList<SequenceI>)gps.get(schar)) == null) {
                svec = new ArrayList<SequenceI>();
                gps.put(schar, svec);
            }
            if (width < sequences[i].getLength()) {
                width = sequences[i].getLength();
            }
            svec.add(sequences[i]);
        }
        SequenceGroup[] groups = new SequenceGroup[gps.size()];
        i = 0;
        for (String key : gps.keySet()) {
            SequenceGroup group = new SequenceGroup((List)gps.get(key), "Subseq: " + key, null, true, true, false, 0, width - 1);
            groups[i++] = group;
        }
        gps.clear();
        pgroup.clear();
        return groups;
    }

    public static SequenceGroup[] makeGroupsFromCols(SequenceI[] sequences, ColumnSelection cs, List<SequenceGroup> list) {
        HashMap<String, ArrayList<SequenceI>> gps = new HashMap<String, ArrayList<SequenceI>>();
        HashMap<String, SequenceGroup> pgroup = new HashMap<String, SequenceGroup>();
        if (list != null) {
            for (SequenceGroup sg : list) {
                for (SequenceI sequenceI : sg.getSequences(null)) {
                    pgroup.put(sequenceI.toString(), sg);
                }
            }
        }
        int[] spos = new int[cs.getSelected().size()];
        int width = -1;
        int i = 0;
        for (Integer pos : cs.getSelected()) {
            spos[i++] = pos;
        }
        for (i = 0; i < sequences.length; ++i) {
            int n = sequences[i].getLength();
            if (width < n) {
                width = n;
            }
            SequenceGroup pgp = (SequenceGroup)pgroup.get(sequences[i].toString());
            StringBuilder schar = new StringBuilder();
            if (pgp != null) {
                schar.append(pgp.getName() + ":");
            }
            for (int p : spos) {
                if (p >= n) {
                    schar.append("~");
                    continue;
                }
                schar.append(sequences[i].getCharAt(p));
            }
            ArrayList<SequenceI> svec = (ArrayList<SequenceI>)gps.get(schar.toString());
            if (svec == null) {
                svec = new ArrayList<SequenceI>();
                gps.put(schar.toString(), svec);
            }
            svec.add(sequences[i]);
        }
        SequenceGroup[] sequenceGroupArray = new SequenceGroup[gps.size()];
        i = 0;
        for (String key : gps.keySet()) {
            SequenceGroup group = new SequenceGroup((List)gps.get(key), "Subseq: " + key, null, true, true, false, 0, width - 1);
            sequenceGroupArray[i++] = group;
        }
        gps.clear();
        pgroup.clear();
        return sequenceGroupArray;
    }

    public static void divideByFeature(String[] featureLabels, String[] groupLabels, int start, int stop, SequenceI[] sequences, Vector exgroups, String method) {
    }
}

