/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.Metadata;
import compbio.data.msa.MsaWS;
import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.metadata.JobStatus;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.util.FileUtil;
import compbio.util.Util;
import compbio.ws.client.CmdHelper;
import compbio.ws.client.Jws2Client;
import compbio.ws.client.Services;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class WSTester {
    public static final String fastaInput2records = ">Foo\nMTADGPRELLQLRAAVRHRPQDFVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAV\n>Bar\nASDAAPEHPGIALWLHALEDAGQAEAAAAYTRAHQLLPEEPYITAQLLNAVA\n";
    public static final String fastaInput1record = ">Foo\nMTADGPRELLQLRAAVRHRPQDFVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAV\n";
    public static final String fastaAlignment = ">Foo\nMTADGPRELLQLRAAVRHRPQDFVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAV--------\n>Bar\nASDAAPEH------------PGIALWLHALE-DAGQAEAAA---AYTRAHQLLPEEPYITAQLLNAVA\n";
    public static final String fastaRNAAlignment = ">Foo\nC-UUGCGUUAAUGAGAACAGAAACG-UAAA--CUAUAA-CCUAG-G-GGUUUCUGUUGGAUGGUUG----GCAAC\n>Bar\nG-UGGCGCUUAUGACGCAGUUGUCU-UAAA-CUCGAAC--UCGA-GCGGGCAAUUGCUGAU-UACGAUUAACCAC\n";
    public static final String clustalRNAAlignment = "CLUSTAL\nFoo             C-UUGCGUUAAUGAGAACAGAAACG-UAAA--CUAUAA-CCUAG-G-GGUUUCUGUUGGA\nBar             G-UGGCGCUUAUGACGCAGUUGUCU-UAAA-CUCGAAC--UCGA-GCGGGCAAUUGCUGA\nFoo             UGGUUG----GCAAC\nBar             U-UACGAUUAACCAC";
    private static final String FAILED = "FAILED";
    private static final String OK = "OK";
    private static final String UNSUPPORTED = "UNSUPPORTED";
    private final PrintWriter writer;
    private final String hostname;

    private static List<FastaSequence> loadSeqs(int n) {
        try {
            if (n == 1) {
                return SequenceUtil.readFasta(new ByteArrayInputStream(fastaInput1record.getBytes()));
            }
            return SequenceUtil.readFasta(new ByteArrayInputStream(fastaInput2records.getBytes()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static List<FastaSequence> loadAlignment() {
        try {
            return SequenceUtil.readFasta(new ByteArrayInputStream(fastaAlignment.getBytes()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static List<FastaSequence> loadRNAAlignment() {
        try {
            return SequenceUtil.readFasta(new ByteArrayInputStream(fastaRNAAlignment.getBytes()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public WSTester(String string, PrintWriter printWriter) {
        if (Util.isEmpty(string)) {
            throw new NullPointerException("Hostname must be provided!");
        }
        this.hostname = string;
        this.writer = printWriter;
    }

    static void printUsage() {
        System.out.println("Usage: <Class or Jar file name> -h=host_and_context <-s=serviceName>");
        System.out.println();
        System.out.println("-h=<host_and_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws");
        System.out.println("-s=<ServiceName> - optional if unspecified all services are tested otherwise one of " + Arrays.toString((Object[])Services.values()));
        System.out.println();
    }

    private <T> boolean presetAlign(MsaWS<T> msaWS, List<Preset<T>> list) throws UnsupportedRuntimeException {
        boolean bl = false;
        for (Preset<T> preset : list) {
            this.writer.print("Aligning with preset '" + preset.getName() + "'... ");
            Alignment alignment = null;
            try {
                String string = msaWS.presetAlign(WSTester.loadSeqs(2), preset);
                alignment = msaWS.getResult(string);
                if (alignment != null) {
                    this.writer.println(OK);
                }
                bl = true;
            }
            catch (Exception exception) {
                if (exception instanceof UnsupportedRuntimeException) {
                    throw (UnsupportedRuntimeException)exception;
                }
                this.reportException(exception);
            }
        }
        return bl;
    }

    private <T> boolean testMsaWS(MsaWS<T> msaWS, Services services) throws Exception {
        assert (msaWS != null);
        boolean bl = this.testDefaultAlignment(msaWS, services);
        PresetManager presetManager = msaWS.getPresets();
        if (presetManager != null && presetManager.getPresets().size() > 0) {
            this.writer.println("Testing alignment with presets:");
            List list = presetManager.getPresets();
            bl = !bl ? this.presetAlign(msaWS, list) : bl;
        }
        this.testMetadata(msaWS);
        return bl;
    }

    private <T> boolean checkService(JABAService jABAService, Services services) {
        try {
            if (jABAService == null) {
                throw new NullPointerException("JABAService instance must be provided!");
            }
            if (jABAService instanceof MsaWS) {
                return this.testMsaWS((MsaWS)jABAService, services);
            }
            if (jABAService instanceof SequenceAnnotation) {
                return this.testSequenceAnnotationWS((SequenceAnnotation)jABAService, services);
            }
            throw new UnsupportedOperationException("The service: " + jABAService.getClass() + " is not supported! ");
        }
        catch (Exception exception) {
            this.reportException(exception);
            return false;
        }
    }

    private <T> boolean testSequenceAnnotationWS(SequenceAnnotation<T> sequenceAnnotation, Services services) throws Exception {
        List list;
        this.writer.print("Calling annotation test.........");
        List<FastaSequence> list2 = WSTester.loadSeqs(2);
        if (services == Services.AAConWS) {
            list2 = WSTester.loadAlignment();
        } else if (services == Services.RNAalifoldWS) {
            list2 = WSTester.loadRNAAlignment();
        }
        boolean bl = this.testDefaultAnalyse(list2, sequenceAnnotation, null, null);
        PresetManager presetManager = sequenceAnnotation.getPresets();
        if (presetManager != null && (list = presetManager.getPresets()) != null && !list.isEmpty()) {
            Preset preset = list.get(0);
            this.writer.print("Calling analyse with Preset.........");
            bl = this.testDefaultAnalyse(list2, sequenceAnnotation, preset, null);
        }
        this.testMetadata(sequenceAnnotation);
        return bl;
    }

    private <T> boolean testDefaultAnalyse(List<FastaSequence> list, SequenceAnnotation<T> sequenceAnnotation, Preset<T> preset, List<Option<T>> list2) throws Exception {
        ScoreManager scoreManager = null;
        String string = null;
        string = list2 != null ? sequenceAnnotation.customAnalize(list, list2) : (preset != null ? sequenceAnnotation.presetAnalize(list, preset) : sequenceAnnotation.analize(list));
        Thread.sleep(1000L);
        scoreManager = sequenceAnnotation.getAnnotation(string);
        if (scoreManager != null) {
            this.writer.println(OK);
        }
        return scoreManager != null;
    }

    private void reportException(Exception exception) {
        this.writer.println(FAILED);
        this.writer.println("Exception while waiting for results. Exception details are below:");
        this.writer.println(exception.getLocalizedMessage());
        exception.printStackTrace(this.writer);
    }

    private <T> void testMetadata(Metadata<T> metadata) throws UnsupportedRuntimeException {
        this.writer.print("Querying presets...");
        PresetManager<T> presetManager = metadata.getPresets();
        if (presetManager != null && presetManager.getPresets().size() > 0) {
            this.writer.println(OK);
        } else {
            this.writer.println(UNSUPPORTED);
        }
        this.writer.print("Querying Parameters...");
        RunnerConfig<T> runnerConfig = metadata.getRunnerOptions();
        if (runnerConfig != null && runnerConfig.getArguments().size() > 0) {
            this.writer.println(OK);
        } else {
            this.writer.println(UNSUPPORTED);
        }
        this.writer.print("Querying Limits...");
        LimitsManager<T> limitsManager = metadata.getLimits();
        if (limitsManager != null && limitsManager.getLimits().size() > 0) {
            this.writer.println(OK);
        } else {
            this.writer.println(UNSUPPORTED);
        }
        this.writer.print("Querying Local Engine Limits...");
        Limit<T> limit = metadata.getLimit("# LocalEngineExecutionLimit #");
        if (limit != null) {
            this.writer.println(OK);
        } else {
            this.writer.println(UNSUPPORTED);
        }
    }

    private <T> boolean testDefaultAlignment(MsaWS<T> msaWS, Services services) throws Exception {
        this.writer.print("Testing alignment with default parameters:");
        Alignment alignment = null;
        boolean bl = false;
        String string = msaWS.align(WSTester.loadSeqs(2));
        this.writer.print("\nQuerying job status...");
        JobStatus jobStatus = msaWS.getJobStatus(string);
        while (jobStatus != JobStatus.FINISHED) {
            Thread.sleep(1000L);
            jobStatus = msaWS.getJobStatus(string);
        }
        this.writer.println(OK);
        this.writer.print("Retrieving results...");
        alignment = msaWS.getResult(string);
        bl = true;
        if (alignment != null) {
            this.writer.println(OK);
        }
        return bl;
    }

    public static <T> void main(String[] stringArray) throws IOException {
        if (stringArray == null || stringArray.length < 1) {
            WSTester.printUsage();
            System.exit(0);
        }
        String string = CmdHelper.getHost(stringArray);
        String string2 = CmdHelper.getServiceName(stringArray);
        if (!Jws2Client.validURL(string)) {
            System.err.println("<host_and_context> parameter is not provided or is incorrect!");
            System.exit(1);
        }
        WSTester wSTester = new WSTester(string, new PrintWriter(System.out, true));
        if (string2 != null) {
            Services[] servicesArray = Services.getService(string2);
            if (servicesArray == null) {
                wSTester.writer.println("Service '" + string2 + "' is not supported. Valid values are: " + Arrays.toString((Object[])Services.values()));
                wSTester.writer.println();
                WSTester.printUsage();
                System.exit(1);
            }
            wSTester.checkService((Services)servicesArray);
            System.exit(0);
        }
        wSTester.writer.println("<ServiceName> is not provided checking all known services...");
        for (Services services : Services.values()) {
            wSTester.writer.println();
            wSTester.checkService(services);
        }
    }

    private JABAService connect(String string, Services services) throws WebServiceException, ConnectException {
        URL uRL = null;
        System.out.println("Attempting to connect with " + services.toString() + "...");
        try {
            uRL = new URL(string + "/" + services.toString() + "?wsdl");
            System.out.println("URL: " + uRL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        Service service = null;
        try {
            service = services.getService(uRL, services.getServiceNamespace());
        }
        catch (WebServiceException webServiceException) {
            webServiceException.printStackTrace();
        }
        if (service == null) {
            throw new ConnectException("Could not connect to " + uRL + ". Is the server down?");
        }
        JABAService jABAService = services.getInterface(service);
        System.out.println("Connected successfully!");
        return jABAService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkService(Services services) throws ConnectException, WebServiceException {
        JABAService jABAService = this.connect(this.hostname, services);
        if (jABAService == null) {
            String string = "Cannot estabilish the connection to host " + this.hostname + " with service ";
            this.writer.println(string + services.toString());
            return false;
        }
        boolean bl = false;
        try {
            this.writer.println("Checking service " + services.toString());
            bl = this.checkService(jABAService, services);
        }
        finally {
            FileUtil.closeSilently((Closeable)((Object)jABAService));
        }
        this.reportResults(services, bl);
        return bl;
    }

    private void reportResults(Services services, boolean bl) {
        if (bl) {
            this.writer.println("Check is completed. The Service " + (Object)((Object)services) + " IS WORKING\n");
        } else {
            this.writer.println("Check is aborted. The Service " + (Object)((Object)services) + " HAS SOME PROBLEMS\n");
        }
    }
}

