/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Option;
import compbio.metadata.Parameter;
import compbio.util.SysPrefs;
import compbio.util.annotation.NotThreadSafe;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@NotThreadSafe
public class RunnerConfig<T> {
    private String runnerClassName;
    List<Option<T>> options = new ArrayList<Option<T>>();
    String prmSeparator;
    List<Parameter<T>> parameters = new ArrayList<Parameter<T>>();
    @XmlTransient
    List<Option<T>> arguments;

    public RunnerConfig<T> copyAndValidateRConfig(RunnerConfig<?> runnerConfig) {
        if (this.runnerClassName != runnerConfig.runnerClassName) {
            throw new InvalidParameterException("Wrong runner configuration! ");
        }
        RunnerConfig<T> runnerConfig2 = new RunnerConfig<T>();
        runnerConfig2.runnerClassName = runnerConfig.runnerClassName;
        runnerConfig2.options = new ArrayList<Option<T>>(this.options);
        return runnerConfig2;
    }

    public List<Option<T>> getOptions() {
        return this.options;
    }

    public void addParameter(Parameter<T> parameter) {
        assert (parameter != null);
        this.parameters.add(parameter);
    }

    public void addOption(Option<T> option) {
        assert (option != null);
        this.options.add(option);
    }

    @XmlTransient
    public List<Option<T>> getArguments() {
        this.arguments = new ArrayList<Option<T>>(this.options);
        this.arguments.addAll(this.parameters);
        return this.arguments;
    }

    public String getPrmSeparator() {
        return this.prmSeparator;
    }

    public void setPrmSeparator(String string) {
        this.prmSeparator = string;
    }

    public void setOptions(List<Option<T>> list) {
        this.options = list;
    }

    @XmlElement(required=true)
    public String getRunnerClassName() {
        return this.runnerClassName;
    }

    public void setRunnerClassName(String string) {
        this.runnerClassName = string;
    }

    public void setParameters(List<Parameter<T>> list) {
        this.parameters = list;
    }

    public List<Parameter<T>> getParameters() {
        return this.parameters;
    }

    public String toString() {
        String string = "Runner: " + this.runnerClassName + SysPrefs.newlinechar;
        for (Option<T> option : this.getArguments()) {
            string = string + option;
        }
        return string;
    }

    public boolean equals(Object object) {
        Parameter parameter;
        if (object == null) {
            return false;
        }
        RunnerConfig runnerConfig = null;
        if (object instanceof RunnerConfig) {
            runnerConfig = (RunnerConfig)object;
        }
        if (!runnerConfig.runnerClassName.equals(this.runnerClassName)) {
            return false;
        }
        if (this.options.size() != runnerConfig.options.size()) {
            return false;
        }
        if (this.parameters.size() != runnerConfig.parameters.size()) {
            return false;
        }
        if (!this.prmSeparator.equals(runnerConfig.prmSeparator)) {
            return false;
        }
        for (Option<T> parameter2 : this.options) {
            parameter = runnerConfig.getArgument(parameter2.getName());
            if (parameter == null) {
                return false;
            }
            if (parameter2.equals(parameter)) continue;
            return false;
        }
        for (Parameter parameter2 : this.parameters) {
            parameter = (Parameter)runnerConfig.getArgument(parameter2.getName());
            if (parameter == null) {
                return false;
            }
            if (parameter2.equals(parameter)) continue;
            return false;
        }
        return true;
    }

    public Option<T> getArgument(String string) {
        for (Option<T> option : this.getArguments()) {
            if (!option.getName().equalsIgnoreCase(string)) continue;
            return option;
        }
        return null;
    }

    public boolean removeArgument(String string) {
        Option<T> option = this.getArgument(string);
        if (option != null) {
            if (option instanceof Parameter) {
                this.parameters.remove(option);
                return true;
            }
            this.options.remove(option);
            return true;
        }
        return false;
    }

    public Option<T> getArgumentByOptionName(String string) {
        for (Option<T> option : this.getArguments()) {
            for (String string2 : option.getOptionNames()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return option;
            }
        }
        return null;
    }

    public boolean removeArgumentByOptionName(String string) {
        Option<T> option = this.getArgumentByOptionName(string);
        if (option != null) {
            if (option instanceof Parameter) {
                this.parameters.remove(option);
                return true;
            }
            this.options.remove(option);
            return true;
        }
        return false;
    }

    public void validate() throws ValidationException {
        for (Option<T> option : this.getArguments()) {
            option.validate();
        }
    }
}

