/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.msa;

import compbio.ws.client.Services;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Category {
    public static final String CATEGORY_ALIGNMENT = "Alignment";
    public static final String CATEGORY_DISORDER = "Protein Disorder";
    public static final String CATEGORY_CONSERVATION = "Conservation";
    public static final String CATEGORY_PREDICTION = "Prediction";
    public String name;
    Set<Services> services;

    private Category(String string, Set<Services> set) {
        this.name = string;
        this.services = set;
    }

    private Category() {
    }

    public Set<Services> getServices() {
        return new TreeSet<Services>(this.services);
    }

    public static Set<Category> getCategories() {
        return Category.init();
    }

    private static Set<Category> init() {
        HashSet<Services> hashSet = new HashSet<Services>();
        hashSet.add(Services.ClustalOWS);
        hashSet.add(Services.ClustalWS);
        hashSet.add(Services.MafftWS);
        hashSet.add(Services.MuscleWS);
        hashSet.add(Services.ProbconsWS);
        hashSet.add(Services.MSAprobsWS);
        hashSet.add(Services.GLprobsWS);
        hashSet.add(Services.TcoffeeWS);
        Category category = new Category(CATEGORY_ALIGNMENT, hashSet);
        HashSet<Services> hashSet2 = new HashSet<Services>();
        hashSet2.add(Services.DisemblWS);
        hashSet2.add(Services.GlobPlotWS);
        hashSet2.add(Services.IUPredWS);
        hashSet2.add(Services.JronnWS);
        Category category2 = new Category(CATEGORY_DISORDER, hashSet2);
        HashSet<Services> hashSet3 = new HashSet<Services>();
        hashSet3.add(Services.AAConWS);
        Category category3 = new Category(CATEGORY_CONSERVATION, hashSet3);
        HashSet<Services> hashSet4 = new HashSet<Services>();
        hashSet4.add(Services.RNAalifoldWS);
        Category category4 = new Category(CATEGORY_PREDICTION, hashSet4);
        HashSet<Category> hashSet5 = new HashSet<Category>();
        hashSet5.add(category);
        hashSet5.add(category2);
        hashSet5.add(category3);
        hashSet5.add(category4);
        return hashSet5;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Category category = (Category)object;
        return !(this.name == null ? category.name != null : !this.name.equals(category.name));
    }
}

