/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.data.Build;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public final class HostWhitelist {
    private static final boolean ALLOW_LOCATOR_FILE_PROTOCOL = Build.allowLocatorFileProtocol();

    public static URL verify(URL url) throws MalformedURLException {
        return HostWhitelist.verify(Build.hostWhitelist(), url);
    }

    public static URL verify(List<String> hosts, URL url) throws MalformedURLException {
        if (url == null || hosts.isEmpty()) {
            return url;
        }
        String urlHost = url.getHost();
        String protocol = url.getProtocol();
        if (ALLOW_LOCATOR_FILE_PROTOCOL && protocol.equals("file") && urlHost.equals("")) {
            return url;
        }
        for (String host : hosts) {
            String regex = host.replace(".", "\\.").replace("*", ".*");
            if (!urlHost.matches(regex)) continue;
            return url;
        }
        throw new MalformedURLException("The host for the specified URL (" + url + ") is not in the host whitelist: " + hosts);
    }
}

