/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.util.LinkedList;

public class ConcurrentDispatcher {
    private int priority;
    private final LinkedList queue = new LinkedList();
    private int threadCount;
    private int maxThreadCount;
    public static final int ENQUEUE_WHEN_BLOCKED = 0;
    public static final int RUN_WHEN_BLOCKED = 1;
    private int blockingPolicy = 0;

    public ConcurrentDispatcher() {
        this(5, 5);
    }

    public ConcurrentDispatcher(int n, int n2) {
        this.priority = n;
        this.maxThreadCount = n2;
    }

    public void setMaxThreadCount(int n) {
        this.maxThreadCount = n;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void dispatch(Runnable runnable) {
        this.dispatch(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Runnable runnable, boolean bl) {
        bl = false;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.threadCount < this.maxThreadCount) {
                if (bl) {
                    this.queue.addFirst(runnable);
                } else {
                    this.queue.addLast(runnable);
                }
                Thread thread = new Thread(this + " Processor"){

                    @Override
                    public void run() {
                        ConcurrentDispatcher.this.processEvents();
                    }
                };
                ++this.threadCount;
                try {
                    thread.setDaemon(false);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                }
                try {
                    thread.setPriority(this.priority);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                }
                thread.start();
                return;
            }
            if (this.blockingPolicy == 0) {
                if (bl) {
                    this.queue.addFirst(runnable);
                } else {
                    this.queue.addLast(runnable);
                }
                return;
            }
        }
        runnable.run();
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvents() {
        while (true) {
            Object e;
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                if (this.queue.isEmpty()) {
                    --this.threadCount;
                    break;
                }
                e = this.queue.removeFirst();
            }
            try {
                ((Runnable)e).run();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
        }
    }
}

