/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaTableUI;
import org.violetlib.aqua.SelectionRepaintable;
import org.violetlib.treetable.TreeTable;
import org.violetlib.treetable.TreeTableCellRenderer;
import org.violetlib.treetable.ui.BasicTreeTableUI;

public class AquaTreeTableUI
extends BasicTreeTableUI {
    protected MyHandler handler = new MyHandler();

    @Override
    protected BasicTreeTableUI.Handler createHandler() {
        return this.handler;
    }

    @Override
    protected JTree createAndConfigureTree() {
        JTree jTree = super.createAndConfigureTree();
        jTree.setFocusable(false);
        jTree.putClientProperty("Component.hasFocusDelegate", this.treeTable);
        jTree.putClientProperty("JTree.paintSelectionBackground", false);
        return jTree;
    }

    @Override
    protected JTable createAndConfigureTable() {
        JTable jTable = super.createAndConfigureTable();
        jTable.setFocusable(false);
        jTable.putClientProperty("Component.hasFocusDelegate", this.treeTable);
        return jTable;
    }

    @Override
    protected void finishConfiguration(JTree jTree, JTable jTable) {
        jTree.putClientProperty("JTree.selectionRepainter", jTable);
    }

    @Override
    protected TreeTableCellRenderer createFocusRenderer() {
        return null;
    }

    @Override
    protected boolean hasTreeHandle(TreeTable treeTable, TreePath treePath) {
        return !treeTable.isLeaf(treePath);
    }

    @Override
    protected List<String> getProperties() {
        ArrayList<String> arrayList = new ArrayList<String>(super.getProperties());
        arrayList.add("Frame.active");
        return arrayList;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MyPropertyChangeListener();
    }

    public void repaintSelection() {
        TableUI tableUI = this.getTable().getUI();
        if (tableUI instanceof SelectionRepaintable) {
            SelectionRepaintable selectionRepaintable = (SelectionRepaintable)((Object)tableUI);
            selectionRepaintable.repaintSelection();
        }
    }

    protected void handleDoubleClick(TreePath treePath) {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Color color = this.treeTable.getAlternateRowColor();
        if (color == null || color instanceof UIResource) {
            JTable jTable = this.getTable();
            if (jTable.getUI() instanceof AquaTableUI && AquaTableUI.isStriped(jTable)) {
                this.treeTable.setAlternateRowColor(UIManager.getColor("Table.oddRowBackground"));
            } else {
                this.treeTable.setAlternateRowColor(null);
            }
        }
        super.paint(graphics, jComponent);
    }

    protected class MyHandler
    extends BasicTreeTableUI.Handler {
        protected MyHandler() {
            super(AquaTreeTableUI.this);
        }

        @Override
        protected void focusChanged() {
            AquaTreeTableUI.this.repaintSelection();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if ("Frame.active".equals(propertyChangeEvent.getPropertyName())) {
                AquaTreeTableUI.this.getTree().putClientProperty("Frame.active", propertyChangeEvent.getNewValue());
                AquaTreeTableUI.this.getTable().putClientProperty("Frame.active", propertyChangeEvent.getNewValue());
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AquaTreeTableUI.this.handler.propertyChange(propertyChangeEvent);
        }
    }
}

