/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PasswordView;
import javax.swing.text.View;
import org.violetlib.aqua.AquaTextFieldUI;
import org.violetlib.aqua.AquaUtils;

public class AquaTextPasswordFieldUI
extends AquaTextFieldUI {
    static final AquaUtils.RecyclableSingleton<CapsLockSymbolPainter> capsLockPainter = new AquaUtils.RecyclableSingletonFromDefaultConstructor<CapsLockSymbolPainter>(CapsLockSymbolPainter.class);

    static CapsLockSymbolPainter getCapsLockPainter() {
        return capsLockPainter.get();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTextPasswordFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "PasswordField";
    }

    @Override
    protected View createBasicView(Element element) {
        return new AquaPasswordView(element);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addKeyListener(AquaTextPasswordFieldUI.getCapsLockPainter());
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeKeyListener(AquaTextPasswordFieldUI.getCapsLockPainter());
        super.uninstallListeners();
    }

    @Override
    protected void paintBackgroundSafely(Graphics graphics) {
        super.paintBackgroundSafely(graphics);
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        if (!jTextComponent.isFocusOwner()) {
            return;
        }
        boolean bl = Toolkit.getDefaultToolkit().getLockingKeyState(20);
        if (!bl) {
            return;
        }
        Rectangle rectangle = jTextComponent.getBounds();
        AquaTextPasswordFieldUI.getCapsLockPainter().paintBorder(jTextComponent, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static class CapsLockSymbolPainter
    extends KeyAdapter
    implements Border,
    UIResource {
        protected Shape capsLockShape;

        CapsLockSymbolPainter() {
        }

        protected Shape getCapsLockShape() {
            if (this.capsLockShape != null) {
                return this.capsLockShape;
            }
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.5, 0.5, 16.0, 16.0, 8.0, 8.0);
            GeneralPath generalPath = new GeneralPath(double_);
            generalPath.setWindingRule(0);
            generalPath.moveTo(8.5, 2.0);
            generalPath.lineTo(4.0, 7.0);
            generalPath.lineTo(6.25, 7.0);
            generalPath.lineTo(6.25, 10.25);
            generalPath.lineTo(10.75, 10.25);
            generalPath.lineTo(10.75, 7.0);
            generalPath.lineTo(13.0, 7.0);
            generalPath.lineTo(8.5, 2.0);
            generalPath.moveTo(10.75, 12.0);
            generalPath.lineTo(6.25, 12.0);
            generalPath.lineTo(6.25, 14.25);
            generalPath.lineTo(10.75, 14.25);
            generalPath.lineTo(10.75, 12.0);
            this.capsLockShape = generalPath;
            return this.capsLockShape;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics = graphics.create(n3 - 23, n4 / 2 - 8, 18, 18);
            graphics.setColor(UIManager.getColor("PasswordField.capsLockIconColor"));
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).fill(this.getCapsLockShape());
            graphics.dispose();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.update(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.update(keyEvent);
        }

        void update(KeyEvent keyEvent) {
            if (20 != keyEvent.getKeyCode()) {
                return;
            }
            keyEvent.getComponent().repaint();
        }
    }

    protected class AquaPasswordView
    extends PasswordView {
        public AquaPasswordView(Element element) {
            super(element);
            this.setupDefaultEchoCharacter();
        }

        protected void setupDefaultEchoCharacter() {
            Character c = (Character)UIManager.getDefaults().get(AquaTextPasswordFieldUI.this.getPropertyPrefix() + ".echoChar");
            if (c != null) {
                LookAndFeel.installProperty(AquaTextPasswordFieldUI.this.getComponent(), "echoChar", c);
            }
        }
    }
}

