/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.border.AbstractBorder;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderLayoutConfiguration;

public class AquaTableHeaderBorder
extends AbstractBorder {
    private Insets editorInsetsLTR;
    private Insets editorInsetsRTL;
    private Insetter arrowInsetsLTR;
    private Insetter arrowInsetsRTL;
    protected final AquaUIPainter painter = AquaPainting.create();
    protected AquaUIPainter.ColumnSortArrowDirection sortArrowDirection = AquaUIPainter.ColumnSortArrowDirection.NONE;
    protected JTable owner;

    protected static AquaTableHeaderBorder getListHeaderBorder() {
        return new AquaTableHeaderBorder();
    }

    protected AquaTableHeaderBorder() {
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = (JComponent)component;
        this.painter.configure(n3 + 1, n4);
        Configuration configuration = this.getConfiguration(jComponent);
        this.painter.getPainter(configuration).paint(graphics, n - 1, n2);
    }

    protected Configuration getConfiguration(JComponent jComponent) {
        AquaUIPainter.State state = this.getState(jComponent);
        boolean bl = jComponent.hasFocus();
        AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(this.owner);
        return new TableColumnHeaderConfiguration(state, this.sortArrowDirection, false, bl, uILayoutDirection);
    }

    protected AquaUIPainter.State getState(JComponent jComponent) {
        if (!jComponent.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        JRootPane jRootPane = jComponent.getRootPane();
        if (jRootPane == null) {
            return AquaUIPainter.State.ACTIVE;
        }
        if (!AquaFocusHandler.isActive(jRootPane)) {
            return AquaUIPainter.State.INACTIVE;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        this.configureInsets();
        return AquaUtils.isLeftToRight(this.owner) ? this.editorInsetsLTR : this.editorInsetsRTL;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = this.getBorderInsets(component);
        insets.left = insets2.left;
        insets.top = insets2.top;
        insets.right = insets2.right;
        insets.bottom = insets2.bottom;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setSortArrowDirection(AquaUIPainter.ColumnSortArrowDirection columnSortArrowDirection) {
        this.sortArrowDirection = columnSortArrowDirection;
    }

    public void setOwner(JTable jTable) {
        this.owner = jTable;
    }

    private void configureInsets() {
        if (this.editorInsetsLTR != null) {
            return;
        }
        AquaUILayoutInfo aquaUILayoutInfo = this.painter.getLayoutInfo();
        this.editorInsetsLTR = aquaUILayoutInfo.getTableColumnHeaderLabelInsets(new TableColumnHeaderLayoutConfiguration(AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT, true)).asInsets();
        this.editorInsetsRTL = aquaUILayoutInfo.getTableColumnHeaderLabelInsets(new TableColumnHeaderLayoutConfiguration(AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT, true)).asInsets();
        this.arrowInsetsLTR = aquaUILayoutInfo.getTableColumnHeaderSortArrowInsets(new TableColumnHeaderLayoutConfiguration(AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT, true));
        this.arrowInsetsRTL = aquaUILayoutInfo.getTableColumnHeaderSortArrowInsets(new TableColumnHeaderLayoutConfiguration(AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT, true));
    }
}

