/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.models.geom.LinesIntersect;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.geom.Line2D;
import java.util.Arrays;

public class Benchmark {
    private RNA rna;
    public int backboneCrossings;
    public double averageUnpairedDistance;
    public double medianConsecutiveBaseDistance;
    public int tooNearConsecutiveBases;
    public int tooFarConsecutiveBases;
    public double targetConsecutiveBaseDistance = 40.0;
    public double tooNearFactor = 0.5;
    public double tooFarFactor = 2.0;

    public Benchmark(RNA rNA) {
        this.rna = rNA;
        this.computeAll();
    }

    private void computeAll() {
        double d;
        int n;
        int n2;
        int n3;
        int n4 = this.rna.getSize();
        Line2D.Double[] doubleArray = new Line2D.Double[n4 - 1];
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            doubleArray[n3] = new Line2D.Double(this.rna.getCoords(n3), this.rna.getCoords(n3 + 1));
        }
        n3 = 0;
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            for (n = n2 + 2; n < n4 - 1; ++n) {
                if (!LinesIntersect.linesIntersect(doubleArray[n2], doubleArray[n])) continue;
                ++n3;
            }
        }
        this.backboneCrossings = n3;
        n4 = this.rna.getSize();
        double d2 = 0.0;
        n2 = 0;
        for (n = 0; n < n4 - 1; ++n) {
            int n5 = this.rna.getBaseAt(n).getElementStructure();
            int n6 = this.rna.getBaseAt(n + 1).getElementStructure();
            if (n5 == -1 && n6 == -1) continue;
            d2 += this.rna.getBaseAt(n).getCoords().distance(this.rna.getBaseAt(n + 1).getCoords());
            ++n2;
        }
        this.averageUnpairedDistance = d2 / (double)n2;
        n4 = this.rna.getSize();
        double[] dArray = new double[n4 - 1];
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            dArray[n3] = this.rna.getBaseAt(n3).getCoords().distance(this.rna.getBaseAt(n3 + 1).getCoords());
        }
        Arrays.sort(dArray);
        this.medianConsecutiveBaseDistance = d = dArray[dArray.length / 2];
        this.tooNearConsecutiveBases = 0;
        this.tooFarConsecutiveBases = 0;
        for (n = 0; n < n4 - 1; ++n) {
            if (dArray[n] < this.tooNearFactor * this.targetConsecutiveBaseDistance) {
                ++this.tooNearConsecutiveBases;
            }
            if (!(dArray[n] > this.tooFarFactor * this.targetConsecutiveBaseDistance)) continue;
            ++this.tooFarConsecutiveBases;
        }
    }

    private int percent(int n, int n2) {
        return (int)Math.round((double)n / (double)n2 * 100.0);
    }

    public void printAll() {
        System.out.println("Benchmark:");
        System.out.println("\tBackbone crossings = " + this.backboneCrossings);
        System.out.println("\tAverage unpaired distance = " + this.averageUnpairedDistance);
        System.out.println("\tMedian of consecutive base distance = " + this.medianConsecutiveBaseDistance);
        System.out.println("\tNumber of too near consecutive bases = " + this.tooNearConsecutiveBases);
        System.out.println("\tNumber of too far consecutive bases = " + this.tooFarConsecutiveBases);
    }
}

