/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.SecStrDrawingProducer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;

public class XFIGExport
extends SecStrDrawingProducer {
    private int _font = 0;
    private StringBuffer buf = new StringBuffer();
    private Hashtable<Color, Integer> _definedCols = new Hashtable();
    private int _nextColCode = 32;
    private static final int UPPER_BOUND_COLOR_CODE = 543;

    public XFIGExport() {
        super.setScale(20.0);
    }

    private String ensureColorDefinition(Color color) {
        if (!this._definedCols.containsKey(color) && this._nextColCode < 543) {
            String string;
            String string2;
            int n = this._nextColCode++;
            this._definedCols.put(color, n);
            String string3 = Integer.toHexString(color.getRed());
            if (string3.length() < 2) {
                string3 = "0" + string3;
            }
            if ((string2 = Integer.toHexString(color.getGreen())).length() < 2) {
                string2 = "0" + string2;
            }
            if ((string = Integer.toHexString(color.getBlue())).length() < 2) {
                string = "0" + string;
            }
            String string4 = "#" + string3 + string2 + string;
            string4 = string4.toUpperCase();
            return "0 " + n + " " + string4 + "\n";
        }
        return "";
    }

    private int getColorCode(Color color) {
        if (this._definedCols.containsKey(color)) {
            return this._definedCols.get(color);
        }
        return 0;
    }

    private int getCurColorCode() {
        if (this._definedCols.containsKey(this._curColor)) {
            return this._definedCols.get(this._curColor);
        }
        return 0;
    }

    private String XFIGHeader() {
        return "#FIG 3.2\nLandscape\nCenter\nInches\nLetter  \n100.00\nSingle\n-2\n1200 2\n";
    }

    @Override
    public String drawCircleS(Point2D.Double double_, double d, double d2) {
        return "1 3 0 " + (long)d2 + " " + this.getCurColorCode() + " 7 50 -1 -1 0.000 1 0.0000 " + (long)double_.x + " " + (long)(-double_.y) + " " + (long)d + " " + (long)d + " 1 1 1 1\n";
    }

    @Override
    public String drawLineS(Point2D.Double double_, Point2D.Double double_2, double d) {
        return "2 1 0 " + (long)d + " " + this.getCurColorCode() + " 7 60 -1 -1 0.000 0 0 -1 0 0 2\n" + " " + (long)double_.x + " " + (long)(-double_.y) + " " + (long)double_2.x + " " + (long)(-double_2.y) + "\n";
    }

    @Override
    public String drawRectangleS(Point2D.Double double_, Point2D.Double double_2, double d) {
        return "2 2 0 " + (long)d + " " + this.getCurColorCode() + " 7 50 -1 -1 0.000 0 0 -1 0 0 5\n" + "\t " + (long)double_.x + " " + (long)(-double_.y) + " " + (long)(double_.x + double_2.x) + " " + (long)(-double_.y) + " " + (long)(double_.x + double_2.x) + " " + (long)(-(double_.y + double_2.y)) + " " + (long)double_.x + " " + (long)(-(double_.y + double_2.y)) + " " + (long)double_.x + " " + (long)(-double_.y) + "\n";
    }

    @Override
    public String drawTextS(Point2D.Double double_, String string) {
        return "4 1 " + this.getCurColorCode() + " 40 -1 " + this._font + " " + (long)this._fontsize + " 0.0000 6 " + 4.0 * this._fontsize + " " + (long)(2.0 * this._fontsize) + " " + (long)double_.x + " " + (long)(-(double_.y - 6.0 * this._fontsize)) + " " + string + "\\001\n";
    }

    @Override
    public String fillCircleS(Point2D.Double double_, double d, double d2, Color color) {
        String string = this.ensureColorDefinition(color);
        return string + "1 3 0 " + (long)d2 + " 0 " + this.getColorCode(color) + " 50 0 20 0.000 1 0.0000 " + (long)double_.x + " " + (long)(-double_.y) + " " + (long)d + " " + (long)d + " 1 1 1 1\n";
    }

    @Override
    public String setFontS(int n, double d) {
        this._font = n;
        this._fontsize = 1.2 * d;
        return "";
    }

    @Override
    public String setColorS(Color color) {
        super.setColorS(color);
        return this.ensureColorDefinition(color);
    }

    @Override
    public String footerS() {
        return "";
    }

    @Override
    public String headerS(Rectangle2D.Double double_) {
        return this.XFIGHeader();
    }

    @Override
    public String drawArcS(Point2D.Double double_, double d, double d2, double d3, double d4) {
        double d5 = double_.x;
        double d6 = -double_.y;
        double d7 = double_.x + d / 2.0;
        double d8 = -double_.y - d2 / 2.0;
        double d9 = double_.x + d;
        double d10 = d6;
        double d11 = (d5 + d9) / 2.0;
        double d12 = d10 + d2 / 2.0;
        return "5 1 0 1 " + this.getCurColorCode() + " 7 50 0 -1 4.000 0 0 0 0 " + d11 + " " + d12 + " " + (int)d5 + " " + (int)d6 + " " + (int)d7 + " " + (int)d8 + " " + (int)d9 + " " + (int)d10 + "\n";
    }

    @Override
    public String drawPolygonS(Point2D.Double[] doubleArray, double d) {
        if (doubleArray.length > 0) {
            String string = "2 3 0 1 " + this.getCurColorCode() + " 7 40 0 -1 4.000 0 0 0 0 0 " + (doubleArray.length + 1) + "\n";
            for (int i = 0; i < doubleArray.length; ++i) {
                string = string + (int)Math.round(doubleArray[i].x) + " " + (int)Math.round(-doubleArray[i].y) + " ";
            }
            string = string + (int)Math.round(doubleArray[0].x) + " " + (int)Math.round(-doubleArray[0].y) + " ";
            string = string + "\n";
            return string;
        }
        return "";
    }

    @Override
    public String fillPolygonS(Point2D.Double[] doubleArray, Color color) {
        if (doubleArray.length > 0) {
            String string = this.ensureColorDefinition(color);
            String string2 = "2 3 0 1 0 " + this.getColorCode(color) + " 35 0 0 4.000 0 0 0 0 0 " + (doubleArray.length + 1) + "\n";
            for (int i = 0; i < doubleArray.length; ++i) {
                string2 = string2 + (int)Math.round(doubleArray[i].x) + " " + (int)Math.round(-doubleArray[i].y) + " ";
            }
            string2 = string2 + (int)Math.round(doubleArray[0].x) + " " + (int)Math.round(-doubleArray[0].y) + " ";
            string2 = string2 + "\n";
            return string + string2;
        }
        return "";
    }
}

